/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.fsm.IWizard;
import com.pingidentity.fsm.state.impl.CustomDataSourceState;
import com.pingidentity.fsm.tasklet.api.AccountLinkingApi;
import com.pingidentity.fsm.tasklet.api.AttributeNamesApi;
import com.pingidentity.fsm.tasklet.api.AttributeSourceApi;
import com.pingidentity.fsm.tasklet.api.RetrieveAttributeSourceInstance;
import com.pingidentity.fsm.tasklet.data.AttributeLookupTestResult;
import com.pingidentity.fsm.tasklet.data.FieldItem;
import com.pingidentity.fsm.tasklet.data.TestDataItem;
import com.pingidentity.fsm.tasklet.impl.MappingTasklet;
import com.pingidentity.sources.CustomDataSourceDriverDescriptor;
import com.pingidentity.sources.gui.FilterFieldsGuiDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.IRequestCycle;
import org.sourceid.saml20.adapter.conf.Configuration;
import org.sourceid.saml20.adapter.conf.Field;
import org.sourceid.saml20.adapter.conf.FieldList;
import org.sourceid.saml20.adapter.conf.SimpleFieldList;
import org.sourceid.saml20.adapter.gui.FieldDescriptor;
import org.sourceid.saml20.adapter.gui.validation.ConfigurationValidator;
import org.sourceid.saml20.adapter.gui.validation.ValidationException;
import org.sourceid.saml20.domain.AttrLookupException;
import org.sourceid.saml20.domain.AttributeContract;
import org.sourceid.saml20.domain.AttributeMapping;
import org.sourceid.saml20.domain.AttributeSource;
import org.sourceid.saml20.domain.ConfigurablePluginInstance;
import org.sourceid.saml20.domain.CustomDataSource;
import org.sourceid.saml20.domain.DataSource;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.mgmt.AttributeSourceFactory;
import org.sourceid.saml20.domain.mgmt.DataSourceManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.util.log.AttributeMap;

public class ConfigureCustomSourceFiltersState
extends CustomDataSourceState {
    private static final long serialVersionUID = 20050515L;
    private AttributeMapping attributeMapping;
    private transient CustomDataSourceDriverDescriptor descriptor;
    public boolean testingLookup = false;
    private Object lookupTestState;

    public ConfigureCustomSourceFiltersState(IWizard owner) {
        super(owner);
        this.setMenuName("Configure Data Source Filters");
    }

    @Override
    public void onStateActivated() {
        AttributeSourceApi parent = this.findParent(AttributeSourceApi.class);
        if (parent != null) {
            this.customSource = parent.getSelectedCustomDataSource();
            DataSourceManager dsMgr = MgmtFactory.getDataSourceManager();
            CustomDataSourceDriverDescriptor tempDescriptor = (CustomDataSourceDriverDescriptor)dsMgr.getSourceDescriptor(this.customSource.getDriverClassName());
            if (this.descriptor == null || !tempDescriptor.equals((Object)this.descriptor)) {
                this.attributeMapping = null;
                this.populate();
            }
        }
    }

    @Override
    public boolean save(Object dataToDisk) {
        AttributeMapping tempMapping = (AttributeMapping)dataToDisk;
        AttributeSource tempSource = tempMapping.getAttributeSource();
        List<Field> fields = this.getConfiguredFields(false, true);
        for (Field f : fields) {
            tempSource.setParameter(f.getName(), f.getValue());
        }
        return true;
    }

    @Override
    protected void populate() {
        if (this.customSource != null) {
            DataSourceManager dsMgr = MgmtFactory.getDataSourceManager();
            this.descriptor = (CustomDataSourceDriverDescriptor)dsMgr.getSourceDescriptor(this.customSource.getDriverClassName());
            FilterFieldsGuiDescriptor fieldsDescriptor = this.descriptor.getFilterFieldsDescriptor();
            this.setMainDesc(fieldsDescriptor.getDescription());
            SimpleFieldList simpleList = this.buildSimpleFieldListFromAttrMapping();
            if (!this.getParent().isDraft()) {
                this.buildFields(fieldsDescriptor.getFields(), (FieldList)simpleList, null, null, false);
            }
        }
    }

    @Override
    protected List<String> validateFieldItems() {
        List<String> errorMessages = super.validateFieldItems();
        Configuration config = this.buildConfiguration();
        List filterValidators = this.descriptor.getFilterFieldsDescriptor().getValidationChain();
        for (ConfigurationValidator validator : filterValidators) {
            try {
                validator.validate(config);
            }
            catch (ValidationException e) {
                errorMessages.add(e.getMessage());
            }
        }
        return errorMessages;
    }

    @Override
    public Configuration buildConfiguration() {
        Configuration filterConfig = super.buildConfiguration();
        Configuration customSourceConfig = this.customSource.getConfiguration();
        for (Field field : customSourceConfig.getFields()) {
            filterConfig.addField(field);
        }
        return filterConfig;
    }

    private SimpleFieldList buildSimpleFieldListFromAttrMapping() {
        if (this.attributeMapping != null) {
            AttributeSource source = this.attributeMapping.getAttributeSource();
            ArrayList<Field> fields = new ArrayList<Field>();
            Set keys = source.getParameterMap().keySet();
            for (String key : keys) {
                fields.add(new Field(key, source.getParameter(key)));
            }
            return new SimpleFieldList(fields);
        }
        return null;
    }

    @Override
    public void populate(Object dataFromDisk) {
        this.attributeMapping = (AttributeMapping)dataFromDisk;
        if (this.attributeMapping.getAttributeSource() != null) {
            this.customSource = (CustomDataSource)this.attributeMapping.getAttributeSource().getDataSource();
        }
        this.populate();
    }

    public CustomDataSource getCustomAttributeSource() {
        return this.customSource;
    }

    @Override
    public void onResumeDraft() {
        RetrieveAttributeSourceInstance parent = this.findParent(RetrieveAttributeSourceInstance.class);
        this.customSource = parent.getSelectedCustomDataSource();
        DataSourceManager dsMgr = MgmtFactory.getDataSourceManager();
        this.descriptor = (CustomDataSourceDriverDescriptor)dsMgr.getSourceDescriptor(this.customSource.getDriverClassName());
        List fieldDescList = this.descriptor.getFilterFieldsDescriptor().getFields();
        if (this.fieldItems.size() != fieldDescList.size()) {
            SimpleFieldList simpleList = this.buildSimpleFieldListFromAttrMapping();
            this.buildFields(fieldDescList, (FieldList)simpleList, null, null, false);
        } else {
            Iterator fieldDescIt = fieldDescList.iterator();
            ArrayList<FieldItem> newFieldItems = new ArrayList<FieldItem>();
            for (FieldItem oldItem : this.fieldItems) {
                FieldDescriptor newDescriptor = (FieldDescriptor)fieldDescIt.next();
                FieldItem newItem = new FieldItem(newDescriptor, oldItem);
                newFieldItems.add(newItem);
            }
            this.fieldItems = newFieldItems;
        }
    }

    @Override
    public boolean isDatasourceFilterState() {
        return true;
    }

    @Override
    public void onTestLookup(IRequestCycle cycle) {
        this.setTestingLookup(true);
    }

    @Override
    public boolean isTestingDatasourceLookup() {
        return this.testingLookup;
    }

    public void setTestingLookup(boolean testingLookup) {
        this.testingLookup = testingLookup;
    }

    public AttributeLookupTestResult doTestLookup(List<TestDataItem> testData) {
        AttributeLookupTestResult result = new AttributeLookupTestResult();
        RetrieveAttributeSourceInstance parent = this.findParent(RetrieveAttributeSourceInstance.class);
        if (parent != null) {
            AttributeSource attributeSource = AttributeSourceFactory.getAttributeSource((DataSource)this.customSource);
            AttributeMap testAttributeMap = new AttributeMap();
            for (TestDataItem testItem : testData) {
                String testValue = testItem.getTestValue();
                testAttributeMap.put(testItem.getFieldName(), StringUtils.isBlank((String)testValue) ? null : testValue);
            }
            List attributeNamesToFulfill = parent.getSelectedCustomDataSource().getDriver().getAvailableFields();
            Configuration config = this.buildConfiguration();
            config.getFields().forEach(field -> attributeSource.setParameter(field.getName(), field.getValue()));
            try {
                AttributeMap resultAttributes = attributeSource.executeAttributeLookup(testAttributeMap, (Collection)attributeNamesToFulfill);
                if (resultAttributes == null || resultAttributes.isEmpty()) {
                    result.setError("No records were returned from the attribute lookup.");
                } else {
                    HashMap<String, Object> results = new HashMap<String, Object>();
                    for (Map.Entry entry : resultAttributes.entrySet()) {
                        results.put((String)entry.getKey(), entry.getValue());
                    }
                    result.setTestResult(results);
                }
            }
            catch (AttrLookupException e) {
                result.setError("Error performing attribute lookup. " + e.getMessage());
                e.printStackTrace();
            }
        }
        return result;
    }

    public List<TestDataItem> getTestLookupDataList() {
        ArrayList<String> names = new ArrayList<String>();
        MappingTasklet mappingTasklet = this.findParent(MappingTasklet.class);
        if (mappingTasklet != null) {
            mappingTasklet.getCurrentState().processState();
            Collection<String> additionalAttrsForFilter = mappingTasklet.getAdditionalInputAttributesForFilter();
            names.addAll(additionalAttrsForFilter);
            ConfigurablePluginInstance pluginInstance = mappingTasklet.getSelectedPlugin();
            if (pluginInstance != null) {
                AttributeContract contract = pluginInstance.getAttributeContract();
                names.addAll(contract.getAllAttributeNames());
            }
        } else {
            AccountLinkingApi accountLinkingApi;
            AttributeNamesApi attributeNamesApi = this.findParent(AttributeNamesApi.class);
            if (attributeNamesApi != null) {
                names.addAll(attributeNamesApi.getAllAttrNamesSorted());
            }
            if ((accountLinkingApi = this.findParent(AccountLinkingApi.class)) != null && accountLinkingApi.isAccountLinkingEnabled()) {
                names.add(IdpConnection.getLocalIdSubstitutionKey());
            }
        }
        return new ArrayList<TestDataItem>(names.stream().map(s -> new TestDataItem((String)s, "")).collect(Collectors.toList()));
    }

    public Object getLookupTestState() {
        return this.lookupTestState;
    }

    public void setLookupTestState(Object state) {
        this.lookupTestState = state;
    }
}

