/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.component.common.Pagination;
import com.pingidentity.component.common.Search;
import com.pingidentity.dependency.error.AffectedItemType;
import com.pingidentity.dependency.error.DependencyErrorHandler;
import com.pingidentity.draft.ConnectionDraft;
import com.pingidentity.draft.Draft;
import com.pingidentity.draft.mgmt.DraftManager;
import com.pingidentity.draft.mgmt.DraftManagerImpl;
import com.pingidentity.fsm.Visit;
import com.pingidentity.fsm.state.impl.AutoSaveState;
import com.pingidentity.fsm.state.impl.ConnectionLimitState;
import com.pingidentity.fsm.state.impl.ConnectionToggleState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.data.ConnectionImageType;
import com.pingidentity.fsm.tasklet.data.ConnectionItem;
import com.pingidentity.fsm.tasklet.data.ConnectionType;
import com.pingidentity.fsm.tasklet.data.Mode;
import com.pingidentity.fsm.tasklet.data.StatusType;
import com.pingidentity.fsm.tasklet.impl.ConnectionImportTasklet;
import com.pingidentity.fsm.tasklet.impl.ConnectionTasklet;
import com.pingidentity.fsm.tasklet.impl.IdpConnectionConfigTasklet;
import com.pingidentity.fsm.tasklet.impl.SingleStateTasklet;
import com.pingidentity.fsm.tasklet.impl.SpConnectionConfigTasklet;
import com.pingidentity.util.StringPairPropertySelectionModel;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.apache.tapestry.valid.ValidationDelegate;
import org.sourceid.saml20.domain.ConnectionBase;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.LocalSettings;
import org.sourceid.saml20.domain.SpConnection;
import org.sourceid.saml20.domain.mgmt.ConnectionManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.impl.NotificationBanner;
import org.sourceid.util.domain.SearchCriteria;
import org.sourceid.util.domain.SearchResult;
import org.sourceid.util.domain.filter.ContainsCriteriaFilter;
import org.sourceid.util.domain.filter.ItemMultiValue;
import org.sourceid.util.license.LicenseManager;

@AutoSaveState
public class ConnMgmtState
extends TaskletState
implements ConnectionToggleState {
    private static final long serialVersionUID = 20050515L;
    private final List<ConnectionItem> connections = new ArrayList<ConnectionItem>();
    private ConnectionType connectionType;
    private final Set<String> refreshedConnections = new HashSet<String>();
    private boolean wasDraftSuccessful = true;
    private boolean wasResumeDraftSuccessful = true;
    private boolean onStateActivated;
    private transient Object componentState;
    private transient Object paginationState;
    private transient Object searchState;
    private boolean showConfirmationMessage;
    private boolean showAdvancedSearch = false;
    private StatusType selectedStatus = StatusType.ALL;
    ConnectionImageType connectionImageType = ConnectionImageType.ALL;
    private static final String NO_SEARCH_RESULTS = "No Results Found";
    private static final int DEFAULT_REQUESTED_ITEMS = 101;
    private static final SearchResult<ConnectionItem> DEFAULT_CONNECTION_SEARCH_RESULT = new SearchResult(0, Collections.emptyList());
    private SearchResult<ConnectionItem> connectionItemSearchResult = DEFAULT_CONNECTION_SEARCH_RESULT;
    private boolean sortConnNameUp;
    private boolean sortConnIdUp;
    private boolean sortVirtualIdentityUp;
    private boolean sortModificationTimeUp = true;
    private boolean sortCreationTimeUp = true;
    private SORT_BY sortBy = SORT_BY.ModificationTime;
    private boolean showAdvancedFields;

    public ConnMgmtState(Tasklet value) {
        super(value);
        this.setMenuName("Manage Connections");
    }

    @Override
    public void onStateActivated() {
        this.onStateActivated = true;
        this.showConfirmationMessage = false;
    }

    @Override
    public void populate(Object dataFromDisk) {
        this.freshenConnections();
    }

    private void freshenConnections() {
        this.connections.clear();
        if (this.connectionType == ConnectionType.IDP) {
            this.populateIdpConnections(false, true);
        } else {
            this.populateSpConnections(false, true);
        }
    }

    private void populateIdpConnections(boolean forceCheck, boolean optimize) {
        ConnectionManager connectionManager = MgmtFactory.getConnectionManager();
        Collection idpConnections = connectionManager.getFilteredIdpConnections();
        LocalSettings localSettings = MgmtFactory.getLocalSettingsManager().getLocalSettings();
        for (IdpConnection connection : idpConnections) {
            ConnectionItem connectionItem = new ConnectionItem(localSettings, (ConnectionBase)connection);
            if (forceCheck) {
                boolean hasProblems = this.checkConnectionForErrors((ConnectionBase)connection, optimize);
                connectionItem.setHasErrorsForListDisplay(hasProblems);
                this.refreshedConnections.add(connectionItem.getEntityId());
            }
            if (this.refreshedConnections.contains(connectionItem.getEntityId())) {
                connectionItem.setRefreshed(true);
            }
            if (this.getParent().showFinishButtonIfAuditor()) {
                connectionItem.setDisabled(true);
            }
            if (connectionManager.isIdpConnectionInUse(connection)) {
                connectionItem.setInUse(true);
            }
            this.connections.add(connectionItem);
        }
        DraftManager draftManager = DraftManagerImpl.getInstance();
        for (Draft draft : draftManager.getIdpDrafts(true)) {
            ConnectionItem draftItem = new ConnectionItem((ConnectionDraft)draft);
            if (this.getParent().showFinishButtonIfAuditor()) {
                draftItem.setDisabled(true);
            }
            this.connections.add(draftItem);
        }
    }

    public void checkConnectionForErrors(ConnectionItem connectionItem) {
        String entityId = connectionItem.getEntityId();
        ConnectionManager mgr = MgmtFactory.getConnectionManager();
        IdpConnection connection = this.connectionType == ConnectionType.IDP ? mgr.getIdpConnection(entityId) : mgr.getSpConnection(entityId);
        boolean hasProblems = this.checkConnectionForErrors((ConnectionBase)connection, true);
        connectionItem.setHasErrorsForListDisplay(hasProblems);
        connectionItem.setRefreshed(true);
        this.refreshedConnections.add(entityId);
    }

    private boolean checkConnectionForErrors(ConnectionBase connection, boolean optimize) {
        ConnectionTasklet tasklet;
        Visit v = this.getVisit();
        v.setSkipForUIPerformanceFlag(optimize);
        ConnectionManager connectionManager = MgmtFactory.getConnectionManager();
        if (connection instanceof SpConnection) {
            SpConnection spConnection = connectionManager.getSpConnection(connection.getEntityId());
            SpConnectionConfigTasklet spTasklet = this.createTaskletToLoad(SpConnectionConfigTasklet.class);
            spTasklet.setSpConnection(spConnection);
            tasklet = spTasklet;
        } else {
            IdpConnection idpConnection = connectionManager.getIdpConnection(connection.getEntityId());
            IdpConnectionConfigTasklet idpTasklet = this.createTaskletToLoad(IdpConnectionConfigTasklet.class);
            idpTasklet.setIdpConnection(idpConnection);
            tasklet = idpTasklet;
        }
        tasklet.setMode(Mode.edit);
        ((Tasklet)tasklet).populate(connection);
        ValidationDelegate delegate = new ValidationDelegate();
        tasklet.appendErrors((IValidationDelegate)delegate, null, false);
        tasklet = null;
        connection = null;
        v.setSkipForUIPerformanceFlag(false);
        return delegate.getHasErrors();
    }

    private void populateSpConnections(boolean forceCheck, boolean optimize) {
        ConnectionManager connectionManager = MgmtFactory.getConnectionManager();
        Collection spConnections = connectionManager.getFilteredSpConnections();
        LocalSettings localSettings = MgmtFactory.getLocalSettingsManager().getLocalSettings();
        for (SpConnection connection : spConnections) {
            ConnectionItem connectionItem = new ConnectionItem(localSettings, (ConnectionBase)connection);
            if (forceCheck) {
                boolean hasProblems = this.checkConnectionForErrors((ConnectionBase)connection, optimize);
                connectionItem.setHasErrorsForListDisplay(hasProblems);
                this.refreshedConnections.add(connectionItem.getEntityId());
            }
            if (this.refreshedConnections.contains(connectionItem.getEntityId())) {
                connectionItem.setRefreshed(true);
            }
            if (this.getParent().showFinishButtonIfAuditor()) {
                connectionItem.setDisabled(true);
            }
            if (connectionManager.isSpConnectionInUse(connection)) {
                connectionItem.setInUse(true);
            }
            this.connections.add(connectionItem);
        }
        DraftManager draftManager = DraftManagerImpl.getInstance();
        for (Draft draft : draftManager.getSpDrafts(true)) {
            ConnectionItem draftItem = new ConnectionItem((ConnectionDraft)draft);
            if (this.getParent().showFinishButtonIfAuditor()) {
                draftItem.setDisabled(true);
            }
            this.connections.add(draftItem);
        }
    }

    @Override
    public void refreshState() {
        for (ConnectionItem item : this.connections) {
            if (!item.isRefreshed()) continue;
            this.refreshedConnections.add(item.getEntityId());
        }
        this.freshenConnections();
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        if (!this.wasDraftSuccessful) {
            delegate.setFormComponent(null);
            delegate.record(this.getMessage("Draft_non_serializable"), ValidationConstraint.REQUIRED);
            this.wasDraftSuccessful = true;
        }
        if (!this.wasResumeDraftSuccessful) {
            delegate.setFormComponent(null);
            delegate.record(this.getMessage("Draft_version_error"), ValidationConstraint.REQUIRED);
            this.wasResumeDraftSuccessful = true;
        }
    }

    public void deleteConnection(ConnectionItem connToDelete) {
        NotificationBanner notificationBanner;
        ConnectionManager connectionManager = MgmtFactory.getConnectionManager();
        ConnectionTasklet tasklet = null;
        if (connToDelete.getRole().equals("IdP")) {
            if (!connToDelete.isDraftConnection()) {
                connectionManager.deleteIdpConnection(connectionManager.getIdpConnection(connToDelete.getEntityId()));
                notificationBanner = NotificationBanner.getBannerForConnectionDeleted();
                this.getVisit().setNotificationBannerContent(notificationBanner);
            } else {
                tasklet = this.createTaskletToLoad(IdpConnectionConfigTasklet.class);
                tasklet.deleteDraftByDraftId(connToDelete.getSystemId());
            }
            MgmtFactory.getDependencyErrorManager().remove(connToDelete.getSystemId(), AffectedItemType.IDP_CONN);
        }
        if (connToDelete.getRole().equals("SP")) {
            if (!connToDelete.isDraftConnection()) {
                connectionManager.deleteSpConnection(connectionManager.getSpConnection(connToDelete.getEntityId()));
                notificationBanner = NotificationBanner.getBannerForConnectionDeleted();
                this.getVisit().setNotificationBannerContent(notificationBanner);
            } else {
                tasklet = this.createTaskletToLoad(SpConnectionConfigTasklet.class);
                tasklet.deleteDraftByDraftId(connToDelete.getSystemId());
            }
            MgmtFactory.getDependencyErrorManager().remove(connToDelete.getSystemId(), AffectedItemType.SP_CONN);
        }
        DependencyErrorHandler dependencyErrorHandler = new DependencyErrorHandler();
        dependencyErrorHandler.updateProtocolSettingsDepsForConnections(connToDelete.getSystemId(), connToDelete.getRole());
        Tasklet currentTasklet = this.getVisit().getCurrentTasklet();
        currentTasklet.setupNavMenuReload();
    }

    @Override
    public void toggleConnection(ConnectionItem conn) {
        ConnectionManager connectionManager = MgmtFactory.getConnectionManager();
        if (conn.getRole().equals("SP")) {
            SpConnection spConn = connectionManager.getSpConnectionBySystemId(conn.getSystemId());
            if (spConn != null) {
                spConn.setActive(!conn.isActive());
                connectionManager.saveSpConnection(spConn);
                NotificationBanner notificationBanner = NotificationBanner.getNotificationBannerForConnection((ConnectionBase)spConn);
                this.getVisit().setNotificationBannerContent(notificationBanner);
            }
        } else {
            IdpConnection idpConn = connectionManager.getIdpConnectionBySystemId(conn.getSystemId());
            if (idpConn != null) {
                idpConn.setActive(!conn.isActive());
                connectionManager.saveIdpConnection(idpConn);
                NotificationBanner notificationBanner = NotificationBanner.getNotificationBannerForConnection((ConnectionBase)idpConn);
                this.getVisit().setNotificationBannerContent(notificationBanner);
            }
        }
        Tasklet currentTasklet = this.getVisit().getCurrentTasklet();
        currentTasklet.setupNavMenuReload();
    }

    public void create(IRequestCycle cycle) {
        this.showConfirmationMessage = false;
        if (this.isAuthorizedForAction()) {
            if (LicenseManager.canAddConnection()) {
                Tasklet tasklet;
                if (this.connectionType == ConnectionType.IDP) {
                    tasklet = this.getParent().loadNewTasklet(IdpConnectionConfigTasklet.class);
                    if (tasklet instanceof IdpConnectionConfigTasklet) {
                        ((IdpConnectionConfigTasklet)tasklet).setExistingConnection(false);
                    }
                } else {
                    SpConnectionConfigTasklet spConnTasklet = this.createTaskletToLoad(SpConnectionConfigTasklet.class);
                    spConnTasklet.setConnTemplateAsInitialStateIfAllowed();
                    spConnTasklet.setExistingConnection(false);
                    tasklet = spConnTasklet;
                    this.loadTasklet(tasklet);
                }
                tasklet.setMode(Mode.create);
                tasklet.markProtocolImgAvailable(true);
            } else {
                String taskletName = "ConnectionLimitTasklet";
                String menuName = "Connection Limit Exceeded";
                SingleStateTasklet tasklet = this.createTaskletToLoad(SingleStateTasklet.class, taskletName, menuName);
                tasklet.setFinishAvailable(false);
                tasklet.setCycle(cycle);
                tasklet.setInitialState(new ConnectionLimitState(tasklet));
                this.loadTasklet(tasklet);
            }
        }
    }

    @Override
    public void reset() {
        ((Search.State)this.getSearchState()).reset();
        this.resetPaginationState();
        this.connectionItemSearchResult = DEFAULT_CONNECTION_SEARCH_RESULT;
    }

    public void importConnection(IRequestCycle cycle) {
        ConnectionImportTasklet tasklet = this.createTaskletToLoad(ConnectionImportTasklet.class);
        tasklet.setFinishAvailable(true);
        tasklet.setFinishLabel("Done");
        tasklet.setCycle(cycle);
        tasklet.setMode(Mode.edit);
        tasklet.setRole(this.connectionType.getRole());
        this.loadTasklet(tasklet);
    }

    private String getSearchString() {
        return this.getSearchState() != null ? ((Search.State)this.getSearchState()).getSearch() : "";
    }

    public Integer getLookAheadAvailableIndex() {
        if (this.paginationState != null && this.connectionItemSearchResult.getResults().size() > 0) {
            int currentPage = ((Pagination.State)this.paginationState).getCurrentPage();
            int pagesPerBlock = ((Pagination.State)this.paginationState).MAX_PAGES_PER_BLOCK;
            return this.getLookAheadAvailableMaxIndexForPaginationBlock(currentPage, 20, pagesPerBlock);
        }
        return -1;
    }

    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_NO_SIDE_EFFECT"}, justification="this is a side effect of the look ahead algorithm")
    private Integer getLookAheadAvailableMaxIndexForPaginationBlock(int currentPage, int maxItemsPerPage, int pagesPerBlock) {
        int pageStartIndex = (currentPage - 1) * maxItemsPerPage;
        int availableItemIndex = currentPage == 1 || currentPage == 2 || currentPage == 3 ? maxItemsPerPage * pagesPerBlock - maxItemsPerPage : maxItemsPerPage * (currentPage + 2) - maxItemsPerPage;
        boolean indexNotFound = true;
        while (indexNotFound) {
            try {
                int availableItemRelativeIndex = availableItemIndex - pageStartIndex;
                this.connectionItemSearchResult.getResults().get(availableItemRelativeIndex);
                indexNotFound = false;
            }
            catch (IndexOutOfBoundsException ex) {
                availableItemIndex -= maxItemsPerPage;
            }
        }
        return availableItemIndex;
    }

    public boolean isShowAdvancedSearch() {
        return this.showAdvancedSearch;
    }

    public void setShowAdvancedSearch(boolean showAdvancedSearch) {
        this.showAdvancedSearch = showAdvancedSearch;
    }

    public LocalSettings getLocalSettings() {
        return MgmtFactory.getLocalSettingsManager().getLocalSettings();
    }

    public void setDraftSuccessful(boolean wasDraftSuccessful) {
        this.wasDraftSuccessful = wasDraftSuccessful;
    }

    public void setResumeDraftSuccessful(boolean wasResumeDraftSuccessful) {
        this.wasResumeDraftSuccessful = wasResumeDraftSuccessful;
    }

    public ConnectionType getConnectionType() {
        return this.connectionType;
    }

    public void setConnectionType(ConnectionType connectionType) {
        this.connectionType = connectionType;
    }

    public boolean isConnectionTypeIdp() {
        return this.connectionType == ConnectionType.IDP;
    }

    public boolean isOnStateActivated() {
        return this.onStateActivated;
    }

    public void setOnStateActivated(boolean onStateActivated) {
        this.onStateActivated = onStateActivated;
    }

    public Object getComponentState() {
        return this.componentState;
    }

    public void setComponentState(Object componentState) {
        this.componentState = componentState;
    }

    public Object getPaginationState() {
        return this.paginationState;
    }

    public void setPaginationState(Object paginationState) {
        this.paginationState = paginationState;
    }

    public Object getSearchState() {
        return this.searchState;
    }

    public void setSearchState(Object searchState) {
        this.searchState = searchState;
    }

    public boolean showConfirmationMessage() {
        return this.showConfirmationMessage;
    }

    public ConnectionImageType getConnectionImageType() {
        return this.connectionImageType;
    }

    public void setConnectionImageType(ConnectionImageType connectionImageType) {
        this.connectionImageType = connectionImageType;
    }

    public StatusType getSelectedStatus() {
        return this.selectedStatus;
    }

    public void setSelectedStatus(StatusType selectedStatus) {
        this.selectedStatus = selectedStatus;
    }

    public StringPairPropertySelectionModel getStatusList() {
        StringPairPropertySelectionModel statusPairs = new StringPairPropertySelectionModel(false);
        statusPairs.add(StatusType.ALL.getLabel(), StatusType.ALL);
        statusPairs.add(StatusType.ACTIVE.getLabel(), StatusType.ACTIVE);
        statusPairs.add(StatusType.INACTIVE.getLabel(), StatusType.INACTIVE);
        statusPairs.add(StatusType.DRAFT.getLabel(), StatusType.DRAFT);
        return statusPairs;
    }

    public boolean getResetSearch() {
        this.resetPaginationState();
        return true;
    }

    public boolean getResetControls() {
        this.resetPaginationState();
        return true;
    }

    public String getNoResultsMessage() {
        if (this.connectionItemSearchResult.getResults().size() == 0 && (StringUtils.isNotBlank((String)this.getSearchString()) || this.getSelectedStatus() != StatusType.ALL || this.getConnectionImageType() != ConnectionImageType.ALL)) {
            return NO_SEARCH_RESULTS;
        }
        return "";
    }

    public boolean isShowTitleBar() {
        return this.connectionItemSearchResult.getResults().size() != 0 && this.connections.size() != 0;
    }

    public boolean isSortConnNameUp() {
        return this.sortConnNameUp;
    }

    public void setSortConnNameUp(boolean sortConnNameUp) {
        this.sortConnNameUp = sortConnNameUp;
    }

    public boolean isSortConnIdUp() {
        return this.sortConnIdUp;
    }

    public void setSortConnIdUp(boolean sortConnIdUp) {
        this.sortConnIdUp = sortConnIdUp;
    }

    public boolean isSortVirtualIdentityUp() {
        return this.sortVirtualIdentityUp;
    }

    public void setSortVirtualIdentityUp(boolean sortVirtualIdentityUp) {
        this.sortVirtualIdentityUp = sortVirtualIdentityUp;
    }

    public boolean isSortModificationTimeUp() {
        return this.sortModificationTimeUp;
    }

    public void setSortModificationTimeUp(boolean sortModificationTimeUp) {
        this.sortModificationTimeUp = sortModificationTimeUp;
    }

    public boolean isSortCreationTimeUp() {
        return this.sortCreationTimeUp;
    }

    public void setSortCreationTimeUp(boolean sortCreationTimeUp) {
        this.sortCreationTimeUp = sortCreationTimeUp;
    }

    public SORT_BY getSortBy() {
        return this.sortBy;
    }

    public void setSortBy(SORT_BY sortBy) {
        this.sortBy = sortBy;
        this.resetPaginationState();
    }

    public synchronized SearchResult<ConnectionItem> search(SearchCriteria searchCriteria) {
        ContainsCriteriaFilter filter = new ContainsCriteriaFilter(c -> new ItemMultiValue(c, (Object[])new String[]{c.getEntityId(), c.getConnectionName()}));
        Collection searchResults = filter.doFilter(searchCriteria.getQuery(), this.connections);
        ConnectionImageType selectedProtocolType = this.getConnectionImageType();
        List resultSearchAndFilterConnections = searchResults.parallelStream().filter(item -> this.getSelectedStatus() == StatusType.ALL || this.getSelectedStatus() == StatusType.valueOf(this.getCurrentStatusString((ConnectionItem)item).toUpperCase())).filter(item -> selectedProtocolType == ConnectionImageType.ALL || item.getConnectionImageTypes().contains((Object)selectedProtocolType)).collect(Collectors.toList());
        if (searchCriteria.getStartIndex() >= resultSearchAndFilterConnections.size()) {
            return new SearchResult(searchCriteria.getStartIndex(), Collections.emptyList());
        }
        switch (searchCriteria.getOrderBy()) {
            case "Id": {
                if (searchCriteria.getOrder() == SearchCriteria.Order.ASC) {
                    resultSearchAndFilterConnections = resultSearchAndFilterConnections.parallelStream().sorted(ConnectionItem.COMPARE_BY_ID_DOWN).collect(Collectors.toList());
                    break;
                }
                resultSearchAndFilterConnections = resultSearchAndFilterConnections.parallelStream().sorted(ConnectionItem.COMPARE_BY_ID_UP).collect(Collectors.toList());
                break;
            }
            case "Name": {
                if (searchCriteria.getOrder() == SearchCriteria.Order.ASC) {
                    resultSearchAndFilterConnections = resultSearchAndFilterConnections.parallelStream().sorted(ConnectionItem.COMPARE_BY_NAME_DOWN).collect(Collectors.toList());
                    break;
                }
                resultSearchAndFilterConnections = resultSearchAndFilterConnections.parallelStream().sorted(ConnectionItem.COMPARE_BY_NAME_UP).collect(Collectors.toList());
                break;
            }
            case "VirtualIdentity": {
                if (searchCriteria.getOrder() == SearchCriteria.Order.ASC) {
                    resultSearchAndFilterConnections = resultSearchAndFilterConnections.parallelStream().sorted(ConnectionItem.COMPARE_BY_VIRT_ID_DOWN).collect(Collectors.toList());
                    break;
                }
                resultSearchAndFilterConnections = resultSearchAndFilterConnections.parallelStream().sorted(ConnectionItem.COMPARE_BY_VIRT_ID_UP).collect(Collectors.toList());
                break;
            }
            case "ModificationTime": {
                if (searchCriteria.getOrder() == SearchCriteria.Order.ASC) {
                    resultSearchAndFilterConnections = resultSearchAndFilterConnections.parallelStream().sorted(ConnectionItem.COMPARE_BY_MODIFICATION_TIME_UP).collect(Collectors.toList());
                    break;
                }
                resultSearchAndFilterConnections = resultSearchAndFilterConnections.parallelStream().sorted(ConnectionItem.COMPARE_BY_MODIFICATION_TIME_DOWN).collect(Collectors.toList());
                break;
            }
            case "CreationTime": {
                if (searchCriteria.getOrder() == SearchCriteria.Order.ASC) {
                    resultSearchAndFilterConnections = resultSearchAndFilterConnections.parallelStream().sorted(ConnectionItem.COMPARE_BY_CREATION_TIME_UP).collect(Collectors.toList());
                    break;
                }
                resultSearchAndFilterConnections = resultSearchAndFilterConnections.parallelStream().sorted(ConnectionItem.COMPARE_BY_CREATION_TIME_DOWN).collect(Collectors.toList());
                break;
            }
        }
        int fromIndex = searchCriteria.getStartIndex();
        int toIndex = searchCriteria.getStartIndex() + searchCriteria.getItemsRequested() >= resultSearchAndFilterConnections.size() ? resultSearchAndFilterConnections.size() : searchCriteria.getStartIndex() + searchCriteria.getItemsRequested();
        ArrayList serializableList = new ArrayList();
        serializableList.addAll(new ArrayList(resultSearchAndFilterConnections).subList(fromIndex, toIndex));
        return new SearchResult(searchCriteria.getStartIndex(), serializableList);
    }

    public List<ConnectionItem> getPageConnections() {
        return new ArrayList<ConnectionItem>(this.getConnectionsForList(this.connectionItemSearchResult));
    }

    public List<ConnectionItem> sortAndFilter() {
        SearchCriteria.Builder searchCriteriaBuilder;
        if (this.paginationState != null) {
            int currentPage = ((Pagination.State)this.paginationState).getCurrentPage();
            int startIndex = (currentPage - 1) * 20;
            searchCriteriaBuilder = new SearchCriteria.Builder(startIndex, 101);
        } else {
            searchCriteriaBuilder = new SearchCriteria.Builder(0, 101);
        }
        searchCriteriaBuilder.query(this.getSearchString());
        if (this.sortBy == SORT_BY.Id && this.sortConnIdUp || this.sortBy == SORT_BY.Name && this.sortConnNameUp || this.sortBy == SORT_BY.VirtualIdentity && this.sortVirtualIdentityUp || this.sortBy == SORT_BY.CreationTime && this.sortCreationTimeUp || this.sortBy == SORT_BY.ModificationTime && this.sortModificationTimeUp) {
            searchCriteriaBuilder.orderByDesc(this.sortBy.toString());
        } else {
            searchCriteriaBuilder.orderByAsc(this.sortBy.toString());
        }
        this.connectionItemSearchResult = this.search(searchCriteriaBuilder.build());
        List<ConnectionItem> connectionsToShow = this.getConnectionsForList(this.connectionItemSearchResult);
        ConnectionManager connectionManager = MgmtFactory.getConnectionManager();
        for (ConnectionItem connection : connectionsToShow) {
            Object conn = "IdP".equalsIgnoreCase(connection.getRole()) ? connectionManager.getIdpConnection(connection.getEntityId()) : connectionManager.getSpConnection(connection.getEntityId());
            if (conn == null) continue;
            boolean hasProblems = this.checkConnectionForErrors((ConnectionBase)conn, true);
            connection.setHasErrorsForListDisplay(hasProblems);
            if (!hasProblems) {
                connection.setRefreshed(true);
            }
            this.refreshedConnections.add(conn.getEntityId());
        }
        return connectionsToShow;
    }

    @Override
    public void formListener(IRequestCycle cycle) {
        this.refreshState();
    }

    private List<ConnectionItem> getConnectionsForList(SearchResult<ConnectionItem> searchResult) {
        if (searchResult.getResults().size() == 0 && this.paginationState != null && ((Pagination.State)this.paginationState).getCurrentPage() > 1) {
            ((Pagination.State)this.paginationState).reset();
            return this.sortAndFilter();
        }
        int toIndex = searchResult.getResults().size() > 20 ? 20 : searchResult.getResults().size();
        ArrayList<ConnectionItem> serializableList = new ArrayList<ConnectionItem>();
        serializableList.addAll(searchResult.getResults().subList(0, toIndex));
        return serializableList;
    }

    @Override
    public boolean isActive(ConnectionItem conn) {
        return this.getCurrentStatus(conn);
    }

    private void resetPaginationState() {
        if (this.paginationState != null) {
            ((Pagination.State)this.paginationState).reset();
        }
    }

    public boolean isHideStatusColumn() {
        return false;
    }

    public boolean isHideLicenseGroupColumn() {
        return false;
    }

    public void toggleShowAdvanced(IRequestCycle cycle) {
        this.setShowAdvancedFields(!this.isShowAdvancedFields());
    }

    public boolean isShowAdvancedFields() {
        return this.showAdvancedFields;
    }

    public void setShowAdvancedFields(boolean showAdvancedFields) {
        this.showAdvancedFields = showAdvancedFields;
    }

    public String getToggleAdvancedButtonText() {
        return (this.showAdvancedFields ? "Hide" : "Show") + " Advanced Fields";
    }

    public boolean isSelectiveReplicationEnabled() {
        return MgmtFactory.getClusterSettingsManager().isEnableSelectiveReplicationForConnections();
    }

    public static enum SORT_BY {
        Name,
        Id,
        VirtualIdentity,
        ModificationTime,
        CreationTime;

    }
}

