/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.admin.api.model.IdpConnection;
import com.pingidentity.admin.api.model.SpConnection;
import com.pingidentity.admin.api.validator.IdpConnectionValidator;
import com.pingidentity.admin.api.validator.SpConnectionValidator;
import com.pingidentity.common.util.xml.InvalidXmlException;
import com.pingidentity.dependency.error.DependencyErrorHandler;
import com.pingidentity.dependency.error.DependencyErrorUIValidator;
import com.pingidentity.dependency.error.DependencyErrorUIValidatorImpl;
import com.pingidentity.fsm.IWizard;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.data.DependencyType;
import com.pingidentity.fsm.tasklet.impl.ConnectionImportTasklet;
import com.pingidentity.pf.admin.rest.translator.IdpConnectionTranslator;
import com.pingidentity.pf.admin.rest.translator.SpConnectionTranslator;
import com.pingidentity.pf.common.api.validator.ValidatorContext;
import com.pingidentity.pf.common.api.validator.ValidatorRegistry;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.request.IUploadFile;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.xmlbeans.XmlException;
import org.sourceid.saml20.domain.ConnectionBase;
import org.sourceid.saml20.domain.mgmt.ConnectionManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.util.api.ConnectionDeserializer;
import org.sourceid.saml20.domain.util.api.ConnectionMigrationException;
import org.sourceid.saml20.domain.util.api.ConnectionMigrationMgr;
import org.sourceid.saml20.metadata.Role;

public class ConnectionImportState
extends TaskletState {
    private static final long serialVersionUID = 1L;
    private IUploadFile file;
    private boolean forceImport = false;
    private boolean importSuccessful = false;
    private boolean errorsFound = false;
    private ConnectionMigrationMgr connectionMigrationMgr = new ConnectionMigrationMgr();

    public ConnectionImportState(IWizard owner) {
        super(owner);
        this.setMenuName(this.getMessage("Menu_name"));
    }

    public void importConnection() {
        if (this.file == null || StringUtils.isBlank((String)this.file.getFileName())) {
            this.recordErrorMsg(this.getMessage("Not_selected"));
        } else if (this.file.getSize() == 0L) {
            this.recordErrorMsg(this.getMessage("Empty"));
        } else if (!this.validRole()) {
            if (!this.getDelegate().getHasErrors()) {
                Role role = ((ConnectionImportTasklet)this.getParent()).getRole();
                this.recordErrorMsg(this.getMessage("Invalid_role", new Object[]{role}));
                this.importSuccessful = false;
            }
        } else {
            this.log.info((Object)("importConnection called with allowUpdate: " + this.forceImport));
            ConnectionBase connection = this.validateConnection();
            if (!this.getDelegate().getHasErrors()) {
                this.deployConnection(connection);
            }
        }
    }

    private boolean validRole() {
        try {
            ConnectionDeserializer deserializer = new ConnectionDeserializer(this.file.getStream());
            ConnectionBase connection = deserializer.getConnection();
            Role role = ((ConnectionImportTasklet)this.getParent()).getRole();
            Role xmlRole = connection.getRoleType();
            return role == xmlRole;
        }
        catch (Exception e) {
            this.log.error((Object)"Error importing connection.", (Throwable)e);
            this.recordErrorMsg(this.getMessage("Invalid"));
            this.importSuccessful = false;
            return false;
        }
    }

    private ConnectionBase validateConnection() {
        try {
            IdpConnectionValidator connectionValidator;
            org.sourceid.saml20.domain.IdpConnection existingConn;
            ConnectionBase connection = this.connectionMigrationMgr.getConnectionWithBasicValidation(this.file.getStream(), this.forceImport, this.getCurrentUser());
            ConnectionManager connectionManager = MgmtFactory.getConnectionManager();
            ValidatorContext validatorContext = new ValidatorContext(false, null, this.getCurrentUser().isExpressionAdmin());
            Object object = existingConn = Role.IDP.equals((Object)connection.getRoleType()) ? connectionManager.getIdpConnection(connection.getEntityId()) : connectionManager.getSpConnection(connection.getEntityId());
            if (existingConn != null && this.forceImport) {
                validatorContext.setUpdateRequest(true);
                connection.setId(existingConn.getId());
            }
            if (Role.IDP.equals((Object)connection.getRoleType())) {
                IdpConnectionTranslator connectionTranslator = new IdpConnectionTranslator(validatorContext);
                IdpConnection idpConnection = connectionTranslator.domainToApi((org.sourceid.saml20.domain.IdpConnection)connection);
                connectionValidator = new IdpConnectionValidator((ConnectionBase)existingConn, idpConnection, new ValidatorRegistry(), true, validatorContext);
            } else {
                SpConnectionTranslator connectionTranslator = new SpConnectionTranslator(validatorContext);
                SpConnection spConnection = connectionTranslator.domainToApi((org.sourceid.saml20.domain.SpConnection)connection);
                connectionValidator = new SpConnectionValidator((ConnectionBase)existingConn, spConnection, new ValidatorRegistry(), true, validatorContext);
            }
            if (!connectionValidator.validate()) {
                this.recordErrors(connectionValidator.getErrors(), (IValidationDelegate)this.delegate);
                this.importSuccessful = false;
            }
            return connection;
        }
        catch (ConnectionMigrationException e) {
            Throwable cause = e.getCause();
            if (cause instanceof InvalidXmlException || cause instanceof XmlException) {
                this.recordErrorMsg(this.getMessage("Invalid"));
            } else {
                for (String errorMessage : e.getProblems()) {
                    this.recordErrorMsg(errorMessage);
                }
            }
            this.importSuccessful = false;
        }
        catch (Exception e) {
            this.log.error((Object)"Error importing connection.", (Throwable)e);
            this.recordErrorMsg(this.getMessage("Invalid"));
            this.importSuccessful = false;
        }
        return null;
    }

    private void deployConnection(ConnectionBase connection) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("importConnection called with xml: " + this.file.getFileName()));
        }
        ConnectionBase conn = this.connectionMigrationMgr.saveConnection(connection);
        this.log.info((Object)(conn.getRoleType() + " connection with name " + conn.getName() + " and entity id " + conn.getEntityId() + " saved"));
        this.importSuccessful = true;
        DependencyErrorUIValidatorImpl affectedItemValidator = new DependencyErrorUIValidatorImpl(this.getParent());
        DependencyErrorHandler dependencyErrorHandler = new DependencyErrorHandler();
        dependencyErrorHandler.performDependencyValidation((DependencyErrorUIValidator)affectedItemValidator, (Object)conn, DependencyType.PROTOCOL_SETTINGS);
    }

    public IUploadFile getFile() {
        return this.file;
    }

    public void setFile(IUploadFile file) {
        this.file = file;
    }

    public boolean isForceImport() {
        return this.forceImport;
    }

    public void setForceImport(boolean forceImport) {
        this.forceImport = forceImport;
    }

    public boolean isImportSuccessful() {
        return this.importSuccessful;
    }

    public boolean isErrorsFound() {
        return this.errorsFound;
    }
}

