/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.data.FieldItem;
import com.pingidentity.fsm.tasklet.impl.IdpConnectionConfigTasklet;
import com.pingidentity.fsm.tasklet.impl.SpConnectionConfigTasklet;
import com.pingidentity.templates.connection.ConnectionTemplate;
import com.pingidentity.templates.connection.ConnectionTemplateManager;
import com.pingidentity.util.StringPairPropertySelectionModel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.saml20.adapter.conf.Field;
import org.sourceid.saml20.adapter.conf.SimpleFieldList;
import org.sourceid.saml20.adapter.gui.FieldDescriptor;
import org.sourceid.saml20.adapter.gui.validation.ValidationException;
import org.sourceid.saml20.domain.SpConnection;
import org.sourceid.saml20.metadata.Role;

public class ConnectionTemplateState
extends TaskletState {
    private static final long serialVersionUID = 1L;
    private static final String SALESFORCE_TYPES_CONFIG_NAME = "salesforce-target-types";
    private transient ConfigStore salesforceTypesConfigStore = ConfigStoreFarm.getConfig((String)"salesforce-target-types");
    private static final String SALESFORCE_TYPES_LIST_NAME = "salesforce-target-types";
    private List<ConnectionTemplateWrapper> connectionTemplates;
    private String selectedTargetType;
    private List<String> salesforceTargetTypes;
    private String useTemplate = "false";
    private boolean stateReadOnly = false;

    public ConnectionTemplateState(Tasklet parent) {
        super(parent);
        this.setMenuName("Connection Template");
        Role role = this.isSpConnection() ? Role.SP : Role.IDP;
        this.connectionTemplates = this.buildConnectionTemplateList(role);
        this.salesforceTargetTypes = this.buildSalesforceTargetTypes();
    }

    @Override
    public void onResumeDraft() {
        Role role = this.isSpConnection() ? Role.SP : Role.IDP;
        ConnectionTemplateWrapper oldWrapper = this.getSelectedConnectionTemplate();
        if (oldWrapper != null) {
            List<ConnectionTemplateWrapper> newConnectionFieldItems = this.buildConnectionTemplateList(role);
            this.connectionTemplates = newConnectionFieldItems;
            ConnectionTemplateWrapper newWrapper = this.getSelectedConnectionTemplate();
            if (newWrapper != null) {
                if (oldWrapper.getFieldItems().size() != newWrapper.getFieldItems().size()) {
                    this.stateReadOnly = false;
                } else {
                    LinkedList<FieldDescriptor> newDescriptors = new LinkedList<FieldDescriptor>();
                    for (FieldItem fi : newWrapper.getFieldItems()) {
                        newDescriptors.add(fi.getFieldDescriptor());
                    }
                    Iterator descIterator = newDescriptors.iterator();
                    newWrapper.getFieldItems().clear();
                    for (FieldItem oldItem : oldWrapper.getFieldItems()) {
                        FieldDescriptor newDescriptor = (FieldDescriptor)descIterator.next();
                        FieldItem newItem = new FieldItem(newDescriptor, oldItem);
                        newWrapper.getFieldItems().add(newItem);
                    }
                }
            }
        } else {
            this.connectionTemplates = this.buildConnectionTemplateList(role);
        }
        super.onResumeDraft();
    }

    @Override
    public void populate(Object dataFromDisk) {
        this.getParent().reconfigureTransitions();
    }

    @Override
    public void onStateActivated() {
        this.getParent().reconfigureTransitions();
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        if (this.isUseTemplateToCreateConnection()) {
            if (this.selectedTargetType == null) {
                delegate.setFormComponent(null);
                delegate.record(this.getMessage("Connection_template_required"), ValidationConstraint.REQUIRED);
            } else {
                ConnectionTemplateWrapper selectedTemplate = this.getSelectedConnectionTemplate();
                if (selectedTemplate != null) {
                    ConnectionTemplate selectedConnectionTemplate = selectedTemplate.getConnectionTemplate();
                    ArrayList<String> errorMessages = new ArrayList<String>();
                    List<String> prereqErrorMessages = selectedConnectionTemplate.checkPrerequisites();
                    if (prereqErrorMessages != null) {
                        errorMessages.addAll(prereqErrorMessages);
                    }
                    List<FieldDescriptor> fieldDescriptors = selectedConnectionTemplate.getFieldDescriptors();
                    SimpleFieldList fieldItems = selectedTemplate.getFieldItemsAsSimpleFieldList();
                    if (fieldDescriptors != null) {
                        for (FieldDescriptor fieldDescriptor : fieldDescriptors) {
                            List validationChain = fieldDescriptor.getValidationChain();
                            if (validationChain == null) continue;
                            for (FieldDescriptor.FieldValidationWrapper fieldValidator : validationChain) {
                                try {
                                    Field field = fieldItems.getField(fieldDescriptor.getName());
                                    if (!StringUtils.isNotBlank((String)field.getValue()) && fieldValidator.isSkipIfValueIsEmpty()) continue;
                                    fieldValidator.getValidator().validate(field);
                                }
                                catch (ValidationException e) {
                                    List fieldErrorMessages = e.getErrorMessages();
                                    for (String fieldErrorMessage : fieldErrorMessages) {
                                        String correctedFieldErrorMessage = StringUtils.replace((String)fieldErrorMessage, (String)fieldDescriptor.getName(), (String)fieldDescriptor.getDescription());
                                        errorMessages.add(correctedFieldErrorMessage);
                                    }
                                }
                            }
                        }
                    }
                    for (String errorMessage : errorMessages) {
                        delegate.setFormComponent(null);
                        delegate.record(errorMessage, ValidationConstraint.REQUIRED);
                    }
                }
            }
        }
    }

    @Override
    public boolean isSaveDraftAvailable() {
        return false;
    }

    @Override
    public boolean onStateExit() {
        if (this.isUseTemplateToCreateConnection() && !this.stateReadOnly) {
            ConnectionTemplateWrapper templateWrapper = this.getSelectedConnectionTemplate();
            ConnectionTemplate connectionTemplate = templateWrapper.getConnectionTemplate();
            SimpleFieldList templateFields = templateWrapper.getFieldItemsAsSimpleFieldList();
            SpConnection templateConnection = (SpConnection)connectionTemplate.getConnection(templateFields);
            SpConnectionConfigTasklet spConnTasklet = (SpConnectionConfigTasklet)this.getParent();
            if (templateConnection != null) {
                templateConnection.setConnectionTargetType(this.selectedTargetType);
                HashMap<String, String> connectionTemplateProperties = new HashMap<String, String>();
                List<FieldItem> fieldItems = this.getSelectedConnectionTemplate().getFieldItems();
                if (fieldItems != null) {
                    for (FieldItem fieldItem : fieldItems) {
                        connectionTemplateProperties.put(fieldItem.getFieldDescriptor().getName(), fieldItem.getValue());
                    }
                }
                templateConnection.setConnectionTemplateProperties(connectionTemplateProperties);
                spConnTasklet.populateTemplate(templateConnection);
            }
            spConnTasklet.setSummaryStateClickable(false);
            this.stateReadOnly = true;
        }
        return true;
    }

    public String getSelectedTargetType() {
        return this.selectedTargetType;
    }

    public void setSelectedTargetType(String selectedTargetType) {
        this.selectedTargetType = selectedTargetType;
    }

    public String getSelectedTargetTypeDescription() {
        String description = "No Template";
        ConnectionTemplateWrapper selectedConnectionTemplate = this.getSelectedConnectionTemplate();
        if (selectedConnectionTemplate != null) {
            description = selectedConnectionTemplate.getConnectionTemplate().getDescription();
        }
        return description;
    }

    public List<ConnectionTemplateWrapper> getConnectionTemplates() {
        return this.connectionTemplates;
    }

    public boolean isSelectedConnectionTemplate(String templateId) {
        return this.selectedTargetType != null && this.selectedTargetType.equals(templateId);
    }

    public boolean showSelectedConnectionTemplateNote() {
        ConnectionTemplateWrapper template = this.getSelectedConnectionTemplate();
        return template != null && template.getConnectionTemplate().getNote() != null;
    }

    public String getSelectedConnectionTemplateNote() {
        String note = "";
        ConnectionTemplateWrapper template = this.getSelectedConnectionTemplate();
        if (template != null && template.getConnectionTemplate().getNote() != null) {
            note = template.getConnectionTemplate().getNote();
        }
        return note;
    }

    public String getUseTemplate() {
        return this.useTemplate;
    }

    public void setUseTemplate(String useTemplate) {
        this.useTemplate = useTemplate;
    }

    public boolean isUseTemplateToCreateConnection() {
        return Boolean.parseBoolean(this.useTemplate);
    }

    public StringPairPropertySelectionModel getTargetTypeList() {
        StringPairPropertySelectionModel model = new StringPairPropertySelectionModel(true);
        for (ConnectionTemplateWrapper templateWrapper : this.connectionTemplates) {
            model.add(templateWrapper.getConnectionTemplate().getDescription(), templateWrapper.getConnectionTemplateId());
        }
        return model;
    }

    public ConnectionTemplateWrapper getSelectedConnectionTemplate() {
        for (ConnectionTemplateWrapper templateWrapper : this.connectionTemplates) {
            if (!templateWrapper.getConnectionTemplateId().equals(this.selectedTargetType)) continue;
            return templateWrapper;
        }
        return null;
    }

    public boolean isSalesforceConnection() {
        return this.salesforceTargetTypes.contains(this.selectedTargetType);
    }

    public boolean isIdpConnection() {
        return this.findParent(IdpConnectionConfigTasklet.class) != null;
    }

    public boolean isSpConnection() {
        return this.findParent(SpConnectionConfigTasklet.class) != null;
    }

    public boolean isStateReadOnly() {
        return this.stateReadOnly;
    }

    private List<String> buildSalesforceTargetTypes() {
        return this.salesforceTypesConfigStore.getListValue("salesforce-target-types", Collections.EMPTY_LIST);
    }

    public boolean hasConnectionTemplates() {
        if (this.connectionTemplates == null) {
            return false;
        }
        return this.connectionTemplates.size() > 0;
    }

    private List<ConnectionTemplateWrapper> buildConnectionTemplateList(Role role) {
        ConnectionTemplateManager templateManager = new ConnectionTemplateManager();
        List<ConnectionTemplate> templateList = templateManager.getConnectionTemplates(role);
        ArrayList<ConnectionTemplateWrapper> connTemplates = new ArrayList<ConnectionTemplateWrapper>();
        for (ConnectionTemplate template : templateList) {
            List<FieldItem> fieldItems = this.buildFieldItems(template.getFieldDescriptors());
            ConnectionTemplateWrapper connectionTemplate = new ConnectionTemplateWrapper(template, fieldItems);
            connTemplates.add(connectionTemplate);
        }
        return connTemplates;
    }

    private List<FieldItem> buildFieldItems(List<FieldDescriptor> fieldDescriptors) {
        ArrayList<FieldItem> fieldItems = new ArrayList<FieldItem>();
        if (fieldDescriptors != null) {
            for (FieldDescriptor fieldDescriptor : fieldDescriptors) {
                FieldItem fieldItem = new FieldItem(fieldDescriptor);
                fieldItem.setValue(fieldDescriptor.getDefaultValue());
                fieldItems.add(fieldItem);
            }
        }
        return fieldItems;
    }

    private class ConnectionTemplateWrapper
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private transient ConnectionTemplate connectionTemplate;
        private List<FieldItem> fieldItems;
        private String connectionTemplateId;

        public ConnectionTemplateWrapper(ConnectionTemplate template, List<FieldItem> fldItems) {
            this.connectionTemplate = template;
            this.fieldItems = fldItems;
            this.connectionTemplateId = template.getId();
        }

        public ConnectionTemplate getConnectionTemplate() {
            return this.connectionTemplate;
        }

        public List<FieldItem> getFieldItems() {
            return this.fieldItems;
        }

        public SimpleFieldList getFieldItemsAsSimpleFieldList() {
            ArrayList<Field> fields = new ArrayList<Field>();
            for (FieldItem fieldItem : this.fieldItems) {
                Field field = new Field(fieldItem.getFieldDescriptor().getName(), fieldItem.getValue());
                fields.add(field);
            }
            return new SimpleFieldList(fields);
        }

        public String getConnectionTemplateId() {
            return this.connectionTemplateId;
        }
    }
}

