/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.component.common.SelectedOption;
import com.pingidentity.component.common.SelectionFilterList;
import com.pingidentity.fsm.IWizard;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.sourceid.saml20.adapter.gui.FilterableSelectionFieldDescriptor;
import org.sourceid.saml20.domain.Affiliation;
import org.sourceid.saml20.domain.ConnectionBase;
import org.sourceid.saml20.domain.SpConnection;
import org.sourceid.saml20.domain.mgmt.ConnectionManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.util.filter.ConnectionFilter;
import org.sourceid.saml20.domain.util.filter.FilterCriteria;
import org.sourceid.saml20.metadata.Role;
import org.sourceid.websso.Protocol;

public class CreateAffiliationState
extends TaskletState {
    private static final long serialVersionUID = 20050515L;
    private String selectedConnectionDisplayName;
    private String selectedConnectionTypeAndId;
    private List<String> selectedSpMembersList = new ArrayList<String>();
    private List<String> availableSpConnectionsList = new ArrayList<String>();
    private List<String> allSpConnections = new ArrayList<String>();
    private String selectedSp;

    public CreateAffiliationState(IWizard owner) {
        super(owner);
        this.setMenuName("Affiliation Membership");
    }

    @Override
    public void onStateActivated() {
        this.configureLists();
    }

    @Override
    public void populate(Object dataFromDisk) {
        Affiliation affiliation = (Affiliation)dataFromDisk;
        if (affiliation != null) {
            this.selectedSpMembersList = affiliation.getMembers();
        }
        this.configureLists();
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        ConnectionManager connectionManager = MgmtFactory.getConnectionManager();
        for (String member : this.selectedSpMembersList) {
            String name = connectionManager.getSpConnection(member).getName();
            summaryList.add(new SummaryInfo(this.getMessage("Member"), name, this));
        }
    }

    @Override
    public boolean populateAllStates(Object importedAffiliation) {
        this.populate(importedAffiliation);
        return true;
    }

    @Override
    public boolean save(Object dataToDisk) {
        Affiliation affiliation = (Affiliation)dataToDisk;
        affiliation.setMembers(this.selectedSpMembersList);
        return true;
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        if (this.selectedSpMembersList.size() == 0) {
            delegate.setFormComponent(null);
            delegate.record(this.getMessage("Selected_member_required"), ValidationConstraint.REQUIRED);
        }
    }

    public void add() {
        if (!StringUtils.isBlank((String)this.selectedSp)) {
            if (this.selectedSpMembersList.contains(this.selectedSp)) {
                this.delegate.setFormComponent(null);
                this.delegate.record(this.getMessage("Duplicate_member_selected"), ValidationConstraint.REQUIRED);
                return;
            }
            for (int i = 0; i < this.availableSpConnectionsList.size(); ++i) {
                if (!this.availableSpConnectionsList.get(i).equals(this.selectedSp)) continue;
                this.availableSpConnectionsList.remove(i);
            }
            this.selectedSpMembersList.add(this.selectedSp);
            Collections.sort(this.selectedSpMembersList);
            this.selectedConnectionDisplayName = null;
            this.selectedSp = null;
            this.selectedConnectionTypeAndId = null;
        }
    }

    public void delete(Integer indexToRemove, String spConnection) {
        this.selectedSpMembersList.remove(indexToRemove);
        this.availableSpConnectionsList.add(spConnection);
        this.selectedSp = null;
    }

    public String getSpName(String entityId) {
        String name = entityId;
        ConnectionManager connectionManager = MgmtFactory.getConnectionManager();
        SpConnection connection = connectionManager.getSpConnection(entityId);
        if (connection != null) {
            name = connection.getName();
        }
        return name;
    }

    private void configureLists() {
        this.allSpConnections = new ArrayList<String>();
        ConnectionManager connectionManager = MgmtFactory.getConnectionManager();
        FilterCriteria idpCriteria = new FilterCriteria();
        idpCriteria.setRoles(new Role[]{Role.SP});
        idpCriteria.setProtocols(new Protocol[]{Protocol.SAML20});
        ConnectionFilter spFilter = new ConnectionFilter(idpCriteria);
        for (ConnectionBase cb : spFilter.filter(connectionManager.getAllConnections())) {
            this.allSpConnections.add(cb.getEntityId());
        }
        HashSet<String> selectedSpMembersSet = new HashSet<String>(this.selectedSpMembersList);
        HashSet<String> allSpConnectionsSet = new HashSet<String>(this.allSpConnections);
        allSpConnectionsSet.removeAll(selectedSpMembersSet);
        this.availableSpConnectionsList = new ArrayList<String>();
        this.availableSpConnectionsList.addAll(allSpConnectionsSet);
        Collections.sort(this.selectedSpMembersList);
    }

    public List<String> getSelectedSpMembersList() {
        return this.selectedSpMembersList;
    }

    public List<String> getSelectedSpMembersListCopy() {
        List<String> selectedSpMembersListCopy = this.getSelectedSpMembersList().stream().collect(Collectors.toList());
        return selectedSpMembersListCopy;
    }

    public void setSelectedSpMembersList(List<String> selectedSpMembersList) {
        this.selectedSpMembersList = selectedSpMembersList;
    }

    public String getSelectedSp() {
        return this.selectedSp;
    }

    public void setSelectedSp(String selectedSp) {
        this.selectedSp = selectedSp;
    }

    public String getSelectedConnectionTypeAndId() {
        return this.selectedConnectionTypeAndId;
    }

    public void setSelectedConnectionTypeAndId(String selectedConnectionTypeAndId) {
        if (!StringUtils.isEmpty((String)selectedConnectionTypeAndId)) {
            this.selectedConnectionTypeAndId = selectedConnectionTypeAndId;
            SelectedOption option = SelectionFilterList.parseSelectedOptionString(selectedConnectionTypeAndId);
            this.selectedSp = option.getId();
        }
    }

    public String getSelectedConnectionDisplayName() {
        return this.selectedConnectionDisplayName;
    }

    public void setSelectedConnectionDisplayName(String selectedConnectionDisplayName) {
        this.selectedConnectionDisplayName = selectedConnectionDisplayName;
    }

    public List<FilterableSelectionFieldDescriptor.SearchableTypeConfig> getSearchableTypes() {
        List<FilterableSelectionFieldDescriptor.QueryParam> list = Collections.singletonList(new FilterableSelectionFieldDescriptor.QueryParam("saml20Only", "true"));
        return Collections.singletonList(new FilterableSelectionFieldDescriptor.SearchableTypeConfig(FilterableSelectionFieldDescriptor.SearchableType.SP_CONNECTION, list));
    }
}

