/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.fsm.state.impl.PolicyManagementTasklet;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.api.AccountLinkingApi;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.fsm.tasklet.impl.AssertionCreationTasklet;
import com.pingidentity.fsm.tasklet.impl.ConnectionTasklet;
import com.pingidentity.fsm.tasklet.impl.IdpConnectionConfigTasklet;
import com.pingidentity.fsm.tasklet.impl.MultiProtocolTasklet;
import com.pingidentity.fsm.tasklet.impl.SpConnectionConfigTasklet;
import com.pingidentity.fsm.tasklet.impl.SpProtocolSettingsTasklet;
import com.pingidentity.fsm.tasklet.impl.WsTrustSpTokenCreationTasklet;
import com.pingidentity.util.StringPairPropertySelectionModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.saml1x.profiles.ap.CreateResponse;
import org.sourceid.saml20.domain.AssertionAttributeContract;
import org.sourceid.saml20.domain.AttributeContract;
import org.sourceid.saml20.domain.ConnectionBase;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.SpConnection;
import org.sourceid.websso.Protocol;

public class CreateAttributeContractState
extends TaskletState {
    private static final long serialVersionUID = 20050515L;
    protected AttributeContract contract = new AssertionAttributeContract();
    protected Set<String> maskedAttributeNames = new HashSet<String>();
    protected String subjectNameFormat;
    protected String attributeNameFormatLabel;
    protected String extendedContractLabel;
    private transient Object componentState;
    private boolean isWsFedJwt;
    private boolean displayCoreContract = true;

    public CreateAttributeContractState(Tasklet value) {
        super(value);
        this.setMenuName("Attribute Contract");
        this.setAttributeNameFormatLabel("Attribute Name Format");
        this.setExtendedContractLabel("Extend the Contract");
    }

    public CreateAttributeContractState(Tasklet value, String name) {
        super(value, name);
        this.setMenuName("Attribute Contract");
        this.setAttributeNameFormatLabel("Attribute Name Format");
        this.setExtendedContractLabel("Extend the Contract");
    }

    @Override
    public String getNoteKey() {
        if (this.getProtocol() == Protocol.OIDC && this.getClass().equals(CreateAttributeContractState.class)) {
            return super.getNoteKey() + "_Oidc";
        }
        return super.getNoteKey();
    }

    @Override
    public void onStateActivated() {
        this.createAttributeContract();
    }

    @Override
    public boolean onStateExit() {
        boolean success = super.onStateExit();
        if (success) {
            Tasklet parentTasklet = this.getParent();
            if (parentTasklet instanceof AssertionCreationTasklet) {
                AssertionCreationTasklet creationTasklet = (AssertionCreationTasklet)this.getParent();
                creationTasklet.cleanAttributeMappings(this.contract.getAllAttributeNames());
            } else if (parentTasklet instanceof WsTrustSpTokenCreationTasklet) {
                WsTrustSpTokenCreationTasklet creationTasklet = (WsTrustSpTokenCreationTasklet)this.getParent();
                creationTasklet.cleanAttributeMappings(this.contract.getAllAttributeNames());
            } else if (parentTasklet instanceof PolicyManagementTasklet) {
                PolicyManagementTasklet creationTasklet = (PolicyManagementTasklet)this.getParent();
                creationTasklet.cleanAttributeMappings(this.contract.getAllAttributeNames());
            }
        }
        return success;
    }

    @Override
    public void populate(Object dataFromDisk) {
        ConnectionBase connection = (ConnectionBase)dataFromDisk;
        this.componentState = null;
        AttributeContract localContract = new AttributeContract();
        AttributeContract existingContract = connection.getAttributeContract();
        if (existingContract != null) {
            HashSet immutableAttributeNames = new HashSet(existingContract.getImmutableAttributeNames());
            localContract.setImmutableAttributeNames(immutableAttributeNames);
            HashMap<String, String> mutableAttributeInfo = new HashMap<String, String>();
            HashSet attributeNames = new HashSet(existingContract.getMutableAttributeNames());
            for (String attributeName : attributeNames) {
                mutableAttributeInfo.put(attributeName, existingContract.getMutableAttributeNameFormat(attributeName));
            }
            localContract.setMutableAttributesInfo(mutableAttributeInfo);
        }
        this.setContract(localContract);
        if (connection instanceof IdpConnection) {
            this.maskedAttributeNames = ((IdpConnection)connection).getMaskedAttributeNames();
        }
        if (this.isIncludeSubjectNameFormat().booleanValue()) {
            this.subjectNameFormat = ((SpConnection)connection).getNameIdFormat();
        }
        this.onStateActivated();
    }

    @Override
    public boolean populateAllStates(Object data) {
        ConnectionBase connection = (ConnectionBase)data;
        AttributeContract contractFromConnection = connection.getAttributeContract();
        if (contractFromConnection == null) {
            connection.setAttributeContract(this.makeEmptyAttributeContract(false, false));
        }
        this.setContract(connection.getAttributeContract());
        this.onStateActivated();
        return true;
    }

    @Override
    public boolean save(Object dataToDisk) {
        ConnectionBase tempConnection = (ConnectionBase)dataToDisk;
        AttributeContract attributeContract = new AttributeContract();
        attributeContract.setImmutableAttributeNames(this.contract.getImmutableAttributeNames());
        HashMap<String, String> mutableAttributeInfo = new HashMap<String, String>();
        HashSet attributeNames = new HashSet(this.contract.getMutableAttributeNames());
        for (String attributeName : attributeNames) {
            mutableAttributeInfo.put(attributeName, this.contract.getMutableAttributeNameFormat(attributeName));
        }
        attributeContract.setMutableAttributesInfo(mutableAttributeInfo);
        tempConnection.setAttributeContract(attributeContract);
        if (tempConnection instanceof IdpConnection) {
            ((IdpConnection)tempConnection).setMaskedAttributeNames(this.maskedAttributeNames);
        }
        if (this.isIncludeSubjectNameFormat().booleanValue() && this.subjectNameFormat != null) {
            ((SpConnection)tempConnection).setNameIdFormat(this.subjectNameFormat);
        }
        return true;
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        if (this.displayCoreContract) {
            for (String item : this.contract.getSortedImmutableAttributeNames()) {
                summaryList.add(new SummaryInfo("Attribute", item, this));
            }
        }
        if (StringUtils.isNotBlank((String)this.subjectNameFormat)) {
            summaryList.add(new SummaryInfo("Subject Name Format", this.subjectNameFormat, this));
        }
        for (String item : this.contract.getSortedMutableAttributeNames()) {
            summaryList.add(new SummaryInfo("Attribute", item, this));
            String attribNameFormat = this.contract.getMutableAttributeNameFormat(item);
            if (!StringUtils.isNotBlank((String)attribNameFormat)) continue;
            summaryList.add(new SummaryInfo("Attribute Name Format", attribNameFormat, this));
        }
    }

    @Override
    public void reset() {
        this.componentState = null;
        this.maskedAttributeNames = new HashSet<String>();
        this.resetAttributeContract(this.isWsFedJwt);
    }

    public boolean allowSamlSubject() {
        return this.getParent(SpProtocolSettingsTasklet.class) == null;
    }

    public Object getComponentState() {
        return this.componentState;
    }

    public void setComponentState(Object componentState) {
        this.componentState = componentState;
    }

    public AttributeContract getContract() {
        return this.contract;
    }

    public void setContract(AttributeContract attributeContract) {
        this.contract = attributeContract;
    }

    public Set<String> getMaskedAttributeNames() {
        return this.maskedAttributeNames;
    }

    public void setMaskedAttributeNames(Set<String> maskedAttributeNames) {
        this.maskedAttributeNames = maskedAttributeNames;
    }

    public Boolean isMaskValues() {
        return this.findParent(IdpConnectionConfigTasklet.class) != null;
    }

    public Boolean isIncludeAttributeNameFormat() {
        SpConnectionConfigTasklet spConnectionTasklet = this.findParent(SpConnectionConfigTasklet.class);
        return !this.isWsFedJwt && spConnectionTasklet != null && (spConnectionTasklet.getProtocolType() == Protocol.SAML20 || spConnectionTasklet.getProtocolType() == Protocol.SAML11 || spConnectionTasklet.getProtocolType() == Protocol.WSFED);
    }

    public StringPairPropertySelectionModel getAttributeNameFormatModel() {
        StringPairPropertySelectionModel model = new StringPairPropertySelectionModel();
        if (this.isIncludeAttributeNameFormat().booleanValue()) {
            ConnectionTasklet connectionTasklet = this.findParent(ConnectionTasklet.class);
            ConfigStore customNameFormatConfigStore = ConfigStoreFarm.getConfig((String)"custom-name-formats");
            if (connectionTasklet.getProtocolType() == Protocol.SAML20) {
                model.add("urn:oasis:names:tc:SAML:2.0:attrname-format:basic", "urn:oasis:names:tc:SAML:2.0:attrname-format:basic");
                model.add("urn:oasis:names:tc:SAML:2.0:attrname-format:unspecified", "urn:oasis:names:tc:SAML:2.0:attrname-format:unspecified");
                model.add("urn:oasis:names:tc:SAML:2.0:attrname-format:uri", "urn:oasis:names:tc:SAML:2.0:attrname-format:uri");
            } else if (connectionTasklet.getProtocolType() == Protocol.SAML11) {
                ConfigStore createResponseConfig = ConfigStoreFarm.getConfig(CreateResponse.class);
                Iterator ns = createResponseConfig.getStringValue("ns", "ns:unspecified");
                model.add((String)((Object)ns), ns);
            } else if (connectionTasklet.getProtocolType() == Protocol.WSFED) {
                model.add("http://schemas.xmlsoap.org/claims", "http://schemas.xmlsoap.org/claims");
                Map stsAttributeNamespaces = customNameFormatConfigStore.getMapValue("sts-attribute-namespaces", Collections.EMPTY_MAP);
                for (Object key : stsAttributeNamespaces.keySet()) {
                    model.add((String)key, stsAttributeNamespaces.get(key));
                }
            }
            Map customAttributeNameFormats = customNameFormatConfigStore.getMapValue("attribute-name-formats", Collections.EMPTY_MAP);
            for (Object key : customAttributeNameFormats.keySet()) {
                model.add((String)key, customAttributeNameFormats.get(key));
            }
            HashSet<String> nameFormats = new HashSet<String>();
            for (String nameFormat2 : this.contract.getMutableAttributesInfo().values()) {
                nameFormats.add(nameFormat2);
            }
            nameFormats.stream().forEach(nameFormat -> model.add((String)nameFormat, nameFormat));
        }
        return model;
    }

    public Boolean isIncludeSubjectNameFormat() {
        SpConnectionConfigTasklet spConnectionTasklet = this.findParent(SpConnectionConfigTasklet.class);
        AssertionCreationTasklet act = this.findParent(AssertionCreationTasklet.class);
        return spConnectionTasklet != null && spConnectionTasklet.getProtocolType() != Protocol.WSFED && !act.isTransientIdentifierEnabled() && !act.isAccountLinkingEnabled();
    }

    public StringPairPropertySelectionModel getSubjectNameFormatModel() {
        ConnectionTasklet connectionTasklet = this.findParent(ConnectionTasklet.class);
        StringPairPropertySelectionModel model = new StringPairPropertySelectionModel();
        if (this.isIncludeSubjectNameFormat().booleanValue()) {
            ConfigStore customNameFormatConfigStore = ConfigStoreFarm.getConfig((String)"custom-name-formats");
            Map customSubjectNameFormats = Collections.EMPTY_MAP;
            if (connectionTasklet.getProtocolType() == Protocol.SAML20) {
                model.add("urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified", "urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified");
                model.add("urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress", "urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress");
                model.add("urn:oasis:names:tc:SAML:1.1:nameid-format:X509SubjectName", "urn:oasis:names:tc:SAML:1.1:nameid-format:X509SubjectName");
                model.add("urn:oasis:names:tc:SAML:1.1:nameid-format:WindowsDomainQualifiedName", "urn:oasis:names:tc:SAML:1.1:nameid-format:WindowsDomainQualifiedName");
                model.add("urn:oasis:names:tc:SAML:2.0:nameid-format:kerberos", "urn:oasis:names:tc:SAML:2.0:nameid-format:kerberos");
                model.add("urn:oasis:names:tc:SAML:2.0:nameid-format:entity", "urn:oasis:names:tc:SAML:2.0:nameid-format:entity");
                customSubjectNameFormats = customNameFormatConfigStore.getMapValue("saml2-subject-name-formats", Collections.EMPTY_MAP);
            } else if (connectionTasklet.getProtocolType() == Protocol.SAML11) {
                model.add("urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified", "urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified");
                model.add("urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress", "urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress");
                model.add("urn:oasis:names:tc:SAML:1.1:nameid-format:X509SubjectName", "urn:oasis:names:tc:SAML:1.1:nameid-format:X509SubjectName");
                model.add("urn:oasis:names:tc:SAML:1.1:nameid-format:WindowsDomainQualifiedName", "urn:oasis:names:tc:SAML:1.1:nameid-format:WindowsDomainQualifiedName");
                model.add("urn:oasis:names:tc:SAML:1.0:assertion#emailAddress (Deprecated)", "urn:oasis:names:tc:SAML:1.0:assertion#emailAddress");
                model.add("urn:oasis:names:tc:SAML:1.0:assertion#X509SubjectName (Deprecated)", "urn:oasis:names:tc:SAML:1.0:assertion#X509SubjectName");
                model.add("urn:oasis:names:tc:SAML:1.0:assertion#WindowsDomainQualifiedName (Deprecated)", "urn:oasis:names:tc:SAML:1.0:assertion#WindowsDomainQualifiedName");
                customSubjectNameFormats = customNameFormatConfigStore.getMapValue("saml11-subject-name-formats", Collections.EMPTY_MAP);
            } else if (connectionTasklet.getProtocolType() == Protocol.SAML10) {
                model.add("urn:oasis:names:tc:SAML:1.0:assertion#emailAddress", "urn:oasis:names:tc:SAML:1.0:assertion#emailAddress");
                model.add("urn:oasis:names:tc:SAML:1.0:assertion#X509SubjectName", "urn:oasis:names:tc:SAML:1.0:assertion#X509SubjectName");
                model.add("urn:oasis:names:tc:SAML:1.0:assertion#WindowsDomainQualifiedName", "urn:oasis:names:tc:SAML:1.0:assertion#WindowsDomainQualifiedName");
                customSubjectNameFormats = customNameFormatConfigStore.getMapValue("saml10-subject-name-formats", Collections.EMPTY_MAP);
            }
            for (Object key : customSubjectNameFormats.keySet()) {
                model.add((String)key, customSubjectNameFormats.get(key));
            }
        }
        return model;
    }

    public String getSubjectNameFormat() {
        return this.subjectNameFormat;
    }

    public void setSubjectNameFormat(String subjectNameFormat) {
        this.subjectNameFormat = subjectNameFormat;
    }

    public String getAttributeNameFormatLabel() {
        return this.attributeNameFormatLabel;
    }

    public void setAttributeNameFormatLabel(String attributeNameFormatLabel) {
        this.attributeNameFormatLabel = attributeNameFormatLabel;
    }

    public String getExtendedContractLabel() {
        return this.extendedContractLabel;
    }

    public void setExtendedContractLabel(String extendedContractLabel) {
        this.extendedContractLabel = extendedContractLabel;
    }

    protected AttributeContract makeEmptyAttributeContract(boolean includePseudonym, boolean includeTransientId) {
        return new AssertionAttributeContract(includePseudonym, includeTransientId, this.getProtocol());
    }

    private void createAttributeContract() {
        MultiProtocolTasklet multiProtocolTasklet = this.findParent(MultiProtocolTasklet.class);
        if (multiProtocolTasklet != null && (multiProtocolTasklet.isSamlProtocol() || multiProtocolTasklet.isConnectionProtocolOIDC())) {
            AccountLinkingApi ala = this.findParent(AccountLinkingApi.class);
            boolean includePseudonym = false;
            boolean includeTransientId = false;
            if (ala != null) {
                if (ala instanceof AssertionCreationTasklet) {
                    includePseudonym = ala.isAccountLinkingEnabled();
                }
                includeTransientId = ala.isTransientIdentifierEnabled();
            }
            AttributeContract attributeContract = this.makeEmptyAttributeContract(includePseudonym, includeTransientId);
            attributeContract.setMutableAttributesInfo(this.contract.getMutableAttributesInfo());
            this.contract = attributeContract;
        }
    }

    @Override
    public void refreshState() {
        this.createAttributeContract();
    }

    public void updateKeyContext(boolean isWsFedJwt) {
        if (this.isWsFedJwt != isWsFedJwt) {
            this.resetAttributeContract(isWsFedJwt);
        }
        this.isWsFedJwt = isWsFedJwt;
        if (isWsFedJwt) {
            this.setKeyContext("jwt");
        } else {
            this.setKeyContext(null);
        }
    }

    private void resetAttributeContract(boolean isWsFedJwt) {
        if (isWsFedJwt) {
            this.contract = new AttributeContract();
            this.setExtendedContractLabel("Attribute");
        } else {
            this.contract = this.makeEmptyAttributeContract(false, false);
            this.setExtendedContractLabel("Extend the Contract");
        }
    }

    private Protocol getProtocol() {
        ConnectionTasklet tasklet = this.findParent(ConnectionTasklet.class);
        if (tasklet != null) {
            return tasklet.getProtocolType();
        }
        return null;
    }

    public boolean getDisplayCoreContract() {
        return this.displayCoreContract;
    }

    public void setDisplayCoreContract(boolean displayCoreContract) {
        this.displayCoreContract = displayCoreContract;
    }
}

