/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.admin.api.validator.NewKeyPairSettingsValidator;
import com.pingidentity.common.util.PropertyInfo;
import com.pingidentity.component.common.SimpleFieldDescriptor;
import com.pingidentity.component.common.TableEditor;
import com.pingidentity.component.common.TableRow;
import com.pingidentity.crypto.Cert;
import com.pingidentity.crypto.CertificateGenerator;
import com.pingidentity.crypto.CertificateService;
import com.pingidentity.crypto.KeyAlgorithmInfo;
import com.pingidentity.crypto.PkCert;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.data.CertItem;
import com.pingidentity.fsm.tasklet.data.CertificateTypes;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.pingcommons.crypto.JavaAlgorithmNames;
import com.pingidentity.util.StringPairPropertySelectionModel;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.ProviderException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.form.IPropertySelectionModel;
import org.apache.tapestry.form.StringPropertySelectionModel;
import org.apache.tapestry.valid.IValidationDelegate;
import org.sourceid.config.GlobalRegistry;

public class CreateCertState
extends TaskletState
implements TableEditor.TableEditorListener {
    private static final long serialVersionUID = 20050515L;
    private CertificateService certService = (CertificateService)GlobalRegistry.getService(CertificateService.class);
    private String commonName;
    private String org;
    private String orgUnit;
    private String city;
    private String state;
    private String country;
    private String validDays = "365";
    private StringPairPropertySelectionModel keyAlgList;
    private String selectedKeyAlg;
    private StringPairPropertySelectionModel keySizeList;
    private String selectedKeySize;
    private StringPairPropertySelectionModel signatureAlgorithmList;
    private String selectedSignatureAlgorithm;
    private CertItem certItem;
    private boolean keyAlgorithmChanged = false;
    private StringPairPropertySelectionModel cryptoProviderList;
    private String selectedCryptoProvider;
    private List<TableRow> subjectAlternativeNames = new ArrayList<TableRow>();
    private static final SimpleFieldDescriptor SUBJECT_ALTERNATIVE_NAME_TYPE = new SimpleFieldDescriptor(SimpleFieldDescriptor.FieldType.DROPDOWN, "General Name", 200);
    private static final SimpleFieldDescriptor SUBJECT_ALTERNATIVE_NAME_VALUE = new SimpleFieldDescriptor(SimpleFieldDescriptor.FieldType.TEXT, "Value", 200);
    private transient Object componentState;

    public CreateCertState(Tasklet value) {
        super(value);
        this.setMenuName("Create Certificate");
        ArrayList<String> dropDownListOptions = new ArrayList<String>();
        String subjectAlternativeNameDropDownDefaultDisplay = "-- Select --";
        dropDownListOptions.add(subjectAlternativeNameDropDownDefaultDisplay);
        dropDownListOptions.addAll(PkCert.getSupportedSubjectAlternativeNameTypes());
        SUBJECT_ALTERNATIVE_NAME_TYPE.setModelValues((IPropertySelectionModel)new StringPropertySelectionModel(dropDownListOptions.toArray(new String[0])));
    }

    @Override
    public void onStateActivated() {
        Collection availableAlgorithms = this.certService.getAvailableKeyAlgorithms();
        if (!availableAlgorithms.isEmpty()) {
            this.selectedKeyAlg = (String)availableAlgorithms.iterator().next();
        }
        this.createKeySizeList();
        if (PropertyInfo.isHSMHybrid()) {
            this.createCryptoProviderList();
        }
    }

    private void createCryptoProviderList() {
        this.cryptoProviderList = new StringPairPropertySelectionModel();
        this.cryptoProviderList.add("Local Trust Store", "local");
        this.cryptoProviderList.add(PropertyInfo.getHSMMode().getDescription(), PropertyInfo.getHSMMode().name());
    }

    public List<String> generate(CertificateTypes.ValidTypes certType) {
        ArrayList<String> errors = new ArrayList<String>();
        try {
            Boolean isHSMProvider = null;
            if (PropertyInfo.isHSMHybrid()) {
                isHSMProvider = "local".equals(this.selectedCryptoProvider) ? Boolean.valueOf(false) : Boolean.valueOf(true);
            }
            PkCert cert = new PkCert.Builder().cn(this.commonName).ou(this.orgUnit).o(this.org).l(this.city).st(this.state).c(this.country).validDays(Integer.parseInt(this.validDays)).keyAlgo(this.selectedKeyAlg).keySize(Integer.parseInt(this.selectedKeySize)).sigAlgorithm(this.selectedSignatureAlgorithm).isHSMProvider(isHSMProvider).subjectAlternativeNameMap(this.getSubjectAlternativeNameMap()).certificateType(CertificateGenerator.CertificateType.lookupByName((String)certType.name())).build();
            this.certItem = new CertItem((Cert)cert);
            this.certItem.setNewCert(true);
        }
        catch (IOException io) {
            this.log.debug((Object)("There was an IOException thrown when trying to generate the cert!! " + io));
        }
        catch (GeneralSecurityException g) {
            this.log.debug((Object)("There was a GeneralSecurityException thrown when trying to generate the cert!! " + g));
        }
        catch (ProviderException pe) {
            String errorMsg = "Failed to generate a self-signed certificate. The selected cryptographic algorithm (" + this.selectedSignatureAlgorithm + ") may not be supported by the cryptographic provider used.";
            this.log.debug((Object)errorMsg, (Throwable)pe);
            errors.add(errorMsg);
        }
        return errors;
    }

    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city.trim();
    }

    public String getCommonName() {
        return this.commonName;
    }

    public void setCommonName(String commonName) {
        this.commonName = commonName.trim();
    }

    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country.trim().toUpperCase();
    }

    public StringPairPropertySelectionModel getKeyAlgList() {
        this.keyAlgList = new StringPairPropertySelectionModel();
        for (String keyAlg : this.certService.getAvailableKeyAlgorithms()) {
            this.keyAlgList.add(keyAlg, keyAlg);
        }
        return this.keyAlgList;
    }

    public StringPairPropertySelectionModel getCryptoProviderList() {
        return this.cryptoProviderList;
    }

    public String getSelectedKeyAlg() {
        return this.selectedKeyAlg;
    }

    public void setSelectedKeyAlg(String selectedKeyAlg) {
        if (!Objects.equals(this.selectedKeyAlg, selectedKeyAlg)) {
            this.keyAlgorithmChanged = true;
            this.selectedKeyAlg = selectedKeyAlg;
        }
    }

    private void createKeySizeList() {
        this.keySizeList = new StringPairPropertySelectionModel();
        this.signatureAlgorithmList = new StringPairPropertySelectionModel();
        if (this.selectedKeyAlg != null) {
            KeyAlgorithmInfo info = this.certService.getKeyAlgorithmInfo(this.selectedKeyAlg);
            for (Integer keySize : info.getKeySizes()) {
                this.keySizeList.add(keySize.toString(), keySize.toString());
            }
            this.selectedKeySize = Integer.toString(info.getDefaultKeySize());
            for (String sigAlgorithm : info.getSignatureAlgorithms()) {
                this.signatureAlgorithmList.add(JavaAlgorithmNames.SignatureName.getDisplayName((String)sigAlgorithm), sigAlgorithm);
            }
            this.selectedSignatureAlgorithm = info.getDefaultSignatureAlgorithm();
        }
    }

    public StringPairPropertySelectionModel getKeySizeList() {
        return this.keySizeList;
    }

    @Override
    public void formListener(IRequestCycle cycle) {
        if (this.keyAlgorithmChanged) {
            this.createKeySizeList();
            this.keyAlgorithmChanged = false;
        }
    }

    public String getSelectedKeySize() {
        return this.selectedKeySize;
    }

    public void setSelectedKeySize(String selectedKeySize) {
        this.selectedKeySize = selectedKeySize;
    }

    public String getOrg() {
        return this.org;
    }

    public void setOrg(String org) {
        this.org = org.trim();
    }

    public String getOrgUnit() {
        return this.orgUnit;
    }

    public void setOrgUnit(String orgUnit) {
        this.orgUnit = orgUnit.trim();
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state.trim();
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        NewKeyPairSettingsValidator validator = new NewKeyPairSettingsValidator(this.commonName, this.org, this.orgUnit, this.city, this.stateName, this.country, this.validDays, this.selectedKeyAlg, this.selectedKeySize, this.selectedSignatureAlgorithm);
        validator.validate();
        this.recordErrors(validator.getErrors(), delegate);
    }

    public CertItem getCertItem() {
        return this.certItem;
    }

    public String getValidDays() {
        return this.validDays;
    }

    public void setValidDays(String validDays) {
        this.validDays = validDays;
    }

    public StringPairPropertySelectionModel getSignatureAlgorithmList() {
        return this.signatureAlgorithmList;
    }

    public void setSignatureAlgorithmList(StringPairPropertySelectionModel signatureAlgorithmList) {
        this.signatureAlgorithmList = signatureAlgorithmList;
    }

    public String getSelectedSignatureAlgorithm() {
        return this.selectedSignatureAlgorithm;
    }

    public String getSelectedSignatureAlgorithmForDisplay() {
        if (this.selectedSignatureAlgorithm == null) {
            return null;
        }
        return JavaAlgorithmNames.SignatureName.getDisplayName((String)this.selectedSignatureAlgorithm);
    }

    public Map<String, String> getSubjectAlternativeNameMap() {
        HashMap<String, String> nameTypeMap = new HashMap<String, String>();
        for (TableRow row : this.subjectAlternativeNames) {
            if (row.isMarkedForDelete()) continue;
            nameTypeMap.put(this.getSubjectAlternativeNameValue(row), this.getSubjectAlternativeNameType(row));
        }
        return nameTypeMap;
    }

    private String getConcatenatedSubjectAlternativeNames() {
        return this.subjectAlternativeNames.stream().filter(san -> !san.isMarkedForDelete()).map(this::getSubjectAlternativeNameValue).collect(Collectors.joining(", "));
    }

    public void setSelectedSignatureAlgorithm(String selectedSignatureAlgorithm) {
        this.selectedSignatureAlgorithm = selectedSignatureAlgorithm;
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        summaryList.add(new SummaryInfo(this.getMessage("Common_name"), this.getCommonName(), this));
        summaryList.add(new SummaryInfo(this.getMessage("Subject_alternative_names"), this.getConcatenatedSubjectAlternativeNames(), this));
        summaryList.add(new SummaryInfo(this.getMessage("Organization"), this.getOrg(), this));
        summaryList.add(new SummaryInfo(this.getMessage("Organizational_unit"), this.getOrgUnit(), this));
        summaryList.add(new SummaryInfo(this.getMessage("City"), this.getCity(), this));
        summaryList.add(new SummaryInfo(this.getMessage("State"), this.getState(), this));
        summaryList.add(new SummaryInfo(this.getMessage("Country"), this.getCountry(), this));
        summaryList.add(new SummaryInfo(this.getMessage("Valid_days_summary"), this.getValidDays(), this));
        if (PropertyInfo.isHSMHybrid()) {
            summaryList.add(new SummaryInfo(this.getMessage("Crypto_provider"), this.cryptoProviderList.getDescription(this.selectedCryptoProvider), this));
        }
        summaryList.add(new SummaryInfo(this.getMessage("Key_algorithm"), this.getSelectedKeyAlg(), this));
        summaryList.add(new SummaryInfo(this.getMessage("Key_size"), this.getSelectedKeySize(), this));
        summaryList.add(new SummaryInfo(this.getMessage("Signature_algorithm"), this.getSelectedSignatureAlgorithmForDisplay(), this));
    }

    public void setSelectedCryptoProvider(String selectedCryptoProvider) {
        this.selectedCryptoProvider = selectedCryptoProvider;
    }

    public String getSelectedCryptoProvider() {
        return this.selectedCryptoProvider;
    }

    public List<SimpleFieldDescriptor> getSubjectAlternativeNameColumnDescriptors() {
        ArrayList<SimpleFieldDescriptor> columnDescriptors = new ArrayList<SimpleFieldDescriptor>();
        columnDescriptors.add(SUBJECT_ALTERNATIVE_NAME_TYPE);
        columnDescriptors.add(SUBJECT_ALTERNATIVE_NAME_VALUE);
        return columnDescriptors;
    }

    public Object getComponentState() {
        return this.componentState;
    }

    public void setComponentState(Object componentState) {
        this.componentState = componentState;
    }

    public List<TableRow> getSubjectAlternativeNames() {
        return this.subjectAlternativeNames;
    }

    public void setSubjectAlternativeNames(List<TableRow> subjectAlternativeNames) {
        this.subjectAlternativeNames = subjectAlternativeNames;
    }

    @Override
    public List<String> validate(TableRow row, TableRow originalRow, List<TableRow> list, TableEditor owner) {
        ArrayList<String> errors = new ArrayList<String>();
        if (this.containDuplicate(list, row, originalRow)) {
            errors.add("Duplicate subject alternative names are not allowed.");
        }
        if (!this.isValidSubjectAlternativeNameTypeValuePair(row)) {
            errors.add("Subject Alternative Name value must be a valid IP address or DNS name.");
        }
        return errors;
    }

    @Override
    public void onAddItem(TableEditor owner, TableRow newRow) {
    }

    @Override
    public void onUpdateItem(TableEditor owner, TableRow originalRow, TableRow updatedRow) {
    }

    private String getSubjectAlternativeNameType(TableRow row) {
        return row.getFields().get(0).getValue();
    }

    private String getSubjectAlternativeNameValue(TableRow row) {
        return row.getFields().get(1).getValue();
    }

    private boolean isSameSubjectAlternativeName(TableRow updatedRow, TableRow originalRow) {
        return this.getSubjectAlternativeNameType(updatedRow).equals(this.getSubjectAlternativeNameType(originalRow)) && this.getSubjectAlternativeNameValue(updatedRow).equals(this.getSubjectAlternativeNameValue(originalRow));
    }

    private boolean containDuplicate(List<TableRow> existingRows, TableRow updatedRow, TableRow originalRow) {
        if (!updatedRow.isNewRow() && this.isSameSubjectAlternativeName(updatedRow, originalRow)) {
            return false;
        }
        return existingRows.stream().anyMatch(existingRow -> this.isSameSubjectAlternativeName(updatedRow, (TableRow)existingRow));
    }

    private boolean isValidSubjectAlternativeNameTypeValuePair(TableRow updatedRow) {
        return PkCert.isValidSubjectAlternativeNameTypeValuePair((String)this.getSubjectAlternativeNameType(updatedRow), (String)this.getSubjectAlternativeNameValue(updatedRow));
    }
}

