/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.fsm.state.impl.CreateAttributeContractState;
import com.pingidentity.fsm.state.impl.PolicyManagementTasklet;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.sourceid.openid.connect.domain.OpenIdConnectProviderPolicy;
import org.sourceid.openid.connect.domain.UserInfoAttrContract;
import org.sourceid.saml20.domain.AttributeContract;

public class CreatePolicyContractState
extends CreateAttributeContractState {
    private static final long serialVersionUID = 20130225L;
    private Set<String> idTokenList = new HashSet<String>();
    private Set<String> userInfoList = new HashSet<String>();
    private Set<String> multiValuedList = new HashSet<String>();

    public CreatePolicyContractState(Tasklet value) {
        super(value);
        this.setMenuName("Attribute Contract");
        this.contract = new UserInfoAttrContract();
    }

    @Override
    public void populate(Object dataFromDisk) {
        OpenIdConnectProviderPolicy.PolicyGroup policyGroup = (OpenIdConnectProviderPolicy.PolicyGroup)dataFromDisk;
        UserInfoAttrContract contractCopy = new UserInfoAttrContract(policyGroup.getUserInfoAttributeContract());
        this.setContract(contractCopy);
        this.setComponentState(null);
        this.populateTokenCustomization(policyGroup);
    }

    private void populateTokenCustomization(OpenIdConnectProviderPolicy.PolicyGroup policyGroup) {
        HashSet<String> newIdTokenList = new HashSet<String>();
        HashSet<String> newUserInfoList = new HashSet<String>();
        HashSet<String> newMultiValuedList = new HashSet<String>();
        if (!policyGroup.getAttributeInclusionMappings().isEmpty()) {
            for (Map.Entry entry : policyGroup.getAttributeInclusionMappings().entrySet()) {
                if (((OpenIdConnectProviderPolicy.AttributeInclusionInfo)entry.getValue()).isIncludeInIdToken()) {
                    newIdTokenList.add((String)entry.getKey());
                }
                if (!((OpenIdConnectProviderPolicy.AttributeInclusionInfo)entry.getValue()).isIncludeInUserInfo()) continue;
                newUserInfoList.add((String)entry.getKey());
            }
        }
        if (!policyGroup.getMultiValuedAttributes().isEmpty()) {
            for (String attrName : policyGroup.getMultiValuedAttributes()) {
                newMultiValuedList.add(attrName);
            }
        }
        this.setIdTokenList(newIdTokenList);
        this.setUserInfoList(newUserInfoList);
        this.setMultiValuedList(newMultiValuedList);
    }

    @Override
    public boolean populateAllStates(Object data) {
        OpenIdConnectProviderPolicy.PolicyGroup policyGroup = (OpenIdConnectProviderPolicy.PolicyGroup)data;
        this.setContract(policyGroup.getUserInfoAttributeContract());
        this.populateTokenCustomization(policyGroup);
        return true;
    }

    @Override
    public boolean save(Object dataToDisk) {
        OpenIdConnectProviderPolicy.PolicyGroup policyGroup = (OpenIdConnectProviderPolicy.PolicyGroup)dataToDisk;
        UserInfoAttrContract contractCopy = new UserInfoAttrContract(this.getContract());
        policyGroup.setUserInfoAttributeContract(contractCopy);
        policyGroup.getAttributeInclusionMappings().clear();
        if (!(this.getIdTokenList().isEmpty() && this.getUserInfoList().isEmpty() && this.getMultiValuedList().isEmpty())) {
            for (String attr : contractCopy.getAllAttributeNames()) {
                boolean includeInIdToken = this.getIdTokenList().contains(attr);
                boolean includeInUserInfo = this.getUserInfoList().contains(attr);
                boolean multiValued = this.getMultiValuedList().contains(attr);
                if (includeInIdToken || includeInUserInfo) {
                    policyGroup.getAttributeInclusionMappings().put(attr, new OpenIdConnectProviderPolicy.AttributeInclusionInfo(includeInIdToken, includeInUserInfo));
                }
                if (!multiValued) continue;
                policyGroup.getMultiValuedAttributes().add(attr);
            }
        }
        return true;
    }

    @Override
    public void reset() {
        this.contract = new UserInfoAttrContract();
    }

    public UserInfoAttrContract getContract() {
        return (UserInfoAttrContract)super.getContract();
    }

    @Override
    public void setContract(AttributeContract contract) {
        this.setContract((UserInfoAttrContract)contract);
    }

    public void setContract(UserInfoAttrContract attributeContract) {
        super.setContract((AttributeContract)attributeContract);
    }

    @Override
    public Boolean isIncludeAttributeNameFormat() {
        return false;
    }

    @Override
    public Boolean isIncludeSubjectNameFormat() {
        return false;
    }

    public Set<String> getIdTokenList() {
        return this.idTokenList;
    }

    public void setIdTokenList(Set<String> idTokenList) {
        this.idTokenList = idTokenList;
    }

    public Set<String> getUserInfoList() {
        return this.userInfoList;
    }

    public void setUserInfoList(Set<String> userInfoList) {
        this.userInfoList = userInfoList;
    }

    public Set<String> getMultiValuedList() {
        return this.multiValuedList;
    }

    public void setMultiValuedList(Set<String> multiValuedList) {
        this.multiValuedList = multiValuedList;
    }

    public boolean getShowIdCustomization() {
        PolicyManagementTasklet policyManagementTasklet = (PolicyManagementTasklet)this.getParent();
        return !policyManagementTasklet.getPolicy().isIncludeUserInfoInIdToken();
    }

    @Override
    public void onStateActivated() {
        super.onStateActivated();
        if (!this.getShowIdCustomization()) {
            this.idTokenList.clear();
            this.userInfoList.clear();
        }
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        for (String item : this.contract.getImmutableAttributeNames()) {
            summaryList.add(new SummaryInfo("Attribute", item, this));
        }
        for (String item : this.contract.getSortedMutableAttributeNames()) {
            summaryList.add(new SummaryInfo("Attribute", this.getSummaryAttributeName(item), this));
        }
    }

    private String getSummaryAttributeName(String attribNameFormat) {
        Object summary = attribNameFormat;
        ArrayList<String> addOn = new ArrayList<String>();
        if (this.idTokenList.contains(attribNameFormat)) {
            addOn.add("ID Token");
        }
        if (this.userInfoList.contains(attribNameFormat)) {
            addOn.add("UserInfo");
        }
        if (this.multiValuedList.contains(attribNameFormat)) {
            addOn.add("Multi-Valued Selected");
        }
        if (!addOn.isEmpty()) {
            summary = (String)summary + " (" + String.join((CharSequence)", ", addOn) + ")";
        }
        return summary;
    }
}

