/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.fsm.tasklet.SingleTaskletState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.impl.ConnectionTasklet;
import com.pingidentity.fsm.tasklet.impl.CredentialsTasklet;
import com.pingidentity.fsm.tasklet.impl.MultiProtocolTasklet;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.sourceid.saml20.domain.ConnectionBase;

public class CredentialsState
extends SingleTaskletState {
    private static final long serialVersionUID = 20050515L;

    public CredentialsState(Tasklet value) {
        super(value);
        this.setMenuName("Credentials");
    }

    @Override
    public void onStateActivated() {
        this.populate(null);
    }

    @Override
    public void populate(Object dataFromDisk) {
        ConnectionBase connection = (ConnectionBase)dataFromDisk;
        CredentialsTasklet tasklet = this.getTaskletToEdit(CredentialsTasklet.class);
        if (tasklet == null) {
            tasklet = this.createTasklet(CredentialsTasklet.class);
            tasklet.configureTasklet();
            tasklet.reconfigureTransitions();
            if (connection != null) {
                tasklet.populate(connection);
            }
            this.setTasklet(tasklet);
        } else {
            ConnectionTasklet connTasklet = this.getParent(ConnectionTasklet.class);
            if (!connTasklet.isDraft()) {
                tasklet.configureTasklet();
            }
            tasklet.reconfigureTransitions();
        }
    }

    @Override
    public boolean populateAllStates(Object data) {
        CredentialsTasklet tasklet = (CredentialsTasklet)this.getTaskletToEdit();
        if (tasklet == null) {
            tasklet = this.createTasklet(CredentialsTasklet.class);
            tasklet.configureTasklet();
            tasklet.reconfigureTransitions();
            if (data != null) {
                tasklet.populateAllStates(data);
            }
            this.setTasklet(tasklet);
        } else {
            ConnectionTasklet connTasklet = this.getParent(ConnectionTasklet.class);
            if (!connTasklet.isDraft()) {
                tasklet.configureTasklet();
            }
            tasklet.reconfigureTransitions();
            tasklet.populateAllStates(data);
        }
        return true;
    }

    public boolean isCanEncrypt() {
        return this.getParent(MultiProtocolTasklet.class).isConnectionProtocol20();
    }

    public boolean showInboundBackChannel() {
        CredentialsTasklet t = this.getTaskletToEdit(CredentialsTasklet.class);
        return t != null ? t.showInboundBackChannel() : false;
    }

    public boolean showOutboundBackChannel() {
        CredentialsTasklet t = this.getTaskletToEdit(CredentialsTasklet.class);
        return t != null ? t.showOutboundBackChannel() : false;
    }

    public boolean showSignatureVerificationSettingsInfo() {
        CredentialsTasklet t = this.getTaskletToEdit(CredentialsTasklet.class);
        return t != null ? t.showSignatureVerificationSettingsInfo() : false;
    }

    public boolean showDsigSigningKey() {
        CredentialsTasklet t = this.getTaskletToEdit(CredentialsTasklet.class);
        return t != null ? t.showDsigSigningKey() : false;
    }

    public boolean showEncryptionCertificate() {
        CredentialsTasklet t = this.getTaskletToEdit(CredentialsTasklet.class);
        return t != null ? t.showEncryptionCertificate() : false;
    }

    public boolean showDecryptionCertificate() {
        CredentialsTasklet t = this.getTaskletToEdit(CredentialsTasklet.class);
        return t != null ? t.showDecryptionCertificate() : false;
    }

    public boolean showSecondaryDigitalSignature() {
        CredentialsTasklet t = this.getTaskletToEdit(CredentialsTasklet.class);
        return t != null ? t.showSecondaryDigitalSignature() : false;
    }

    public String getBackChannelAuthenticationConfigured() {
        CredentialsTasklet t = this.getTaskletToEdit(CredentialsTasklet.class);
        return t != null ? t.getBackChannelAuthenticationConfigured() : null;
    }

    public String getInboundBackChannelAuthenticationConfigured() {
        CredentialsTasklet t = this.getTaskletToEdit(CredentialsTasklet.class);
        return t != null ? t.getInboundBackChannelAuthenticationConfigured() : null;
    }

    public String getOutboundBackChannelAuthenticationConfigured() {
        CredentialsTasklet t = this.getTaskletToEdit(CredentialsTasklet.class);
        return t != null ? t.getOutboundBackChannelAuthenticationConfigured() : null;
    }

    public String getDigitalSignatureConfigured() {
        CredentialsTasklet t = this.getTaskletToEdit(CredentialsTasklet.class);
        return t != null ? t.getDigitalSignatureConfigured() : null;
    }

    public String getSecondaryDigitalSignatureConfigured() {
        CredentialsTasklet t = this.getTaskletToEdit(CredentialsTasklet.class);
        return t != null ? t.getSecondaryDigitalSignatureConfigured() : null;
    }

    public List<String> getActiveSignatureVerificationCertStrings() {
        CredentialsTasklet t = this.getTaskletToEdit(CredentialsTasklet.class);
        if (t != null) {
            List<String> digitalSignatureVerificationConfigured = t.getActiveSignatureVerificationCertStrings();
            if (digitalSignatureVerificationConfigured.isEmpty()) {
                return Collections.singletonList("Not Configured");
            }
            return Stream.concat(Stream.of("Unanchored Certificate(s):"), digitalSignatureVerificationConfigured.stream()).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public boolean isAnchored() {
        CredentialsTasklet t = this.getTaskletToEdit(CredentialsTasklet.class);
        return t != null ? t.isAnchored() : false;
    }

    public String getSubjectDn() {
        CredentialsTasklet t = this.getTaskletToEdit(CredentialsTasklet.class);
        return "Subject DN: " + t.getSubjectDn();
    }

    public String getEncryptionCertificateConfigured() {
        CredentialsTasklet t = this.getTaskletToEdit(CredentialsTasklet.class);
        return t != null ? t.getEncryptionCertificateConfigured() : null;
    }

    public String getDecryptionCertificateConfigured() {
        CredentialsTasklet t = this.getTaskletToEdit(CredentialsTasklet.class);
        return t != null ? t.getDecryptionCertificatesConfigured() : null;
    }

    public void metaDataReset() {
        CredentialsTasklet tasklet = this.getTaskletToEdit(CredentialsTasklet.class);
        if (tasklet != null) {
            tasklet.metaDataReset();
        }
    }
}

