/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.admin.api.validator.JdbcDataStoreValidator;
import com.pingidentity.admin.api.validator.JdbcTagConfigValidator;
import com.pingidentity.component.common.FieldItem;
import com.pingidentity.component.common.SimpleFieldDescriptor;
import com.pingidentity.component.common.TableEditor;
import com.pingidentity.component.common.TableRow;
import com.pingidentity.fsm.impl.Wizard;
import com.pingidentity.fsm.state.impl.AdvancedDataBaseOptionsState;
import com.pingidentity.fsm.state.impl.ManageDataSourcesState;
import com.pingidentity.fsm.state.impl.TagableDataStoreState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.data.Mode;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.fsm.tasklet.impl.DataSourceTasklet;
import com.pingidentity.fsm.tasklet.impl.SingleStateTasklet;
import com.pingidentity.sdk.secretmanager.SecretManagerException;
import com.pingidentity.sdk.secretmanager.SecretReferenceUtil;
import com.pingidentity.util.StringPairPropertySelectionModel;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.apache.tapestry.valid.ValidationDelegate;
import org.sourceid.saml20.domain.DataSource;
import org.sourceid.saml20.domain.JdbcDataSource;
import org.sourceid.saml20.domain.SecretType;
import org.sourceid.saml20.domain.datasource.tag.JdbcInstanceIdentifier;
import org.sourceid.saml20.domain.datasource.tag.JdbcTagConfig;
import org.sourceid.saml20.domain.log.AdminAuditLogger;
import org.sourceid.saml20.domain.mgmt.DataSourceManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class CustomDataBaseConfigState
extends TaskletState
implements TagableDataStoreState<JdbcInstanceIdentifier>,
TableEditor.TableEditorListener {
    private static final long serialVersionUID = 20050515L;
    private String defaultJdbcUrl;
    private String driver;
    private String userName;
    private String password;
    private SecretType secretType = SecretType.INTERNALLY_MANAGED;
    private SecretType previousSecretTypeSelected;
    private String secretManagerPassword;
    private String id;
    private JdbcDataSource jdbc;
    private Tasklet advancedDatabaseOptionsTasklet;
    private boolean maskAttributeValues;
    private String validateConn;
    private boolean isMultiValueAttrsAllowed = true;
    private String sourceName;
    private String connectionTestSuccessfulMessage = null;
    private List<TableRow> jdbcTagTable = new ArrayList<TableRow>();
    private transient Object componentState;
    private StringPairPropertySelectionModel testConnectionList;
    private String testConnectionId;
    private static final int TEST_CONNECTION_MIN_POOL_SIZE = 1;
    private static final String TAG_COL_NAME = "Tags";
    private static final String JDBC_URL_COL_NAME = "JDBC URL";
    private final SimpleFieldDescriptor TAG_DESC = new SimpleFieldDescriptor.Builder().setType(SimpleFieldDescriptor.FieldType.TEXT).setName("Tags").setWidth(200).setDescriptorId("tags").create();
    private final SimpleFieldDescriptor JDBC_URL_DESC = new SimpleFieldDescriptor.Builder().setType(SimpleFieldDescriptor.FieldType.TEXT).setName("JDBC URL").setWidth(200).setDescriptorId("jdbcUrl").setRequiredField(true).create();

    public CustomDataBaseConfigState(Tasklet value) {
        super(value);
        this.setMenuName("Database Config");
        this.createTestConnectionList();
    }

    @Override
    public void populate(Object dataFromDisk) {
        this.jdbc = (JdbcDataSource)dataFromDisk;
        this.id = this.jdbc.getId();
        this.defaultJdbcUrl = this.jdbc.getConnectionUrl();
        this.driver = this.jdbc.getDriverClass();
        this.userName = this.jdbc.getUserName();
        if (SecretReferenceUtil.isSecretReference((String)this.jdbc.getPassword())) {
            this.secretType = SecretType.SECRET_MANAGER;
            this.secretManagerPassword = this.jdbc.getPassword();
        } else {
            this.secretType = SecretType.INTERNALLY_MANAGED;
            this.password = this.jdbc.getPassword();
        }
        this.maskAttributeValues = this.jdbc.isMaskAttributeValues();
        this.sourceName = this.jdbc.getDsName();
        this.validateConn = this.jdbc.getCheckValidConnectionSql();
        this.isMultiValueAttrsAllowed = this.jdbc.isMultiValueAttributesAllowed();
        this.populateTagInfo(this.jdbc.getJdbcTagConfigList());
        this.createAndPopulateAdvancedDataBaseOptionsTasklet();
    }

    @Override
    public void onStateActivated() {
        if (!this.isShowSourceName() && this.getParent() != null && this.getParent() instanceof DataSourceTasklet) {
            this.sourceName = ((DataSourceTasklet)this.getParent()).getSourceName();
        }
        if (!this.isShowMaskLogValues() && this.getParent() != null && this.getParent() instanceof DataSourceTasklet) {
            this.maskAttributeValues = ((DataSourceTasklet)this.getParent()).isMaskAttributeValues();
        }
        this.createAndPopulateAdvancedDataBaseOptionsTasklet();
        this.createTestConnectionList();
    }

    @Override
    public void refreshState() {
        this.createTestConnectionList();
    }

    @Override
    public boolean save(Object dataToDisk) {
        JdbcDataSource tempJdbc = (JdbcDataSource)dataToDisk;
        this.fillJdbcDataSource(tempJdbc);
        if (this.advancedDatabaseOptionsTasklet != null) {
            this.advancedDatabaseOptionsTasklet.save(tempJdbc);
        }
        this.jdbc = tempJdbc;
        return true;
    }

    @Override
    public void loadTaskletToEdit() {
        if (this.advancedDatabaseOptionsTasklet == null) {
            this.createAndPopulateAdvancedDataBaseOptionsTasklet();
        }
        this.loadTasklet(this.advancedDatabaseOptionsTasklet);
    }

    private void createAndPopulateAdvancedDataBaseOptionsTasklet() {
        if (this.advancedDatabaseOptionsTasklet == null) {
            SingleStateTasklet tasklet;
            tasklet.setFinishAvailable(!(tasklet = this.createTaskletToLoad(SingleStateTasklet.class, "AdvancedDataBaseOptionsTasklet", "Advanced Database Options")).showFinishButtonIfAuditor());
            tasklet.setFinishLabel("Done");
            tasklet.setInitialState(new AdvancedDataBaseOptionsState(tasklet));
            tasklet.setMode(Mode.edit);
            this.advancedDatabaseOptionsTasklet = tasklet;
        }
        this.advancedDatabaseOptionsTasklet.populate(this.jdbc);
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        summaryList.add(new SummaryInfo(this.getMessage("InstanceName"), this.sourceName, this));
        this.doTaggingSummary(summaryList);
        summaryList.add(new SummaryInfo(this.getMessage("Driver"), this.driver, this));
        summaryList.add(new SummaryInfo(this.getMessage("Username"), this.userName, this));
        if (SecretType.SECRET_MANAGER.equals((Object)this.secretType)) {
            summaryList.add(new SummaryInfo(this.getMessage("Password_reference"), this.secretManagerPassword, this));
        }
        summaryList.add(new SummaryInfo(this.getMessage("Validate_connection"), this.validateConn, this));
        summaryList.add(new SummaryInfo(this.getMessage("Mask_attribute_values"), Boolean.toString(this.maskAttributeValues), this));
        summaryList.add(new SummaryInfo(this.getMessage("Allow_multi_value_attributes"), String.valueOf(this.isMultiValueAttrsAllowed), this));
        Optional.of(this.advancedDatabaseOptionsTasklet).map(Wizard::getSourceState).filter(state -> state instanceof AdvancedDataBaseOptionsState).ifPresent(state -> ((AdvancedDataBaseOptionsState)state).doSummary(summaryList));
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        this.fillDefaultDataSource(new JdbcDataSource());
        List<JdbcTagConfig> jdbcTagTableConfigList = this.convertTagTableRow(this.jdbcTagTable);
        JdbcTagConfigValidator jdbcTagConfigValidator = new JdbcTagConfigValidator(jdbcTagTableConfigList);
        JdbcDataStoreValidator validator = new JdbcDataStoreValidator.Builder().setConnectionUrl(this.defaultJdbcUrl).setId(this.id).setDriverClass(this.driver).setPassword(SecretType.SECRET_MANAGER.equals((Object)this.secretType) ? this.secretManagerPassword : this.password).setUseSecretManager(SecretType.SECRET_MANAGER.equals((Object)this.secretType)).setValidateConnectionUrl(false).setJdbcTagConfigValidator(jdbcTagConfigValidator).setCreate(false).build();
        if (!validator.validate()) {
            this.recordErrors(validator.getErrors(), delegate);
        }
        if (this.isShowSourceName() && StringUtils.isBlank((String)this.sourceName)) {
            delegate.setFormComponent(null);
            delegate.record(this.getMessage("Name_required"), ValidationConstraint.REQUIRED);
        }
        DataSourceTasklet dataSourceTasklet = this.getParent(DataSourceTasklet.class);
        if (this.isShowSourceName() && dataSourceTasklet.isDuplicate(this.sourceName, this.findParentState(ManageDataSourcesState.class), true)) {
            delegate.setFormComponent(null);
            delegate.record(this.getMessage("Instance_name_in_use"), ValidationConstraint.REQUIRED);
        }
    }

    @Override
    public boolean onStateExit() {
        return true;
    }

    @Override
    public void formListener(IRequestCycle cycle) {
        if (SecretType.SECRET_MANAGER.equals((Object)this.secretType)) {
            this.password = "";
        } else {
            this.secretManagerPassword = "";
        }
    }

    private void fillJdbcDataSource(JdbcDataSource ds) {
        ds.setId(this.id);
        ds.setDriverClass(this.driver);
        if (StringUtils.isNotEmpty((String)this.userName)) {
            ds.setUserName(this.userName);
        }
        if (SecretType.SECRET_MANAGER.equals((Object)this.secretType)) {
            ds.setPassword(this.secretManagerPassword);
        } else if (StringUtils.isNotEmpty((String)this.password)) {
            ds.setPassword(this.password);
        }
        ds.setMaskAttributeValues(this.maskAttributeValues);
        ds.setDescription(this.sourceName);
        ds.setDsName(this.sourceName);
        ds.setCheckValidConnectionSql(this.validateConn);
        ds.setMultiValueAttributesAllowed(this.isMultiValueAttrsAllowed);
        ds.setJdbcTagConfigList(this.getDataStoreTaggingInfo());
        this.fillDefaultDataSource(ds);
    }

    private void fillDefaultDataSource(JdbcDataSource jdbc) {
        jdbc.setConnectionUrl(null);
        this.defaultJdbcUrl = null;
        for (TableRow row : this.jdbcTagTable) {
            if (!row.isDefault() || row.isMarkedForDelete()) continue;
            String tableDefaultJdbcUrl = this.getFieldValue(row, this.JDBC_URL_DESC);
            jdbc.setConnectionUrl(tableDefaultJdbcUrl);
            this.defaultJdbcUrl = tableDefaultJdbcUrl;
        }
    }

    public String getDriver() {
        return this.driver;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public String getDefaultJdbcUrl() {
        return this.defaultJdbcUrl;
    }

    public void setDefaultJdbcUrl(String defaultJdbcUrl) {
        this.defaultJdbcUrl = defaultJdbcUrl;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = this.previousSecretTypeSelected != null && !this.previousSecretTypeSelected.equals((Object)this.secretType) ? "" : password;
    }

    public SecretType getSecretType() {
        return this.secretType;
    }

    public void setSecretType(SecretType secretType) {
        this.previousSecretTypeSelected = this.secretType;
        this.secretType = secretType;
    }

    public String getSecretManagerPassword() {
        return this.secretManagerPassword;
    }

    public void setSecretManagerPassword(String secretManagerPassword) {
        this.secretManagerPassword = this.previousSecretTypeSelected != null && !this.previousSecretTypeSelected.equals((Object)this.secretType) ? "" : secretManagerPassword;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public JdbcDataSource getJdbc() {
        return this.jdbc;
    }

    public void setJdbc(JdbcDataSource jdbc) {
        this.jdbc = jdbc;
    }

    public String getId() {
        return this.id;
    }

    public boolean isMaskAttributeValues() {
        return this.maskAttributeValues;
    }

    public void setMaskAttributeValues(boolean maskAttributeValues) {
        this.maskAttributeValues = maskAttributeValues;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public void setSourceName(String sourceName) {
        this.sourceName = sourceName;
    }

    public void setValidateConn(String validateConn) {
        this.validateConn = validateConn;
    }

    public String getValidateConn() {
        return this.validateConn;
    }

    public boolean isMultiValueAttributesAllowed() {
        return this.isMultiValueAttrsAllowed;
    }

    public void setMultiValueAttributesAllowed(boolean multiValueAttsAllowed) {
        this.isMultiValueAttrsAllowed = multiValueAttsAllowed;
    }

    public StringPairPropertySelectionModel getTestConnectionList() {
        return this.testConnectionList;
    }

    public void setTestConnectionList(StringPairPropertySelectionModel testConnectionList) {
        this.testConnectionList = testConnectionList;
    }

    public String getTestConnectionId() {
        return this.testConnectionId;
    }

    public void setTestConnectionId(String testConnectionId) {
        this.testConnectionId = testConnectionId;
    }

    public boolean isShowSourceName() {
        return this.getParent().getMode() == Mode.edit;
    }

    public boolean isShowMaskLogValues() {
        return this.getParent().getMode() == Mode.edit;
    }

    private void createTestConnectionList() {
        this.testConnectionList = this.createTestConnectionList(this.jdbcTagTable, this.JDBC_URL_DESC);
    }

    public void testJDBCConnection() {
        DataSourceManager dsMgr = MgmtFactory.getDataSourceManager();
        JdbcDataSource jdbc = new JdbcDataSource();
        this.fillJdbcDataSource(jdbc);
        jdbc.setConnectionUrl(this.testConnectionId);
        jdbc.setJdbcTagConfigList(new LinkedList());
        jdbc.setMinPoolSize(1);
        this.appendErrors((IValidationDelegate)this.delegate, null, false);
        if (this.delegate.getHasErrors()) {
            return;
        }
        AdminAuditLogger.log((AdminAuditLogger.Component)AdminAuditLogger.Component.DATA_STORE, (AdminAuditLogger.Event)AdminAuditLogger.Event.TEST_CONNECTION, (String)("Test connection to JDBC URL: " + jdbc.getConnectionUrl()));
        try {
            dsMgr.test((DataSource)jdbc, false);
            this.setConnectionTestSuccessfulMessage("Connectivity test was successful.");
        }
        catch (SecretManagerException e) {
            this.handleTestConnectionFailure("Data_store_secret_manager_error");
        }
        catch (Exception e) {
            this.handleTestConnectionFailure("Data_store_unavailable");
        }
    }

    private void handleTestConnectionFailure(String messageKey) {
        ValidationDelegate delegate = this.getParent().getDelegate();
        delegate.setFormComponent(null);
        delegate.record(this.getMessage(messageKey), ValidationConstraint.REQUIRED);
        this.connectionTestSuccessfulMessage = null;
    }

    public String getConnectionTestSuccessfulMessage() {
        return this.connectionTestSuccessfulMessage;
    }

    public void setConnectionTestSuccessfulMessage(String message) {
        this.connectionTestSuccessfulMessage = message;
    }

    private TableRow makeRowFromEntry(String url, String tags, boolean isDefault) {
        TableRow newRow = this.makeRowFromEntry(url, tags);
        newRow.setDefault(isDefault);
        return newRow;
    }

    private TableRow makeRowFromEntry(String url, String tags) {
        ArrayList<FieldItem> fields = new ArrayList<FieldItem>();
        fields.add(new FieldItem(this.JDBC_URL_DESC, url));
        fields.add(new FieldItem(this.TAG_DESC, tags));
        return new TableRow(fields);
    }

    private List<JdbcTagConfig> getDataStoreTaggingInfo() {
        LinkedList<JdbcTagConfig> jdbcTagConfigList = new LinkedList<JdbcTagConfig>();
        for (TableRow row : this.jdbcTagTable) {
            if (row.isMarkedForDelete()) continue;
            String jdbcUrl = this.getFieldValue(row, this.JDBC_URL_DESC);
            String tags = this.getFieldValue(row, this.TAG_DESC);
            if (!StringUtils.isNotEmpty((String)jdbcUrl)) continue;
            JdbcInstanceIdentifier identifier = new JdbcInstanceIdentifier(jdbcUrl);
            jdbcTagConfigList.add(new JdbcTagConfig(identifier, tags, row.isDefault()));
        }
        return jdbcTagConfigList;
    }

    private void populateTagInfo(List<JdbcTagConfig> tagConfigList) {
        boolean tagConfigTableHasDefault;
        if (tagConfigList == null) {
            return;
        }
        this.jdbcTagTable = new ArrayList<TableRow>();
        if (StringUtils.isNotEmpty((String)this.defaultJdbcUrl) && !(tagConfigTableHasDefault = tagConfigList.parallelStream().anyMatch(dataSourceTagConfig -> dataSourceTagConfig.getIdentifier().getJdbcUrl().equals(this.defaultJdbcUrl)))) {
            this.jdbcTagTable.add(this.makeRowFromEntry(this.defaultJdbcUrl, "", true));
        }
        for (JdbcTagConfig tagConfig : tagConfigList) {
            this.jdbcTagTable.add(this.makeRowFromEntry(tagConfig.getIdentifier().getJdbcUrl(), tagConfig.getTags(), tagConfig.isDefaultSource()));
        }
    }

    @Override
    public List<SimpleFieldDescriptor> getTaggingColumnDescriptors() {
        ArrayList<SimpleFieldDescriptor> tableList = new ArrayList<SimpleFieldDescriptor>();
        tableList.add(this.JDBC_URL_DESC);
        tableList.add(this.TAG_DESC);
        return tableList;
    }

    @Override
    public List<TableRow> getTaggingTable() {
        return this.jdbcTagTable;
    }

    @Override
    public Object getComponentState() {
        return this.componentState;
    }

    @Override
    public void setComponentState(Object componentState) {
        this.componentState = componentState;
    }

    @Override
    public void setTaggingTable(List tagTable) {
        this.jdbcTagTable = tagTable;
    }

    @Override
    public void doTaggingSummary(ArrayList<SummaryInfo> summaryList) {
        if (this.jdbcTagTable == null || this.jdbcTagTable.isEmpty()) {
            summaryList.add(new SummaryInfo(JDBC_URL_COL_NAME, "", this));
        } else {
            for (TableRow tagInfoRow : this.jdbcTagTable) {
                if (tagInfoRow.isMarkedForDelete()) continue;
                StringBuilder rowValue = new StringBuilder();
                String rowJdbcUrl = this.getFieldValue(tagInfoRow, this.JDBC_URL_DESC);
                String tags = this.getFieldValue(tagInfoRow, this.TAG_DESC);
                rowValue.append("JDBC URL: " + rowJdbcUrl);
                if (StringUtils.isNotEmpty((String)tags)) {
                    rowValue.append(System.lineSeparator() + "Tags: " + tags);
                }
                if (StringUtils.equals((String)rowJdbcUrl, (String)this.defaultJdbcUrl)) {
                    rowValue.append(System.lineSeparator() + "Default");
                }
                summaryList.add(new SummaryInfo(JDBC_URL_COL_NAME, rowValue.toString(), this));
            }
        }
    }

    @Override
    public List<String> validate(TableRow row, TableRow originalRow, List<TableRow> list, TableEditor owner) {
        LinkedList<String> errorList = new LinkedList<String>();
        List<JdbcTagConfig> jdbcTagConfigList = this.convertTagTableRow(owner.getUnsavedRowList());
        JdbcTagConfigValidator validator = new JdbcTagConfigValidator(jdbcTagConfigList);
        validator.setValidateDuplicateTags(false);
        validator.setValidateDuplicateDataStoreIdentifier(false);
        if (!validator.validate()) {
            errorList.addAll(this.convertErrorMessages(validator.getErrors()));
        }
        if (!list.isEmpty() && this.missingDefault(list, row)) {
            errorList.add("Must set one JDBC URL as default");
        }
        return errorList;
    }

    @Override
    public void onUpdateItem(TableEditor owner, TableRow originalRow, TableRow updatedRow) {
        this.createTestConnectionList();
    }

    @Override
    public void onAddItem(TableEditor owner, TableRow newRow) {
        TableEditor.TableEditorListener.super.onAddItem(owner, newRow);
        this.createTestConnectionList();
    }

    @Override
    public void onChooseDefaultItem(TableEditor owner, TableRow rowToSetAsDefault) {
        TableEditor.TableEditorListener.super.onChooseDefaultItem(owner, rowToSetAsDefault);
        String defaultJdbcUrl = this.getFieldValue(rowToSetAsDefault, this.JDBC_URL_DESC);
        if (StringUtils.isNotEmpty((String)defaultJdbcUrl)) {
            this.defaultJdbcUrl = defaultJdbcUrl;
        }
    }

    @Override
    public void onDeleteItem(TableEditor owner, TableRow deletedRow) {
        TableEditor.TableEditorListener.super.onDeleteItem(owner, deletedRow);
        this.createTestConnectionList();
    }

    @Override
    public void onUndeleteItem(TableEditor owner, TableRow undeletedRow) {
        TableEditor.TableEditorListener.super.onUndeleteItem(owner, undeletedRow);
        this.createTestConnectionList();
    }

    public void setId(String id) {
        this.id = id;
    }

    private List<JdbcTagConfig> convertTagTableRow(List<TableRow> tableRows) {
        ArrayList<JdbcTagConfig> jdbcTagConfigForSingleRow = new ArrayList<JdbcTagConfig>();
        for (TableRow tableRow : tableRows) {
            if (tableRow.isMarkedForDelete()) continue;
            JdbcInstanceIdentifier rowIdentifier = new JdbcInstanceIdentifier(this.getFieldValue(tableRow, this.JDBC_URL_DESC));
            String rowTags = this.getFieldValue(tableRow, this.TAG_DESC);
            JdbcTagConfig rowTagConfig = new JdbcTagConfig(rowIdentifier, rowTags, tableRow.isDefault());
            jdbcTagConfigForSingleRow.add(rowTagConfig);
        }
        return jdbcTagConfigForSingleRow;
    }
}

