/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.admin.api.validator.PluginFieldValidator;
import com.pingidentity.fsm.IWizard;
import com.pingidentity.fsm.state.impl.ConfigureAdapterState;
import com.pingidentity.fsm.tasklet.data.FieldItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.sourceid.saml20.adapter.conf.Field;
import org.sourceid.saml20.adapter.gui.ClientCertKeypairFieldDescriptor;
import org.sourceid.saml20.adapter.gui.FieldDescriptor;
import org.sourceid.saml20.adapter.gui.SecretReferenceFieldDescriptor;
import org.sourceid.saml20.domain.CustomDataSource;

public abstract class CustomDataSourceState
extends ConfigureAdapterState {
    protected CustomDataSource customSource;

    public CustomDataSourceState(IWizard owner) {
        super(owner);
    }

    @Override
    protected List<String> validateFieldItems() {
        ArrayList<String> errorMessages = new ArrayList<String>();
        for (FieldItem fieldItem : this.fieldItems) {
            FieldDescriptor fieldDescriptor = fieldItem.getFieldDescriptor();
            if (fieldDescriptor == null) continue;
            Field field = this.buildField(fieldItem);
            PluginFieldValidator fieldValidator = new PluginFieldValidator(fieldDescriptor, field, "", null);
            boolean success = fieldValidator.validate();
            errorMessages.addAll(this.getErrorMsgs(fieldValidator.getErrors()));
            if (success || !fieldItem.isAdvanced()) continue;
            this.setShowAdvancedFields(true);
        }
        return errorMessages;
    }

    private Map<String, Field> getAllFieldsAndValues() {
        HashMap<String, Field> allFieldsMap = new HashMap<String, Field>();
        if (this.customSource != null) {
            allFieldsMap.putAll(this.customSource.getConfiguration().getReadOnlyFieldMap());
        }
        for (FieldItem fieldItem : this.fieldItems) {
            FieldDescriptor fieldDescriptor = fieldItem.getFieldDescriptor();
            if (fieldDescriptor == null) continue;
            allFieldsMap.put(fieldDescriptor.getName(), this.buildField(fieldItem));
        }
        return allFieldsMap;
    }

    @Override
    public boolean isShowManageSecretManagersButton() {
        return this.fieldItems.stream().anyMatch(fieldItem -> fieldItem.getFieldDescriptor() instanceof SecretReferenceFieldDescriptor);
    }

    @Override
    public boolean isShowManageSSLClientKeysAndCertsButton() {
        return this.fieldItems.stream().anyMatch(fieldItem -> fieldItem.getFieldDescriptor() instanceof ClientCertKeypairFieldDescriptor);
    }
}

