/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.authnselection.ui.AsActionOption;
import com.pingidentity.authnselection.ui.AsUiDefaultAction;
import com.pingidentity.fsm.IWizard;
import com.pingidentity.fsm.tasklet.TaskletState;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.sourceid.saml20.adapter.gui.FilterableSelectionFieldDescriptor;
import org.sourceid.saml20.domain.mgmt.AuthnSelectionConfigManager;
import org.sourceid.saml20.domain.mgmt.ConnectionManager;
import org.sourceid.saml20.domain.mgmt.IdpAdapterManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.service.AuthnSourceKey;

public class DefaultAuthnSourcesState
extends TaskletState {
    private static final long serialVersionUID = 1L;
    private List<AsUiDefaultAction> defaultAuthnSources = new LinkedList<AsUiDefaultAction>();
    private static boolean isIdpEnabled = MgmtFactory.getLocalSettingsManager().getLocalSettings().isEnableIdP();
    private static boolean isSpEnabled = MgmtFactory.getLocalSettingsManager().getLocalSettings().isEnableSP();
    private final transient IdpAdapterManager idpAdapterManager = MgmtFactory.getIdpAdapterManager();
    private final transient ConnectionManager connManager = MgmtFactory.getConnectionManager();

    public DefaultAuthnSourcesState(IWizard owner) {
        super(owner);
        this.setMenuName("Default Authentication Sources");
    }

    @Override
    public void populate(Object dataFromDisk) {
        this.defaultAuthnSources = new ArrayList<AsUiDefaultAction>();
        AuthnSelectionConfigManager authnSelectionMgr = MgmtFactory.getAuthnSelectionConfigManager();
        for (AuthnSourceKey authnSourceKey : authnSelectionMgr.getDefaultAuthnSourceKeys()) {
            if (authnSourceKey.getType().equals((Object)AuthnSourceKey.AuthnSourceType.ADAPTER) && (!isIdpEnabled || this.idpAdapterManager.getInstance(authnSourceKey.getId()) == null) || authnSourceKey.getType().equals((Object)AuthnSourceKey.AuthnSourceType.IDP_CONN) && (!isSpEnabled || this.connManager.getIdpConnectionBySystemId(authnSourceKey.getId()) == null || !MgmtFactory.getLocalSettingsManager().getLocalSettings().isEnableProtocolSp(this.connManager.getIdpConnectionBySystemId(authnSourceKey.getId()).getProtocol()))) {
                this.defaultAuthnSources.add(new AsUiDefaultAction());
                continue;
            }
            this.defaultAuthnSources.add(new AsUiDefaultAction(authnSourceKey));
        }
        this.defaultAuthnSources.add(new AsUiDefaultAction());
    }

    @Override
    public boolean save(Object dataToDisk) {
        ArrayList<AuthnSourceKey> newDefaultAuthnSourceKeys = new ArrayList<AuthnSourceKey>();
        for (AsUiDefaultAction defaultAction : this.defaultAuthnSources) {
            AuthnSourceKey defaultAuthnSourceKey;
            AsActionOption selectedOption = defaultAction.getSelectedOption();
            if (selectedOption == null || (defaultAuthnSourceKey = selectedOption.toAuthnSourceKey()) == null) continue;
            newDefaultAuthnSourceKeys.add(defaultAuthnSourceKey);
        }
        AuthnSelectionConfigManager authnSelectionConfigManager = MgmtFactory.getAuthnSelectionConfigManager();
        authnSelectionConfigManager.setDefaultAuthnSourceKeys(newDefaultAuthnSourceKeys);
        return true;
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        super.appendErrors(delegate, component, fastFail);
        HashSet<AuthnSourceKey> defaultKeys = new HashSet<AuthnSourceKey>();
        HashSet<AuthnSourceKey> duplicateKeys = new HashSet<AuthnSourceKey>();
        for (AsUiDefaultAction defaultAction : this.defaultAuthnSources) {
            AsActionOption selectedOption = defaultAction.getSelectedOption();
            if (selectedOption == null) continue;
            AuthnSourceKey authnSourceKey = selectedOption.toAuthnSourceKey();
            if (authnSourceKey != null && defaultKeys.contains(authnSourceKey)) {
                if (duplicateKeys.contains(authnSourceKey)) continue;
                delegate.setFormComponent(null);
                delegate.record(this.getMessage("error_duplicate_defaults"), ValidationConstraint.CONSISTENCY);
                duplicateKeys.add(authnSourceKey);
                continue;
            }
            defaultKeys.add(authnSourceKey);
        }
    }

    @Override
    public void formListener(IRequestCycle cycle) {
        super.formListener(cycle);
        this.defaultAuthnSources.removeIf(cell -> cell.getSelectedOption() == null);
        this.defaultAuthnSources.add(new AsUiDefaultAction());
    }

    public List<FilterableSelectionFieldDescriptor.SearchableTypeConfig> getDefaultAuthnSourceSearchableTypes(AsUiDefaultAction asUiDefaultAction) {
        ArrayList<FilterableSelectionFieldDescriptor.SearchableTypeConfig> searchableTypes = new ArrayList<FilterableSelectionFieldDescriptor.SearchableTypeConfig>();
        if (isIdpEnabled) {
            searchableTypes.add(FilterableSelectionFieldDescriptor.SearchableTypeConfig.IDP_ADAPTER);
        }
        if (isSpEnabled) {
            List<FilterableSelectionFieldDescriptor.QueryParam> queryParams = Collections.singletonList(new FilterableSelectionFieldDescriptor.QueryParam("spInitSSO", "true"));
            searchableTypes.add(new FilterableSelectionFieldDescriptor.SearchableTypeConfig(FilterableSelectionFieldDescriptor.SearchableType.IDP_CONNECTION, queryParams));
        }
        return searchableTypes;
    }

    public List<AsUiDefaultAction> getDefaultAuthnSources() {
        return this.defaultAuthnSources;
    }

    public int getNumDefaultAuthnSources() {
        return this.defaultAuthnSources.size();
    }

    public void removeDefaultAuthnSource(Integer index) {
        this.defaultAuthnSources.get(index).setSelectedOption(null);
    }

    public void moveUpDefaultAuthnSource(int index) {
        if (index > 0) {
            AsUiDefaultAction defaultAdapterIdCell = this.defaultAuthnSources.get(index);
            this.defaultAuthnSources.set(index, this.defaultAuthnSources.get(index - 1));
            this.defaultAuthnSources.set(index - 1, defaultAdapterIdCell);
        }
    }

    public void moveDownDefaultAuthnSource(int index) {
        if (index < this.defaultAuthnSources.size() - 1) {
            AsUiDefaultAction defaultAdapterIdCell = this.defaultAuthnSources.get(index);
            this.defaultAuthnSources.set(index, this.defaultAuthnSources.get(index + 1));
            this.defaultAuthnSources.set(index + 1, defaultAdapterIdCell);
        }
    }
}

