/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.admin.api.validator.HttpUrlValidator;
import com.pingidentity.component.common.NameValuePair;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.fsm.tasklet.impl.IdpProtocolSettingsTasklet;
import com.pingidentity.fsm.tasklet.impl.SpProtocolSettingsTasklet;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.valid.IValidationDelegate;
import org.sourceid.a2a.domain.Direct2SpAdapterMapping;
import org.sourceid.saml20.domain.AuthnContextMapping;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.SpConnection;

public class DefaultTargetUrlState
extends TaskletState {
    private static final String NONE_SUMMARY = "(None)";
    private static final long serialVersionUID = 20050515L;
    private String defaultTargetResource;
    private transient Object authnCtxComponentState;
    private List<NameValuePair> authnCtxMappings = new ArrayList<NameValuePair>();

    public DefaultTargetUrlState(Tasklet parent) {
        super(parent);
        String menuName = "Default Target URL";
        if (parent instanceof IdpProtocolSettingsTasklet) {
            menuName = "Overrides";
        }
        this.setMenuName(menuName);
    }

    @Override
    public boolean populateAllStates(Object data) {
        this.populate(data);
        return true;
    }

    @Override
    public void populate(Object dataFromDisk) {
        this.authnCtxComponentState = null;
        this.authnCtxMappings = new ArrayList<NameValuePair>();
        if (dataFromDisk instanceof SpConnection) {
            SpConnection sp = (SpConnection)dataFromDisk;
            this.defaultTargetResource = sp.getDefaultTargetResource();
        } else if (dataFromDisk instanceof IdpConnection) {
            IdpConnection idp = (IdpConnection)dataFromDisk;
            this.defaultTargetResource = idp.getDefaultTargetResource();
            if (this.isShowAuthnContext()) {
                List authnContextMappings = idp.getAuthnContextMappings();
                for (AuthnContextMapping mapping : authnContextMappings) {
                    NameValuePair tempItem = new NameValuePair(mapping.getLocal(), mapping.getRemote());
                    this.authnCtxMappings.add(tempItem);
                }
            }
        } else if (dataFromDisk instanceof Direct2SpAdapterMapping) {
            Direct2SpAdapterMapping a2aMapping = (Direct2SpAdapterMapping)dataFromDisk;
            this.defaultTargetResource = a2aMapping.getDefaultTargetResource();
        }
    }

    @Override
    public boolean save(Object dataToSave) {
        if (dataToSave instanceof SpConnection) {
            SpConnection tempConnection = (SpConnection)dataToSave;
            tempConnection.setDefaultTargetResource(this.defaultTargetResource);
        } else if (dataToSave instanceof IdpConnection) {
            IdpConnection tempConnection = (IdpConnection)dataToSave;
            tempConnection.setDefaultTargetResource(this.defaultTargetResource);
            ArrayList<AuthnContextMapping> authnContextMappings = new ArrayList<AuthnContextMapping>();
            if (this.isShowAuthnContext()) {
                for (NameValuePair item : this.authnCtxMappings) {
                    if (item.isMarkedForDelete()) continue;
                    authnContextMappings.add(new AuthnContextMapping(item.getName(), item.getValue()));
                }
            }
            tempConnection.setAuthnContextMappings(authnContextMappings);
        } else if (dataToSave instanceof Direct2SpAdapterMapping) {
            Direct2SpAdapterMapping a2aMapping = (Direct2SpAdapterMapping)dataToSave;
            a2aMapping.setDefaultTargetResource(this.defaultTargetResource);
        }
        return true;
    }

    @Override
    public void reset() {
        this.defaultTargetResource = "";
        this.authnCtxComponentState = null;
        this.authnCtxMappings = new ArrayList<NameValuePair>();
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        if (StringUtils.isNotBlank((String)this.defaultTargetResource)) {
            summaryList.add(new SummaryInfo(this.getMessage("Url"), this.defaultTargetResource, this));
        }
        for (NameValuePair item : this.getAuthnCtxMappings()) {
            String local = StringUtils.isBlank((String)item.getName()) ? NONE_SUMMARY : item.getName();
            String remote = StringUtils.isBlank((String)item.getValue()) ? NONE_SUMMARY : item.getValue();
            summaryList.add(new SummaryInfo("Authn Context Mapping", "Local: " + local, this));
            summaryList.add(new SummaryInfo("", "Remote: " + remote, this));
        }
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        HttpUrlValidator validator = new HttpUrlValidator(this.defaultTargetResource, !this.isRequired(), null);
        if (!validator.validate()) {
            this.recordErrors(validator.getErrors(), delegate);
        }
    }

    public boolean isRequired() {
        Tasklet parent = this.findParent(SpProtocolSettingsTasklet.class);
        return parent != null;
    }

    public String getDefaultTargetResource() {
        return this.defaultTargetResource;
    }

    public void setDefaultTargetResource(String defaultTargetResource) {
        this.defaultTargetResource = StringUtils.stripToEmpty((String)defaultTargetResource);
    }

    public boolean isShowAuthnContext() {
        IdpProtocolSettingsTasklet tasklet = this.findParent(IdpProtocolSettingsTasklet.class);
        return tasklet != null && (tasklet.isConnectionProtocol20() || tasklet.isConnectionProtocolOIDC());
    }

    public List<NameValuePair> getAuthnCtxMappings() {
        return this.authnCtxMappings;
    }

    public void setAuthnCtxMappings(List<NameValuePair> scopeDescriptions) {
        this.authnCtxMappings = scopeDescriptions;
    }

    public Object getAuthnCtxComponentState() {
        return this.authnCtxComponentState;
    }

    public void setAuthnCtxComponentState(Object authnCtxComponentState) {
        this.authnCtxComponentState = authnCtxComponentState;
    }
}

