/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.admin.api.ApiUtil;
import com.pingidentity.authnselection.fragment.PolicyFragment;
import com.pingidentity.authnselection.fragment.PolicyFragmentManager;
import com.pingidentity.c2ccontract.C2cContract;
import com.pingidentity.component.card.TaskletListCardUser;
import com.pingidentity.component.common.Pagination;
import com.pingidentity.dependency.error.AffectedItemType;
import com.pingidentity.dependency.error.DependencyErrorHandler;
import com.pingidentity.dependency.error.DependencyErrorManager;
import com.pingidentity.dependency.error.mgmt.DependencyError;
import com.pingidentity.fsm.Visit;
import com.pingidentity.fsm.state.impl.Adapter2AdapterMappingTasklet;
import com.pingidentity.fsm.state.impl.Apc2SpAdapterMappingTasklet;
import com.pingidentity.fsm.state.impl.CibaPolicyManagementTasklet;
import com.pingidentity.fsm.state.impl.OAuthApc2TargetMappingTasklet;
import com.pingidentity.fsm.state.impl.OAuthAuthorizationServerSettingsState;
import com.pingidentity.fsm.state.impl.OAuthIdpAdapter2TargetMappingTasklet;
import com.pingidentity.fsm.state.impl.OAuthRoCreds2TargetMappingTasklet;
import com.pingidentity.fsm.state.impl.OAuthTepp2TargetMappingTasklet;
import com.pingidentity.fsm.state.impl.OAuthUserKey2AccessTokenMappingState;
import com.pingidentity.fsm.state.impl.PolicyManagementTasklet;
import com.pingidentity.fsm.state.impl.Token2TokenMappingTasklet;
import com.pingidentity.fsm.state.impl.fragments.PolicyFragmentsState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.data.DependencyType;
import com.pingidentity.fsm.tasklet.data.Mode;
import com.pingidentity.fsm.tasklet.impl.AdapterSelectorManagementTasklet;
import com.pingidentity.fsm.tasklet.impl.AuthnAdapterInstanceTasklet;
import com.pingidentity.fsm.tasklet.impl.AuthnPoliciesTasklet;
import com.pingidentity.fsm.tasklet.impl.ConnectionTasklet;
import com.pingidentity.fsm.tasklet.impl.IdpConnectionConfigTasklet;
import com.pingidentity.fsm.tasklet.impl.OAuthClientTasklet;
import com.pingidentity.fsm.tasklet.impl.PluginInstanceTasklet;
import com.pingidentity.fsm.tasklet.impl.ProtocolSettingsTasklet;
import com.pingidentity.fsm.tasklet.impl.SingleStateTasklet;
import com.pingidentity.fsm.tasklet.impl.SpConnectionConfigTasklet;
import com.pingidentity.fsm.tasklet.impl.fragments.PolicyFragmentTasklet;
import com.pingidentity.fsm.tasklet.impl.oauth.exchange.PolicyProcessor2GeneratorMappingTasklet;
import com.pingidentity.fsm.tasklet.impl.oauth.exchange.ProcessorPolicyManagementTasklet;
import com.pingidentity.fsm.tasklet.util.DisplayPaginationHelper;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.a2a.domain.Direct2SpAdapterMapping;
import org.sourceid.a2a.domain.Source2TargetMapping;
import org.sourceid.a2a.domain.Token2TokenMapping;
import org.sourceid.a2a.domain.mgmt.Token2TokenManager;
import org.sourceid.oauth20.domain.AccessTokenMapping;
import org.sourceid.oauth20.domain.ApcToUserKeyAttrMapping;
import org.sourceid.oauth20.domain.AuthzServerManager;
import org.sourceid.oauth20.domain.PluginToUserKeyAttrMapping;
import org.sourceid.oauth20.domain.TeppToUserKeyAttrMapping;
import org.sourceid.oauth20.domain.UserKeyToAccessTokenMapping;
import org.sourceid.oauth20.exchange.domain.ProcessorPolicy2GeneratorMapping;
import org.sourceid.oauth20.exchange.domain.TokenExchangeProcessorPolicy;
import org.sourceid.oauth20.exchange.manager.ProcessorPolicy2TokenGeneratorManager;
import org.sourceid.oauth20.exchange.manager.TokenExchangeProcessorPolicyManager;
import org.sourceid.oauth20.handlers.ContextUtil;
import org.sourceid.oauth20.handlers.OAuthSourceId;
import org.sourceid.openid.ciba.domain.CibaServerPolicy;
import org.sourceid.openid.connect.domain.OpenIdConnectProviderPolicy;
import org.sourceid.openid.connect.domain.mgmt.OpenIdConnectProviderPolicyManager;
import org.sourceid.saml20.domain.AuthnAdapterInstance;
import org.sourceid.saml20.domain.AuthnSelectorInstance;
import org.sourceid.saml20.domain.ConnectionBase;
import org.sourceid.saml20.domain.IdpAuthnAdapterInstance;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.LocalSettings;
import org.sourceid.saml20.domain.SpConnection;
import org.sourceid.saml20.domain.mgmt.ConnectionManager;
import org.sourceid.saml20.domain.mgmt.IdpAdapterManager;
import org.sourceid.saml20.domain.mgmt.LocalSettingsManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.PluginManager;
import org.sourceid.saml20.domain.mgmt.impl.PluginManagementSupport;

public class DependencyErrorManagementState
extends TaskletState
implements TaskletListCardUser {
    private static final long serialVersionUID = 2505104494256461505L;
    private static final Log log = LogFactory.getLog(DependencyErrorManagementState.class);
    public static final String DEPENDENCY_ERROR_TASKLET_NAME = "Manage Dependency Errors";
    private final transient DependencyErrorManager dependencyErrorManager = MgmtFactory.getDependencyErrorManager();
    private final List<Tasklet> depErrorTasklets = new ArrayList<Tasklet>();
    private transient Object paginationState;
    private boolean onStateActivated = true;

    public DependencyErrorManagementState(Tasklet value) {
        super(value);
        this.setMenuName(DEPENDENCY_ERROR_TASKLET_NAME);
    }

    @Override
    public void populate(Object dataFromDisk) {
        this.depErrorTasklets.clear();
        this.loadDependentItems();
    }

    private void loadDependentItems() {
        HashSet<AffectItem> affectedItems = new HashSet<AffectItem>();
        ConnectionManager connectionManager = MgmtFactory.getConnectionManager();
        for (DependencyError dependencyError : this.dependencyErrorManager.getErrors()) {
            AffectItem affectItem = new AffectItem(dependencyError.getAffectedInstanceId(), dependencyError.getAffectedInstanceType());
            if (affectedItems.contains(affectItem)) continue;
            Tasklet parentTasklet = (Tasklet)this.getWizard();
            Visit v = this.getVisit();
            switch (dependencyError.getCausedByType()) {
                case AUTH_SERVER_SETTINGS: 
                case OOB_AUTH_PLUGIN: {
                    Map policiesMap = MgmtFactory.getCibaServerPolicyManager().getCibaServerPolicy().getRequestHandlingPolicies();
                    CibaServerPolicy.RequestHandlingPolicy policy = (CibaServerPolicy.RequestHandlingPolicy)policiesMap.get(dependencyError.getAffectedInstanceId());
                    if (policy == null) break;
                    CibaPolicyManagementTasklet tasklet = parentTasklet.createTaskletToLoad(CibaPolicyManagementTasklet.class);
                    tasklet.setCycle(parentTasklet.getCycle());
                    tasklet.setMode(Mode.edit);
                    tasklet.setFinishLabel("Save");
                    tasklet.populate(policy);
                    this.depErrorTasklets.add(tasklet);
                    break;
                }
                case c2c: {
                    this.generateIdpConnectionTasklets(connectionManager, dependencyError, parentTasklet);
                    this.generateSpConnectionTasklets(connectionManager, dependencyError, parentTasklet);
                    this.generateApc2SpaMappings(dependencyError, parentTasklet);
                    v.setSkipForUIPerformanceFlag(false);
                    break;
                }
                case IDP_ADAPTER: {
                    if (AffectedItemType.SP_CONN == dependencyError.getAffectedInstanceType()) {
                        this.generateSpConnectionTasklets(connectionManager, dependencyError, parentTasklet);
                        break;
                    }
                    if (AffectedItemType.IDP_TO_SP_ADAPTER_MAPPING == dependencyError.getAffectedInstanceType()) {
                        this.generateAdapterMappingTasklets(dependencyError, parentTasklet);
                        break;
                    }
                    if (AffectedItemType.AUTH_SERVER_SETTINGS == dependencyError.getAffectedInstanceType()) {
                        this.generateAuthServerSettingsTasklets(parentTasklet);
                        break;
                    }
                    if (AffectedItemType.IDP_ADAPTER != dependencyError.getAffectedInstanceType()) break;
                    this.generateAuthnAdapterTasklet(parentTasklet, dependencyError.getAffectedInstanceId());
                    break;
                }
                case SP_ADAPTER: {
                    if (AffectedItemType.IDP_CONN == dependencyError.getAffectedInstanceType()) {
                        this.generateIdpConnectionTasklets(connectionManager, dependencyError, parentTasklet);
                    } else {
                        this.generateAdapterMappingTasklets(dependencyError, parentTasklet);
                    }
                    v.setSkipForUIPerformanceFlag(false);
                    break;
                }
                case AUTHN_POLICY_ATTRS: {
                    this.generateAuthnSelectionTreeTasklets(parentTasklet);
                    v.setSkipForUIPerformanceFlag(false);
                    break;
                }
                case FRAGMENT_ATTRS: {
                    this.generateFragmentTasklets(parentTasklet, dependencyError);
                    v.setSkipForUIPerformanceFlag(false);
                    break;
                }
                case IDP_CONN_METADATA: {
                    this.generateIdpConnectionTasklets(connectionManager, dependencyError, parentTasklet);
                    v.setSkipForUIPerformanceFlag(false);
                    break;
                }
                case SP_CONN_METADATA: {
                    this.generateSpConnectionTasklets(connectionManager, dependencyError, parentTasklet);
                    v.setSkipForUIPerformanceFlag(false);
                    break;
                }
                case SCOPE_MANAGEMENT: {
                    if (AffectedItemType.CLIENT_SETTINGS_SCOPE == dependencyError.getAffectedInstanceType()) {
                        this.generateClientSettingTasklets(parentTasklet);
                    } else if (AffectedItemType.AUTH_SERVER_SETTINGS == dependencyError.getAffectedInstanceType()) {
                        this.generateAuthServerSettingsTasklets(parentTasklet);
                    }
                    v.setSkipForUIPerformanceFlag(false);
                    break;
                }
                case LOCAL_IDENTITY_PROFILE: {
                    if (AffectedItemType.AUTHN_POLICIES == dependencyError.getAffectedInstanceType()) {
                        this.generateAuthnSelectionTreeTasklets(parentTasklet);
                    } else if (AffectedItemType.FRAGMENTS == dependencyError.getAffectedInstanceType()) {
                        this.generateFragmentTasklets(parentTasklet, dependencyError);
                    }
                    v.setSkipForUIPerformanceFlag(false);
                    break;
                }
                case TOKEN_PROCESSOR: {
                    if (AffectedItemType.SP_CONN == dependencyError.getAffectedInstanceType()) {
                        this.generateSpConnectionTasklets(connectionManager, dependencyError, parentTasklet);
                        break;
                    }
                    if (AffectedItemType.TOKEN_TRANSLATOR_MAPPING == dependencyError.getAffectedInstanceType()) {
                        this.generateTokenMappingTasklets(dependencyError, parentTasklet);
                        break;
                    }
                    if (AffectedItemType.TEPP == dependencyError.getAffectedInstanceType()) {
                        this.generateTepp(dependencyError, parentTasklet);
                        break;
                    }
                    if (AffectedItemType.PROTOCOL_SETTINGS != dependencyError.getAffectedInstanceType()) break;
                    this.generateProtocolSettingsTasklet(dependencyError, parentTasklet);
                    break;
                }
                case TOKEN_GENERATOR: {
                    if (AffectedItemType.IDP_CONN == dependencyError.getAffectedInstanceType()) {
                        this.generateIdpConnectionTasklets(connectionManager, dependencyError, parentTasklet);
                        break;
                    }
                    if (AffectedItemType.TOKEN_TRANSLATOR_MAPPING == dependencyError.getAffectedInstanceType()) {
                        this.generateTokenMappingTasklets(dependencyError, parentTasklet);
                        break;
                    }
                    if (AffectedItemType.TEPP_TO_TG_MAPPING == dependencyError.getAffectedInstanceType()) {
                        this.generatePolicyProcessor2GeneratorMappingTasklets(dependencyError, parentTasklet);
                        break;
                    }
                    if (AffectedItemType.PROTOCOL_SETTINGS != dependencyError.getAffectedInstanceType()) break;
                    this.generateProtocolSettingsTasklet(dependencyError, parentTasklet);
                    break;
                }
                case PCV: {
                    this.generateOAuthROCredentialsMapping(dependencyError, parentTasklet);
                    break;
                }
                case IDENTITY_STORE_PROVISIONER: {
                    this.generateIdpConnectionTasklets(connectionManager, dependencyError, parentTasklet);
                    break;
                }
                case STS: {
                    this.generateSpConnectionTasklets(connectionManager, dependencyError, parentTasklet);
                    break;
                }
                case OAUTH_CLIENT_SETTINGS: {
                    this.handleOauthClientSettingsDependentItems(dependencyError, parentTasklet);
                    break;
                }
                case EXTENDED_PROPERTIES: {
                    this.handleExtendedPropertiesDependentItems(dependencyError, parentTasklet);
                    break;
                }
                case TOKEN_EXCHANGE_PROCESSOR_POLICY: {
                    if (AffectedItemType.OAUTH_ACCESS_TOKEN_MAPPING == dependencyError.getAffectedInstanceType()) {
                        this.generateOauthUserKey2AccessTokenMappingTasklets(dependencyError, parentTasklet);
                    }
                    if (AffectedItemType.TEPP_TO_TG_MAPPING != dependencyError.getAffectedInstanceType()) break;
                    this.generatePolicyProcessor2GeneratorMappingTasklets(dependencyError, parentTasklet);
                    break;
                }
                case PROTOCOL_SETTINGS: {
                    this.generateProtocolSettingsTasklet(dependencyError, parentTasklet);
                    break;
                }
                case SP_CONNECTION: 
                case IDP_CONNECTION: {
                    if (AffectedItemType.PROTOCOL_SETTINGS != dependencyError.getAffectedInstanceType()) break;
                    this.generateProtocolSettingsTasklet(dependencyError, parentTasklet);
                    break;
                }
                case ACCESS_TOKEN_MANAGEMENT_ATTRS: {
                    if (AffectedItemType.IDP_CONN == dependencyError.getAffectedInstanceType()) {
                        this.generateIdpConnectionTasklets(connectionManager, dependencyError, parentTasklet);
                    } else {
                        this.generateOauthUserKey2AccessTokenMappingTasklets(dependencyError, parentTasklet);
                    }
                    v.setSkipForUIPerformanceFlag(false);
                    break;
                }
                default: {
                    if (!log.isDebugEnabled()) break;
                    log.debug((Object)("No known caused by type for " + dependencyError.getCausedByType().name() + ". Please add it to the Dependency Error State."));
                }
            }
            affectedItems.add(affectItem);
        }
    }

    private void handleExtendedPropertiesDependentItems(DependencyError dependencyError, Tasklet parentTasklet) {
        if (AffectedItemType.AUTHN_POLICIES.equals((Object)dependencyError.getAffectedInstanceType())) {
            this.generateAuthnSelectionTreeTasklets(parentTasklet);
            this.getVisit().setSkipForUIPerformanceFlag(false);
        } else if (AffectedItemType.FRAGMENTS.equals((Object)dependencyError.getAffectedInstanceType())) {
            this.generateFragmentTasklets(parentTasklet, dependencyError);
            this.getVisit().setSkipForUIPerformanceFlag(false);
        } else {
            this.generateExtendedProperToAuthSelector(dependencyError, parentTasklet);
        }
    }

    private void handleOauthClientSettingsDependentItems(DependencyError dependencyError, Tasklet parentTasklet) {
        switch (dependencyError.getAffectedInstanceType()) {
            case OAUTH_IDP_ADAPTER_MAPPING: {
                this.generateOauthIdpAdapter2TargetMappingTasklets(dependencyError, parentTasklet);
                break;
            }
            case APC_TO_PERSISTENT_GRANT_MAPPING: {
                this.generateOauthIApc2TargetMappingTasklets(dependencyError, parentTasklet);
                break;
            }
            case OAUTH_RESOURCE_OWNER_CREDENTIAL_MAPPING: {
                this.generateOauthRoCreds2TargetMappingTasklets(dependencyError, parentTasklet);
                break;
            }
            case OAUTH_ACCESS_TOKEN_MAPPING: {
                this.generateOauthUserKey2AccessTokenMappingTasklets(dependencyError, parentTasklet);
                break;
            }
            case TEPP_TO_PERSISTENT_GRANT_MAPPING: {
                this.generateOauthTepp2TargetMappingTasklets(dependencyError, parentTasklet);
                break;
            }
            case OIDC_POLICY_MANAGEMENT: {
                this.generateOidcProviderPolicyTasklets(dependencyError, parentTasklet);
                break;
            }
            case IDP_CONN: {
                this.generateIdpConnectionTasklets(MgmtFactory.getConnectionManager(), dependencyError, parentTasklet);
                break;
            }
            case SP_CONN: {
                this.generateSpConnectionTasklets(MgmtFactory.getConnectionManager(), dependencyError, parentTasklet);
                break;
            }
            case AUTHENTICATION_SELECTOR: {
                this.generateExtendedProperToAuthSelector(dependencyError, parentTasklet);
                break;
            }
            case TEPP_TO_TG_MAPPING: {
                this.generatePolicyProcessor2GeneratorMappingTasklets(dependencyError, parentTasklet);
                break;
            }
            case TEPP: {
                this.generateTepp(dependencyError, parentTasklet);
                break;
            }
        }
    }

    private void generateExtendedProperToAuthSelector(DependencyError dependencyError, Tasklet parentTasklet) {
        AuthnSelectorInstance selector = (AuthnSelectorInstance)MgmtFactory.getAuthnSelectorManager().getInstance(dependencyError.getAffectedInstanceId());
        if (selector != null) {
            AdapterSelectorManagementTasklet tasklet = parentTasklet.createTaskletToLoad(AdapterSelectorManagementTasklet.class);
            tasklet.setCycle(parentTasklet.getCycle());
            tasklet.setPluginManager((PluginManager<?, ?>)MgmtFactory.getAuthnSelectorManager());
            tasklet.setCycle(parentTasklet.getCycle());
            tasklet.setMode(Mode.edit);
            tasklet.setFinishAvailable(true);
            tasklet.setFinishLabel("Save");
            tasklet.populate(selector);
            this.depErrorTasklets.add(tasklet);
        }
    }

    private void generateApc2SpaMappings(DependencyError dependencyError, Tasklet parentTasklet) {
        String mappingId = dependencyError.getAffectedInstanceId();
        String[] ids = mappingId.split("\\|");
        if (ids.length != 2) {
            return;
        }
        String apcId = ids[0];
        String spAdapterId = ids[1];
        Direct2SpAdapterMapping apc2SpaMapping = (Direct2SpAdapterMapping)MgmtFactory.getApc2SpAdapterManager().getMapping(apcId, spAdapterId);
        if (apc2SpaMapping != null) {
            Apc2SpAdapterMappingTasklet tasklet = parentTasklet.createTaskletToLoad(Apc2SpAdapterMappingTasklet.class);
            tasklet.setCycle(parentTasklet.getCycle());
            tasklet.setMode(Mode.edit);
            tasklet.setFinishAvailable(false);
            tasklet.populate(apc2SpaMapping);
            this.depErrorTasklets.add(tasklet);
        }
    }

    private void generateOAuthROCredentialsMapping(DependencyError dependencyError, Tasklet parentTasklet) {
        String mappingId = dependencyError.getCausedByInstanceId();
        PluginToUserKeyAttrMapping mapping = MgmtFactory.getAuthzServerManager().getPwdCredValidatorToUserKeyMapping(mappingId);
        if (mapping != null) {
            OAuthRoCreds2TargetMappingTasklet tasklet = parentTasklet.createTaskletToLoad(OAuthRoCreds2TargetMappingTasklet.class);
            tasklet.setCycle(parentTasklet.getCycle());
            tasklet.setMode(Mode.edit);
            tasklet.setFinishLabel("Save");
            tasklet.populate(mapping);
            this.depErrorTasklets.add(tasklet);
        }
    }

    private void generateAuthServerSettingsTasklets(Tasklet parentTasklet) {
        SingleStateTasklet tasklet = parentTasklet.createTaskletToLoad(SingleStateTasklet.class, "AuthorizationServerSettingsTasklet", "Authorization Server Settings");
        OAuthAuthorizationServerSettingsState state = new OAuthAuthorizationServerSettingsState(tasklet);
        state.populate(null);
        tasklet.setFinishAvailable(true);
        tasklet.setCycle(parentTasklet.getCycle());
        tasklet.setInitialState(state);
        this.depErrorTasklets.add(tasklet);
    }

    private void generateClientSettingTasklets(Tasklet parentTasklet) {
        String clientSettingsTasklet = "ClientSettingsTasklet";
        String menuName = "Client Settings";
        OAuthClientTasklet tasklet = this.createTaskletToLoad(OAuthClientTasklet.class, clientSettingsTasklet, menuName);
        tasklet.setCycle(parentTasklet.getCycle());
        tasklet.setMode(Mode.edit);
        tasklet.setFinishAvailable(true);
        tasklet.populateAllStates(MgmtFactory.getClientSettingManager().getClientSetting());
        this.depErrorTasklets.add(tasklet);
    }

    private void generateAuthnSelectionTreeTasklets(Tasklet parentTasklet) {
        AuthnPoliciesTasklet tasklet = this.createTaskletToLoad(AuthnPoliciesTasklet.class);
        tasklet.setCycle(parentTasklet.getCycle());
        tasklet.setMode(Mode.edit);
        tasklet.populate(null);
        this.depErrorTasklets.add(tasklet);
    }

    private void generateFragmentTasklets(Tasklet parentTasklet, DependencyError dependencyError) {
        PolicyFragmentManager fragmentManager = MgmtFactory.getPolicyFragmentManager();
        PolicyFragment fragment = fragmentManager.getFragment(dependencyError.getAffectedInstanceId());
        if (fragment != null) {
            PolicyFragmentTasklet tasklet = parentTasklet.createTaskletToLoad(PolicyFragmentTasklet.class);
            tasklet.setParentPoliciesState(new PolicyFragmentsState(tasklet));
            tasklet.setMode(Mode.edit);
            tasklet.setCycle(parentTasklet.getCycle());
            tasklet.populate(fragment);
            tasklet.setFinishLabel("Save");
            this.depErrorTasklets.add(tasklet);
        }
    }

    private void generateOidcProviderPolicyTasklets(DependencyError dependencyError, Tasklet parentTasklet) {
        OpenIdConnectProviderPolicyManager oidcProviderPolicyManager = MgmtFactory.getOIDCProviderPolicyManager();
        OpenIdConnectProviderPolicy.PolicyGroup policyGroup = oidcProviderPolicyManager.getPolicy().getPolicyGroup(dependencyError.getAffectedInstanceId());
        if (policyGroup != null) {
            PolicyManagementTasklet tasklet = parentTasklet.createTaskletToLoad(PolicyManagementTasklet.class);
            tasklet.setCycle(parentTasklet.getCycle());
            tasklet.setMode(Mode.edit);
            tasklet.setFinishLabel("Save");
            tasklet.populate(policyGroup);
            this.depErrorTasklets.add(tasklet);
        }
    }

    private void generateOauthUserKey2AccessTokenMappingTasklets(DependencyError dependencyError, Tasklet parentTasklet) {
        AuthzServerManager authzServerManager = MgmtFactory.getAuthzServerManager();
        UserKeyToAccessTokenMapping accessTokenMapping = authzServerManager.getUserKeyToAccessTokenMapping(dependencyError.getAffectedInstanceId());
        if (accessTokenMapping == null) {
            accessTokenMapping = authzServerManager.getClientCredsToAccessTokenMapping(dependencyError.getAffectedInstanceId());
        }
        if (accessTokenMapping != null) {
            OAuthUserKey2AccessTokenMappingState.OAuthUserKey2AccessTokenMappingTasklet tasklet = parentTasklet.createTaskletToLoad(OAuthUserKey2AccessTokenMappingState.OAuthUserKey2AccessTokenMappingTasklet.class);
            tasklet.setCycle(parentTasklet.getCycle());
            tasklet.setMode(Mode.edit);
            tasklet.setFinishLabel("Save");
            tasklet.populate(accessTokenMapping);
            tasklet.loadMapping(accessTokenMapping);
            this.depErrorTasklets.add(tasklet);
        }
    }

    private void generateOauthRoCreds2TargetMappingTasklets(DependencyError dependencyError, Tasklet parentTasklet) {
        AuthzServerManager authzServerManager = MgmtFactory.getAuthzServerManager();
        PluginToUserKeyAttrMapping roCredToUserKeyAttrMapping = authzServerManager.getPwdCredValidatorToUserKeyMapping(dependencyError.getAffectedInstanceId());
        if (roCredToUserKeyAttrMapping != null) {
            OAuthRoCreds2TargetMappingTasklet tasklet = parentTasklet.createTaskletToLoad(OAuthRoCreds2TargetMappingTasklet.class);
            tasklet.setCycle(parentTasklet.getCycle());
            tasklet.setMode(Mode.edit);
            tasklet.setFinishLabel("Save");
            tasklet.populate(roCredToUserKeyAttrMapping);
            tasklet.loadMapping(roCredToUserKeyAttrMapping);
            this.depErrorTasklets.add(tasklet);
        }
    }

    private void generateOauthIdpAdapter2TargetMappingTasklets(DependencyError dependencyError, Tasklet parentTasklet) {
        AuthzServerManager authzServerManager = MgmtFactory.getAuthzServerManager();
        PluginToUserKeyAttrMapping pluginToUserKeyAttrMapping = (PluginToUserKeyAttrMapping)authzServerManager.getAdapterToUserKeyMapping(dependencyError.getAffectedInstanceId());
        if (pluginToUserKeyAttrMapping != null) {
            OAuthIdpAdapter2TargetMappingTasklet tasklet = parentTasklet.createTaskletToLoad(OAuthIdpAdapter2TargetMappingTasklet.class);
            tasklet.setCycle(parentTasklet.getCycle());
            tasklet.setMode(Mode.edit);
            tasklet.setFinishLabel("Save");
            tasklet.populate(pluginToUserKeyAttrMapping);
            this.depErrorTasklets.add(tasklet);
        }
    }

    private void generateOauthIApc2TargetMappingTasklets(DependencyError dependencyError, Tasklet parentTasklet) {
        AuthzServerManager authzServerManager = MgmtFactory.getAuthzServerManager();
        ApcToUserKeyAttrMapping apcToUserKeyAttrMapping = authzServerManager.getApcToUserKeyMapping(dependencyError.getAffectedInstanceId());
        if (apcToUserKeyAttrMapping != null) {
            OAuthApc2TargetMappingTasklet tasklet = parentTasklet.createTaskletToLoad(OAuthApc2TargetMappingTasklet.class);
            tasklet.setCycle(parentTasklet.getCycle());
            tasklet.setMode(Mode.edit);
            tasklet.setFinishLabel("Save");
            tasklet.populate(apcToUserKeyAttrMapping);
            this.depErrorTasklets.add(tasklet);
        }
    }

    private void generateOauthTepp2TargetMappingTasklets(DependencyError dependencyError, Tasklet parentTasklet) {
        AuthzServerManager authzServerManager = MgmtFactory.getAuthzServerManager();
        TeppToUserKeyAttrMapping teppToUserKeyAttrMapping = authzServerManager.getTeppToUserKeyMapping(dependencyError.getAffectedInstanceId());
        if (teppToUserKeyAttrMapping != null) {
            OAuthTepp2TargetMappingTasklet tasklet = parentTasklet.createTaskletToLoad(OAuthTepp2TargetMappingTasklet.class);
            tasklet.setCycle(parentTasklet.getCycle());
            tasklet.setMode(Mode.edit);
            tasklet.setFinishLabel("Save");
            tasklet.populate(teppToUserKeyAttrMapping);
            this.depErrorTasklets.add(tasklet);
        }
    }

    private void generateIdpConnectionTasklets(ConnectionManager connectionManager, DependencyError dependencyError, Tasklet parentTasklet) {
        IdpConnection idpConnection = connectionManager.getIdpConnectionBySystemId(dependencyError.getAffectedInstanceId());
        if (idpConnection != null) {
            IdpConnectionConfigTasklet tasklet = parentTasklet.createTaskletToLoad(IdpConnectionConfigTasklet.class);
            tasklet.setCycle(parentTasklet.getCycle());
            tasklet.setIdpConnection(idpConnection);
            tasklet.setExistingConnection(true);
            tasklet.setMode(Mode.edit);
            tasklet.setFinishLabel("Save");
            tasklet.populate(idpConnection);
            this.depErrorTasklets.add(tasklet);
        }
    }

    private void generateSpConnectionTasklets(ConnectionManager connectionManager, DependencyError instance, Tasklet parentTasklet) {
        SpConnection spConnection = connectionManager.getSpConnectionBySystemId(instance.getAffectedInstanceId());
        if (spConnection != null) {
            SpConnectionConfigTasklet tasklet = parentTasklet.createTaskletToLoad(SpConnectionConfigTasklet.class);
            tasklet.setCycle(parentTasklet.getCycle());
            tasklet.setSpConnection(spConnection);
            tasklet.setExistingConnection(true);
            tasklet.setMode(Mode.edit);
            tasklet.populate(spConnection);
            this.depErrorTasklets.add(tasklet);
        }
    }

    private void generateAdapterMappingTasklets(DependencyError instance, Tasklet parentTasklet) {
        Direct2SpAdapterMapping policyAdapterMapping;
        String[] sourceTargetId = ApiUtil.splitId((String)instance.getAffectedInstanceId());
        String sourceId = sourceTargetId[0];
        String targetId = sourceTargetId[1];
        Direct2SpAdapterMapping currAdapterMapping = (Direct2SpAdapterMapping)MgmtFactory.getAdapter2AdapterManager().getMapping(sourceId, targetId);
        if (currAdapterMapping != null) {
            Adapter2AdapterMappingTasklet tasklet = parentTasklet.createTaskletToLoad(Adapter2AdapterMappingTasklet.class);
            tasklet.setCycle(parentTasklet.getCycle());
            tasklet.setFinishAvailable(true);
            tasklet.setFinishLabel("Save");
            tasklet.setMode(Mode.edit);
            tasklet.populate(currAdapterMapping);
            this.depErrorTasklets.add(tasklet);
        }
        if ((policyAdapterMapping = (Direct2SpAdapterMapping)MgmtFactory.getApc2SpAdapterManager().getMapping(sourceId, targetId)) != null) {
            Apc2SpAdapterMappingTasklet tasklet = parentTasklet.createTaskletToLoad(Apc2SpAdapterMappingTasklet.class);
            tasklet.setCycle(parentTasklet.getCycle());
            tasklet.setMode(Mode.edit);
            tasklet.populate(policyAdapterMapping);
            this.depErrorTasklets.add(tasklet);
        }
    }

    private void generateTokenMappingTasklets(DependencyError instance, Tasklet parentTasklet) {
        Token2TokenManager tokenMappingManager = MgmtFactory.getToken2TokenManager();
        List mappings = null;
        if (instance.getCausedByType() == DependencyType.TOKEN_PROCESSOR) {
            mappings = tokenMappingManager.getMappingsUsingSource(instance.getCausedByInstanceId());
        } else if (instance.getCausedByType() == DependencyType.TOKEN_GENERATOR) {
            mappings = tokenMappingManager.getMappingsUsingTarget(instance.getCausedByInstanceId());
        }
        if (mappings != null && !mappings.isEmpty()) {
            Token2TokenMapping tokenMapping = (Token2TokenMapping)mappings.get(0);
            Token2TokenMappingTasklet tasklet = parentTasklet.createTaskletToLoad(Token2TokenMappingTasklet.class);
            tasklet.setCycle(parentTasklet.getCycle());
            tasklet.setMode(Mode.edit);
            tasklet.populate(tokenMapping);
            tasklet.setFinishAvailable(false);
            this.depErrorTasklets.add(tasklet);
        }
    }

    private void generateTepp(DependencyError dependencyError, Tasklet parentTasklet) {
        TokenExchangeProcessorPolicyManager teppManager = MgmtFactory.getTokenExchangeProcessorPolicyManager();
        ProcessorPolicyManagementTasklet tasklet = parentTasklet.createTaskletToLoad(ProcessorPolicyManagementTasklet.class);
        tasklet.setCycle(parentTasklet.getCycle());
        tasklet.setMode(Mode.edit);
        tasklet.populate(teppManager.getTokenExchangeProcessorPolicies().getPolicy(dependencyError.getAffectedInstanceId()));
        tasklet.setFinishAvailable(false);
        tasklet.setFinishLabel("Save");
        this.depErrorTasklets.add(tasklet);
    }

    private void generateAuthnAdapterTasklet(Tasklet parentTasklet, String affectedInstanceId) {
        IdpAuthnAdapterInstance instance = (IdpAuthnAdapterInstance)MgmtFactory.getIdpAdapterManager().getInstance(affectedInstanceId);
        PluginInstanceTasklet tasklet = parentTasklet.createTaskletToLoad(AuthnAdapterInstanceTasklet.class);
        tasklet.setPluginType(PluginManagementSupport.PluginManagementType.IDP_ADAPTER);
        tasklet.setPluginManager((PluginManager<?, ?>)MgmtFactory.getIdpAdapterManager());
        tasklet.setMode(Mode.edit);
        tasklet.setFinishAvailable(true);
        tasklet.setFinishLabel("Save");
        tasklet.setCycle(parentTasklet.getCycle());
        tasklet.populate(instance);
        this.depErrorTasklets.add(tasklet);
    }

    public boolean errorExists() {
        return this.dependencyErrorManager.errorsExist();
    }

    @Override
    public String getFirstColumnData(Tasklet t) {
        if (t instanceof ConnectionTasklet) {
            ConnectionTasklet connTasklet = (ConnectionTasklet)t;
            return connTasklet.getConnectionName();
        }
        if (t instanceof Apc2SpAdapterMappingTasklet) {
            AuthnAdapterInstance spAdapterInstance;
            Apc2SpAdapterMappingTasklet apc2SpaTasklet = (Apc2SpAdapterMappingTasklet)t;
            String apcId = ((Direct2SpAdapterMapping)apc2SpaTasklet.getSource2TargetMapping()).getSourceId();
            String spAdapterId = ((Direct2SpAdapterMapping)apc2SpaTasklet.getSource2TargetMapping()).getTargetId();
            String apcName = apcId;
            String spAdapterName = spAdapterId;
            C2cContract c2cContract = MgmtFactory.getC2cContractManager().getContract(apcId);
            if (c2cContract != null) {
                apcName = c2cContract.getName();
            }
            if ((spAdapterInstance = (AuthnAdapterInstance)MgmtFactory.getSpAdapterManager().getInstance(spAdapterId)) != null) {
                spAdapterName = spAdapterInstance.getName();
            }
            return "'" + apcName + "' to '" + spAdapterName + "'";
        }
        if (t instanceof OAuthClientTasklet) {
            return "Dynamic Client Registration";
        }
        if (t instanceof SingleStateTasklet && "AuthorizationServerSettingsTasklet".equals(t.getTaskletName())) {
            return t.getMenuName();
        }
        if (t instanceof Adapter2AdapterMappingTasklet) {
            Adapter2AdapterMappingTasklet a2aTasklet = (Adapter2AdapterMappingTasklet)t;
            return a2aTasklet.getDescription();
        }
        if (t instanceof OAuthRoCreds2TargetMappingTasklet) {
            return ((OAuthRoCreds2TargetMappingTasklet)t).getDescription();
        }
        if (t instanceof OAuthIdpAdapter2TargetMappingTasklet) {
            return ((OAuthIdpAdapter2TargetMappingTasklet)t).getDescription();
        }
        if (t instanceof OAuthApc2TargetMappingTasklet) {
            return ((OAuthApc2TargetMappingTasklet)t).getDescription();
        }
        if (t instanceof OAuthTepp2TargetMappingTasklet) {
            return ((OAuthTepp2TargetMappingTasklet)t).getDescription();
        }
        if (t instanceof OAuthUserKey2AccessTokenMappingState.OAuthUserKey2AccessTokenMappingTasklet) {
            OAuthUserKey2AccessTokenMappingState.OAuthUserKey2AccessTokenMappingTasklet accessTokenMappingTasklet = (OAuthUserKey2AccessTokenMappingState.OAuthUserKey2AccessTokenMappingTasklet)t;
            return accessTokenMappingTasklet.getDescription() + " to " + accessTokenMappingTasklet.getTargetDescription();
        }
        if (t instanceof PolicyManagementTasklet) {
            return ((PolicyManagementTasklet)t).getName();
        }
        if (t instanceof Token2TokenMappingTasklet) {
            Token2TokenMappingTasklet t2tTasklet = (Token2TokenMappingTasklet)t;
            return t2tTasklet.getDescription();
        }
        if (t instanceof AdapterSelectorManagementTasklet) {
            return ((AdapterSelectorManagementTasklet)t).getPluginId();
        }
        if (t instanceof CibaPolicyManagementTasklet) {
            return ((CibaPolicyManagementTasklet)t).getDescription();
        }
        if (t instanceof PolicyProcessor2GeneratorMappingTasklet) {
            return ((PolicyProcessor2GeneratorMappingTasklet)t).getDescription();
        }
        if (t instanceof ProcessorPolicyManagementTasklet) {
            return ((ProcessorPolicyManagementTasklet)t).getDescription();
        }
        if (t instanceof ProtocolSettingsTasklet) {
            return ((ProtocolSettingsTasklet)t).getDescription();
        }
        if (t instanceof PolicyFragmentTasklet) {
            return ((PolicyFragmentTasklet)t).getName();
        }
        if (t instanceof AuthnAdapterInstanceTasklet) {
            return ((AuthnAdapterInstanceTasklet)t).getPluginId();
        }
        return "Policies";
    }

    @Override
    public String getSecondColumnData(Tasklet t) {
        DependencyError depError = this.getAffectedItemID(t);
        return depError.getAffectedInstanceType().getFriendlyName();
    }

    @Override
    public String getThirdColumnData(Tasklet t) {
        Object data = t.getPopulateData();
        AffectItem affectItem = new AffectItem(null, null).invoke(t, data);
        StringBuilder causedBy = new StringBuilder();
        List errors = this.dependencyErrorManager.getErrorsByAffectedItem(affectItem.getId(), affectItem.getType());
        if (errors != null) {
            for (DependencyError error : errors) {
                causedBy.append(error.getCausedByType().getFriendlyName()).append(System.lineSeparator());
            }
        }
        return causedBy.toString();
    }

    @Override
    public String getFourthColumnData(Tasklet t) {
        return null;
    }

    private DependencyError getAffectedItemID(Tasklet t) {
        Object data = t.getPopulateData();
        AffectItem affectItem = new AffectItem(null, null).invoke(t, data);
        String id = affectItem.getId();
        AffectedItemType type = affectItem.getType();
        return this.dependencyErrorManager.getErrorByAffectedItem(id, type);
    }

    public List<Tasklet> getDepErrorTasklets() {
        return this.depErrorTasklets;
    }

    @Override
    public boolean enableActionColumn() {
        return false;
    }

    @Override
    public void refreshState() {
        this.populate(null);
    }

    @Override
    public void setTaskletToEdit(Tasklet taskletToEdit) {
        if (!taskletToEdit.isCancelled()) {
            if (taskletToEdit instanceof Apc2SpAdapterMappingTasklet) {
                Apc2SpAdapterMappingTasklet apc2SpaTasklet = (Apc2SpAdapterMappingTasklet)taskletToEdit;
                Direct2SpAdapterMapping apc2SpaMapping = new Direct2SpAdapterMapping();
                apc2SpaTasklet.save(apc2SpaMapping);
                MgmtFactory.getApc2SpAdapterManager().saveMapping((Source2TargetMapping)apc2SpaMapping);
                this.dependencyErrorManager.remove(DependencyErrorHandler.buildMappingId((Source2TargetMapping)apc2SpaMapping), AffectedItemType.APC2SPA);
            } else if (taskletToEdit instanceof Token2TokenMappingTasklet) {
                Token2TokenMappingTasklet mappingTasklet = (Token2TokenMappingTasklet)taskletToEdit;
                Token2TokenMapping mapping = new Token2TokenMapping();
                mappingTasklet.save(mapping);
                MgmtFactory.getToken2TokenManager().saveMapping((Source2TargetMapping)mapping);
                this.dependencyErrorManager.remove(DependencyErrorHandler.buildMappingId((Source2TargetMapping)mapping), AffectedItemType.TOKEN_TRANSLATOR_MAPPING);
            }
        }
        super.setTaskletToEdit(taskletToEdit);
    }

    public boolean isOnStateActivated() {
        return this.onStateActivated;
    }

    public void setOnStateActivated(boolean onStateActivated) {
        this.onStateActivated = onStateActivated;
    }

    @Override
    public void onStateActivated() {
        this.onStateActivated = true;
    }

    public Object getPaginationState() {
        return this.paginationState;
    }

    public void setPaginationState(Object paginationState) {
        this.paginationState = paginationState;
    }

    public void resetPaginationState() {
        if (this.paginationState != null) {
            ((Pagination.State)this.paginationState).reset();
        }
    }

    public Integer getLookAheadAvailableIndex() {
        return DisplayPaginationHelper.getLookAheadAvailableIndex(this.paginationState, this.getDepErrorTasklets());
    }

    public List<Tasklet> getPageDepErrTasklets() {
        return DisplayPaginationHelper.getPagedTasklets(this.paginationState, this.getDepErrorTasklets());
    }

    private void generatePolicyProcessor2GeneratorMappingTasklets(DependencyError dependencyError, Tasklet parentTasklet) {
        String mappingId;
        String[] id;
        ProcessorPolicy2TokenGeneratorManager processorPolicy2TokenGeneratorManager = MgmtFactory.getProcessorPolicy2TokenGeneratorManager();
        ProcessorPolicy2GeneratorMapping mapping = (ProcessorPolicy2GeneratorMapping)processorPolicy2TokenGeneratorManager.getMapping((id = (mappingId = dependencyError.getAffectedInstanceId()).split("\\|", 2))[0], id[1]);
        if (mapping != null) {
            PolicyProcessor2GeneratorMappingTasklet tasklet = parentTasklet.createTaskletToLoad(PolicyProcessor2GeneratorMappingTasklet.class);
            tasklet.setCycle(parentTasklet.getCycle());
            tasklet.setMode(Mode.edit);
            tasklet.setFinishAvailable(false);
            tasklet.populate(mapping);
            this.depErrorTasklets.add(tasklet);
        }
    }

    private void generateProtocolSettingsTasklet(DependencyError dependencyError, Tasklet parentTasklet) {
        LocalSettingsManager localSettingsManager = MgmtFactory.getLocalSettingsManager();
        LocalSettings localSettings = localSettingsManager.getLocalSettings();
        ProtocolSettingsTasklet tasklet = this.createTaskletToLoad(ProtocolSettingsTasklet.class);
        tasklet.setCycle(parentTasklet.getCycle());
        tasklet.setMode(Mode.edit);
        tasklet.setFinishAvailable(false);
        tasklet.populateAllStates(localSettings);
        this.depErrorTasklets.add(tasklet);
    }

    @Override
    public void reset() {
        this.refreshState();
        this.resetPaginationState();
    }

    private static class AffectItem {
        private String id;
        private AffectedItemType type;

        AffectItem(String id, AffectedItemType type) {
            this.id = id;
            this.type = type;
        }

        public String getId() {
            return this.id;
        }

        public AffectedItemType getType() {
            return this.type;
        }

        public AffectItem invoke(Tasklet t, Object data) {
            if (data instanceof ConnectionBase) {
                this.id = ((ConnectionBase)data).getId();
                this.type = data instanceof SpConnection ? AffectedItemType.SP_CONN : AffectedItemType.IDP_CONN;
            } else if (t instanceof Apc2SpAdapterMappingTasklet) {
                Apc2SpAdapterMappingTasklet apc2SpaTasklet = (Apc2SpAdapterMappingTasklet)t;
                this.id = DependencyErrorHandler.buildMappingId(apc2SpaTasklet.getSource2TargetMapping());
                this.type = AffectedItemType.APC2SPA;
            } else if (t instanceof OAuthClientTasklet) {
                this.id = AffectedItemType.CLIENT_SETTINGS_SCOPE.getFriendlyName();
                this.type = AffectedItemType.CLIENT_SETTINGS_SCOPE;
            } else if (t instanceof SingleStateTasklet && "AuthorizationServerSettingsTasklet".equals(t.getTaskletName())) {
                this.id = AffectedItemType.AUTH_SERVER_SETTINGS.getFriendlyName();
                this.type = AffectedItemType.AUTH_SERVER_SETTINGS;
            } else if (t instanceof AuthnAdapterInstanceTasklet && ((AuthnAdapterInstanceTasklet)t).getPluginManager() instanceof IdpAdapterManager) {
                this.id = ((IdpAuthnAdapterInstance)data).getId();
                this.type = AffectedItemType.IDP_ADAPTER;
            } else if (t instanceof PolicyFragmentTasklet) {
                this.id = ((PolicyFragment)data).getId();
                this.type = AffectedItemType.FRAGMENTS;
            } else if (t instanceof Adapter2AdapterMappingTasklet) {
                Direct2SpAdapterMapping mapping = (Direct2SpAdapterMapping)data;
                this.id = ApiUtil.combineId((String)mapping.getSourceId(), (String)mapping.getTargetId());
                this.type = AffectedItemType.IDP_TO_SP_ADAPTER_MAPPING;
            } else if (t instanceof OAuthRoCreds2TargetMappingTasklet) {
                PluginToUserKeyAttrMapping mapping = (PluginToUserKeyAttrMapping)data;
                this.id = mapping.getSourcePluginId();
                this.type = AffectedItemType.OAUTH_RESOURCE_OWNER_CREDENTIAL_MAPPING;
            } else if (t instanceof OAuthIdpAdapter2TargetMappingTasklet) {
                PluginToUserKeyAttrMapping mapping = (PluginToUserKeyAttrMapping)data;
                this.id = mapping.getSourcePluginId();
                this.type = AffectedItemType.OAUTH_IDP_ADAPTER_MAPPING;
            } else if (t instanceof OAuthApc2TargetMappingTasklet) {
                ApcToUserKeyAttrMapping mapping = (ApcToUserKeyAttrMapping)data;
                this.id = mapping.getSourceId();
                this.type = AffectedItemType.APC_TO_PERSISTENT_GRANT_MAPPING;
            } else if (t instanceof OAuthTepp2TargetMappingTasklet) {
                TeppToUserKeyAttrMapping mapping = (TeppToUserKeyAttrMapping)data;
                this.id = mapping.getSourceId();
                this.type = AffectedItemType.TEPP_TO_PERSISTENT_GRANT_MAPPING;
            } else if (t instanceof OAuthUserKey2AccessTokenMappingState.OAuthUserKey2AccessTokenMappingTasklet) {
                AccessTokenMapping mapping = (AccessTokenMapping)data;
                this.id = mapping.getId();
                this.type = AffectedItemType.OAUTH_ACCESS_TOKEN_MAPPING;
            } else if (t instanceof PolicyManagementTasklet) {
                OpenIdConnectProviderPolicy.PolicyGroup policyGroup = (OpenIdConnectProviderPolicy.PolicyGroup)data;
                this.id = policyGroup.getPolicyId();
                this.type = AffectedItemType.OIDC_POLICY_MANAGEMENT;
            } else if (t instanceof Token2TokenMappingTasklet) {
                Token2TokenMapping mapping = (Token2TokenMapping)data;
                this.id = ApiUtil.combineId((String)mapping.getSourceId(), (String)mapping.getTargetId());
                this.type = AffectedItemType.TOKEN_TRANSLATOR_MAPPING;
            } else if (t instanceof AdapterSelectorManagementTasklet) {
                AuthnSelectorInstance selector = (AuthnSelectorInstance)data;
                this.id = selector.getId();
                this.type = AffectedItemType.AUTHENTICATION_SELECTOR;
            } else if (t instanceof CibaPolicyManagementTasklet) {
                CibaServerPolicy.RequestHandlingPolicy policy = (CibaServerPolicy.RequestHandlingPolicy)data;
                this.id = policy.getId();
                this.type = AffectedItemType.CIBA_POLICY_MANAGEMENT;
            } else if (t instanceof PolicyProcessor2GeneratorMappingTasklet) {
                ProcessorPolicy2GeneratorMapping mapping = (ProcessorPolicy2GeneratorMapping)data;
                ContextUtil context = new ContextUtil();
                OAuthSourceId teppId = new OAuthSourceId(OAuthSourceId.Type.TOKEN_EXCHANGE_PROCESSOR_POLICY, mapping.getTargetId());
                this.id = context.buildQualifiedId(mapping.getSourceId(), teppId);
                this.type = AffectedItemType.TEPP_TO_TG_MAPPING;
            } else if (t instanceof ProcessorPolicyManagementTasklet) {
                this.id = ((TokenExchangeProcessorPolicy)data).getId();
                this.type = AffectedItemType.TEPP;
            } else if (t instanceof ProtocolSettingsTasklet) {
                this.id = AffectedItemType.PROTOCOL_SETTINGS.getFriendlyName();
                this.type = AffectedItemType.PROTOCOL_SETTINGS;
            } else {
                this.id = AffectedItemType.AUTHN_POLICIES.name();
                this.type = AffectedItemType.AUTHN_POLICIES;
            }
            return this;
        }

        public boolean equals(Object other) {
            if (other != null && other instanceof AffectItem) {
                AffectItem otherItem = (AffectItem)other;
                if (this.id != null && this.id.equals(otherItem.id) && this.type != null && this.type == otherItem.type) {
                    return true;
                }
            }
            return false;
        }

        public int hashCode() {
            int prime = 51;
            int result = 1;
            result = 51 * result + (this.id == null ? 0 : this.id.hashCode());
            result = 51 * result + (this.type == null ? 0 : this.type.hashCode());
            return result;
        }
    }
}

