/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.validator.DnValidator;
import com.pingidentity.crypto.Cert;
import com.pingidentity.fsm.state.impl.ImportCertState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.data.CertificateTypes;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.request.IUploadFile;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.sourceid.saml20.domain.ConnectionBase;

public class DynamicDsigSubjectDnState
extends ImportCertState {
    private static final long serialVersionUID = 20050515L;
    private String subjectDn;
    private boolean restrictIssuer = true;
    private String issuerDn;
    private transient IUploadFile issuerCertFile;

    public DynamicDsigSubjectDnState(Tasklet value) {
        super(value);
        this.setMenuName("Certificate Subject DN");
        this.setCertType(CertificateTypes.ValidTypes.dsigVerificationCert);
    }

    @Override
    public void populate(Object dataFromDisk) {
        ConnectionBase connection = (ConnectionBase)dataFromDisk;
        this.subjectDn = connection.getStringDsigVerificationExpectedSubjectDNas();
        this.issuerDn = connection.getStringDsigVerificationExpectedIssuerDNas();
        this.restrictIssuer = StringUtils.isNotBlank((String)this.issuerDn);
    }

    @Override
    public boolean populateAllStates(Object data) {
        this.populate(data);
        return true;
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        DnValidator dnv;
        if (StringUtils.isBlank((String)this.subjectDn)) {
            delegate.setFormComponent(null);
            delegate.record(this.getMessage("Invalid_subject_dn"), ValidationConstraint.REQUIRED);
        } else {
            dnv = new DnValidator(this.subjectDn, null, ApiMessageKey.anchored_trust_invalid_subject_dn);
            dnv.validate();
            this.recordErrors(dnv.getErrors(), delegate);
        }
        if (this.restrictIssuer) {
            if (StringUtils.isBlank((String)this.issuerDn)) {
                delegate.setFormComponent(null);
                delegate.record(this.getMessage("Invalid_issuer_dn"), ValidationConstraint.REQUIRED);
            } else {
                dnv = new DnValidator(this.issuerDn, null, ApiMessageKey.anchored_trust_invalid_issuer_dn, true, ApiMessageKey.anchored_trust_not_a_trust_anchor);
                dnv.validate();
                this.recordErrors(dnv.getErrors(), delegate);
            }
        }
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        summaryList.add(new SummaryInfo(this.getMessage("Subject_Dn_desc"), this.subjectDn, this));
        if (this.restrictIssuer) {
            summaryList.add(new SummaryInfo(this.getMessage("Issuer_Dn_desc"), this.issuerDn, this));
        }
    }

    public void extractSubjectDn() {
        this.subjectDn = this.extractDn(this.getCertFile());
    }

    public void extractIssuerDn() {
        this.issuerDn = this.extractDn(this.getIssuerCertFile());
    }

    private String extractDn(IUploadFile file) {
        Cert c = this.importCertFile(file);
        if (this.getErrorMessage() == null && c != null) {
            X509Certificate x509 = c.getX509Certificate();
            Principal p = x509.getSubjectDN();
            return p.getName();
        }
        if (this.getErrorMessage() != null) {
            this.delegate.setFormComponent(null);
            this.delegate.record(this.getErrorMessage(), ValidationConstraint.REQUIRED);
        } else {
            this.delegate.setFormComponent(null);
            this.delegate.record(this.getMessage("Valid_path_required"), ValidationConstraint.REQUIRED);
        }
        return null;
    }

    @Override
    public void formListener(IRequestCycle cycle) {
    }

    @Override
    public boolean save(Object dataToDisk) {
        ConnectionBase connection = (ConnectionBase)dataToDisk;
        if (!StringUtils.isBlank((String)this.subjectDn)) {
            connection.setDsigVerificationExpectedSubjectDN(StringUtils.trim((String)this.subjectDn));
        }
        if (this.restrictIssuer) {
            connection.setDsigVerificationExpectedIssuerDN(StringUtils.trim((String)this.issuerDn));
        } else {
            connection.setDsigVerificationExpectedIssuerDN((String)null);
        }
        return true;
    }

    public String getSubjectDn() {
        return this.subjectDn;
    }

    public void setSubjectDn(String subjectDn) {
        this.subjectDn = subjectDn;
    }

    public String getIssuerDn() {
        return this.issuerDn;
    }

    public void setIssuerDn(String issuerDn) {
        this.issuerDn = issuerDn;
    }

    public boolean isRestrictIssuer() {
        return this.restrictIssuer;
    }

    public void setRestrictIssuer(boolean restrictIssuer) {
        this.restrictIssuer = restrictIssuer;
    }

    public IUploadFile getIssuerCertFile() {
        return this.issuerCertFile;
    }

    public void setIssuerCertFile(IUploadFile issuerCertFile) {
        this.issuerCertFile = issuerCertFile;
    }
}

