/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.fsm.IWizard;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.fsm.tasklet.impl.UserProvisioningTasklet;
import java.util.ArrayList;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.SpConnection;
import org.sourceid.saml20.domain.UserProvisioning;
import org.sourceid.saml20.domain.WsTrustFederatedWscSettings;

public class ErrorHandlingState
extends TaskletState {
    private static final long serialVersionUID = 2L;
    private static final String ABORT_SSO = "Abort the SSO transaction";
    private boolean abortSso;

    public ErrorHandlingState(IWizard owner) {
        super(owner);
        this.setMenuName("Error Handling");
    }

    @Override
    public void populate(Object dataFromDisk) {
        if (dataFromDisk instanceof IdpConnection) {
            IdpConnection connection = (IdpConnection)dataFromDisk;
            this.abortSso = connection.getUserProvisioning() != null ? connection.getUserProvisioning().getErrorHandling() == UserProvisioning.ErrorHandlingType.AbortSSO : false;
        } else if (dataFromDisk instanceof WsTrustFederatedWscSettings) {
            WsTrustFederatedWscSettings settings = (WsTrustFederatedWscSettings)dataFromDisk;
            this.abortSso = settings.isAbortIfNotFulfilledFromRequest();
        }
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        summaryList.add(new SummaryInfo("Error Handling", this.getSummary(), this));
    }

    public String getContinueLabel() {
        if (this.isUserProvisioning()) {
            return this.getMessage("Continue_user_provisioning");
        }
        return this.getMessage("Continue_token_processor");
    }

    public String getAbortLabel() {
        if (this.isUserProvisioning()) {
            return this.getMessage("Abort_user_provisioning");
        }
        return this.getMessage("Abort_token_processor");
    }

    public boolean isUserProvisioning() {
        Tasklet t = this.findParent(UserProvisioningTasklet.class);
        return t != null;
    }

    public String getSummary() {
        return this.abortSso ? ABORT_SSO : this.getContinueLabel();
    }

    public void setAbortSso(boolean abortSso) {
        this.abortSso = abortSso;
    }

    public boolean isAbortSso() {
        return this.abortSso;
    }

    @Override
    public boolean save(Object dataToDisk) {
        if (dataToDisk instanceof IdpConnection) {
            IdpConnection tempConnection = (IdpConnection)dataToDisk;
            if (this.abortSso) {
                tempConnection.getUserProvisioning().setErrorHandling(UserProvisioning.ErrorHandlingType.AbortSSO);
            } else {
                tempConnection.getUserProvisioning().setErrorHandling(UserProvisioning.ErrorHandlingType.ContinueSSO);
            }
        } else if (dataToDisk instanceof SpConnection) {
            SpConnection spConn = (SpConnection)dataToDisk;
            WsTrustFederatedWscSettings settings = spConn.getWsTrustSettings();
            settings.setAbortIfNotFulfilledFromRequest(this.abortSso);
        }
        return true;
    }

    @Override
    public void reset() {
        this.abortSso = false;
    }
}

