/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.fsm.IWizard;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.fsm.tasklet.impl.IdpConnectionConfigTasklet;
import java.util.ArrayList;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.UserProvisioning;

public class EventTriggerState
extends TaskletState {
    private static final long serialVersionUID = 2L;
    private IdpConnection connection;
    private static final String OIDC = "claims";
    private static final String SAML = "SAML Assertions";
    private static final String ALL_ASSERTIONS_SUMMARY = "All %s";
    private static final String FIRST_TIME_ONLY_SUMMARY = "Only %s containing a new user id";
    private boolean allSamlAssertions = false;

    public EventTriggerState(IWizard owner) {
        super(owner);
        this.setMenuName("Event Trigger");
    }

    @Override
    public boolean populateAllStates(Object data) {
        this.populate(data);
        return true;
    }

    @Override
    public void populate(Object dataFromDisk) {
        this.connection = (IdpConnection)dataFromDisk;
        this.allSamlAssertions = this.connection.getUserProvisioning() != null ? this.connection.getUserProvisioning().getEventTrigger() == UserProvisioning.EventTriggerType.AllSAMLAssertions : false;
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        summaryList.add(new SummaryInfo("Event Trigger", this.getSummary(), this));
    }

    public String getSummary() {
        if (this.allSamlAssertions) {
            return this.getAllAssertionsText();
        }
        return this.getNewUserText();
    }

    private boolean isOidc() {
        IdpConnectionConfigTasklet tasklet = this.findParent(IdpConnectionConfigTasklet.class);
        return tasklet != null && tasklet.isConnectionProtocolOIDC();
    }

    @Override
    public String getNoteKey() {
        return this.isOidc() ? super.getNoteKey() + "_Oidc" : super.getNoteKey();
    }

    public void setAllSamlAssertions(boolean allSamlAssertions) {
        this.allSamlAssertions = allSamlAssertions;
    }

    public boolean isAllSamlAssertions() {
        return this.allSamlAssertions;
    }

    @Override
    public boolean save(Object dataToDisk) {
        IdpConnection tempConnection = (IdpConnection)dataToDisk;
        if (this.allSamlAssertions) {
            tempConnection.getUserProvisioning().setEventTrigger(UserProvisioning.EventTriggerType.AllSAMLAssertions);
        } else {
            tempConnection.getUserProvisioning().setEventTrigger(UserProvisioning.EventTriggerType.NewUserOnly);
        }
        return true;
    }

    @Override
    public void reset() {
        this.allSamlAssertions = false;
    }

    public String getAllAssertionsText() {
        return String.format(ALL_ASSERTIONS_SUMMARY, this.getSubText());
    }

    public String getNewUserText() {
        return String.format(FIRST_TIME_ONLY_SUMMARY, this.getSubText());
    }

    private String getSubText() {
        return this.isOidc() ? OIDC : SAML;
    }
}

