/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.crypto.Cert;
import com.pingidentity.fsm.IWizard;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.data.CertificateTypes;
import com.pingidentity.fsm.tasklet.data.Mode;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.fsm.tasklet.impl.CertManagementTasklet;
import java.util.ArrayList;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.sourceid.saml20.domain.DSignRotationSetting;
import org.sourceid.saml20.domain.mgmt.DSignRotationSettingsManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.PkCertManager;
import org.sourceid.saml20.domain.util.MetaDataInfo;
import org.sourceid.saml20.domain.util.MetadataImportExportUtil;

public class ExportCertDataState
extends TaskletState {
    private static final long serialVersionUID = 1L;
    private static final DSignRotationSettingsManager dSignRotationManager = MgmtFactory.getDSignRotationSettingsManager();
    private Cert selectedCert;
    private Cert selectedSecondaryCert;

    public ExportCertDataState(IWizard owner) {
        super(owner);
        this.setMenuName("Signing Key");
    }

    @Override
    public void reset() {
        this.selectedCert = null;
        this.selectedSecondaryCert = null;
    }

    public Cert getSelectedCert() {
        return this.selectedCert;
    }

    public void setSelectedCert(Cert selectedCert) {
        this.selectedCert = selectedCert;
    }

    public Cert getSelectedSecondaryCert() {
        return this.selectedSecondaryCert;
    }

    public void setSelectedSecondaryCert(Cert selectedSecondaryCert) {
        this.selectedSecondaryCert = selectedSecondaryCert;
    }

    @Override
    public boolean save(Object dataToDisk) {
        MetaDataInfo m = (MetaDataInfo)dataToDisk;
        m.setSigningCert(this.selectedCert);
        if (this.isShowSecondaryCertDropDown()) {
            m.setSecondarySigningCert(this.selectedSecondaryCert);
        } else {
            m.setSecondarySigningCert(null);
        }
        return true;
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        Cert secondarySigningCert;
        super.appendErrors(delegate, component, fastFail);
        Cert primarySigningCert = this.getSelectedCert();
        if (primarySigningCert != null && (secondarySigningCert = this.getSelectedSecondaryCert()) != null) {
            if (primarySigningCert.getAlias().equals(secondarySigningCert.getAlias())) {
                delegate.record(this.getMessage("Primary_signing_cert_same_as_secondary_signing_cert", new Object[]{secondarySigningCert.getDescriptionForDisplay(35)}), ValidationConstraint.CONSISTENCY);
            } else {
                DSignRotationSetting secondaryCertRotationSettings = dSignRotationManager.getRotationSetting(secondarySigningCert.getAlias());
                if (secondaryCertRotationSettings != null && secondaryCertRotationSettings.isEnableCertRotation()) {
                    delegate.record(this.getMessage("Secondary_signing_cert_cannot_have_rotation_enabled"), ValidationConstraint.CONSISTENCY);
                }
            }
        }
    }

    public PkCertManager getCertManager() {
        return MgmtFactory.getDsigPkCertManager();
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        if (this.getSelectedCert() == null) {
            summaryList.add(new SummaryInfo(this.getMessage("Signing_key_label"), "None", this));
        } else {
            summaryList.add(new SummaryInfo(this.getMessage("Signing_key_label"), this.selectedCert.getDescriptionForDisplay(), this));
            if (this.getSelectedSecondaryCert() == null) {
                summaryList.add(new SummaryInfo(this.getMessage("Secondary_signing_key_label"), "None", this));
            } else {
                summaryList.add(new SummaryInfo(this.getMessage("Signing_key_label"), this.selectedSecondaryCert.getDescriptionForDisplay(), this));
            }
        }
    }

    @Override
    public void loadTaskletToEdit() {
        CertManagementTasklet tasklet = this.createTasklet(CertManagementTasklet.class);
        tasklet.setCertType(CertificateTypes.ValidTypes.dsigSigningCert);
        tasklet.setSelectedCert(this.getSelectedCert());
        tasklet.setMode(Mode.edit);
        tasklet.populate(this.selectedCert);
        tasklet.setMenuName("Digital Signature Settings");
        tasklet.markProtocolImgAvailable(this.getParent().isProtocolImgAvailable());
        this.loadTasklet(tasklet);
    }

    public boolean isShowSecondaryCertDropDown() {
        String certAlias;
        Cert selectedCert = this.getSelectedCert();
        String string = certAlias = selectedCert != null ? selectedCert.getAlias() : null;
        if (certAlias != null) {
            return MetadataImportExportUtil.allowAlternativeSigningCert((String)certAlias, (DSignRotationSettingsManager)dSignRotationManager);
        }
        return true;
    }
}

