/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.admin.api.validator.PasswordValidator;
import com.pingidentity.common.util.PropertyInfo;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.data.CertItem;
import com.pingidentity.fsm.tasklet.data.CertificateTypes;
import com.pingidentity.fsm.tasklet.data.ExportType;
import com.pingidentity.fsm.tasklet.data.KeyPairFileFormat;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.fsm.tasklet.impl.CertManagementTasklet;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;

public class ExportCertState
extends TaskletState {
    private static final long serialVersionUID = 20050515L;
    private KeyPairFileFormat format = KeyPairFileFormat.PKCS12;
    private String password;
    private String confirmPassword;
    private CertItem certItem;
    private ExportType exportType = ExportType.CERT_ONLY;

    public ExportCertState(Tasklet value) {
        super(value);
        this.setMenuName("Export Certificate");
    }

    @Override
    public String getNoteKey() {
        if (this.findParent(CertManagementTasklet.class).getCertType() == CertificateTypes.ValidTypes.trustedCAs) {
            return super.getNoteKey() + "_TrustedCAs";
        }
        return super.getNoteKey();
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        X509Certificate x509 = this.certItem.getCert().getX509Certificate();
        summaryList.add(new SummaryInfo("Subject DN", x509.getSubjectDN().getName(), this));
        summaryList.add(new SummaryInfo("Issuer DN", x509.getIssuerDN().getName(), this));
        summaryList.add(new SummaryInfo("Serial Number", this.certItem.getCert().getSerialNumberForDisplay(), this));
        summaryList.add(new SummaryInfo("Expires", x509.getNotAfter().toString(), this));
        if (this.exportType == ExportType.CERT_AND_PRIVATE_KEY) {
            summaryList.add(new SummaryInfo("Format", this.format.getName(), this));
        }
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        if (this.exportType != ExportType.CERT_ONLY) {
            if (this.password == null || this.password.length() == 0) {
                delegate.setFormComponent(null);
                delegate.record(this.getMessage("Password_required"), ValidationConstraint.REQUIRED);
            } else {
                PasswordValidator passwordValidator;
                PasswordValidator passwordValidator2 = passwordValidator = this.isBCFIPSMode() ? new PasswordValidator(this.password, 14) : new PasswordValidator(this.password);
                if (StringUtils.isBlank((String)this.password)) {
                    delegate.setFormComponent(null);
                    delegate.record(this.getMessage("Password_invalid"), ValidationConstraint.REQUIRED);
                } else if (!this.password.equals(this.confirmPassword)) {
                    delegate.setFormComponent(null);
                    delegate.record(this.getMessage("Passwords_dont_match"), ValidationConstraint.REQUIRED);
                } else if (!passwordValidator.validate()) {
                    delegate.setFormComponent(null);
                    this.recordErrors(passwordValidator.getErrors(), delegate);
                }
            }
        }
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public CertItem getCertItem() {
        return this.certItem;
    }

    public void setCertItem(CertItem certItem) {
        this.certItem = certItem;
    }

    public KeyPairFileFormat getFormat() {
        return this.format;
    }

    public void setFormat(KeyPairFileFormat format) {
        this.format = format;
    }

    public String getConfirmPassword() {
        return this.confirmPassword;
    }

    public void setConfirmPassword(String confirmPassword) {
        this.confirmPassword = confirmPassword;
    }

    public boolean requirePassword() {
        return this.exportType == ExportType.CERT_AND_PRIVATE_KEY;
    }

    public ExportType getExportType() {
        return this.exportType;
    }

    public void setExportType(ExportType exportType) {
        this.exportType = exportType;
    }

    public boolean isBCFIPSMode() {
        return PropertyInfo.isBCFIPSMode();
    }
}

