/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.component.common.SelectedOption;
import com.pingidentity.component.common.SelectionFilterList;
import com.pingidentity.crypto.Cert;
import com.pingidentity.fsm.IWizard;
import com.pingidentity.fsm.state.impl.CertListState;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.fsm.tasklet.impl.ExportMetadataTasklet;
import com.pingidentity.util.StringPairPropertySelectionModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.form.IPropertySelectionModel;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.sourceid.common.HashAlgorithm;
import org.sourceid.common.HashUtil;
import org.sourceid.saml20.adapter.gui.FilterableSelectionFieldDescriptor;
import org.sourceid.saml20.domain.AttributeContract;
import org.sourceid.saml20.domain.ConnectionBase;
import org.sourceid.saml20.domain.DomainMode;
import org.sourceid.saml20.domain.VirtualIdentity;
import org.sourceid.saml20.domain.mgmt.ConnectionManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.util.MetaDataInfo;
import org.sourceid.saml20.domain.util.MetadataImportExportUtil;
import org.sourceid.websso.Protocol;

public class ExportConnectionState
extends TaskletState
implements CertListState {
    private static final long serialVersionUID = 1L;
    private String selectedConnection;
    private String selectedConnectionTypeAndId;
    private String selectedConnectionDisplayName;
    private ConnectionBase selectedConnectionInstance;
    private final ConnectionManager connManager = MgmtFactory.getConnectionManager();
    private List<String> attributeContractList;
    private List<String> virtualServerIds;
    private String selectedVirtualServerId;
    private IPropertySelectionModel virtualHostNamesModel = this.createVirtualHostNamesModel();
    private String selectedVirtualHostName;

    public ExportConnectionState(IWizard owner) {
        super(owner);
        this.setMenuName("Connection Metadata");
    }

    @Override
    public void onStateActivated() {
        this.refreshConnectionInfo();
    }

    @Override
    public void reset() {
        this.selectedConnection = null;
    }

    @Override
    public boolean save(Object dataToDisk) {
        MetaDataInfo info = (MetaDataInfo)dataToDisk;
        this.refreshConnectionInfo();
        if (!this.virtualServerIds.isEmpty() && StringUtils.isNotEmpty((String)this.selectedVirtualServerId)) {
            VirtualIdentity virtualIdentity = new VirtualIdentity();
            virtualIdentity.setVirtualEntityId(this.selectedVirtualServerId, DomainMode.CONFIGTIME);
            virtualIdentity.setVirtualSourceId(HashUtil.hashToBytes((String)this.selectedVirtualServerId, (HashAlgorithm)HashAlgorithm.SHA1));
            info.setVirtualEntityId(virtualIdentity, this.virtualServerIds.size() > 1);
        }
        MetadataImportExportUtil.populateMetaDataInfoWithConnection((MetaDataInfo)info, (ConnectionBase)this.selectedConnectionInstance);
        info.setVirtualHostName(this.selectedVirtualHostName);
        return true;
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        delegate.setFormComponent(null);
        if (StringUtils.isEmpty((String)this.selectedConnection)) {
            delegate.record(this.getMessage("Valid_connection_required"), ValidationConstraint.REQUIRED);
        }
    }

    @Override
    public void formListener(IRequestCycle cycle) {
        this.refreshConnectionInfo();
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        summaryList.add(new SummaryInfo(this.getMessage("Selected_connection"), this.getSelectedConnectionByName(), this));
        if (this.selectedConnectionInstance != null) {
            Cert xmlDecryptionKeyCert;
            Cert cert;
            AttributeContract contract = this.selectedConnectionInstance.getAttributeContract();
            if (contract != null) {
                Set attrs = contract.getAllAttributeNames();
                for (String attr : attrs) {
                    summaryList.add(new SummaryInfo(this.getMessage("Attribute"), attr, this));
                }
            }
            if ((cert = this.selectedConnectionInstance.getSigningKeyCertificate()) != null) {
                summaryList.add(new SummaryInfo(this.getMessage("Digital_signature_key"), cert.getDescriptionForDisplay(), this));
            }
            if ((xmlDecryptionKeyCert = MetadataImportExportUtil.getDecryptionCert((ConnectionBase)this.selectedConnectionInstance)) != null) {
                summaryList.add(new SummaryInfo(this.getMessage("Xml_encryption_key"), xmlDecryptionKeyCert.getDescriptionForDisplay(), this));
            }
            if (StringUtils.isNotEmpty((String)this.selectedVirtualServerId)) {
                summaryList.add(new SummaryInfo(this.getMessage("Virtual_server_id"), this.selectedVirtualServerId, this));
            }
            if (StringUtils.isNotEmpty((String)this.selectedVirtualHostName)) {
                summaryList.add(new SummaryInfo(this.getMessage("Virtual_host_name"), this.selectedVirtualHostName, this));
            }
        }
    }

    private ConnectionBase getConnection(String entityId) {
        ExportMetadataTasklet t = this.findParent(ExportMetadataTasklet.class);
        if (t.exportIDP()) {
            return this.connManager.getSpConnection(entityId);
        }
        return this.connManager.getIdpConnection(entityId);
    }

    private Collection<? extends ConnectionBase> getConnections() {
        ExportMetadataTasklet t = this.findParent(ExportMetadataTasklet.class);
        ArrayList conns = null;
        conns = t.exportIDP() ? new ArrayList(this.connManager.getFilteredSamlSpConnections()) : new ArrayList(this.connManager.getFilteredSamlIdpConnections());
        Collections.sort(conns, ConnectionBase.COMPARE_BY_ENTITY_ID);
        return conns;
    }

    private void refreshConnectionInfo() {
        this.selectedConnectionInstance = this.getConnection(this.selectedConnection);
        this.virtualServerIds = new ArrayList<String>();
        if (this.selectedConnectionInstance != null) {
            AttributeContract contract = this.selectedConnectionInstance.getAttributeContract();
            if (contract != null) {
                this.attributeContractList = new ArrayList<String>(contract.getAllAttrNamesSorted());
                Collections.sort(this.attributeContractList, String.CASE_INSENSITIVE_ORDER);
            }
            for (VirtualIdentity virtualIdentity : this.selectedConnectionInstance.getVirtualIdentities()) {
                String virtualServerId = virtualIdentity.getVirtualEntityId(DomainMode.CONFIGTIME);
                if (!StringUtils.isNotEmpty((String)virtualServerId)) continue;
                this.virtualServerIds.add(virtualServerId);
            }
            if (this.selectedVirtualServerId == null) {
                if (this.virtualServerIds.size() == 1) {
                    this.selectedVirtualServerId = this.virtualServerIds.get(0);
                } else if (this.virtualServerIds.size() > 1 && this.selectedConnectionInstance.getDefaultVirtualIdentity() != null) {
                    this.selectedVirtualServerId = this.selectedConnectionInstance.getDefaultVirtualIdentity().getVirtualEntityId(DomainMode.CONFIGTIME);
                }
            }
        } else {
            this.attributeContractList = new ArrayList<String>();
        }
    }

    public String getSelectedConnection() {
        return this.selectedConnection;
    }

    public void setSelectedConnection(String selectedConnection) {
        this.selectedConnection = selectedConnection;
    }

    public String getSelectedConnectionByName() {
        if (this.selectedConnection == null) {
            return null;
        }
        return this.getConnection(this.selectedConnection).getName();
    }

    public AttributeContract getContract() {
        return this.selectedConnectionInstance != null ? this.selectedConnectionInstance.getAttributeContract() : null;
    }

    public String getCertDisplayName() {
        return this.selectedConnectionInstance != null && this.selectedConnectionInstance.getSigningKeyCertificate() != null ? this.selectedConnectionInstance.getSigningKeyCertificate().getDescriptionForDisplay() : null;
    }

    public String getXmlDecryptionKeyCertDisplayName() {
        return this.selectedConnectionInstance != null && MetadataImportExportUtil.getDecryptionCert((ConnectionBase)this.selectedConnectionInstance) != null ? MetadataImportExportUtil.getDecryptionCert((ConnectionBase)this.selectedConnectionInstance).getDescriptionForDisplay() : null;
    }

    @Override
    public Cert getCert(int index) {
        return index == 0 ? this.selectedConnectionInstance.getSigningKeyCertificate() : MetadataImportExportUtil.getDecryptionCert((ConnectionBase)this.selectedConnectionInstance);
    }

    public List<String> getAttributeContractList() {
        return this.attributeContractList;
    }

    public void setAttributeContractList(ArrayList<String> attributeContractList) {
        this.attributeContractList = attributeContractList;
    }

    public boolean isSaml2Connection() {
        return this.selectedConnectionInstance != null && this.selectedConnectionInstance.getProtocol() == Protocol.SAML20;
    }

    public ConnectionBase getSelectedConnectionInstance() {
        if (this.selectedConnectionInstance == null) {
            this.refreshConnectionInfo();
        }
        return this.selectedConnectionInstance;
    }

    public List<String> getVirtualServerIds() {
        return this.virtualServerIds;
    }

    public String getSelectedVirtualServerId() {
        return this.selectedVirtualServerId;
    }

    public void setSelectedVirtualServerId(String selectedVirtualServerId) {
        this.selectedVirtualServerId = selectedVirtualServerId;
    }

    public String getSelectedConnectionDisplayName() {
        return this.selectedConnectionDisplayName;
    }

    public void setSelectedConnectionDisplayName(String selectedConnectionDisplayName) {
        this.selectedConnectionDisplayName = selectedConnectionDisplayName;
    }

    public String getSelectedConnectionTypeAndId() {
        return this.selectedConnectionTypeAndId;
    }

    public void setSelectedConnectionTypeAndId(String selectedConnectionTypeAndId) {
        this.selectedConnectionTypeAndId = selectedConnectionTypeAndId;
        if (StringUtils.isNotEmpty((String)selectedConnectionTypeAndId)) {
            SelectedOption option = SelectionFilterList.parseSelectedOptionString(selectedConnectionTypeAndId);
            this.setSelectedConnection(option.getId());
        }
    }

    public List<FilterableSelectionFieldDescriptor.SearchableTypeConfig> getSearchableTypes() {
        ExportMetadataTasklet t = this.findParent(ExportMetadataTasklet.class);
        List<FilterableSelectionFieldDescriptor.QueryParam> samlOnly = Collections.singletonList(new FilterableSelectionFieldDescriptor.QueryParam("samlOnly", "true"));
        if (t.exportIDP()) {
            return Collections.singletonList(new FilterableSelectionFieldDescriptor.SearchableTypeConfig(FilterableSelectionFieldDescriptor.SearchableType.SP_CONNECTION, samlOnly));
        }
        return Collections.singletonList(new FilterableSelectionFieldDescriptor.SearchableTypeConfig(FilterableSelectionFieldDescriptor.SearchableType.IDP_CONNECTION, samlOnly));
    }

    public IPropertySelectionModel createVirtualHostNamesModel() {
        StringPairPropertySelectionModel model = new StringPairPropertySelectionModel(true);
        for (String vhn : MgmtFactory.getVirtualHostNamesMgr().getHostNames()) {
            model.add(vhn, vhn);
        }
        model.sort();
        return model;
    }

    public IPropertySelectionModel getVirtualHostNamesModel() {
        return this.virtualHostNamesModel;
    }

    public String getSelectedVirtualHostName() {
        return this.selectedVirtualHostName;
    }

    public void setSelectedVirtualHostName(String selectedVirtualHostName) {
        this.selectedVirtualHostName = selectedVirtualHostName;
    }

    public boolean isDisplayVirtualHostNamesList() {
        return this.virtualHostNamesModel.getOptionCount() > 1;
    }
}

