/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.fsm.IWizard;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.util.StringPairPropertySelectionModel;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.form.IPropertySelectionModel;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.util.MetaDataInfo;

public class ExportVirtualHostNameState
extends TaskletState {
    private static final long serialVersionUID = 20050515L;
    private IPropertySelectionModel virtualHostNamesModel = this.createVirtualHostNamesModel();
    private String selectedVirtualHostName;

    public ExportVirtualHostNameState(IWizard owner) {
        super(owner);
        this.setMenuName("Virtual Host Name");
    }

    @Override
    public boolean save(Object dataToDisk) {
        MetaDataInfo m = (MetaDataInfo)dataToDisk;
        m.setVirtualHostName(this.selectedVirtualHostName);
        return true;
    }

    @Override
    public void reset() {
        this.selectedVirtualHostName = null;
        this.virtualHostNamesModel = this.createVirtualHostNamesModel();
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        String vhn = StringUtils.isNotEmpty((String)this.selectedVirtualHostName) ? this.selectedVirtualHostName : "None";
        summaryList.add(new SummaryInfo(this.getMessage("Virtual_host_name"), vhn, this));
    }

    public IPropertySelectionModel createVirtualHostNamesModel() {
        StringPairPropertySelectionModel model = new StringPairPropertySelectionModel(true);
        for (String vhn : MgmtFactory.getVirtualHostNamesMgr().getHostNames()) {
            model.add(vhn, vhn);
        }
        model.sort();
        return model;
    }

    public IPropertySelectionModel getVirtualHostNamesModel() {
        return this.virtualHostNamesModel;
    }

    public String getSelectedVirtualHostName() {
        return this.selectedVirtualHostName;
    }

    public void setSelectedVirtualHostName(String selectedVirtualHostName) {
        this.selectedVirtualHostName = selectedVirtualHostName;
    }
}

