/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.fsm.state.impl.CertificateState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.data.CertificateTypes;
import com.pingidentity.fsm.tasklet.data.KeyAlgorithmFilter;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.fsm.tasklet.impl.CertManagementTasklet;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.PkCertManager;
import org.sourceid.saml20.domain.util.MetaDataInfo;

public class ExportXmlEncryptionCertState
extends CertificateState
implements CertificateTypes {
    private static final long serialVersionUID = 20050515L;

    public ExportXmlEncryptionCertState(Tasklet value) {
        super(value);
    }

    @Override
    public boolean save(Object dataToDisk) {
        MetaDataInfo m = (MetaDataInfo)dataToDisk;
        m.setXmlEncryptionCert(this.getSelectedCert());
        return true;
    }

    @Override
    public void refreshState() {
        CertManagementTasklet tasklet = (CertManagementTasklet)this.getTaskletToEdit();
        this.setSelectedCert(tasklet.getSelectedCert());
    }

    public PkCertManager getCertManager() {
        return MgmtFactory.getDsigPkCertManager();
    }

    public Set<KeyAlgorithmFilter> getKeyAlgorithmFilter() {
        HashSet<KeyAlgorithmFilter> algFilters = new HashSet<KeyAlgorithmFilter>();
        algFilters.add(new KeyAlgorithmFilter.KeyAlgorithmFilterBuilder(CertificateTypes.KeyAlgorithms.RSA).build());
        return algFilters;
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        if (this.getSelectedCert() == null) {
            summaryList.add(new SummaryInfo(this.getMessage("Encrypt_keys_label"), "None", this));
        } else {
            summaryList.add(new SummaryInfo(this.getMessage("Encrypt_keys_label"), this.getSelectedCert().getDescriptionForDisplay(), this));
        }
    }
}

