/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.admin.api.validator.ExtendedPropertiesValidator;
import com.pingidentity.component.common.NameValuePair;
import com.pingidentity.component.common.OAuthClientExtendedMetadataEditor;
import com.pingidentity.component.common.StringPairListEditor;
import com.pingidentity.dependency.error.DependencyErrorHandler;
import com.pingidentity.dependency.error.DependencyErrorUIValidator;
import com.pingidentity.dependency.error.DependencyErrorUIValidatorImpl;
import com.pingidentity.fsm.IWizard;
import com.pingidentity.fsm.state.impl.AutoSaveState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.data.DependencyType;
import com.pingidentity.fsm.tasklet.data.Mode;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.valid.IValidationDelegate;
import org.sourceid.oauth20.domain.ClientParam;
import org.sourceid.oauth20.domain.ClientSettingManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

@AutoSaveState
public class ExtendedPropertiesState
extends TaskletState
implements Serializable,
StringPairListEditor.StringPairListEditorListener {
    private static final long serialVersionUID = 1L;
    private List<NameValuePair> paramNameDesc = new ArrayList<NameValuePair>();
    private Object clientMetadataParamComponentState;
    protected Map<String, Boolean> multiValueMap = new HashMap<String, Boolean>();
    private static final ClientSettingManager clientSettingManager = MgmtFactory.getClientSettingManager();

    public ExtendedPropertiesState(IWizard owner) {
        super(owner);
        this.setMenuName("Extended Properties");
    }

    public ExtendedPropertiesState(IWizard owner, String cardName) {
        super(owner, cardName);
    }

    public List<NameValuePair> getParamNameDesc() {
        return this.paramNameDesc;
    }

    public void setParamNameDesc(List<NameValuePair> paramNameDesc) {
        this.paramNameDesc = paramNameDesc;
    }

    public Object getClientMetadataParamComponentState() {
        return this.clientMetadataParamComponentState;
    }

    public void setClientMetadataParamComponentState(Object clientMetadataParamComponentState) {
        this.clientMetadataParamComponentState = clientMetadataParamComponentState;
    }

    @Override
    public boolean populateAllStates(Object data) {
        this.populate(data);
        return true;
    }

    @Override
    public void populate(Object dataFromDisk) {
        Map paramDescs = clientSettingManager.getExtendedProperties();
        this.paramNameDesc = new ArrayList<NameValuePair>(paramDescs.size());
        this.multiValueMap = new HashMap<String, Boolean>();
        if (this.clientMetadataParamComponentState instanceof OAuthClientExtendedMetadataEditor.ClientParamState) {
            OAuthClientExtendedMetadataEditor.ClientParamState state = (OAuthClientExtendedMetadataEditor.ClientParamState)this.clientMetadataParamComponentState;
            state.clear();
        }
        for (Map.Entry entry : paramDescs.entrySet()) {
            this.paramNameDesc.add(new NameValuePair((String)entry.getKey(), ((ClientParam)entry.getValue()).getParamDescription()));
            this.multiValueMap.put((String)entry.getKey(), ((ClientParam)entry.getValue()).isMultiValued());
        }
        Collections.sort(this.paramNameDesc);
    }

    @Override
    public boolean save(Object dataToDisk) {
        HashMap<String, ClientParam> params = new HashMap<String, ClientParam>();
        for (NameValuePair entry : this.paramNameDesc) {
            if (entry.isMarkedForDelete()) continue;
            params.put(entry.getName(), new ClientParam(entry.getValue(), this.multiValueMap.get(entry.getName()).booleanValue()));
        }
        this.setMode(Mode.edit);
        clientSettingManager.saveExtendedProperties(params);
        DependencyErrorUIValidatorImpl dependencyErrorUIValidator = new DependencyErrorUIValidatorImpl((Tasklet)this.getWizard());
        DependencyErrorHandler dependencyErrorHandler = new DependencyErrorHandler();
        dependencyErrorHandler.performDependencyValidation((DependencyErrorUIValidator)dependencyErrorUIValidator, (Object)clientSettingManager.getClientSetting(), DependencyType.OAUTH_CLIENT_SETTINGS);
        this.getParent().checkForClusterReplication();
        return true;
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        ExtendedPropertiesValidator validator = this.getValidator();
        validator.validate();
        this.recordErrors(validator.getErrors(), delegate);
    }

    private ExtendedPropertiesValidator getValidator() {
        HashMap<String, String> paramDescs = new HashMap<String, String>();
        for (NameValuePair pair : this.paramNameDesc) {
            if (pair.isMarkedForDelete()) continue;
            paramDescs.put(pair.getName(), pair.getValue());
        }
        ExtendedPropertiesValidator validator = new ExtendedPropertiesValidator(paramDescs);
        return validator;
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        for (NameValuePair entry : this.paramNameDesc) {
            summaryList.add(new SummaryInfo(entry.getName(), entry.getValue(), this));
        }
    }

    @Override
    public void onAddListItem(StringPairListEditor owner, String newItemName) {
        Collections.sort(this.paramNameDesc);
        this.save(null);
    }

    @Override
    public void onUpdateListItem(StringPairListEditor owner, String originalItemName, String newItemName) {
        Collections.sort(this.paramNameDesc);
        this.save(null);
    }

    @Override
    public void onDeleteListItem(StringPairListEditor owner, String itemToDeleteName) {
        this.save(null);
    }

    @Override
    public void refreshState() {
        Iterator<NameValuePair> iter = this.paramNameDesc.iterator();
        while (iter.hasNext()) {
            NameValuePair paramName = iter.next();
            if (!paramName.isMarkedForDelete()) continue;
            iter.remove();
        }
    }

    @Override
    public String validate(String name, String value, String originalName, String originalValue, List<NameValuePair> list, StringPairListEditor owner) {
        return null;
    }

    public Map<String, Boolean> getMultiValueMap() {
        return this.multiValueMap;
    }

    public void setMultiValueMap(Map<String, Boolean> multiValueMap) {
        this.multiValueMap = multiValueMap;
    }

    public boolean getParamMultiValueStatus(String paramName) {
        return this.multiValueMap.get(paramName);
    }
}

