/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.admin.api.validator.ExtendedPropertyValueValidator;
import com.pingidentity.component.common.MultiValuedNamePair;
import com.pingidentity.component.common.NameValuePair;
import com.pingidentity.component.common.StringPairListEditor;
import com.pingidentity.fsm.IWizard;
import com.pingidentity.fsm.state.impl.OAuthClientManagementTasklet;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.fsm.tasklet.impl.IdpConnectionConfigTasklet;
import com.pingidentity.fsm.tasklet.impl.SpConnectionConfigTasklet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.valid.IValidationDelegate;
import org.sourceid.oauth20.domain.Client;
import org.sourceid.oauth20.domain.ClientParam;
import org.sourceid.oauth20.domain.ParamValues;
import org.sourceid.saml20.domain.ConnectionBase;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.SpConnection;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class ExtendedPropertyManagementState
extends TaskletState
implements StringPairListEditor.StringPairListEditorListener {
    private static final long serialVersionUID = 1L;
    private List<MultiValuedNamePair> metadataParams = new LinkedList<MultiValuedNamePair>();
    private transient Object metadataComponentState = null;
    private boolean isConnection;

    public ExtendedPropertyManagementState(IWizard owner, boolean isConnection) {
        super(owner);
        this.isConnection = isConnection;
        this.setMenuName("Extended Properties");
    }

    public List<MultiValuedNamePair> getMetadataParams() {
        return this.metadataParams;
    }

    public void setMetadataParams(List<MultiValuedNamePair> metadataParams) {
        this.metadataParams = metadataParams;
    }

    public Object getMetadataComponentState() {
        return this.metadataComponentState;
    }

    public void setMetadataComponentState(Object metadataComponentState) {
        this.metadataComponentState = metadataComponentState;
    }

    @Override
    public void onStateActivated() {
        Map extendedMetadataParams = null;
        if (this.metadataParams == null || this.metadataParams.isEmpty()) {
            if (this.isConnection) {
                Tasklet parent = this.getParent();
                if (parent instanceof IdpConnectionConfigTasklet) {
                    IdpConnection idpConnection = ((IdpConnectionConfigTasklet)this.getParent()).getIdpConnection();
                    if (idpConnection != null) {
                        extendedMetadataParams = idpConnection.getExtendedProperties();
                    }
                } else {
                    SpConnection spConnection = ((SpConnectionConfigTasklet)this.getParent()).getSpConnection();
                    if (spConnection != null) {
                        extendedMetadataParams = ((SpConnectionConfigTasklet)this.getParent()).getSpConnection().getExtendedProperties();
                    }
                }
            } else {
                Client client = ((OAuthClientManagementTasklet)this.getParent()).getClient();
                if (client != null) {
                    extendedMetadataParams = client.getExtendedParams();
                }
            }
            if (extendedMetadataParams == null) {
                extendedMetadataParams = new LinkedHashMap();
            }
            this.populateProperties(extendedMetadataParams);
        }
    }

    @Override
    public void populate(Object dataFromDisk) {
        Map<String, Object> extendedMetadataParams = null;
        if (dataFromDisk == null) {
            extendedMetadataParams = new LinkedHashMap<String, ParamValues>();
        } else if (this.isConnection) {
            ConnectionBase connection = (ConnectionBase)dataFromDisk;
            extendedMetadataParams = connection.getExtendedProperties();
        } else {
            Client client = (Client)dataFromDisk;
            extendedMetadataParams = client.getExtendedParams();
        }
        this.populateProperties(extendedMetadataParams);
    }

    private void populateProperties(Map<String, ParamValues> extendedMetadataParams) {
        this.metadataParams.clear();
        Map params = MgmtFactory.getClientSettingManager().getExtendedProperties();
        Set paramNames = params.keySet();
        if (paramNames != null) {
            ArrayList sortedParams = new ArrayList(paramNames);
            Collections.sort(sortedParams);
            for (String name : sortedParams) {
                MultiValuedNamePair lastPair = new MultiValuedNamePair(false, true);
                ParamValues values = extendedMetadataParams.get(name);
                boolean isMultiValued = ((ClientParam)params.get(name)).isMultiValued();
                boolean addLastElement = this.isAddElement(values);
                if (addLastElement) {
                    lastPair = new MultiValuedNamePair(true, true);
                } else {
                    this.addValuesForParamName(name, values.getElements(), isMultiValued);
                }
                lastPair.setName(name);
                Collections.sort(this.metadataParams);
                if (!isMultiValued && !addLastElement) continue;
                this.metadataParams.add(lastPair);
            }
        }
    }

    private boolean isAddElement(ParamValues values) {
        return values == null || values.getElements() == null || values.getElements().size() == 0;
    }

    private void addValuesForParamName(String name, List<String> values, boolean isMultiValued) {
        ArrayList<String> sortedValues = new ArrayList<String>(values);
        Collections.sort(sortedValues);
        Iterator valueIterator = sortedValues.iterator();
        if (valueIterator.hasNext()) {
            String firstValue = (String)valueIterator.next();
            MultiValuedNamePair firstPair = new MultiValuedNamePair(true, false);
            firstPair.setName(name);
            firstPair.setValue(firstValue);
            this.metadataParams.add(firstPair);
        }
        while (valueIterator.hasNext()) {
            MultiValuedNamePair pair = new MultiValuedNamePair(false, false);
            pair.setName(name);
            pair.setValue((String)valueIterator.next());
            this.metadataParams.add(pair);
        }
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        Map<String, ParamValues> params = this.getNameValueMap();
        ExtendedPropertyValueValidator validator = new ExtendedPropertyValueValidator(params);
        validator.validate();
        this.recordErrors(validator.getErrors(), delegate);
    }

    @Override
    public boolean save(Object diskObject) {
        if (this.isConnection) {
            ConnectionBase connection = (ConnectionBase)diskObject;
            Map<String, ParamValues> params = this.getNameValueMap();
            connection.setExtendedProperties(params);
            this.metadataComponentState = null;
        } else {
            Client client = (Client)diskObject;
            Map<String, ParamValues> params = this.getNameValueMap();
            client.setExtendedParams(params);
            this.metadataComponentState = null;
        }
        return true;
    }

    private Map<String, ParamValues> getNameValueMap() {
        LinkedHashMap<String, ParamValues> params = new LinkedHashMap<String, ParamValues>();
        for (NameValuePair nameValuePair : this.metadataParams) {
            if (!StringUtils.isNotEmpty((String)nameValuePair.getValue()) || nameValuePair.isMarkedForDelete()) continue;
            if (params.containsKey(nameValuePair.getName())) {
                ArrayList<String> values = new ArrayList<String>();
                ParamValues paramValues = (ParamValues)params.get(nameValuePair.getName());
                if (paramValues == null) continue;
                values.addAll(paramValues.getElements());
                values.add(nameValuePair.getValue());
                ParamValues newParamValues = new ParamValues();
                newParamValues.setElements(values);
                params.put(nameValuePair.getName(), newParamValues);
                continue;
            }
            ParamValues newParamValues = new ParamValues();
            newParamValues.setElements(new ArrayList<String>(Arrays.asList(nameValuePair.getValue())));
            params.put(nameValuePair.getName(), newParamValues);
        }
        return params;
    }

    @Override
    public String validate(String name, String value, String originalName, String originalValue, List<NameValuePair> list, StringPairListEditor owner) {
        ExtendedPropertyValueValidator validator = new ExtendedPropertyValueValidator(null);
        validator.validateParamEntry(name, value);
        this.recordErrors(validator.getErrors(), (IValidationDelegate)this.delegate);
        return null;
    }

    @Override
    public void onAddListItem(StringPairListEditor owner, String newItemName) {
    }

    @Override
    public void onUpdateListItem(StringPairListEditor owner, String originalItemName, String newItemName) {
    }

    @Override
    public void onDeleteListItem(StringPairListEditor owner, String itemToDeleteName) {
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        if (this.isConnection && this.metadataParams != null && !this.metadataParams.isEmpty()) {
            Iterator<MultiValuedNamePair> it = this.metadataParams.iterator();
            NameValuePair previous = (NameValuePair)it.next();
            if (StringUtils.isNotEmpty((String)previous.getValue())) {
                summaryList.add(new SummaryInfo(previous.getName(), previous.getValue(), this));
            }
            while (it.hasNext()) {
                NameValuePair pair = (NameValuePair)it.next();
                if (StringUtils.isNotEmpty((String)pair.getValue())) {
                    if (previous.getName().equals(pair.getName())) {
                        summaryList.add(new SummaryInfo("", pair.getValue(), this));
                    } else {
                        summaryList.add(new SummaryInfo(pair.getName(), pair.getValue(), this));
                    }
                }
                previous = pair;
            }
        }
    }
}

