/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.admin.api.validator.GeneralInfoValidator;
import com.pingidentity.common.util.FieldObfuscator;
import com.pingidentity.draft.mgmt.DraftManager;
import com.pingidentity.draft.mgmt.DraftManagerImpl;
import com.pingidentity.fsm.IWizard;
import com.pingidentity.fsm.state.impl.OIDCDiscoveryMetadata;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.data.ConnectionType;
import com.pingidentity.fsm.tasklet.data.Mode;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.fsm.tasklet.impl.ConnectionTasklet;
import com.pingidentity.fsm.tasklet.impl.IdpConnectionConfigTasklet;
import com.pingidentity.fsm.tasklet.impl.SpConnectionConfigTasklet;
import com.pingidentity.sdk.oauth20.Scope;
import com.pingidentity.util.EnumPropertySelectionModel;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.form.IPropertySelectionModel;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.sourceid.common.HashAlgorithm;
import org.sourceid.common.HashUtil;
import org.sourceid.saml20.domain.AssertionAttributeContract;
import org.sourceid.saml20.domain.AttributeContract;
import org.sourceid.saml20.domain.ConnectionBase;
import org.sourceid.saml20.domain.ContactInfo;
import org.sourceid.saml20.domain.DomainMode;
import org.sourceid.saml20.domain.Endpoint;
import org.sourceid.saml20.domain.EndpointGroup;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.LoggingMode;
import org.sourceid.saml20.domain.OIDCSettings;
import org.sourceid.saml20.domain.SpConnection;
import org.sourceid.saml20.domain.VirtualIdentity;
import org.sourceid.saml20.domain.VirtualServerIdsReferencer;
import org.sourceid.saml20.domain.mgmt.ConnectionManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.metadata.Role;
import org.sourceid.websso.Protocol;

public class GeneralInfoState
extends TaskletState {
    private static final long serialVersionUID = 2L;
    private String connId = "";
    private String connIdOnDisk = null;
    private String connectionName = "";
    private List<VirtualServerId> virtualServerIds = new ArrayList<VirtualServerId>();
    private URL baseUrl;
    private String baseUrlString;
    private String company;
    private String contactName;
    private String contactNumber;
    private String contactEmail;
    private String errMsg = "errorDetail.spSsoFailure";
    private ConnectionBase connection;
    private LoggingMode loggingMode = LoggingMode.STANDARD;
    private String virtualServerIdToAdd;
    private String originalVirtualServerId;
    private int indexInEdit = -1;
    private String applicationName;
    private URL applicationIconUrl;
    private String applicationIconUrlStr;
    private String clientId;
    private String clientSecret;
    private boolean hasExistingPass;
    private boolean additionalIssuersEnabled;
    private boolean metaDataLoaded;
    private boolean updatedIssuer;

    public GeneralInfoState(IWizard owner) {
        super(owner);
        this.setMenuName("General Info");
    }

    @Override
    public boolean populateAllStates(Object data) {
        this.populate(data);
        return true;
    }

    @Override
    public void populate(Object dataFromDisk) {
        this.connection = (ConnectionBase)dataFromDisk;
        if (this.connection != null) {
            ContactInfo ci;
            this.setConnId(this.connection.getEntityId());
            this.connIdOnDisk = this.connection.getEntityIdOnDisk();
            this.setConnectionName(this.connection.getName());
            for (VirtualIdentity virtualEntity : this.connection.getVirtualIdentities()) {
                String virtualEntityId = virtualEntity.getVirtualEntityId(DomainMode.CONFIGTIME);
                if (!StringUtils.isNotEmpty((String)virtualEntityId)) continue;
                VirtualServerId vsid = new VirtualServerId(virtualEntityId);
                if (virtualEntity.equals((Object)this.connection.getDefaultVirtualIdentity())) {
                    vsid.setDefault(true);
                }
                this.virtualServerIds.add(vsid);
            }
            if (this.connection.getBaseUrl() != null) {
                this.setBaseUrlString(this.connection.getBaseUrl().toString());
            }
            if ((ci = this.connection.getContactInfo()) != null) {
                this.setCompany(ci.getCompany());
                this.setContactName(this.concatContactName(ci.getFirstName(), ci.getLastName()));
                this.setContactNumber(ci.getPhone());
                this.setContactEmail(ci.getEmail());
            }
            if (this.connection instanceof IdpConnection) {
                IdpConnection idpConn = (IdpConnection)this.connection;
                this.errMsg = idpConn.getErrorPageMsg();
                if (Protocol.OIDC == this.connection.getProtocol() && idpConn.getOidcSettings() != null) {
                    OIDCSettings oidcSettings = idpConn.getOidcSettings();
                    this.clientId = oidcSettings.getClientId();
                    if (StringUtils.isNotBlank((String)oidcSettings.getClientSecret())) {
                        this.clientSecret = FieldObfuscator.REAL.deobfuscate(oidcSettings.getClientSecret());
                        this.hasExistingPass = true;
                    }
                    this.setAdditionalIssuersEnabled(idpConn.isAllowAdditionalEntities());
                }
            }
            if (this.connection instanceof SpConnection) {
                this.applicationName = ((SpConnection)this.connection).getApplicationName();
                if (((SpConnection)this.connection).getApplicationIconUrl() != null) {
                    this.applicationIconUrlStr = ((SpConnection)this.connection).getApplicationIconUrl().toString();
                }
            }
            this.loggingMode = this.connection.getConfiguredLogMode();
        }
    }

    public boolean isOidc() {
        ConnectionTasklet tasklet = this.getParent(ConnectionTasklet.class);
        return tasklet.isBrowserSsoProfileEnabled() && tasklet.getProtocolType() == Protocol.OIDC;
    }

    @Override
    public boolean save(Object dataToDisk) {
        ConnectionBase conn = (ConnectionBase)dataToDisk;
        boolean isNewConnection = conn.getId() == null;
        conn.setEntityId(this.connId);
        if (this.connIdOnDisk != null) {
            if (isNewConnection) {
                conn.setEntityIdOnDisk(this.connId);
            } else {
                conn.setEntityIdOnDisk(this.connIdOnDisk);
            }
        }
        conn.setName(this.connectionName);
        List virtualIdentities = conn.getVirtualIdentities();
        for (VirtualServerId virtualServerId : this.virtualServerIds) {
            if (virtualServerId.isMarkedForDelete()) continue;
            VirtualIdentity virtualIdentity = new VirtualIdentity();
            virtualIdentity.setVirtualEntityId(virtualServerId.getName(), DomainMode.CONFIGTIME);
            virtualIdentity.setVirtualSourceId(HashUtil.hashToBytes((String)virtualServerId.getName(), (HashAlgorithm)HashAlgorithm.SHA1));
            virtualIdentities.add(virtualIdentity);
            if (!virtualServerId.isDefault()) continue;
            conn.setDefaultVirtualIdentity(virtualIdentity);
        }
        conn.setBaseUrl(this.baseUrl);
        ContactInfo ci = new ContactInfo();
        ci.setCompany(this.getCompany());
        ci.setFirstName(this.getContactFirstName());
        ci.setLastName(this.getContactLastName());
        ci.setPhone(this.getContactNumber());
        ci.setEmail(this.getContactEmail());
        conn.setContactInfo(ci);
        if (conn instanceof IdpConnection) {
            IdpConnection idpConn = (IdpConnection)conn;
            idpConn.setErrorPageMsg(this.getErrMsg());
            if (this.isOidc()) {
                OIDCSettings oidcSettings = idpConn.getOidcSettings();
                if (oidcSettings == null) {
                    oidcSettings = new OIDCSettings();
                    idpConn.setOidcSettings(oidcSettings);
                }
                oidcSettings.setClientId(this.clientId);
                oidcSettings.setClientSecret(FieldObfuscator.REAL.obfuscate(this.clientSecret));
                idpConn.setAllowAdditionalEntities(this.isAdditionalIssuersEnabled());
            }
        }
        if (conn instanceof SpConnection) {
            ((SpConnection)conn).setApplicationName(this.applicationName);
            ((SpConnection)conn).setApplicationIconUrl(this.applicationIconUrl);
        }
        conn.setLoggingMode(this.loggingMode);
        return true;
    }

    public String getConnId() {
        return this.connId;
    }

    public void setConnId(String connId) {
        this.connId = connId.trim();
    }

    public String getConnIdOnDisk() {
        return this.connIdOnDisk;
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        Role role;
        this.metaDataLoaded = false;
        this.updatedIssuer = false;
        this.contactNumber = StringUtils.defaultString((String)this.contactNumber);
        ConnectionManager connectionManager = MgmtFactory.getConnectionManager();
        DraftManager draftManager = DraftManagerImpl.getInstance();
        ConnectionTasklet parentTasklet = this.getParent(ConnectionTasklet.class);
        ConnectionType connectionType = parentTasklet.getConnectionType();
        String existingId = this.connection == null ? null : this.connection.getId();
        Role role2 = role = connectionType == ConnectionType.IDP ? Role.IDP : Role.SP;
        if (this.isEditMode()) {
            delegate.setFormComponent(null);
            delegate.record(this.getMessage("Virtual_server_id_finish_editing"), ValidationConstraint.REQUIRED);
        }
        GeneralInfoValidator validator = null;
        validator = this.isOidc() ? new GeneralInfoValidator(role, existingId, this.connId, this.connectionName, null, null, this.baseUrlString, this.contactEmail, this.applicationIconUrlStr, this.getBrowserSsoProtocol()) : new GeneralInfoValidator(role, existingId, this.connId, this.connectionName, this.getDefaultVirtualServerIdName(), this.getVirtualServerIdNames(), this.baseUrlString, this.contactEmail, this.applicationIconUrlStr, this.getBrowserSsoProtocol());
        validator.validate();
        this.recordErrors(validator.getErrors(), delegate);
        this.baseUrl = this.validateUrl(this.baseUrlString);
        this.applicationIconUrl = this.validateUrl(this.applicationIconUrlStr);
        if (this.isOidc() && StringUtils.isBlank((String)this.clientId)) {
            delegate.setFormComponent(null);
            delegate.record(this.getMessage("field_required", new Object[]{"Client ID"}), ValidationConstraint.REQUIRED);
        }
        if (!StringUtils.isBlank((String)this.connId)) {
            ArrayList mappings = new ArrayList();
            switch (connectionType) {
                case IDP: {
                    String idpSystemId;
                    IdpConnectionConfigTasklet idpTasklet = (IdpConnectionConfigTasklet)parentTasklet;
                    IdpConnection idpStored = idpTasklet.getIdpConnection();
                    String string = idpSystemId = idpStored != null ? idpStored.getId() : null;
                    if (parentTasklet.isModeCreate() && draftManager.isIdpEntityIdInUse(this.connId, idpSystemId)) {
                        delegate.setFormComponent(null);
                        delegate.record(this.getMessage("Draft_id_in_use", new Object[]{this.getIdLabel()}), ValidationConstraint.REQUIRED);
                    }
                    if (parentTasklet.isModeCreate() && draftManager.isIdpConnectionNameInUse(this.connectionName, idpSystemId)) {
                        delegate.setFormComponent(null);
                        delegate.record(this.getMessage("Connection_name_in_use"), ValidationConstraint.REQUIRED);
                    }
                    if (idpStored == null) break;
                    mappings.addAll(idpStored.getTargetAttributeMappings());
                    if (idpStored.getWsTrustSettings() == null) break;
                    mappings.addAll(idpStored.getWsTrustSettings().getAssertionToTokenMappingsMappings());
                    break;
                }
                case SP: {
                    SpConnection spStored;
                    String spSystemId;
                    SpConnection sp = connectionManager.getSpConnectionWithQuietLog(this.connId);
                    SpConnectionConfigTasklet spTasklet = (SpConnectionConfigTasklet)parentTasklet;
                    if (!connectionManager.isEntityIdInUseForSp(this.connId, existingId) && sp == null && spTasklet.isSalesforceConnection()) {
                        if (this.virtualServerIds.isEmpty() && (connectionManager.isEntityIdInUse(this.connId, null) || draftManager.isIdpEntityIdInUse(this.connId, null))) {
                            delegate.setFormComponent(null);
                            delegate.record(this.getMessage("Connection_id_in_use_on_sp_side"), ValidationConstraint.REQUIRED);
                        } else {
                            for (String virtualServerId : this.getVirtualServerIdNames()) {
                                if (!connectionManager.isEntityIdInUse(virtualServerId, null) && !draftManager.isIdpEntityIdInUse(virtualServerId, null)) continue;
                                delegate.setFormComponent(null);
                                delegate.record(this.getMessage("Virtual_connection_id_in_use_on_sp_side"), ValidationConstraint.REQUIRED);
                            }
                        }
                    }
                    String string = spSystemId = (spStored = spTasklet.getSpConnection()) != null ? spStored.getId() : null;
                    if (parentTasklet.isModeCreate() && draftManager.isSpEntityIdInUse(this.connId, spSystemId)) {
                        delegate.setFormComponent(null);
                        delegate.record(this.getMessage("Draft_id_in_use", new Object[]{this.getIdLabel()}), ValidationConstraint.REQUIRED);
                    }
                    if (parentTasklet.isModeCreate() && draftManager.isSpConnectionNameInUse(this.connectionName, spSystemId)) {
                        delegate.setFormComponent(null);
                        delegate.record(this.getMessage("Connection_name_in_use"), ValidationConstraint.REQUIRED);
                    }
                    if (spStored == null) break;
                    mappings.addAll(spStored.getAdapterMappings());
                    if (spStored.getWsTrustSettings() == null) break;
                    mappings.addAll(spStored.getWsTrustSettings().getTokenToAssertionMappings());
                }
            }
            HashSet vsidsInUse = new HashSet();
            for (VirtualServerIdsReferencer mapping : mappings) {
                if (!mapping.isRestrictVirtualServerIds()) continue;
                vsidsInUse.addAll(mapping.getRestrictedVirtualServerIds());
            }
            vsidsInUse.removeAll(this.getVirtualServerIdNames());
            if (!vsidsInUse.isEmpty()) {
                delegate.setFormComponent(null);
                for (String vsidInUse : vsidsInUse) {
                    delegate.record(this.getMessage("Virtual_server_id_in_use", new Object[]{vsidInUse}), ValidationConstraint.REQUIRED);
                }
            }
            if (!StringUtils.isBlank((String)this.connectionName) && connectionType == ConnectionType.SP) {
                SpConnectionConfigTasklet spTasklet = (SpConnectionConfigTasklet)parentTasklet;
                SpConnection spConnFromDisk = connectionManager.getSpConnectionWithQuietLog(this.connId);
                if (spConnFromDisk == null && spTasklet.isSalesforceConnection() && (connectionManager.isNameInUse(this.connectionName, null, Role.IDP) || draftManager.isIdpConnectionNameInUse(this.connectionName, null))) {
                    delegate.setFormComponent(null);
                    delegate.record(this.getMessage("Connection_name_in_use_on_sp_side"), ValidationConstraint.REQUIRED);
                }
            }
        }
    }

    public String getVirtualServerIdsLabel() {
        return "Virtual Server IDs";
    }

    protected URL validateUrl(String urlStr) {
        if (!StringUtils.isBlank((String)urlStr)) {
            try {
                return new URL(urlStr);
            }
            catch (MalformedURLException e) {
                this.log.debug((Object)(urlStr + " is an invalid URL: " + e));
            }
        }
        return null;
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        summaryList.add(new SummaryInfo(this.getStandardsBasedTerm(), this.getConnId(), this));
        summaryList.add(new SummaryInfo("Connection Name", this.connectionName, this));
        if (this.isOidc()) {
            summaryList.add(new SummaryInfo("Enable Additional Issuers", Boolean.valueOf(this.isAdditionalIssuersEnabled()).toString(), this));
            summaryList.add(new SummaryInfo("Client ID", this.clientId, this));
        }
        for (VirtualServerId virtualServerId : this.virtualServerIds) {
            Object label = "Virtual Server ID";
            if (virtualServerId.isDefault()) {
                label = "Default " + (String)label;
            }
            summaryList.add(new SummaryInfo((String)label, virtualServerId.getName(), this));
        }
        if (this.isBaseUrlConfigured()) {
            summaryList.add(new SummaryInfo("Base URL", this.baseUrlString, this));
        }
        if (!StringUtils.isBlank((String)this.company)) {
            summaryList.add(new SummaryInfo("Company", this.company, this));
        }
        if (!StringUtils.isBlank((String)this.contactName)) {
            summaryList.add(new SummaryInfo("Contact Name", this.contactName, this));
        }
        if (!StringUtils.isBlank((String)this.contactNumber)) {
            summaryList.add(new SummaryInfo("Contact Number", this.contactNumber, this));
        }
        if (!StringUtils.isBlank((String)this.contactEmail)) {
            summaryList.add(new SummaryInfo("Contact Email", this.contactEmail, this));
        }
        if (StringUtils.isNotBlank((String)this.applicationName)) {
            summaryList.add(new SummaryInfo("Application Name", this.applicationName, this));
        }
        if (StringUtils.isNotBlank((String)this.applicationIconUrlStr)) {
            summaryList.add(new SummaryInfo("Application Icon URL", this.applicationIconUrlStr, this));
        }
    }

    @Override
    public boolean isSaveDraftAvailable() {
        return false;
    }

    public String getCompany() {
        return this.company;
    }

    public void setCompany(String company) {
        this.company = company;
    }

    public ConnectionBase getConnection() {
        return this.connection;
    }

    public void setConnection(ConnectionBase connection) {
        this.connection = connection;
    }

    public String getContactEmail() {
        return this.contactEmail;
    }

    public void setContactEmail(String contactEmail) {
        this.contactEmail = contactEmail;
    }

    public String getContactName() {
        return this.contactName;
    }

    public String getContactFirstName() {
        String firstName = "";
        if (!StringUtils.isBlank((String)this.contactName)) {
            int firstSpace = this.contactName.indexOf(32);
            firstName = firstSpace == -1 ? this.contactName : this.contactName.substring(0, firstSpace);
        }
        return firstName;
    }

    public String getContactLastName() {
        int firstSpace;
        String lastName = "";
        if (!StringUtils.isBlank((String)this.contactName) && (firstSpace = this.contactName.indexOf(32)) != -1) {
            lastName = this.contactName.substring(firstSpace + 1, this.contactName.length());
        }
        return lastName;
    }

    public void setContactName(String contactName) {
        this.contactName = contactName;
    }

    public String getContactNumber() {
        return this.contactNumber;
    }

    public void setContactNumber(String contactNumber) {
        this.contactNumber = contactNumber;
    }

    public String getBaseUrlString() {
        return this.baseUrlString;
    }

    public void setBaseUrlString(String baseUrlString) {
        this.baseUrlString = baseUrlString;
    }

    public boolean isBaseUrlConfigured() {
        return StringUtils.isNotBlank((String)this.baseUrlString);
    }

    public String getErrMsg() {
        return this.errMsg;
    }

    public void setErrMsg(String errMsg) {
        this.errMsg = errMsg;
    }

    public boolean getShowErrMsg() {
        ConnectionTasklet ct = this.findParent(ConnectionTasklet.class);
        return ct.getConnectionType() == ConnectionType.IDP && !ct.isWsFedProtocol() && ct.isBrowserSsoProfileEnabled();
    }

    public String getStandardsBasedTerm() {
        ConnectionTasklet connectionTasklet = this.findParent(ConnectionTasklet.class);
        if (this.isOidc()) {
            return "Issuer";
        }
        if (connectionTasklet.isConnectionProtocol1x()) {
            switch (connectionTasklet.getConnectionType()) {
                case IDP: {
                    return "Issuer (Connection ID)";
                }
                case SP: {
                    return "Audience (Connection ID)";
                }
            }
        } else if (connectionTasklet.isWsFedProtocol()) {
            return "Partner's Realm (Connection ID)";
        }
        return "Partner's Entity ID (Connection ID)";
    }

    public LoggingMode getLoggingMode() {
        return this.loggingMode;
    }

    public void setLoggingMode(LoggingMode loggingMode) {
        this.loggingMode = loggingMode;
    }

    public boolean isOverrideOn() {
        ConnectionTasklet connectionTasklet = this.findParent(ConnectionTasklet.class);
        switch (connectionTasklet.getConnectionType()) {
            case IDP: {
                GeneralInfoState generalInfoState = this;
                return generalInfoState.loggingMode.isIdpOverrideOn();
            }
            case SP: {
                GeneralInfoState generalInfoState = this;
                return generalInfoState.loggingMode.isSpOverrideOn();
            }
        }
        return false;
    }

    public List<VirtualServerId> getVirtualServerIds() {
        return this.virtualServerIds;
    }

    public void addVirtualServerId() {
        this.delegate.clearErrors();
        this.virtualServerIdToAdd = this.virtualServerIdToAdd.trim();
        if (StringUtils.isEmpty((String)this.virtualServerIdToAdd)) {
            this.delegate.setFormComponent(null);
            this.delegate.record(this.getMessage("Virtual_server_id_required"), ValidationConstraint.REQUIRED);
        } else if (this.isVirtualServerIdDefined(this.virtualServerIdToAdd, -1)) {
            this.delegate.setFormComponent(null);
            this.delegate.record(this.getMessage("Virtual_server_id_already_exists", new Object[]{this.virtualServerIdToAdd}), ValidationConstraint.REQUIRED);
        } else {
            VirtualServerId vsid = new VirtualServerId(this.virtualServerIdToAdd);
            if (this.virtualServerIds.isEmpty()) {
                vsid.setDefault(true);
            }
            this.virtualServerIds.add(vsid);
            this.virtualServerIdToAdd = "";
        }
    }

    public void editVirtualServerId(int index, String virtualServerId) {
        this.indexInEdit = index;
        this.originalVirtualServerId = virtualServerId;
        this.virtualServerIds.get(index).setEdit(true);
    }

    public void deleteVirtualServerId(int indexToDelete) {
        this.virtualServerIds.get(indexToDelete).setMarkedForDelete(true);
    }

    public void unDeleteVirtualServerId(int indexToDelete) {
        this.virtualServerIds.get(indexToDelete).setMarkedForDelete(false);
    }

    public void updateVirtualServerId() {
        this.delegate.clearErrors();
        VirtualServerId virtualServerId = this.virtualServerIds.get(this.indexInEdit);
        String newVirtualServerId = virtualServerId.getName().trim();
        if (StringUtils.isEmpty((String)newVirtualServerId)) {
            this.delegate.record(this.getMessage("Virtual_server_id_required"), ValidationConstraint.REQUIRED);
        } else if (this.isVirtualServerIdDefined(newVirtualServerId, this.indexInEdit)) {
            this.delegate.record(this.getMessage("Virtual_server_id_already_exists", new Object[]{newVirtualServerId}), ValidationConstraint.REQUIRED);
        }
        if (!this.delegate.getHasErrors()) {
            virtualServerId.setEdit(false);
            this.indexInEdit = -1;
        }
    }

    public void cancelVirtualServerIdEdit(int index) {
        VirtualServerId virtualServerId = this.virtualServerIds.get(index);
        virtualServerId.setName(this.originalVirtualServerId);
        virtualServerId.setEdit(false);
    }

    public void setVirtualServerIds(List<VirtualServerId> virtualServerIds) {
        this.virtualServerIds = virtualServerIds;
    }

    public String getConnectionName() {
        return this.connectionName;
    }

    public void setConnectionName(String connectionName) {
        this.connectionName = connectionName.trim();
    }

    public String getVirtualServerIdToAdd() {
        return this.virtualServerIdToAdd;
    }

    public void setVirtualServerIdToAdd(String virtualServerIdToAdd) {
        this.virtualServerIdToAdd = virtualServerIdToAdd;
    }

    public boolean isEditMode() {
        for (VirtualServerId virtualServerId : this.virtualServerIds) {
            if (!virtualServerId.isEdit()) continue;
            return true;
        }
        return false;
    }

    public List<String> getVirtualServerIdNames() {
        ArrayList<String> virtualServerIdNames = new ArrayList<String>();
        for (VirtualServerId virtualServerId : this.virtualServerIds) {
            if (virtualServerId.isMarkedForDelete()) continue;
            virtualServerIdNames.add(virtualServerId.getName());
        }
        return virtualServerIdNames;
    }

    public String getDefaultVirtualServerIdName() {
        for (VirtualServerId virtualServerId : this.virtualServerIds) {
            if (!virtualServerId.isDefault() || virtualServerId.isMarkedForDelete()) continue;
            return virtualServerId.getName();
        }
        return null;
    }

    public void setDefaultVirtualEntityId(int index) {
        for (VirtualServerId vsid : this.virtualServerIds) {
            vsid.setDefault(false);
        }
        VirtualServerId virtualServerId = this.virtualServerIds.get(index);
        virtualServerId.setDefault(true);
    }

    private Protocol getBrowserSsoProtocol() {
        Protocol protocol = null;
        ConnectionTasklet tasklet = this.getParent(ConnectionTasklet.class);
        if (tasklet.isBrowserSsoProfileEnabled()) {
            protocol = tasklet.getProtocolType();
        }
        return protocol;
    }

    private boolean isVirtualServerIdDefined(String name, int index) {
        for (int i = 0; i < this.virtualServerIds.size(); ++i) {
            VirtualServerId vsid;
            if (i == index || !(vsid = this.virtualServerIds.get(i)).getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    private String concatContactName(String first, String last) {
        if (!StringUtils.isBlank((String)first) && StringUtils.isBlank((String)last)) {
            return first;
        }
        if (StringUtils.isBlank((String)first) && !StringUtils.isBlank((String)last)) {
            return last;
        }
        if (!StringUtils.isBlank((String)first) && !StringUtils.isBlank((String)last)) {
            return first + " " + last;
        }
        return "";
    }

    public String getApplicationIconUrlStr() {
        return this.applicationIconUrlStr;
    }

    public void setApplicationIconUrlStr(String applicationIconUrlStr) {
        this.applicationIconUrlStr = applicationIconUrlStr;
    }

    public boolean getShowApplicationInfo() {
        ConnectionTasklet ct = this.findParent(ConnectionTasklet.class);
        return ct.getConnectionType() == ConnectionType.SP;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public void setClientSecret(String clientSecret) {
        if (StringUtils.isBlank((String)clientSecret)) {
            this.clientSecret = null;
            this.hasExistingPass = false;
        } else {
            this.clientSecret = clientSecret;
            this.hasExistingPass = true;
        }
    }

    public boolean isAdditionalIssuersEnabled() {
        return this.additionalIssuersEnabled;
    }

    public void setAdditionalIssuersEnabled(boolean additionalIssuersEnabled) {
        this.additionalIssuersEnabled = additionalIssuersEnabled;
    }

    public void loadMetadata(OIDCDiscoveryMetadata oidcMetadata) {
        if (this.isOidc() && !this.delegate.getHasErrors()) {
            AttributeContract existingContract;
            String connId;
            IdpConnection idpConn = (IdpConnection)this.getConnection();
            if (idpConn == null) {
                idpConn = new IdpConnection();
                this.setMode(Mode.edit);
                idpConn.setAttributeContract((AttributeContract)new AssertionAttributeContract(false, false, this.getParent(ConnectionTasklet.class).getProtocolType()));
            }
            if (!(connId = this.getParent(IdpConnectionConfigTasklet.class).getConnId()).equals(oidcMetadata.getIssuer()) && !this.isAdditionalIssuersEnabled()) {
                idpConn.setEntityId(oidcMetadata.getIssuer());
                this.setConnId(oidcMetadata.getIssuer());
                this.updatedIssuer = true;
            } else {
                this.updatedIssuer = false;
            }
            this.getParent(IdpConnectionConfigTasklet.class).save(idpConn);
            OIDCSettings oidcSettings = idpConn.getOidcSettings();
            if (oidcSettings == null) {
                oidcSettings = new OIDCSettings();
            }
            if ((existingContract = idpConn.getAttributeContract()) == null) {
                idpConn.setAttributeContract((AttributeContract)new AssertionAttributeContract(false, false, this.getParent(ConnectionTasklet.class).getProtocolType()));
            }
            existingContract = idpConn.getAttributeContract();
            if (oidcMetadata.getClaimsSupported() != null) {
                for (String claim : oidcMetadata.getClaimsSupported()) {
                    if (existingContract.getImmutableAttributeNames().contains(claim)) continue;
                    existingContract.addMutableAttributeName(claim);
                }
            }
            if (oidcMetadata.getTokenAuthMethodsSupported() == null || oidcMetadata.getTokenAuthMethodsSupported() != null && oidcMetadata.getTokenAuthMethodsSupported().contains("client_secret_basic")) {
                oidcSettings.setBasicAuth(true);
            }
            oidcSettings.setTokenEndpoint(new Endpoint(null, oidcMetadata.getTokenEndpoint()));
            oidcSettings.setUserInfoEndpoint(new Endpoint(null, oidcMetadata.getUserinfoEndpoint()));
            oidcSettings.setJwksUri(new Endpoint(null, oidcMetadata.getJwksUri()));
            oidcSettings.setScopes(Scope.getScope((String)String.join((CharSequence)" ", oidcMetadata.getScopesSupported())));
            List<String> codeChallengeSupportMethods = oidcMetadata.getCodeChallengeMethodsSupported();
            if (codeChallengeSupportMethods != null && !codeChallengeSupportMethods.isEmpty()) {
                boolean enablePkce = codeChallengeSupportMethods.stream().collect(Collectors.toSet()).contains("S256");
                oidcSettings.setEnableProofKeyForCodeExchange(enablePkce);
            }
            if (StringUtils.isNotEmpty((String)oidcMetadata.getPushedAuthorizationRequestEndpoint())) {
                oidcSettings.setPushedAuthorizationRequestEndpoint(new Endpoint("oauth:par", oidcMetadata.getPushedAuthorizationRequestEndpoint()));
            }
            if (StringUtils.isNotEmpty((String)oidcMetadata.getEndSessionEndpoint())) {
                oidcSettings.setTrackUserSessionsForLogout(true);
                oidcSettings.setLogoutEndpoint(new Endpoint(null, oidcMetadata.getEndSessionEndpoint()));
            }
            idpConn.setOidcSettings(oidcSettings);
            ArrayList<Endpoint> allEndpoints = new ArrayList<Endpoint>();
            Endpoint endpoint = new Endpoint("oauth:authz", oidcMetadata.getAuthorizationEndpoint());
            allEndpoints.add(endpoint);
            EndpointGroup ssoServices = new EndpointGroup();
            ssoServices.setEndpoints(allEndpoints);
            idpConn.setSingleSignOnServices(ssoServices);
            IdpConnectionConfigTasklet tasklet = (IdpConnectionConfigTasklet)this.getParent();
            TaskletState idpBrowserSsoState = tasklet.findState("idpBrowserSso");
            idpBrowserSsoState.setTaskletToEditToNull();
            idpBrowserSsoState.populate(idpConn);
            this.metaDataLoaded = true;
        }
    }

    @Override
    public String getNoteKey() {
        if (this.isOidc()) {
            return super.getNoteKey() + "_Oidc";
        }
        return super.getNoteKey();
    }

    public boolean hasExistingPassword() {
        return this.hasExistingPass;
    }

    public String getMetadataLoadedMessage() {
        if (this.metaDataLoaded && this.updatedIssuer) {
            return this.getMessage("Metadata_loaded_updated_issuer");
        }
        if (this.metaDataLoaded) {
            return this.getMessage("Metadata_loaded");
        }
        return "";
    }

    public void setMetaDataLoaded(boolean metaDataLoaded) {
        this.metaDataLoaded = metaDataLoaded;
    }

    public boolean isMetaDataLoaded() {
        return this.metaDataLoaded;
    }

    private String getIdLabel() {
        return this.isOidc() ? "Issuer" : "Connection ID";
    }

    public IPropertySelectionModel getLoggingModeList() {
        return new EnumPropertySelectionModel((Enum[])LoggingMode.values());
    }

    private static class VirtualServerId
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private boolean edit = false;
        private boolean markedForDelete;
        private boolean isDefault;
        private String name;

        public VirtualServerId(String name) {
            this.name = name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public boolean isEdit() {
            return this.edit;
        }

        public void setEdit(boolean edit) {
            this.edit = edit;
        }

        public boolean isMarkedForDelete() {
            return this.markedForDelete;
        }

        public void setMarkedForDelete(boolean markedForDelete) {
            this.markedForDelete = markedForDelete;
        }

        public boolean isDefault() {
            return this.isDefault;
        }

        public void setDefault(boolean isDefault) {
            this.isDefault = isDefault;
        }
    }
}

