/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.fsm.IWizard;
import com.pingidentity.fsm.tasklet.IdentifiableTasklet;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletListState;
import java.util.ArrayList;
import java.util.List;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.valid.IValidationDelegate;

public class IdentifiableTaskletListState
extends TaskletListState {
    private static final long serialVersionUID = 2L;

    public IdentifiableTaskletListState(IWizard owner) {
        super(owner);
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        this.removeDeletedTasklets();
        for (Tasklet tasklet : this.getTasklets()) {
            tasklet.appendErrors(delegate, component, fastFail);
        }
    }

    protected void removeDeletedTasklets() {
        List<Tasklet> taskletsToRemove = this.getTaskletsToRemove();
        List<Tasklet> tasklets = this.getTasklets();
        for (Tasklet t : taskletsToRemove) {
            if (!tasklets.contains(t)) continue;
            tasklets.remove(t);
        }
    }

    protected List<Tasklet> getTaskletsToRemove() {
        List<Tasklet> tasklets = this.getTasklets();
        ArrayList<Tasklet> taskletsToRemove = new ArrayList<Tasklet>();
        for (Tasklet t : tasklets) {
            if (t.isDraft() || !t.isItDeleted()) continue;
            taskletsToRemove.add(t);
        }
        return taskletsToRemove;
    }

    public Tasklet getTaskletFromList(String identifier) {
        for (Tasklet tasklet : this.getTasklets()) {
            IdentifiableTasklet t = (IdentifiableTasklet)((Object)tasklet);
            if (!t.getId().equals(identifier)) continue;
            tasklet.initialize();
            return tasklet;
        }
        return null;
    }

    public boolean hasMapping(String desc) {
        return this.findTaskletByMappingId(desc) != null;
    }

    public void delete(String mappingToDelete) {
        this.markTaskletAsDeleted(mappingToDelete);
    }

    protected void markTaskletAsDeleted(String mappingToDelete) {
        Tasklet taskletToDelete = this.findTaskletByMappingId(mappingToDelete);
        if (taskletToDelete != null) {
            taskletToDelete.setItDeleted(true);
        }
    }

    public void undelete(String mappingToDelete) {
        Tasklet taskletToUndelete = this.findTaskletByMappingId(mappingToDelete);
        if (taskletToUndelete != null) {
            taskletToUndelete.setItDeleted(false);
        }
    }

    protected Tasklet findTaskletByMappingId(String mappingId) {
        for (Tasklet tasklet : this.getTasklets()) {
            IdentifiableTasklet t = (IdentifiableTasklet)((Object)tasklet);
            if (!t.getId().equals(mappingId)) continue;
            return tasklet;
        }
        return null;
    }

    @Override
    public void cancel(Object newData) {
        if (!this.isViewOnly()) {
            for (Tasklet t : this.getTasklets()) {
                t.setItDeleted(false);
            }
            super.cancel(newData);
        }
    }
}

