/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.c2ccontract.C2cContractToAssertionMapping;
import com.pingidentity.component.card.TaskletListCardUser;
import com.pingidentity.fsm.Visit;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.api.AccountLinkingApi;
import com.pingidentity.fsm.tasklet.data.Mode;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.fsm.tasklet.impl.MultiProtocolTasklet;
import com.pingidentity.fsm.tasklet.impl.SpAuthnSourceMappingTasklet;
import com.pingidentity.fsm.tasklet.impl.SpConfigAdapterMappingTasklet;
import com.pingidentity.fsm.tasklet.impl.SpConfigC2cMappingTasklet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.sourceid.saml20.domain.AdapterToAssertionMapping;
import org.sourceid.saml20.domain.AttributeMapping;
import org.sourceid.saml20.domain.AuthnSourceToAssertionMapping;
import org.sourceid.saml20.domain.SpConnection;

public class IdpAdapterMappingState
extends TaskletState
implements TaskletListCardUser {
    private static final long serialVersionUID = 20050515L;
    private static final String ADAPTER_TYPE = "adapter";
    private static final String C2C_CONTRACT_TYPE = "c2cContract";
    private List<AdapterToAssertionMapping> adapterMappings = new ArrayList<AdapterToAssertionMapping>();
    private List<C2cContractToAssertionMapping> c2cMappings = new ArrayList<C2cContractToAssertionMapping>();
    private List<SpConfigAdapterMappingTasklet> adapterTasklets = new ArrayList<SpConfigAdapterMappingTasklet>();
    private List<SpConfigC2cMappingTasklet> c2cTasklets = new ArrayList<SpConfigC2cMappingTasklet>();

    public IdpAdapterMappingState(Tasklet value) {
        super(value);
        this.setMenuName("Authentication Source Mapping");
    }

    @Override
    public void onResumeDraft() {
        for (Tasklet tasklet : this.adapterTasklets) {
            tasklet.onResumeDraft();
        }
        for (Tasklet tasklet : this.c2cTasklets) {
            tasklet.onResumeDraft();
        }
    }

    @Override
    public void updateVisit(Visit freshVisit) {
        for (Tasklet tasklet : this.adapterTasklets) {
            tasklet.updateVisit(freshVisit);
        }
        for (Tasklet tasklet : this.c2cTasklets) {
            tasklet.updateVisit(freshVisit);
        }
    }

    @Override
    public void getSummary(ArrayList<SummaryInfo> summaryList) {
        super.getSummary(summaryList);
        for (Tasklet tasklet : this.adapterTasklets) {
            if (tasklet.isItDeleted()) continue;
            tasklet.getSummary(summaryList);
        }
        for (Tasklet tasklet : this.c2cTasklets) {
            if (tasklet.isItDeleted()) continue;
            tasklet.getSummary(summaryList);
        }
    }

    @Override
    public void initialize() {
        for (Tasklet tasklet : this.adapterTasklets) {
            tasklet.initialize();
        }
        for (Tasklet tasklet : this.c2cTasklets) {
            tasklet.initialize();
        }
    }

    @Override
    public void setQueue(Queue<String> returnPath) {
        LinkedBlockingQueue<String> temp;
        super.setQueue(returnPath);
        for (Tasklet tasklet : this.adapterTasklets) {
            temp = new LinkedBlockingQueue<String>(this.path);
            temp.add(ADAPTER_TYPE);
            temp.add(tasklet.getTaskletId());
            tasklet.setQueue(temp);
        }
        for (Tasklet tasklet : this.c2cTasklets) {
            temp = new LinkedBlockingQueue(this.path);
            temp.add(C2C_CONTRACT_TYPE);
            temp.add(tasklet.getTaskletId());
            tasklet.setQueue(temp);
        }
    }

    @Override
    public void jumpToState(IRequestCycle cycle, Queue<String> returnPath) {
        block3: {
            String taskletId;
            String taskletType;
            block2: {
                taskletType = returnPath.poll();
                taskletId = returnPath.poll();
                if (!ADAPTER_TYPE.equals(taskletType)) break block2;
                for (Tasklet tasklet : this.adapterTasklets) {
                    if (!taskletId.equals(tasklet.getTaskletId())) continue;
                    Tasklet currentTasklet = (Tasklet)this.getWizard();
                    currentTasklet.loadTasklet(tasklet);
                    tasklet.jumpToState(cycle, returnPath);
                    this.setTaskletToEdit(tasklet);
                }
                break block3;
            }
            if (!C2C_CONTRACT_TYPE.equals(taskletType)) break block3;
            for (Tasklet tasklet : this.c2cTasklets) {
                if (!taskletId.equals(tasklet.getTaskletId())) continue;
                Tasklet currentTasklet = (Tasklet)this.getWizard();
                currentTasklet.loadTasklet(tasklet);
                tasklet.jumpToState(cycle, returnPath);
                this.setTaskletToEdit(tasklet);
            }
        }
    }

    @Override
    public void setTaskletToEdit(Tasklet taskletToEdit) {
        if (this.isAdapterTasklet(taskletToEdit)) {
            if (!taskletToEdit.isCancelled() && !this.adapterTasklets.contains(taskletToEdit)) {
                SpConfigAdapterMappingTasklet at = (SpConfigAdapterMappingTasklet)taskletToEdit;
                at.setNewAdapter(false);
                this.adapterTasklets.add(at);
                Collections.sort(this.adapterTasklets);
            }
        } else if (!taskletToEdit.isCancelled() && !this.c2cTasklets.contains(taskletToEdit)) {
            SpConfigC2cMappingTasklet c2ct = (SpConfigC2cMappingTasklet)taskletToEdit;
            c2ct.setNewContract(false);
            this.c2cTasklets.add(c2ct);
            Collections.sort(this.c2cTasklets);
        }
    }

    private boolean isAdapterTasklet(Tasklet t) {
        return t instanceof SpConfigAdapterMappingTasklet;
    }

    @Override
    public void reset() {
        this.adapterTasklets.clear();
        this.adapterMappings = new ArrayList<AdapterToAssertionMapping>();
        this.c2cTasklets.clear();
        this.c2cMappings = new ArrayList<C2cContractToAssertionMapping>();
    }

    @Override
    public void populate(Object dataFromDisk) {
        SpAuthnSourceMappingTasklet tasklet;
        SpConnection sp = (SpConnection)dataFromDisk;
        this.adapterMappings = new ArrayList<AdapterToAssertionMapping>(sp.getAdapterMappings());
        this.c2cMappings = new ArrayList<C2cContractToAssertionMapping>(sp.getC2cMappings());
        this.adapterTasklets.clear();
        this.c2cTasklets.clear();
        MultiProtocolTasklet multiProtocolTasklet = this.findParent(MultiProtocolTasklet.class);
        AccountLinkingApi ala = this.findParent(AccountLinkingApi.class);
        for (AdapterToAssertionMapping adapterToAssertionMapping : this.adapterMappings) {
            tasklet = this.createTasklet(SpConfigAdapterMappingTasklet.class);
            this.populateMappingTasklet(tasklet, (AuthnSourceToAssertionMapping)adapterToAssertionMapping, ala, multiProtocolTasklet.isWsFedProtocol());
            this.adapterTasklets.add((SpConfigAdapterMappingTasklet)tasklet);
        }
        Collections.sort(this.adapterTasklets);
        for (C2cContractToAssertionMapping c2cContractToAssertionMapping : this.c2cMappings) {
            tasklet = this.createTasklet(SpConfigC2cMappingTasklet.class);
            this.populateMappingTasklet(tasklet, (AuthnSourceToAssertionMapping)c2cContractToAssertionMapping, ala, multiProtocolTasklet.isWsFedProtocol());
            this.c2cTasklets.add((SpConfigC2cMappingTasklet)tasklet);
        }
        Collections.sort(this.c2cTasklets);
    }

    private void populateMappingTasklet(SpAuthnSourceMappingTasklet tasklet, AuthnSourceToAssertionMapping mapping, AccountLinkingApi ala, boolean isWsFed) {
        tasklet.setTransientIdentifierEnabled(ala.isTransientIdentifierEnabled());
        tasklet.setWsFedProtocol(isWsFed);
        tasklet.setAccountLinkingEnabled(ala.isAccountLinkingEnabled());
        tasklet.setNoAdditionalAttributes(ala.hasAdditionalAttributes());
        tasklet.setMode(Mode.edit);
        tasklet.populate(mapping);
    }

    @Override
    public boolean save(Object dataToDisk) {
        AdapterToAssertionMapping mapping;
        SpConnection conn = (SpConnection)dataToDisk;
        ArrayList<AdapterToAssertionMapping> newAdapterMappings = new ArrayList<AdapterToAssertionMapping>();
        ArrayList<AdapterToAssertionMapping> newC2cMappings = new ArrayList<AdapterToAssertionMapping>();
        for (Tasklet tasklet : this.adapterTasklets) {
            if (tasklet.isItDeleted()) continue;
            mapping = new AdapterToAssertionMapping();
            mapping.setDefaultAttributeMapping(new AttributeMapping());
            tasklet.save(mapping);
            newAdapterMappings.add(mapping);
        }
        conn.setAdapterMappings(newAdapterMappings);
        for (Tasklet tasklet : this.c2cTasklets) {
            if (tasklet.isItDeleted()) continue;
            mapping = new C2cContractToAssertionMapping();
            mapping.setDefaultAttributeMapping(new AttributeMapping());
            tasklet.save(mapping);
            newC2cMappings.add(mapping);
        }
        conn.setC2cMappings(newC2cMappings);
        return true;
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        if (!this.isAuthnSourceMapped()) {
            delegate.setFormComponent(null);
            delegate.record(this.getMessage("One_mapping_required"), ValidationConstraint.REQUIRED);
        } else {
            for (Tasklet tasklet : this.adapterTasklets) {
                if (tasklet.isItDeleted()) continue;
                tasklet.appendErrors(delegate, component, fastFail);
            }
            for (Tasklet tasklet : this.c2cTasklets) {
                if (tasklet.isItDeleted()) continue;
                tasklet.appendErrors(delegate, component, fastFail);
            }
        }
    }

    private boolean isAuthnSourceMapped() {
        for (Tasklet tasklet : this.adapterTasklets) {
            if (tasklet.isItDeleted()) continue;
            return true;
        }
        for (Tasklet tasklet : this.c2cTasklets) {
            if (tasklet.isItDeleted()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean onStateExit() {
        this.removeDeletedTasklets(this.adapterTasklets);
        this.removeDeletedTasklets(this.c2cTasklets);
        return true;
    }

    private void removeDeletedTasklets(List<? extends Tasklet> tasklets) {
        Iterator<? extends Tasklet> taskletIterator = tasklets.iterator();
        while (taskletIterator.hasNext()) {
            Tasklet t = taskletIterator.next();
            if (!t.isItDeleted()) continue;
            taskletIterator.remove();
        }
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        ArrayList<SummaryInfo> sortedAdapterSummaryInfo = new ArrayList<SummaryInfo>();
        ArrayList<SummaryInfo> sortedC2cSummaryInfo = new ArrayList<SummaryInfo>();
        for (Tasklet tasklet : this.adapterTasklets) {
            SpConfigAdapterMappingTasklet spConfigAdapterMappingTasklet = (SpConfigAdapterMappingTasklet)tasklet;
            sortedAdapterSummaryInfo.add(new SummaryInfo("Adapter instance name", spConfigAdapterMappingTasklet.getSelectedAdapter().getName(), this));
        }
        for (Tasklet tasklet : this.c2cTasklets) {
            SpConfigC2cMappingTasklet spConfigC2cMappingTasklet = (SpConfigC2cMappingTasklet)tasklet;
            sortedC2cSummaryInfo.add(new SummaryInfo("Authentication policy contract name", spConfigC2cMappingTasklet.getContractName(), this));
        }
        Collections.sort(sortedAdapterSummaryInfo);
        Collections.sort(sortedC2cSummaryInfo);
        summaryList.addAll(sortedAdapterSummaryInfo);
        summaryList.addAll(sortedC2cSummaryInfo);
    }

    public List<SpConfigAdapterMappingTasklet> getAdapterTasklets() {
        return this.adapterTasklets;
    }

    public List<SpConfigC2cMappingTasklet> getC2cTasklets() {
        return this.c2cTasklets;
    }

    @Override
    public String getFirstColumnData(Tasklet t) {
        if (this.isAdapterTasklet(t)) {
            SpConfigAdapterMappingTasklet at = (SpConfigAdapterMappingTasklet)t;
            return at.getDescription();
        }
        SpConfigC2cMappingTasklet c2ct = (SpConfigC2cMappingTasklet)t;
        return c2ct.getDescription();
    }

    @Override
    public String getSecondColumnData(Tasklet t) {
        SpAuthnSourceMappingTasklet mappingTasklet = (SpAuthnSourceMappingTasklet)t;
        return this.buildVirtualIdsString(mappingTasklet.getVirtualServerIds());
    }

    @Override
    public String getThirdColumnData(Tasklet t) {
        return null;
    }

    @Override
    public String getFourthColumnData(Tasklet t) {
        return null;
    }

    private String buildVirtualIdsString(List<String> ids) {
        StringBuilder result = new StringBuilder();
        for (String virtualId : ids) {
            if (result.length() > 0) {
                result.append('\n');
            }
            result.append(virtualId);
        }
        return result.toString();
    }

    @Override
    public boolean enableActionColumn() {
        return true;
    }
}

