/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.api.SamlProfilesApi;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.fsm.tasklet.impl.IdpProtocolSettingsTasklet;
import com.pingidentity.fsm.tasklet.impl.MultiProtocolTasklet;
import java.util.ArrayList;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.sourceid.saml20.domain.IdpConnection;

public class IdpSignaturePolicyState
extends TaskletState {
    public static final String STANDARD = "STD";
    public static final String CUSTOM = "CUSTOM";
    private static final long serialVersionUID = 20050515L;
    private IdpConnection idpConnection;
    private boolean wantAuthnRequestsSigned;
    private boolean assertionSigned;
    private boolean alwaysSignArtifactResponse;
    private String signatureMode = "STD";

    public IdpSignaturePolicyState(Tasklet value) {
        super(value);
        this.setMenuName("Signature Policy");
    }

    @Override
    public void onStateActivated() {
        if (this.wantAuthnRequestsSigned || this.assertionSigned) {
            this.signatureMode = CUSTOM;
        }
    }

    @Override
    public void populate(Object dataFromDisk) {
        this.idpConnection = (IdpConnection)dataFromDisk;
        this.assertionSigned = this.idpConnection.isAssertionSigned();
        this.wantAuthnRequestsSigned = this.idpConnection.isWantAuthnRequestsSigned();
        this.alwaysSignArtifactResponse = this.idpConnection.isAlwaysSignArtifactResponse();
        this.signatureMode = this.wantAuthnRequestsSigned || this.assertionSigned || this.alwaysSignArtifactResponse ? CUSTOM : STANDARD;
    }

    @Override
    public boolean populateAllStates(Object data) {
        this.populate(data);
        return true;
    }

    @Override
    public boolean save(Object dataToDisk) {
        ((IdpConnection)dataToDisk).setAssertionSigned(this.assertionSigned);
        ((IdpConnection)dataToDisk).setWantAuthnRequestsSigned(this.wantAuthnRequestsSigned);
        ((IdpConnection)dataToDisk).setAlwaysSignArtifactResponse(this.alwaysSignArtifactResponse);
        return true;
    }

    @Override
    public void reset() {
        this.wantAuthnRequestsSigned = false;
        this.assertionSigned = false;
        this.signatureMode = STANDARD;
        this.alwaysSignArtifactResponse = false;
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        if (this.isShowAuthnRequestsSigned()) {
            summaryList.add(new SummaryInfo(this.getMessage("Authn_Requests_Signed"), Boolean.toString(this.wantAuthnRequestsSigned), this));
        }
        summaryList.add(new SummaryInfo(this.getMessage("Want_Assertions_Signed"), Boolean.toString(this.assertionSigned), this));
        if (this.isShowAlwaysSignArtifact()) {
            summaryList.add(new SummaryInfo(this.getMessage("Always_Sign_ArtifactResponse"), Boolean.toString(this.alwaysSignArtifactResponse), this));
        }
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        if (this.signatureMode.equals(CUSTOM) && !this.wantAuthnRequestsSigned && !this.assertionSigned && !this.alwaysSignArtifactResponse) {
            delegate.setFormComponent(null);
            delegate.record(this.getMessage("Additional_signature_requirements_not_defined"), ValidationConstraint.REQUIRED);
        }
    }

    public boolean isWantAuthnRequestsSigned() {
        return this.wantAuthnRequestsSigned;
    }

    public void setWantAuthnRequestsSigned(boolean wantAuthnRequestsSigned) {
        this.wantAuthnRequestsSigned = wantAuthnRequestsSigned;
    }

    public boolean isAssertionSigned() {
        return this.assertionSigned;
    }

    public void setAssertionSigned(boolean assertionSigned) {
        this.assertionSigned = assertionSigned;
    }

    public boolean isShowAuthnRequestsSigned() {
        return this.findParent(MultiProtocolTasklet.class).isConnectionProtocol20() && !this.findParent(SamlProfilesApi.class).onlyIdpSsoSelected();
    }

    public String getSignatureMode() {
        return this.signatureMode;
    }

    public void setSignatureMode(String signatureMode) {
        this.signatureMode = signatureMode;
    }

    public boolean isStandardMode() {
        return STANDARD.equals(this.signatureMode);
    }

    public void setAlwaysSignArtifactResponse(boolean alwaysSignArtifactResponse) {
        this.alwaysSignArtifactResponse = alwaysSignArtifactResponse;
    }

    public boolean isAlwaysSignArtifactResponse() {
        return this.alwaysSignArtifactResponse;
    }

    public boolean isShowAlwaysSignArtifact() {
        IdpProtocolSettingsTasklet parent = this.findParent(IdpProtocolSettingsTasklet.class);
        return parent != null && (parent.isArtifactSsoSlo() || parent.isInboundArtifact());
    }

    @Override
    public void formListener(IRequestCycle cycle) {
        if (STANDARD.equals(this.signatureMode)) {
            this.wantAuthnRequestsSigned = false;
            this.assertionSigned = false;
            this.alwaysSignArtifactResponse = false;
        }
    }
}

