/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.admin.api.validator.CertificateValidator;
import com.pingidentity.common.util.PropertyInfo;
import com.pingidentity.crypto.Cert;
import com.pingidentity.fsm.helper.ImportMetadataSummaryHelper;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.data.CertItem;
import com.pingidentity.fsm.tasklet.data.CertificateTypes;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.fsm.tasklet.impl.SignatureVerificationTasklet;
import com.pingidentity.pf.common.api.validator.error.ValidationError;
import com.pingidentity.util.StringPairPropertySelectionModel;
import java.io.InputStream;
import java.util.ArrayList;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.request.IUploadFile;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.sourceid.saml20.domain.log.AdminAuditLogger;
import org.sourceid.saml20.domain.log.AuditLoggerScope;

public class ImportCertState
extends TaskletState {
    private static final long serialVersionUID = 20050515L;
    private String fileName;
    private long fileSize;
    private String password;
    private transient IUploadFile certFile;
    private Cert cert;
    private String errorMessage;
    private CertificateTypes.ValidTypes certType;
    private boolean required = true;
    private StringPairPropertySelectionModel cryptoProviderList;
    private String selectedCryptoProvider;

    public ImportCertState(Tasklet value) {
        super(value);
        this.setMenuName("Import Certificate");
    }

    @Override
    public void onStateActivated() {
        if (PropertyInfo.isHSMHybrid()) {
            this.createCryptoProviderList();
        }
    }

    private void createCryptoProviderList() {
        this.cryptoProviderList = new StringPairPropertySelectionModel();
        this.cryptoProviderList.add("Local Trust Store", "local");
        this.cryptoProviderList.add(PropertyInfo.getHSMMode().getDescription(), PropertyInfo.getHSMMode().name());
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        summaryList.add(new SummaryInfo(this.getMessage("Filename"), this.getFileName(), this));
        summaryList.add(new SummaryInfo(this.getMessage("File_size"), Long.toString(this.getFileSize()), this));
        if (this.cert != null) {
            summaryList.addAll(ImportMetadataSummaryHelper.getCertSummary(this.cert, this));
        }
        if (this.isHybridMode()) {
            summaryList.add(new SummaryInfo(this.getMessage("Crypto_provider"), this.cryptoProviderList.getDescription(this.selectedCryptoProvider), this));
        }
    }

    public IUploadFile getCertFile() {
        return this.certFile;
    }

    @Override
    public void formListener(IRequestCycle cycle) {
        this.importCertFile();
    }

    protected void importCertFile() {
        this.importCertFile(this.certFile);
    }

    protected Cert importCertFile(IUploadFile file) {
        this.errorMessage = null;
        if (file != null && file.getSize() > 0L) {
            InputStream stream = file.getStream();
            CertificateValidator validator = null;
            validator = this.isCertType() ? new CertificateValidator(stream, null) : new CertificateValidator(stream, null, this.password, null);
            if (validator.validate()) {
                this.cert = validator.getCert();
                this.setFileName(file.getFileName());
                this.setFileSize(file.getSize());
                try (AuditLoggerScope auditLoggerScope = new AuditLoggerScope();){
                    auditLoggerScope.log(AdminAuditLogger.Component.CERTIFICATE, AdminAuditLogger.Event.IMPORT, file.getFileName());
                }
                if (PropertyInfo.isHSMHybrid()) {
                    if (!"BCFIPS".equals(this.selectedCryptoProvider) && (this.isConnectionCert() || "local".equals(this.selectedCryptoProvider) || this.isLocalCertStorageHSMType() && this.isCertType())) {
                        this.cert.setStoredOnHSM(Boolean.valueOf(false));
                    } else {
                        this.cert.setStoredOnHSM(Boolean.valueOf(true));
                    }
                }
                return this.cert;
            }
            this.errorMessage = ((ValidationError)validator.getErrors().get(0)).getMessage();
        } else {
            this.fileName = null;
        }
        return null;
    }

    private boolean isLocalCertStorageHSMType() {
        return PropertyInfo.HSM_MODE.LUNA == PropertyInfo.getHSMMode() || PropertyInfo.HSM_MODE.AWSCLOUDHSM == PropertyInfo.getHSMMode();
    }

    private boolean isCertType() {
        CertificateTypes.ValidTypes importCertType = this.getCertType();
        return importCertType == CertificateTypes.ValidTypes.dsigVerificationCert || importCertType == CertificateTypes.ValidTypes.sslCertVerification || importCertType == CertificateTypes.ValidTypes.trustedCAs || importCertType == CertificateTypes.ValidTypes.xmlEncryptionCert || importCertType == CertificateTypes.ValidTypes.ocspDsigVerificationCert || importCertType == CertificateTypes.ValidTypes.wsTrustDsigVerificationCert;
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        if (this.errorMessage != null) {
            delegate.setFormComponent(null);
            delegate.record(this.errorMessage, ValidationConstraint.REQUIRED);
        } else if (this.fileName == null && this.required) {
            delegate.setFormComponent(null);
            delegate.record(this.getMessage("Valid_path_required"), ValidationConstraint.REQUIRED);
        }
        if (delegate.getHasErrors()) {
            this.setPassword(null);
        }
    }

    public void setCertFile(IUploadFile certFile) {
        this.certFile = certFile;
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public void setFileSize(long fileSize) {
        this.fileSize = fileSize;
    }

    public CertItem getCertItem() {
        return this.errorMessage == null ? new CertItem(this.cert) : null;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean isDisplayPasswordField() {
        return this.getCertType() != CertificateTypes.ValidTypes.dsigVerificationCert && this.getCertType() != CertificateTypes.ValidTypes.sslCertVerification && this.getCertType() != CertificateTypes.ValidTypes.trustedCAs && this.getCertType() != CertificateTypes.ValidTypes.xmlEncryptionCert && this.getCertType() != CertificateTypes.ValidTypes.ocspDsigVerificationCert && this.getCertType() != CertificateTypes.ValidTypes.wsTrustDsigVerificationCert;
    }

    public boolean isConnectionCert() {
        if (this.getCertType() == CertificateTypes.ValidTypes.xmlEncryptionCert) {
            return true;
        }
        return this.findParent(SignatureVerificationTasklet.class) != null && (this.getCertType() == CertificateTypes.ValidTypes.dsigVerificationCert || this.getCertType() == CertificateTypes.ValidTypes.ocspDsigVerificationCert || this.getCertType() == CertificateTypes.ValidTypes.wsTrustDsigVerificationCert);
    }

    public CertificateTypes.ValidTypes getCertType() {
        return this.certType;
    }

    public void setCertType(CertificateTypes.ValidTypes certType) {
        this.certType = certType;
        this.configureNote();
    }

    private void configureNote() {
        if (this.isDisplayPasswordField()) {
            if (!this.isBCFIPSMode()) {
                this.setNoteKey("ImportCertState_key_pair_note");
            } else {
                this.setNoteKey("ImportCertState_key_pair_note_in_BCFIPS_mode");
            }
        } else {
            this.setNoteKey("ImportCertState_certificate_note");
        }
    }

    public Cert getCert() {
        return this.cert;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    protected void recordError(String errorMessage) {
        this.delegate.clear();
        this.delegate.setFormComponent(null);
        this.delegate.record(errorMessage, ValidationConstraint.REQUIRED);
    }

    public StringPairPropertySelectionModel getCryptoProviderList() {
        return this.cryptoProviderList;
    }

    public void setSelectedCryptoProvider(String selectedCryptoProvider) {
        this.selectedCryptoProvider = selectedCryptoProvider;
    }

    public String getSelectedCryptoProvider() {
        return this.selectedCryptoProvider;
    }

    public boolean isHybridMode() {
        if (PropertyInfo.isHSMHybrid()) {
            if (PropertyInfo.HSM_MODE.LUNA == PropertyInfo.getHSMMode() || PropertyInfo.HSM_MODE.AWSCLOUDHSM == PropertyInfo.getHSMMode()) {
                return this.isDisplayPasswordField();
            }
            return PropertyInfo.isBCFIPSMode() || !this.isConnectionCert();
        }
        return false;
    }

    public boolean isBCFIPSMode() {
        return PropertyInfo.isBCFIPSMode();
    }
}

