/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.admin.api.validator.CsrResponseValidator;
import com.pingidentity.common.util.PropertyInfo;
import com.pingidentity.crypto.Cert;
import com.pingidentity.crypto.PkCert;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.data.CertItem;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.pf.common.api.validator.error.ValidationError;
import java.io.InputStream;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.request.IUploadFile;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.sourceid.saml20.domain.log.AdminAuditLogger;
import org.sourceid.saml20.domain.log.AuditLoggerScope;

public class ImportCsrRespState
extends TaskletState {
    private static final long serialVersionUID = 20050515L;
    private IUploadFile certFile;
    private CertItem certItem;
    private String fileName;
    private long fileSize;
    private boolean invalidFile = true;
    private List<ValidationError> validationErrors;
    private Cert newPkCert;

    public ImportCsrRespState(Tasklet value, String name) {
        super(value, name);
        this.setMenuName("Import CSR Response");
    }

    @Override
    public void formListener(IRequestCycle cycle) {
        this.invalidFile = true;
        if (this.certFile != null && this.certFile.getSize() > 0L) {
            InputStream stream = this.certFile.getStream();
            CsrResponseValidator validator = new CsrResponseValidator(stream, (PkCert)this.certItem.getCert(), null);
            if (validator.validate()) {
                this.invalidFile = false;
                PkCert pkCert = validator.getNewPkCert();
                if (PropertyInfo.isHSMHybrid()) {
                    pkCert.setStoredOnHSM(Boolean.valueOf(this.certItem.isStoredOnHSM()));
                }
                this.setNewPkCert((Cert)validator.getNewPkCert());
                try (AuditLoggerScope auditLoggerScope = new AuditLoggerScope();){
                    auditLoggerScope.log(AdminAuditLogger.Component.CERTIFICATE, AdminAuditLogger.Event.IMPORT, this.certFile.getFileName());
                }
            } else {
                this.validationErrors = validator.getErrors();
            }
            this.setFileName(this.certFile.getFileName());
            this.setFileSize(this.certFile.getSize());
        }
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        X509Certificate x509 = this.newPkCert.getX509Certificate();
        Principal subjectPrin = x509.getSubjectDN();
        Principal issuerPrin = x509.getIssuerDN();
        Date expiration = x509.getNotAfter();
        summaryList.add(new SummaryInfo(this.getMessage("Subject_dn"), subjectPrin.getName(), this));
        summaryList.add(new SummaryInfo(this.getMessage("Issuer_dn"), issuerPrin.getName(), this));
        summaryList.add(new SummaryInfo(this.getMessage("Serial_number"), this.newPkCert.getSerialNumberForDisplay(), this));
        summaryList.add(new SummaryInfo(this.getMessage("Expires"), expiration.toString(), this));
        summaryList.add(new SummaryInfo(this.getMessage("Filename"), this.getFileName(), this));
        summaryList.add(new SummaryInfo(this.getMessage("File_size"), Long.toString(this.getFileSize()), this));
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        if (StringUtils.isBlank((String)this.fileName)) {
            delegate.setFormComponent(null);
            delegate.record(this.getMessage("Select_file_to_import"), ValidationConstraint.REQUIRED);
        } else if (this.invalidFile) {
            this.recordErrors(this.validationErrors, delegate);
        } else {
            delegate.clear();
            delegate.clearErrors();
        }
    }

    public IUploadFile getCertFile() {
        return this.certFile;
    }

    public void setCertFile(IUploadFile certFile) {
        this.certFile = certFile;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public void setFileSize(long fileSize) {
        this.fileSize = fileSize;
    }

    public CertItem getCertItem() {
        return this.certItem;
    }

    public void setCertItem(CertItem certItem) {
        this.certItem = certItem;
    }

    public Cert getNewPkCert() {
        return this.newPkCert;
    }

    public void setNewPkCert(Cert newPkCert) {
        this.newPkCert = newPkCert;
    }
}

