/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.admin.api.model.connmetadata.ImportMetadataStatusHelper;
import com.pingidentity.admin.api.validator.MetadataSignatureValidator;
import com.pingidentity.crypto.Cert;
import com.pingidentity.fsm.state.impl.ImportCertState;
import com.pingidentity.fsm.state.impl.ImportMetadataState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.api.ImportMetadataApi;
import com.pingidentity.fsm.tasklet.data.CertificateTypes;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.pf.common.api.validator.error.ValidationError;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.IRequestCycle;
import org.sourceid.common.dsig.XmlSignatureVerifier;
import org.sourceid.saml20.domain.MetadataUrlCertPair;
import org.sourceid.saml20.domain.mgmt.MetadataUrlManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.PkCertAndConnectionCertManager;

public class ImportMetadataCertState
extends ImportCertState {
    private static final long serialVersionUID = 20070309L;
    private transient XmlSignatureVerifier verifier;

    public ImportMetadataCertState(Tasklet value) {
        super(value);
        this.setMenuName("Import Certificate");
        this.setCertType(CertificateTypes.ValidTypes.dsigVerificationCert);
        this.setRequired(true);
    }

    @Override
    public void formListener(IRequestCycle cycle) {
        super.formListener(cycle);
        String errorMessage = this.getErrorMessage();
        if (StringUtils.isBlank((String)errorMessage) && this.getFileName() != null && this.getFileName().length() > 0 && this.getCert() != null) {
            ImportMetadataApi ima = this.getParent(ImportMetadataApi.class);
            MetadataSignatureValidator mdSigValidator = new MetadataSignatureValidator(ima.getMetadataXml(), true, this.getCert(), null, null);
            if (!mdSigValidator.validate()) {
                this.setRequired(mdSigValidator.getSigVerifier().hasSignature());
                this.recordError(((ValidationError)mdSigValidator.getErrors().iterator().next()).getMessage());
            }
            this.verifier = mdSigValidator.getSigVerifier();
        }
    }

    @Override
    public void getSummary(ArrayList<SummaryInfo> summaryList) {
        this.doSummary(summaryList);
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        ImportMetadataStatusHelper.MetadataSignatureStatus signStatus = ImportMetadataStatusHelper.getSignature((XmlSignatureVerifier)this.verifier);
        String signStatusStr = signStatus == ImportMetadataStatusHelper.MetadataSignatureStatus.SIGNED ? "signed" : "unsigned";
        summaryList.add(new SummaryInfo(this.getMessage("Metadata_signature_status"), signStatusStr, this));
        if (signStatus == ImportMetadataStatusHelper.MetadataSignatureStatus.SIGNED) {
            ImportMetadataStatusHelper.MetadataCertificateTrustStatus trustStatus = ImportMetadataStatusHelper.getCertificateStatus((XmlSignatureVerifier)this.verifier);
            String trustStatusStr = trustStatus == ImportMetadataStatusHelper.MetadataCertificateTrustStatus.TRUSTED ? "trusted" : "not trusted";
            summaryList.add(new SummaryInfo(this.getMessage("Certificate_status"), trustStatusStr, this, false));
            super.doSummary(summaryList);
        }
    }

    @Override
    public boolean isSaveDraftAvailable() {
        return false;
    }

    @Override
    public boolean save(Object dataToDisk) {
        Tasklet parent = this.getParent();
        String id = null;
        boolean isUrl = false;
        if (parent instanceof ImportMetadataApi) {
            ImportMetadataApi metadataApi = (ImportMetadataApi)((Object)parent);
            id = metadataApi.getMetadataUrlId();
            isUrl = metadataApi.getMetadataType().equals(ImportMetadataState.URL);
        }
        if (isUrl && this.verifier != null && this.verifier.getEffectiveCert() != null) {
            Cert verificationCert = new Cert(null, this.verifier.getEffectiveCert());
            PkCertAndConnectionCertManager certManager = (PkCertAndConnectionCertManager)MgmtFactory.getDsigPkCertManager();
            HashSet<Cert> certs = new HashSet<Cert>();
            certs.add(verificationCert);
            certManager.saveCertsForFeature(certs, id);
            Set savedCerts = certManager.getCertsForFeature(id);
            if (savedCerts != null && !savedCerts.isEmpty()) {
                verificationCert = (Cert)savedCerts.iterator().next();
            }
            String certAlias = verificationCert.getAlias();
            MetadataUrlManager metdataManager = MgmtFactory.getMetadataUrlManager();
            MetadataUrlCertPair metadataUrlCert = metdataManager.getMetadataUrlPair(id);
            metadataUrlCert.setCertAlias(certAlias);
            metdataManager.saveMetadataUrl(metadataUrlCert);
        }
        return true;
    }
}

