/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.admin.api.model.connmetadata.ImportMetadataStatusHelper;
import com.pingidentity.admin.api.validator.ImportMetadataUrlValidator;
import com.pingidentity.admin.api.validator.MetadataValidator;
import com.pingidentity.crypto.Cert;
import com.pingidentity.dependency.error.DependencyErrorHandler;
import com.pingidentity.dependency.error.DependencyErrorUIValidator;
import com.pingidentity.dependency.error.DependencyErrorUIValidatorImpl;
import com.pingidentity.fsm.IWizard;
import com.pingidentity.fsm.helper.ImportMetadataSummaryHelper;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.api.ImportMetadataApi;
import com.pingidentity.fsm.tasklet.data.DependencyType;
import com.pingidentity.fsm.tasklet.data.Mode;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.fsm.tasklet.impl.ConnectionTasklet;
import com.pingidentity.fsm.tasklet.impl.IdpConnectionConfigTasklet;
import com.pingidentity.fsm.tasklet.impl.ImportMetadataTasklet;
import com.pingidentity.fsm.tasklet.impl.SpConnectionConfigTasklet;
import com.pingidentity.pf.common.api.validator.error.ValidationError;
import com.pingidentity.util.StringPairPropertySelectionModel;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import javax.xml.bind.ValidationException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.request.IUploadFile;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.apache.xmlbeans.XmlCalendar;
import org.apache.xmlbeans.XmlObject;
import org.sourceid.common.ValidationUtil;
import org.sourceid.common.dsig.SignatureStatus;
import org.sourceid.common.dsig.XmlSignatureVerifier;
import org.sourceid.saml20.domain.ConnectionBase;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.MetadataUrlCertPair;
import org.sourceid.saml20.domain.SpConnection;
import org.sourceid.saml20.domain.mgmt.ConnectionManager;
import org.sourceid.saml20.domain.mgmt.MetadataUrlManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.NotificationMgr;
import org.sourceid.saml20.domain.mgmt.impl.MetadataUpdateTaskHelper;
import org.sourceid.saml20.domain.util.MetadataImportException;
import org.sourceid.saml20.domain.util.MetadataImportExportUtil;
import org.sourceid.saml20.metadata.Role;
import org.sourceid.websso.Protocol;

public class ImportMetadataState
extends TaskletState
implements ImportMetadataApi {
    private static final long serialVersionUID = 20050515L;
    private static final String METADATA_SIGNATURE_STATUS_FIELD_NAME = "Metadata_signature_status";
    public static final Integer NONE = ImportMetadataUrlValidator.NONE;
    public static final Integer FILE = ImportMetadataUrlValidator.FILE;
    public static final Integer URL = ImportMetadataUrlValidator.URL;
    private static final String MENU_NAME_NEW = "Import Metadata";
    private static final String MENU_NAME = "Metadata URL";
    private transient IUploadFile metaDataFile;
    private String fileName;
    private long fileSize;
    private String errorMessage;
    private transient MetadataValidator mdValidator;
    private transient XmlSignatureVerifier verifier;
    private transient ConnectionBase importedConnection;
    private transient Collection<ConnectionBase> importedConnectionList;
    private transient ConnectionBase mergedConnection;
    private boolean updateMetadata = false;
    private boolean updateSuccessful = false;
    private boolean metadataLoaded = false;
    private String oldMetadataUrl;
    private MetadataUrlCertPair selectedMetadataPair = null;
    private String metadataUrlId = null;
    private String selectedEntityId = "";
    private boolean enableMetadataAutoUpdate = true;
    private Integer metadataType = NONE;
    private boolean isExistingConnection = true;
    private transient StringPairPropertySelectionModel entityIdList;

    public ImportMetadataState(IWizard owner) {
        super(owner);
        this.setMenuName(MENU_NAME_NEW);
    }

    @Override
    public void formListener(IRequestCycle cycle) {
        boolean isMetadataFile = this.metadataType.equals(FILE);
        boolean isMetadataURL = this.metadataType.equals(URL);
        if (isMetadataFile || isMetadataURL) {
            if (isMetadataURL && this.hasUrlChanged()) {
                this.errorMessage = null;
            } else if (isMetadataFile && this.isInputMetadataFileUploaded(cycle)) {
                this.updateSuccessful = this.loadMetadata();
            }
            if (this.mdValidator != null) {
                this.completeMetadataImport(true);
            }
        }
        this.populateMergedConnection();
    }

    private boolean hasUrlChanged() {
        String url = this.getMetadataInputUrl();
        if (this.oldMetadataUrl == null) {
            if (url != null) {
                return true;
            }
        } else {
            if (url == null) {
                return true;
            }
            if (!url.equals(this.oldMetadataUrl)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public void reset() {
        if (this.delegate != null) {
            this.delegate.clearErrors();
        }
        this.resetConnectionsVerifiers();
        this.resetEntityId();
    }

    private void resetConnectionsVerifiers() {
        this.oldMetadataUrl = null;
        this.mdValidator = null;
        this.verifier = null;
        this.importedConnection = null;
        this.errorMessage = null;
        this.mergedConnection = null;
        this.importedConnectionList = null;
    }

    @Override
    public void onResumeDraft() {
        super.onResumeDraft();
        if (FILE.equals(this.metadataType)) {
            this.metadataType = NONE;
        }
    }

    @Override
    public void cancel(Object newData) {
        this.reset();
        super.cancel(newData);
    }

    public boolean loadMetadata() {
        boolean metadataImport = false;
        InputStream metadataFileStream = null;
        this.reset();
        this.validate((IValidationDelegate)this.delegate, false, false);
        if (this.delegate.getHasErrors()) {
            return false;
        }
        String url = this.getMetadataInputUrl();
        try {
            if (this.metadataType.equals(URL)) {
                if (StringUtils.isBlank((String)url)) {
                    this.errorMessage = this.getMessage("no_metadata_URL");
                } else if (!this.isValidUrl(url)) {
                    this.errorMessage = this.getMessage("invalid_metadata_URL", new String[]{url});
                }
            }
            if (this.errorMessage == null) {
                metadataFileStream = this.getMetadataFileStream(url);
                this.generateValidator(metadataFileStream);
            }
        }
        catch (ValidationException e) {
            this.errorMessage = e.getMessage();
        }
        if (this.mdValidator != null) {
            if (this.mdValidator.validate()) {
                if (this.isSignatureVerificationRequired()) {
                    boolean hasEmbeddedCert;
                    this.verifier = this.mdValidator.getSigVerifier();
                    if (this.verifier != null && this.usingExistingUrl() && (hasEmbeddedCert = this.verifier.isCertInKeyInfo()) && this.selectedMetadataPair.getCertAlias() == null) {
                        this.errorMessage = this.getMessage("invalid_saved_metadata_signature");
                    }
                }
                if (this.errorMessage == null) {
                    metadataImport = this.updateMetadata || this.isExistingConnection ? this.updateConnectionMetadata() : this.importMetadataForNewConnection();
                }
            } else {
                String validationError = ((ValidationError)this.mdValidator.getErrors().iterator().next()).getMessage();
                this.errorMessage = this.isSignatureVerificationRequired() && this.usingExistingUrl() && this.mdValidator.isInvalidCert() ? (this.mdValidator.getSigVerifier().hasSignature() ? this.getMessage("invalid_saved_metadata_signature") : this.getMessage("metadata_not_signed")) : validationError;
            }
        }
        if (StringUtils.isNotBlank((String)url)) {
            this.oldMetadataUrl = url;
        }
        if (this.errorMessage == null) {
            this.completeMetadataImport(false);
        }
        this.recordErrorsforUpdateMetadata(this.errorMessage);
        this.updateSuccessful = metadataImport;
        this.metadataLoaded = this.metadataLoaded || this.updateSuccessful;
        Tasklet parentTasklet = this.getParent();
        parentTasklet.reconfigureTransitions();
        if (parentTasklet instanceof ConnectionTasklet) {
            ((ConnectionTasklet)parentTasklet).metaDataReset();
        }
        return metadataImport;
    }

    public String getMetadataInputUrl() {
        String metadata = null;
        if (this.selectedMetadataPair != null && StringUtils.isNotBlank((String)this.selectedMetadataPair.getUrl())) {
            metadata = this.selectedMetadataPair.getUrl();
        }
        return metadata;
    }

    private void resetEntityId() {
        this.selectedEntityId = "";
        this.entityIdList = new StringPairPropertySelectionModel(true);
    }

    private boolean updateConnectionMetadata() {
        boolean mergeConnection = false;
        ConnectionBase metadataConnection = null;
        ConnectionBase sourceConnection = this.getSourceConnection();
        String sourceConnectionEntityId = null;
        if (sourceConnection != null) {
            sourceConnectionEntityId = sourceConnection.getEntityId();
            if (this.mdValidator != null && this.mdValidator.getImportedConnectionsList() != null) {
                Collection connectionBase = this.mdValidator.getImportedConnectionsList();
                try {
                    metadataConnection = MetadataUpdateTaskHelper.getConnectionWithEntityId((String)sourceConnectionEntityId, (Collection)connectionBase);
                }
                catch (MetadataImportException e) {
                    this.errorMessage = this.getMessage("mismatched_entity_id", new String[]{sourceConnectionEntityId});
                }
            }
            if (metadataConnection != null) {
                this.mergedConnection = MetadataImportExportUtil.mergeConnections((ConnectionBase)sourceConnection, metadataConnection);
                mergeConnection = true;
            }
        }
        return mergeConnection;
    }

    public boolean importMetadataForNewConnection() {
        boolean importSuccessful = false;
        this.importedConnectionList = this.mdValidator.getImportedConnectionsList();
        if (this.importedConnectionList != null) {
            if (this.importedConnectionList.size() == 1) {
                this.selectedEntityId = this.importedConnectionList.iterator().next().getEntityId();
            } else {
                for (ConnectionBase connectionBase : this.importedConnectionList) {
                    String connEntityId = connectionBase.getEntityId();
                    String selectIdName = this.entityIdName(connEntityId);
                    this.getEntityIdList().add(selectIdName, connEntityId);
                }
                int entityIdCount = this.importedConnectionList.size();
                if (entityIdCount > 1) {
                    this.getEntityIdList().sort();
                }
            }
            importSuccessful = true;
        }
        return importSuccessful;
    }

    private String entityIdName(String connEntityId) {
        int index = connEntityId.indexOf("://");
        Object selectIdName = connEntityId;
        if (index != -1 && connEntityId.length() > index + 3) {
            selectIdName = connEntityId.substring(index + 3) + " - [" + connEntityId.substring(0, index) + "]";
        }
        return selectIdName;
    }

    public boolean isMetadataFileEmpty() {
        boolean isMetadataFileEmpty = false;
        if (this.metaDataFile == null) {
            isMetadataFileEmpty = true;
        } else {
            this.fileName = this.metaDataFile.getFileName();
            this.fileSize = this.metaDataFile.getSize();
            if (this.fileSize == 0L) {
                isMetadataFileEmpty = true;
            }
        }
        return isMetadataFileEmpty;
    }

    public void recordErrorsforUpdateMetadata(String connectionValidationError) {
        if (!StringUtils.isEmpty((String)connectionValidationError)) {
            this.delegate.setFormComponent(null);
            this.delegate.record(connectionValidationError, ValidationConstraint.REQUIRED);
        }
    }

    public boolean isInputMetadataFileUploaded(IRequestCycle cycle) {
        boolean fileExists = false;
        boolean noMetadataFile = this.metaDataFile == null || StringUtils.isBlank((String)this.metaDataFile.getFileName());
        String parameter = cycle.getRequestContext().getParameter("hack");
        fileExists = !StringUtils.isBlank((String)parameter) || !noMetadataFile;
        return fileExists;
    }

    private boolean hasConnectionsImported() {
        boolean connectionsImported = false;
        if (this.mdValidator == null || this.mdValidator.getImportedConnectionsList() != null && this.mdValidator.getImportedConnectionsList().size() > 0) {
            connectionsImported = true;
        }
        return connectionsImported;
    }

    private void generateValidator(InputStream metadataFileStream) throws ValidationException {
        boolean isIdpConnectionWizard = this.isIdpConnection();
        Protocol expectedProtocol = this.getConnectionProtocol();
        ConnectionBase sourceConnection = this.getSourceConnection();
        boolean errorOnNoCert = false;
        if (this.errorMessage == null) {
            Cert verificationCert = null;
            if (this.usingExistingUrl()) {
                verificationCert = this.selectedMetadataPair.getVerificationCert();
                errorOnNoCert = true;
            }
            this.mdValidator = this.selectedMetadataPair != null && !this.selectedMetadataPair.isValidateSignature() ? new MetadataValidator(isIdpConnectionWizard ? MetadataImportExportUtil.ImportExpectedConnectionType.IDP : MetadataImportExportUtil.ImportExpectedConnectionType.SP, expectedProtocol, metadataFileStream, null) : new MetadataValidator(isIdpConnectionWizard ? MetadataImportExportUtil.ImportExpectedConnectionType.IDP : MetadataImportExportUtil.ImportExpectedConnectionType.SP, expectedProtocol, metadataFileStream, errorOnNoCert, verificationCert, null, null);
            if (this.updateMetadata || this.isExistingConnection) {
                this.mdValidator.setSourceConnection(sourceConnection);
            }
        }
    }

    private InputStream getMetadataFileStream(String url) throws ValidationException {
        InputStream metadataFileStream = null;
        if (this.metadataType.equals(FILE)) {
            metadataFileStream = this.metaDataFile.getStream();
        } else if (this.metadataType.equals(URL)) {
            metadataFileStream = MetadataUpdateTaskHelper.downloadMetadataFromUrl((String)url);
        }
        return metadataFileStream;
    }

    private void completeMetadataImport(boolean validateMetadataLoadClick) {
        this.validate((IValidationDelegate)this.delegate, validateMetadataLoadClick, false);
        if (this.mdValidator != null && (this.errorMessage == null || StringUtils.isNotBlank((String)this.errorMessage) && (!this.delegate.getHasErrors() || this.errorMessage.equals(this.getMessage("select_entity_id"))))) {
            Collection connectionBases = this.mdValidator.getImportedConnectionsList();
            if (connectionBases != null && connectionBases.size() == 0) {
                this.errorMessage = this.getMessage("conn_metadata_no_suitable_connections");
            } else if (!this.isExistingConnection) {
                if (this.isEntityIdSelected()) {
                    try {
                        this.mergedConnection = MetadataUpdateTaskHelper.getConnectionWithEntityId((String)this.selectedEntityId, (Collection)connectionBases);
                        this.errorMessage = null;
                        this.delegate.clearErrors();
                    }
                    catch (MetadataImportException e) {
                        this.errorMessage = this.getMessage("mismatched_entity_id");
                    }
                } else if (this.importedConnectionList != null && this.importedConnectionList.size() > 1 && validateMetadataLoadClick) {
                    this.errorMessage = this.getMessage("select_entity_id");
                }
            }
        }
    }

    public void populateMergedConnection() {
        boolean connectionsImported = this.hasConnectionsImported();
        if ((!this.isExistingConnection || this.updateMetadata) && connectionsImported) {
            this.importedConnection = this.mergedConnection;
        }
        this.updateSuccessful = false;
        this.getParent().reconfigureTransitions();
    }

    public void cancelUpdate() {
        this.updateSuccessful = false;
        this.metaDataFile = null;
        this.reset();
    }

    private ConnectionBase getSourceConnection() {
        ConnectionBase sourceConnection = null;
        if (this.updateMetadata) {
            ImportMetadataTasklet importMetadataTasklet = this.getParent(ImportMetadataTasklet.class);
            sourceConnection = importMetadataTasklet.getConnection();
        } else {
            ConnectionTasklet connectionTasklet = this.getParent(ConnectionTasklet.class);
            if (connectionTasklet instanceof SpConnectionConfigTasklet) {
                sourceConnection = ((SpConnectionConfigTasklet)connectionTasklet).getSpConnection();
            } else if (connectionTasklet instanceof IdpConnectionConfigTasklet) {
                sourceConnection = ((IdpConnectionConfigTasklet)connectionTasklet).getIdpConnection();
            }
        }
        return sourceConnection;
    }

    private Protocol getConnectionProtocol() {
        Protocol connProtocol = null;
        if (this.updateMetadata) {
            ImportMetadataTasklet importMetadataTasklet = this.getParent(ImportMetadataTasklet.class);
            connProtocol = importMetadataTasklet.getConnection().getProtocol();
        } else {
            ConnectionTasklet connectionTasklet = this.getParent(ConnectionTasklet.class);
            connProtocol = connectionTasklet.getProtocolType();
        }
        return connProtocol;
    }

    private boolean isIdpConnection() {
        boolean isIdPConnection = false;
        if (this.updateMetadata) {
            ImportMetadataTasklet importMetadataTasklet = this.getParent(ImportMetadataTasklet.class);
            isIdPConnection = importMetadataTasklet.getConnection().getRoleType().equals((Object)Role.IDP);
        } else {
            ConnectionTasklet connectionTasklet = this.getParent(IdpConnectionConfigTasklet.class);
            if (connectionTasklet instanceof IdpConnectionConfigTasklet) {
                isIdPConnection = true;
            }
        }
        return isIdPConnection;
    }

    @Override
    public ArrayList<SummaryInfo> getMetadataSummary() {
        ArrayList<SummaryInfo> summaryList = new ArrayList<SummaryInfo>();
        this.doSummary(summaryList);
        return summaryList;
    }

    @Override
    public void getSummary(ArrayList<SummaryInfo> summaryList) {
        if (this.selectedMetadataPair != null) {
            super.getSummary(summaryList);
        }
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        String inputMetadataUrl = this.getMetadataInputUrl();
        if (inputMetadataUrl != null && this.metadataType.equals(URL)) {
            summaryList.add(new SummaryInfo(this.getMessage("Metadata_URL"), inputMetadataUrl, this));
        }
        if (!this.updateMetadata) {
            if (this.metadataType.equals(URL)) {
                summaryList.add(new SummaryInfo(this.getMessage("Enable_Auto_Metadata_Update"), String.valueOf(this.enableMetadataAutoUpdate), this));
            }
            if (!this.isExistingConnection) {
                summaryList.add(new SummaryInfo(this.getMessage("Entity_Id"), this.selectedEntityId, this));
            }
        }
        if (this.verifier != null) {
            if (this.verifier.getEffectiveCert() != null) {
                Cert verificationCert = new Cert(null, this.verifier.getEffectiveCert());
                ImportMetadataStatusHelper.MetadataSignatureStatus metadataSignStatus = ImportMetadataStatusHelper.getSignature((XmlSignatureVerifier)this.verifier);
                String signStatusStr = metadataSignStatus == ImportMetadataStatusHelper.MetadataSignatureStatus.SIGNED ? "signed" : "unsigned";
                ImportMetadataStatusHelper.MetadataCertificateTrustStatus trustStatus = ImportMetadataStatusHelper.getCertificateStatus((XmlSignatureVerifier)this.verifier);
                String trustStatusStr = trustStatus == ImportMetadataStatusHelper.MetadataCertificateTrustStatus.TRUSTED ? "trusted" : "not trusted";
                summaryList.add(new SummaryInfo(this.getMessage(METADATA_SIGNATURE_STATUS_FIELD_NAME), signStatusStr, this));
                summaryList.add(new SummaryInfo(this.getMessage("Certificate_status"), trustStatusStr, this));
                summaryList.addAll(ImportMetadataSummaryHelper.getCertSummary(verificationCert, this));
            } else if (this.verifier.getSignatureStatus() != SignatureStatus.UNVERIFIED) {
                summaryList.add(new SummaryInfo(this.getMessage(METADATA_SIGNATURE_STATUS_FIELD_NAME), "unsigned", this));
            }
        }
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        this.validate(delegate, true, true);
    }

    private void validate(IValidationDelegate delegate, boolean validateMetadataLoadClick, boolean validateMetadataLoaded) {
        delegate.clearErrors();
        if (this.enableMetadataAutoUpdate || this.isNewTasklet()) {
            boolean urlRequired;
            boolean bl = urlRequired = this.isInputTypeAvailable() || this.enableMetadataAutoUpdate;
            if (this.metadataType.equals(FILE) && this.isMetadataFileEmpty() && CollectionUtils.isEmpty(this.importedConnectionList) && this.mergedConnection == null) {
                delegate.record(this.getMessage("no_metadata_file"), ValidationConstraint.REQUIRED);
            } else if (this.metadataType.equals(URL)) {
                if (this.getParent() instanceof ImportMetadataTasklet && !this.getParent().isCancelled() && validateMetadataLoaded && !this.metadataLoaded) {
                    delegate.record(this.getMessage("load_from_URL"), ValidationConstraint.REQUIRED);
                } else {
                    ImportMetadataUrlValidator validator = new ImportMetadataUrlValidator(this.oldMetadataUrl, this.selectedMetadataPair, this.isNewTasklet(), this.metadataType);
                    validator.setValidateLoadClicked(validateMetadataLoadClick);
                    boolean valid = validator.validate();
                    if (!valid) {
                        this.recordErrors(validator.getErrors(), delegate);
                    }
                }
            }
            if (!delegate.getHasErrors() && StringUtils.isNotBlank((String)this.errorMessage)) {
                delegate.record(this.errorMessage, ValidationConstraint.REQUIRED);
            }
        }
    }

    @Override
    public boolean isSaveDraftAvailable() {
        return false;
    }

    public IUploadFile getMetaDataFile() {
        return this.metaDataFile;
    }

    public void setMetaDataFile(IUploadFile metaDataFile) {
        this.metaDataFile = metaDataFile;
    }

    public ConnectionBase getImportedConnection() {
        return this.importedConnection;
    }

    public void setImportedConnection(ConnectionBase importedConnection) {
        this.importedConnection = importedConnection;
    }

    public String getFileName() {
        return this.fileName;
    }

    public boolean isSignedMetadataWoKeyInfo() {
        boolean rc = false;
        if (this.verifier != null) {
            boolean useExisting = this.usingExistingUrl();
            if (this.verifier.hasSignature() && !this.verifier.isCertInKeyInfo() && !useExisting) {
                rc = true;
            }
        }
        return rc;
    }

    public boolean isUnsignedOrSignedWithKeyInfo() {
        boolean rc = false;
        if (this.verifier != null && (!this.verifier.hasSignature() || this.verifier.getSignatureStatus() == SignatureStatus.VALID && this.verifier.isCertInKeyInfo())) {
            rc = true;
        }
        return rc;
    }

    public XmlSignatureVerifier getXmlSignatureVerifier() {
        return this.verifier;
    }

    @Override
    public void importConnection() {
        if (this.importedConnection != null) {
            Tasklet tasklet = this.getParent();
            tasklet.populateAllStates(this.importedConnection);
        }
    }

    @Override
    public XmlObject getMetadataXml() {
        return this.mdValidator.getMetadataXml();
    }

    public boolean isUpdateMetadata() {
        return this.updateMetadata;
    }

    public void setUpdateMetadata(boolean updateMetadata) {
        this.updateMetadata = updateMetadata;
    }

    public boolean isUpdateSuccessful() {
        return this.updateSuccessful;
    }

    public void setUpdateSuccessful(boolean updateSuccessful) {
        this.updateSuccessful = updateSuccessful;
    }

    public boolean isEntityIdRequired() {
        return this.importedConnectionList != null && this.getEntityIdList().getOptionCount() > 1;
    }

    public String getSelectedEntityId() {
        return this.selectedEntityId;
    }

    public void setSelectedEntityId(String selectedEntityId) {
        this.selectedEntityId = selectedEntityId;
    }

    public StringPairPropertySelectionModel getEntityIdList() {
        if (this.entityIdList == null) {
            this.entityIdList = new StringPairPropertySelectionModel(true);
        }
        return this.entityIdList;
    }

    public StringPairPropertySelectionModel getUrlList() {
        StringPairPropertySelectionModel urlList = this.generateUrlSelectionList();
        return urlList;
    }

    @Override
    public String getMetadataUrlId() {
        return this.metadataUrlId;
    }

    public void setMetadataUrlId(String selectedMetadataId) {
        this.metadataUrlId = selectedMetadataId;
        MetadataUrlManager metadataUrlManager = MgmtFactory.getMetadataUrlManager();
        this.selectedMetadataPair = metadataUrlManager.getMetadataUrlPair(selectedMetadataId);
    }

    public ConnectionBase getMergedConnection() {
        return this.mergedConnection;
    }

    public boolean isExistingConnection() {
        return this.isExistingConnection;
    }

    public void setExistingConnection(boolean isExistingConnection) {
        this.isExistingConnection = isExistingConnection;
    }

    public boolean isEnableMetadataAutoUpdate() {
        return this.enableMetadataAutoUpdate;
    }

    public void setEnableMetadataAutoUpdate(boolean enableMetadataAutoUpdate) {
        this.enableMetadataAutoUpdate = enableMetadataAutoUpdate;
    }

    @Override
    public Integer getMetadataType() {
        return this.metadataType;
    }

    public void setMetadataType(Integer metadataType) {
        if (!this.metadataType.equals(metadataType)) {
            this.reset();
        }
        this.metadataType = metadataType;
    }

    public MetadataUrlCertPair getSelectedMetadataPair() {
        return this.selectedMetadataPair;
    }

    @Override
    public void populate(Object dataFromDisk) {
        IdpConnection connection = null;
        if (dataFromDisk != null) {
            if (dataFromDisk instanceof IdpConnection) {
                connection = (IdpConnection)dataFromDisk;
            } else if (dataFromDisk instanceof SpConnection) {
                connection = (SpConnection)dataFromDisk;
            }
            if (connection != null) {
                String savedMetadataId = connection.getMetadataUrlId();
                this.setMetadataInputType(savedMetadataId);
                this.enableMetadataAutoUpdate = connection.isEnableAutoMetadataUpdate();
                if (savedMetadataId != null) {
                    this.generateUrlSelectionList();
                    MetadataUrlManager metadataUrlManager = MgmtFactory.getMetadataUrlManager();
                    this.selectedMetadataPair = metadataUrlManager.getMetadataUrlPair(savedMetadataId);
                    this.metadataUrlId = savedMetadataId;
                    if (this.selectedMetadataPair != null) {
                        this.oldMetadataUrl = this.selectedMetadataPair.getUrl();
                    }
                }
            }
        }
    }

    private void setMetadataInputType(String savedMetadataId) {
        if (this.updateMetadata) {
            String connMetdataUrlId = savedMetadataId;
            this.metadataType = StringUtils.isNotBlank((String)connMetdataUrlId) ? URL : FILE;
        } else if (this.isExistingConnection) {
            this.metadataType = URL;
        }
        this.getParent().reconfigureTransitions();
    }

    @Override
    public boolean save(Object dataToDisk) {
        if (dataToDisk instanceof ConnectionBase) {
            ConnectionBase connection = (ConnectionBase)dataToDisk;
            this.saveConnectionToDisk(connection);
            this.saveMetadataSettings(connection);
        }
        return true;
    }

    private void saveMetadataSettings(ConnectionBase connection) {
        if (!this.metadataType.equals(URL)) {
            return;
        }
        String id = null;
        if (this.selectedMetadataPair != null) {
            id = this.selectedMetadataPair.getId();
        }
        if (this.enableMetadataAutoUpdate) {
            connection.setMetadataUrlId(id);
        }
        connection.setEnableAutoMetadataUpdate(this.enableMetadataAutoUpdate);
    }

    @Override
    public void onStateActivated() {
        this.setMetadataInputType(null);
        if (this.getParent() instanceof ImportMetadataTasklet) {
            ImportMetadataTasklet importMetadataTasklet = (ImportMetadataTasklet)this.getParent();
            this.populate(importMetadataTasklet.getConnection());
        }
        if (!this.isInputTypeAvailable()) {
            this.metadataType = URL;
        }
        if (this.isNewTasklet()) {
            this.setMenuName(MENU_NAME_NEW);
        } else {
            this.setMenuName(MENU_NAME);
        }
    }

    @Override
    public String getNoteKey() {
        String baseKey = super.getNoteKey();
        String newTaskletNoteKey = baseKey + "_newState";
        return this.isNewTasklet() ? newTaskletNoteKey : baseKey;
    }

    public boolean isNewTasklet() {
        if (this.getParent() instanceof ImportMetadataTasklet) {
            return true;
        }
        return this.getParent().getMode() == Mode.create;
    }

    @Override
    public boolean onStateExit() {
        if (!this.isExistingConnection && !this.updateMetadata) {
            ImportMetadataApi ima = this.getParent(ImportMetadataApi.class);
            ima.importConnection();
        }
        return true;
    }

    public void saveConnectionToDisk(ConnectionBase connection) {
        ConnectionManager connectionManager = MgmtFactory.getConnectionManager();
        if (connection != null && this.updateMetadata) {
            DependencyErrorUIValidatorImpl affectedItemValidator = new DependencyErrorUIValidatorImpl((Tasklet)this.getWizard());
            DependencyErrorHandler dependencyErrorHandler = new DependencyErrorHandler();
            DependencyType dependencyType = null;
            if (!this.updateMetadata) {
                connection.setCreationTime((Calendar)new XmlCalendar(new Date()));
            }
            if (connection instanceof IdpConnection) {
                connectionManager.saveIdpConnection((IdpConnection)connection);
                dependencyType = DependencyType.IDP_CONN_METADATA;
            } else if (connection instanceof SpConnection) {
                connectionManager.saveSpConnection((SpConnection)connection);
                dependencyType = DependencyType.SP_CONN_METADATA;
            }
            dependencyErrorHandler.performDependencyValidation((DependencyErrorUIValidator)affectedItemValidator, (Object)connection, dependencyType);
        }
    }

    private boolean isValidUrl(String url) {
        return ValidationUtil.isValidHttpOrHttpsUrl((String)url);
    }

    public boolean isEntityIdSelected() {
        boolean isSelected = false;
        isSelected = StringUtils.isNotBlank((String)this.selectedEntityId) && !this.selectedEntityId.equals("- SELECT -");
        return isSelected;
    }

    public boolean isNotificationConfigured() {
        NotificationMgr notificationMgr = MgmtFactory.getNotificationMgr();
        boolean isNotificationServerConfigured = notificationMgr.getNotificationSettings().isEnableMetadataEventNotification();
        return isNotificationServerConfigured;
    }

    public boolean isInputTypeAvailable() {
        return this.updateMetadata || !this.isExistingConnection;
    }

    private StringPairPropertySelectionModel generateUrlSelectionList() {
        StringPairPropertySelectionModel urlList = new StringPairPropertySelectionModel(true);
        MetadataUrlManager metadataUrlManager = MgmtFactory.getMetadataUrlManager();
        Collection metadataPairs = metadataUrlManager.getMetadataUrlPairs();
        for (MetadataUrlCertPair metadataPair : metadataPairs) {
            urlList.add(metadataPair.getName(), metadataPair.getId());
        }
        urlList.sort();
        return urlList;
    }

    public boolean displaySelectedUrlField() {
        String url;
        String urlName;
        return this.selectedMetadataPair == null || !(urlName = this.selectedMetadataPair.getName()).equals(url = this.selectedMetadataPair.getUrl());
    }

    @Override
    public void onStateRevisit() {
        if (this.metadataType.equals(FILE)) {
            this.metaDataFile = null;
            this.fileSize = 0L;
            this.fileName = null;
            this.reset();
        }
    }

    public boolean isMetadataSummaryRequired() {
        boolean isSummaryRequired = true;
        if (this.usingExistingUrl()) {
            isSummaryRequired = false;
        }
        return isSummaryRequired;
    }

    private boolean usingExistingUrl() {
        return this.metadataType.equals(URL) && (this.selectedMetadataPair != null || this.getMetadataInputUrl() == null);
    }

    public boolean isSignatureVerificationRequired() {
        MetadataUrlCertPair urlCertPair;
        if (this.metadataUrlId != null && (urlCertPair = MgmtFactory.getMetadataUrlManager().getMetadataUrlPair(this.metadataUrlId)) != null) {
            return urlCertPair.isValidateSignature();
        }
        return true;
    }
}

