/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.admin.api.validator.InboundBackChannelAuthTypeValidator;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.api.SamlProfilesApi;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.fsm.tasklet.impl.ConnectionTasklet;
import java.util.ArrayList;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.valid.IValidationDelegate;
import org.sourceid.config.SoapAuthInfo;
import org.sourceid.saml20.domain.ConnectionBase;

public class InboundConfigSoapAuthState
extends TaskletState {
    private static final long serialVersionUID = 69L;
    private boolean cert;
    private boolean basic;
    private boolean none;
    private boolean requiresSsl = true;

    public InboundConfigSoapAuthState(Tasklet parent) {
        super(parent);
        this.setMenuName("Inbound Authentication Type");
    }

    @Override
    public void populate(Object dataFromDisk) {
        ConnectionBase connectionBase = (ConnectionBase)dataFromDisk;
        SoapAuthInfo soapAuthIn = connectionBase.getSoapAuthIn();
        this.none = soapAuthIn.isHasNoneEntry();
        this.basic = soapAuthIn.isHasBasicEntry();
        this.cert = soapAuthIn.isHasCertEntry();
        this.requiresSsl = soapAuthIn.isSsl();
    }

    @Override
    public boolean save(Object dataToDisk) {
        ConnectionBase conn = (ConnectionBase)dataToDisk;
        SoapAuthInfo soapAuthIn = conn.getSoapAuthIn();
        soapAuthIn.setHasNoneEntry(this.none);
        soapAuthIn.setSsl(this.requiresSsl);
        return true;
    }

    @Override
    public void reset() {
        this.cert = false;
        this.none = false;
        this.basic = false;
        this.requiresSsl = true;
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        if (this.basic) {
            summaryList.add(new SummaryInfo(this.getMessage("Soap_auth_type"), this.getMessage("Basic_desc"), this));
        }
        if (this.cert) {
            summaryList.add(new SummaryInfo(this.getMessage("Soap_auth_type"), this.getMessage("Cert_desc"), this));
        }
        if (this.none) {
            summaryList.add(new SummaryInfo(this.getMessage("Soap_auth_type"), this.isXaspOnly() ? this.getMessage("Dsig_desc_none") : this.getMessage("Dsig_desc"), this));
        }
        if (this.isEnableRequireSsl()) {
            summaryList.add(new SummaryInfo(this.getMessage("Ssl_required"), Boolean.toString(this.requiresSsl), this));
        }
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        InboundBackChannelAuthTypeValidator validator = new InboundBackChannelAuthTypeValidator(this.cert, this.basic, this.none, this.needAtLeastBasicOrCert());
        if (!validator.validate()) {
            this.recordErrors(validator.getErrors(), delegate);
        }
    }

    @Override
    public String getNoteKey() {
        if (this.findParent(ConnectionTasklet.class).isConnectionProtocol1x()) {
            return super.getNoteKey() + "_1x";
        }
        if (this.isXaspOnly()) {
            return super.getNoteKey() + "_Xasp";
        }
        return super.getNoteKey();
    }

    public boolean usesDsigAuth() {
        return this.none;
    }

    public boolean showDsigAuth() {
        return this.findParent(ConnectionTasklet.class).isBrowserSsoStateEnabled();
    }

    public boolean isEnableRequireSsl() {
        return !this.isCert();
    }

    public boolean needAtLeastBasicOrCert() {
        ConnectionTasklet connectionTasklet = this.findParent(ConnectionTasklet.class);
        return connectionTasklet.isConnectionProtocol1x();
    }

    public boolean isXaspOnly() {
        SamlProfilesApi spa = this.findParent(SamlProfilesApi.class);
        return spa.isAttributeQuerySelected() && !spa.isAnySsoSelected();
    }

    public boolean isCert() {
        return this.cert;
    }

    public void setCert(boolean cert) {
        this.cert = cert;
    }

    public boolean isBasic() {
        return this.basic;
    }

    public void setBasic(boolean basic) {
        this.basic = basic;
    }

    public boolean isNone() {
        return this.none;
    }

    public void setNone(boolean none) {
        this.none = none;
    }

    public boolean getRequiresSsl() {
        return this.requiresSsl || this.isCert();
    }

    public void setRequiresSsl(boolean requiresSsl) {
        this.requiresSsl = requiresSsl;
    }
}

