/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.admin.api.validator.InboundProvisioningCustomScim2AttributesValidator;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletListState;
import com.pingidentity.fsm.tasklet.data.Mode;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.fsm.tasklet.impl.IdpConnectionConfigTasklet;
import com.pingidentity.fsm.tasklet.impl.InboundProvisioningCustomScim2AttributeTasklet;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.scim.ScimVersion;
import org.sourceid.saml20.domain.scim.model.Scim2Schema;
import org.sourceid.saml20.domain.scim.model.Scim2SchemaAttribute;

public class InboundProvisioningCustomScim2AttributesState
extends TaskletListState {
    protected String customScimAttributeNameToAdd = "";
    protected String namespace = "urn:scim:schemas:extension:custom:2.0";

    public InboundProvisioningCustomScim2AttributesState(Tasklet value, String name) {
        super(value, name);
        this.setMenuName("Custom SCIM Attributes");
    }

    private List<Scim2SchemaAttribute> getCustomScimAttributesFromDisk(Scim2Schema customScim) {
        ArrayList atts = customScim.getAttributes();
        if (atts == null) {
            atts = new ArrayList();
        }
        return atts;
    }

    @Override
    public void populate(Object dataFromDisk) {
        this.deleteAllTasklets();
        IdpConnection connection = null;
        connection = dataFromDisk == null ? MgmtFactory.getConnectionManager().getIdpConnection(this.getIdpConnId()) : (IdpConnection)dataFromDisk;
        if (connection.getInboundProvisioning() != null && connection.getInboundProvisioning().getCustomScim2Schema() != null) {
            List<Scim2SchemaAttribute> schemaAttributeList = this.getCustomScimAttributesFromDisk(connection.getInboundProvisioning().getCustomScim2Schema());
            for (Scim2SchemaAttribute customScimAttribute : schemaAttributeList) {
                this.createTaskletForCustomAttribute(customScimAttribute);
            }
            this.namespace = connection.getInboundProvisioning().getCustomScim2Schema().getSchema();
        }
    }

    private void createTaskletForCustomAttribute(Scim2SchemaAttribute customScimAttribute) {
        InboundProvisioningCustomScim2AttributeTasklet customScimAttributeTasklet = this.createTasklet(InboundProvisioningCustomScim2AttributeTasklet.class);
        customScimAttributeTasklet.setMode(Mode.edit);
        customScimAttributeTasklet.populate(customScimAttribute);
        this.addTasklet(customScimAttributeTasklet);
    }

    @Override
    public boolean save(Object dataToDisk) {
        ArrayList atts;
        IdpConnection connection = (IdpConnection)dataToDisk;
        ArrayList<Scim2SchemaAttribute> schemaAttributesList = new ArrayList<Scim2SchemaAttribute>();
        for (Tasklet tasklet : this.getTasklets()) {
            InboundProvisioningCustomScim2AttributeTasklet customScimAttributeTasklet = (InboundProvisioningCustomScim2AttributeTasklet)tasklet;
            if (customScimAttributeTasklet.isItDeleted()) continue;
            Scim2SchemaAttribute schemaAttribute = new Scim2SchemaAttribute();
            schemaAttribute.setName(customScimAttributeTasklet.getAttributeName());
            schemaAttribute.setDescription(customScimAttributeTasklet.getAttributeDescription());
            schemaAttribute.setType(customScimAttributeTasklet.getAttributeType());
            schemaAttribute.setReturned(customScimAttributeTasklet.getReturned());
            schemaAttribute.setUniqueness(customScimAttributeTasklet.getUniqueness());
            schemaAttribute.setMutability(customScimAttributeTasklet.getMutability());
            schemaAttribute.setMultiValued(Boolean.valueOf(customScimAttributeTasklet.isMultiValued()));
            schemaAttribute.setCaseExact(Boolean.valueOf(customScimAttributeTasklet.isCaseExact()));
            schemaAttribute.setRequired(Boolean.valueOf(customScimAttributeTasklet.getRequired()));
            schemaAttribute.setCanonicalValues(customScimAttributeTasklet.getCanonicalValues());
            customScimAttributeTasklet.save(schemaAttribute);
            schemaAttributesList.add(schemaAttribute);
        }
        Scim2Schema scim2Schema = connection.getInboundProvisioning().getCustomScim2Schema();
        if (scim2Schema == null) {
            scim2Schema = new Scim2Schema();
        }
        if ((atts = connection.getInboundProvisioning().getCustomScim2Schema().getAttributes()) == null) {
            atts = new ArrayList();
        }
        atts.clear();
        atts.addAll(schemaAttributesList);
        scim2Schema.setAttributes(atts);
        scim2Schema.setSchema(this.namespace);
        scim2Schema.setName(this.namespace);
        connection.getInboundProvisioning().setCustomScim2Schema(scim2Schema);
        connection.getInboundProvisioning().setVersion(ScimVersion.SCIM20);
        return true;
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        if (StringUtils.isEmpty((String)this.namespace) && !this.getAllUndeletedTasklets().isEmpty()) {
            delegate.setFormComponent(null);
            delegate.record(this.getMessage("extension_namespace_cannot_be_blank"), ValidationConstraint.REQUIRED);
        }
    }

    public String getCustomScimAttributeNameToAdd() {
        return this.customScimAttributeNameToAdd;
    }

    public void setCustomScimAttributeNameToAdd(String customScimAttributeNameToAdd) {
        this.customScimAttributeNameToAdd = customScimAttributeNameToAdd;
    }

    public void addCustomAttributeName() {
        InboundProvisioningCustomScim2AttributesValidator validator = new InboundProvisioningCustomScim2AttributesValidator.Builder().setSchema(this.namespace).setAttributeName(this.customScimAttributeNameToAdd).build();
        if (!validator.validate()) {
            this.recordErrors(validator.getErrors(), (IValidationDelegate)this.delegate);
        }
        if (!validator.hasErrors()) {
            Scim2SchemaAttribute schemaAttributeToAdd = new Scim2SchemaAttribute();
            schemaAttributeToAdd.setName(this.customScimAttributeNameToAdd);
            schemaAttributeToAdd.setMultiValued(Boolean.valueOf(false));
            schemaAttributeToAdd.setDescription(this.customScimAttributeNameToAdd);
            schemaAttributeToAdd.setSubAttributes(null);
            this.createTaskletForCustomAttribute(schemaAttributeToAdd);
            this.customScimAttributeNameToAdd = "";
        }
    }

    public Tasklet getTaskletForCustomAttributeName(String customScimAttributeName) {
        for (Tasklet tasklet : this.getTasklets()) {
            InboundProvisioningCustomScim2AttributeTasklet t = (InboundProvisioningCustomScim2AttributeTasklet)tasklet;
            if (!t.getAttributeName().equals(customScimAttributeName)) continue;
            tasklet.initialize();
            return tasklet;
        }
        return null;
    }

    public void delete(String customAttributeToDelete) {
        for (Tasklet tasklet : this.getTasklets()) {
            InboundProvisioningCustomScim2AttributeTasklet t = (InboundProvisioningCustomScim2AttributeTasklet)tasklet;
            if (!t.getAttributeName().equals(customAttributeToDelete)) continue;
            t.setItDeleted(true);
            return;
        }
    }

    public void undelete(String customAttributeToUndelete) {
        for (Tasklet tasklet : this.getTasklets()) {
            InboundProvisioningCustomScim2AttributeTasklet t = (InboundProvisioningCustomScim2AttributeTasklet)tasklet;
            if (!t.getAttributeName().equals(customAttributeToUndelete)) continue;
            t.setItDeleted(false);
            return;
        }
    }

    private List<String> getAttributeNamesListFromSchemaAttributesList(List<Scim2SchemaAttribute> schemaAttributes) {
        ArrayList<String> attrNames = new ArrayList<String>();
        for (Scim2SchemaAttribute schemaAttribute : schemaAttributes) {
            attrNames.add(schemaAttribute.getName());
        }
        return attrNames;
    }

    public List<String> getAttributeNamesNotIncludingTasklet(String excludedTaskletId) {
        ArrayList<String> attrNames = new ArrayList<String>();
        List<Tasklet> allTasklets = this.getTasklets();
        for (Tasklet tasklet : allTasklets) {
            if (tasklet.getTaskletId().equals(excludedTaskletId)) continue;
            attrNames.add(((InboundProvisioningCustomScim2AttributeTasklet)tasklet).getAttributeName());
        }
        return attrNames;
    }

    public List<String> getAllCustomAttributeNames() {
        ArrayList<String> attrNames = new ArrayList<String>();
        for (Tasklet tasklet : this.getTasklets()) {
            attrNames.add(((InboundProvisioningCustomScim2AttributeTasklet)tasklet).getAttributeName());
        }
        return attrNames;
    }

    private String getIdpConnId() {
        IdpConnectionConfigTasklet idpConnectionConfigTasklet = this.findParent(IdpConnectionConfigTasklet.class);
        return idpConnectionConfigTasklet.getConnId();
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        summaryList.add(new SummaryInfo(this.getMessage("extension_namespace"), this.namespace, this));
        for (Tasklet tasklet : this.getTasklets()) {
            summaryList.add(new SummaryInfo(this.getMessage("custom_attribute"), ((InboundProvisioningCustomScim2AttributeTasklet)tasklet).getAttributeName(), this));
        }
    }

    private List<Tasklet> getAllUndeletedTasklets() {
        ArrayList<Tasklet> undeletedTaskletsList = new ArrayList<Tasklet>();
        for (Tasklet tasklet : this.getTasklets()) {
            if (tasklet.isDraft()) continue;
            undeletedTaskletsList.add(tasklet);
        }
        return undeletedTaskletsList;
    }
}

