/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.admin.api.validator.InboundProvisioningScim2ServiceProviderConfigValidator;
import com.pingidentity.fsm.IWizard;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import java.util.ArrayList;
import org.apache.axis.utils.StringUtils;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.valid.IValidationDelegate;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.scim.ScimUserProvisioning;

public class InboundProvisioningCustomScim2ServiceProviderConfigState
extends TaskletState {
    private String documentationUri;

    public InboundProvisioningCustomScim2ServiceProviderConfigState(IWizard owner, String name) {
        super(owner, name);
        this.setMenuName("Service Provider Config Options");
    }

    @Override
    public void populate(Object dataFromDisk) {
        IdpConnection connection = (IdpConnection)dataFromDisk;
        ScimUserProvisioning scimUserProvisioning = connection.getInboundProvisioning();
        if (scimUserProvisioning.getDocumentationUri() != null) {
            this.documentationUri = scimUserProvisioning.getDocumentationUri();
        }
    }

    @Override
    public boolean save(Object dataToDisk) {
        IdpConnection connection = (IdpConnection)dataToDisk;
        ScimUserProvisioning scimUserProvisioning = connection.getInboundProvisioning();
        scimUserProvisioning.setDocumentationUri(this.documentationUri != null ? this.documentationUri.trim() : null);
        return true;
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        if (!StringUtils.isEmpty((String)this.documentationUri)) {
            summaryList.add(new SummaryInfo("SCIM Documentation URI", this.documentationUri, this));
        }
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        InboundProvisioningScim2ServiceProviderConfigValidator validator = new InboundProvisioningScim2ServiceProviderConfigValidator(this.documentationUri);
        if (!validator.validate()) {
            this.recordErrors(validator.getErrors(), delegate);
        }
    }

    public String getDocumentationUri() {
        return this.documentationUri;
    }

    public void setDocumentationUri(String documentationUri) {
        this.documentationUri = documentationUri;
    }
}

