/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.admin.api.validator.InboundProvisioningCustomScimAttributeValidator;
import com.pingidentity.component.common.StringListEditor;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.impl.InboundProvisioningCustomScimAttributeTasklet;
import com.pingidentity.fsm.tasklet.impl.InboundProvisioningTasklet;
import java.util.ArrayList;
import java.util.List;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.valid.IValidationDelegate;
import org.sourceid.saml20.domain.InboundProvisioningUserRepositoryType;
import org.sourceid.saml20.domain.scim.model.SchemaAttribute;
import org.sourceid.saml20.domain.scim.model.SchemaSubAttribute;

public class InboundProvisioningCustomScimAttributeState
extends TaskletState {
    private static final long serialVersionUID = 1L;
    String menuName = "Custom SCIM Attribute";
    private String attributeName;
    private boolean multiValued;
    private List<String> subAttributesNamesList = new ArrayList<String>();
    private List<String> types = new ArrayList<String>();
    private transient Object subAttributesNamesState;
    private transient Object attributeTypesState;

    public String getAttributeName() {
        return this.attributeName;
    }

    public void setAttributeName(String attributeName) {
        this.attributeName = attributeName;
    }

    public boolean isMultiValued() {
        return this.multiValued;
    }

    public void setMultiValued(boolean multiValued) {
        this.multiValued = multiValued;
    }

    public List<String> getTypes() {
        return this.types;
    }

    public void setTypes(List<String> types) {
        this.types = types;
    }

    public List<String> getSubAttributesNamesList() {
        return this.subAttributesNamesList;
    }

    public void setSubAttributesNamesList(List<String> names) {
        this.subAttributesNamesList = names;
    }

    public InboundProvisioningCustomScimAttributeState(Tasklet value, String name) {
        super(value, name);
        this.setMenuName(this.menuName);
    }

    @Override
    public void populate(Object dataFromDisk) {
        if (dataFromDisk != null) {
            SchemaAttribute schemaAttribute = (SchemaAttribute)dataFromDisk;
            this.attributeName = schemaAttribute.getName();
            this.multiValued = schemaAttribute.isMultiValued();
            this.types.clear();
            ArrayList<String> names = new ArrayList<String>();
            if (schemaAttribute.getSubAttributes() != null) {
                for (SchemaSubAttribute schemaSubAttribute : schemaAttribute.getSubAttributes()) {
                    if (!schemaSubAttribute.getName().equals("type") || schemaSubAttribute.getName().equals("type") && schemaSubAttribute.getCanonicalValues().size() == 0) {
                        names.add(schemaSubAttribute.getName());
                        continue;
                    }
                    this.setTypes(new ArrayList<String>(schemaSubAttribute.getCanonicalValues()));
                }
            }
            this.setSubAttributesNamesList(names);
        }
    }

    @Override
    public void reset() {
        this.setSubAttributesNamesState(null);
        this.setAttributeTypesState(null);
        this.subAttributesNamesList.clear();
        this.types.clear();
    }

    @Override
    public boolean save(Object dataToDisk) {
        if (dataToDisk != null) {
            SchemaAttribute schemaAttribute = (SchemaAttribute)dataToDisk;
            schemaAttribute.setName(this.attributeName);
            schemaAttribute.setMultiValued(Boolean.valueOf(this.multiValued));
            ArrayList<SchemaSubAttribute> subAttributes = new ArrayList<SchemaSubAttribute>();
            for (String name : this.getSubAttributesNamesList()) {
                SchemaSubAttribute schemaSubAttribute = new SchemaSubAttribute();
                schemaSubAttribute.setName(name);
                subAttributes.add(schemaSubAttribute);
            }
            if (this.isMultiValued() && this.types.size() > 0) {
                SchemaSubAttribute schemaSubAttribute = new SchemaSubAttribute();
                schemaSubAttribute.setName("type");
                schemaSubAttribute.getCanonicalValues().addAll(this.types);
                subAttributes.add(schemaSubAttribute);
            }
            if (schemaAttribute.getSubAttributes() == null) {
                schemaAttribute.setSubAttributes(new ArrayList());
            }
            schemaAttribute.getSubAttributes().addAll(subAttributes);
            if (schemaAttribute.getSubAttributes().size() > 0) {
                schemaAttribute.setType("complex");
            }
            this.subAttributesNamesState = null;
            this.attributeTypesState = null;
        }
        return true;
    }

    public Object getSubAttributesNamesState() {
        return this.subAttributesNamesState;
    }

    public void setSubAttributesNamesState(Object componentState) {
        this.subAttributesNamesState = componentState;
    }

    public Object getAttributeTypesState() {
        return this.attributeTypesState;
    }

    public void setAttributeTypesState(Object attributeTypesState) {
        this.attributeTypesState = attributeTypesState;
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        this.validate(delegate);
        super.appendErrors(delegate, component, fastFail);
    }

    private void validate(IValidationDelegate delegate) {
        InboundProvisioningCustomScimAttributeValidator validator = new InboundProvisioningCustomScimAttributeValidator.Builder().setAttributeName(this.attributeName).setMultiValued(this.multiValued).setSubAttributesNamesList(this.subAttributesNamesList).setTypes(this.types).setTheOtherAttributeNames(this.getTheOtherAttributeNames()).setLdapUserRepositoryType(this.isLdapUserRepositoryType()).build();
        if (!validator.validate()) {
            this.recordErrors(validator.getErrors(), delegate);
        }
    }

    private List<String> getTheOtherAttributeNames() {
        InboundProvisioningTasklet grandparent = this.findParent(InboundProvisioningTasklet.class);
        InboundProvisioningCustomScimAttributeTasklet parent = this.findParent(InboundProvisioningCustomScimAttributeTasklet.class);
        return grandparent.getCustomAttributeNamesNotIncludingTasklet(parent.getTaskletId());
    }

    private boolean isLdapUserRepositoryType() {
        InboundProvisioningTasklet grandparent = this.findParent(InboundProvisioningTasklet.class);
        return grandparent.getUserRepositoryType().equals((Object)InboundProvisioningUserRepositoryType.ACTIVE_DIRECTORY);
    }

    @Override
    public void cancel(Object newData) {
        super.cancel(newData);
        this.subAttributesNamesState = null;
        this.attributeTypesState = null;
    }

    @Override
    public boolean onStateExit() {
        this.updateTypes();
        return true;
    }

    public void updateTypes() {
        if (this.attributeTypesState != null) {
            StringListEditor.State componentState = (StringListEditor.State)this.attributeTypesState;
            if (!this.multiValued) {
                componentState.deleteAllStringListItems();
            }
        }
    }
}

