/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.fsm.tasklet.SingleTaskletState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.data.Mode;
import com.pingidentity.fsm.tasklet.impl.ConnectionTasklet;
import com.pingidentity.fsm.tasklet.impl.InboundProvisioningOperationTasklet;
import com.pingidentity.fsm.tasklet.impl.InboundProvisioningTasklet;
import java.util.List;
import java.util.Set;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.valid.IValidationDelegate;
import org.sourceid.common.Util;
import org.sourceid.saml20.domain.IdpConnection;

public class InboundProvisioningOperationState
extends SingleTaskletState {
    private static final long serialVersionUID = 20050515L;
    private IdpConnection idpConnection;
    private Object populateAllStatesData;
    private OperationType operationType;

    public InboundProvisioningOperationState(Tasklet value, OperationType type) {
        super(value);
        this.operationType = type;
        this.setMenuName(this.getOperationMenuName());
        if (this.operationType == OperationType.WRITE_USERS) {
            String key = this.getParent().getHelpName() + "_InboundProvisioningOperationWriteUsersState";
            super.setNoteKey(key);
            super.setHelpId(key);
        } else if (this.operationType == OperationType.READ_USERS) {
            String key = this.getParent().getHelpName() + "_InboundProvisioningOperationReadUsersState";
            super.setNoteKey(key);
            super.setHelpId(key);
        } else if (this.operationType == OperationType.WRITE_GROUPS) {
            String key = this.getParent().getHelpName() + "_InboundProvisioningOperationWriteGroupsState";
            super.setNoteKey(key);
            super.setHelpId(key);
        } else if (this.operationType == OperationType.READ_GROUPS) {
            String key = this.getParent().getHelpName() + "_InboundProvisioningOperationReadGroupsState";
            super.setNoteKey(key);
            super.setHelpId(key);
        }
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        Tasklet tasklet = this.getTaskletToEdit();
        if (tasklet == null) {
            this.populateTasklet();
        }
        super.appendErrors(delegate, component, fastFail);
    }

    @Override
    public void onStateActivated() {
        this.populateTasklet();
    }

    @Override
    public void populate(Object dataFromDisk) {
        this.idpConnection = (IdpConnection)dataFromDisk;
        this.populateTasklet();
    }

    @Override
    public boolean populateAllStates(Object data) {
        this.populateAllStatesData = data;
        this.populateTasklet();
        return true;
    }

    private void populateTasklet() {
        InboundProvisioningOperationTasklet tasklet = this.getTaskletToEdit(InboundProvisioningOperationTasklet.class);
        if (tasklet == null) {
            tasklet = this.createTasklet(InboundProvisioningOperationTasklet.class);
            tasklet.setMenuName(this.getOperationMenuName());
            tasklet.setOperationType(this.operationType);
            tasklet.setUserRepositoryType(this.findParent(InboundProvisioningTasklet.class).getUserRepositoryType());
            tasklet.setScimVersion(this.findParent(InboundProvisioningTasklet.class).getInboundProvisioningScimVersion());
            tasklet.configureTasklet();
            if (this.idpConnection != null) {
                tasklet.setMode(Mode.edit);
                tasklet.populate(this.idpConnection);
            }
            if (this.populateAllStatesData != null) {
                tasklet.populateAllStates(this.populateAllStatesData);
            }
            this.setTasklet(tasklet);
        } else {
            ConnectionTasklet connTasklet = this.findParent(ConnectionTasklet.class);
            if (!connTasklet.isDraft()) {
                tasklet.setUserRepositoryType(this.findParent(InboundProvisioningTasklet.class).getUserRepositoryType());
                tasklet.configureTasklet();
            }
        }
    }

    public Set<String> getWriteContractAttributeFulfillmentValues() {
        InboundProvisioningOperationTasklet tasklet = (InboundProvisioningOperationTasklet)this.getTasklet();
        return tasklet.getWriteContractAttributeFulfillmentValues();
    }

    public OperationType getOperationType() {
        return this.operationType;
    }

    public String getOperationMenuName() {
        String menuName;
        switch (this.operationType) {
            case WRITE_USERS: {
                menuName = "Write Users";
                break;
            }
            case READ_USERS: {
                menuName = "Read Users";
                break;
            }
            case WRITE_GROUPS: {
                menuName = "Write Groups";
                break;
            }
            case READ_GROUPS: {
                menuName = "Read Groups";
                break;
            }
            default: {
                menuName = "UNKNOWN OP";
            }
        }
        return menuName;
    }

    public String getButtonLabel() {
        return "Configure " + this.getOperationMenuName();
    }

    public boolean showContractAttributes() {
        OperationType type = this.getOperationType();
        return type == OperationType.READ_USERS || type == OperationType.READ_GROUPS;
    }

    public String getAttributeContract() {
        InboundProvisioningOperationTasklet tasklet = this.getTaskletToEdit(InboundProvisioningOperationTasklet.class);
        return Util.listToCommaDelimString((List)tasklet.getContract().getAllAttrNamesSorted());
    }

    public String getSelectedAttributes() {
        List<String> attributes = null;
        InboundProvisioningOperationTasklet tasklet = this.getTaskletToEdit(InboundProvisioningOperationTasklet.class);
        switch (tasklet.getUserRepositoryType()) {
            case ACTIVE_DIRECTORY: {
                attributes = tasklet.getSelectedAttributes();
                break;
            }
            case IDENTITY_STORE: {
                OperationType type = this.getOperationType();
                if (type == OperationType.READ_USERS || type == OperationType.WRITE_USERS) {
                    attributes = tasklet.getContractAttributes();
                    break;
                }
                if (type != OperationType.READ_GROUPS && type != OperationType.WRITE_GROUPS) break;
                attributes = tasklet.getGroupContractAttributes();
                break;
            }
        }
        return Util.listToCommaDelimString(attributes);
    }

    public static enum OperationType {
        WRITE_USERS,
        READ_USERS,
        WRITE_GROUPS,
        READ_GROUPS;

    }
}

