/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.fsm.state.impl.UserRepositoryState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.fsm.tasklet.impl.IdpConnectionConfigTasklet;
import com.pingidentity.sdk.provision.IdentityStoreProvisioner;
import com.pingidentity.util.StringPairPropertySelectionModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.apache.tapestry.valid.ValidationDelegate;
import org.sourceid.saml20.domain.AttributeContract;
import org.sourceid.saml20.domain.AttributeSource;
import org.sourceid.saml20.domain.DataSource;
import org.sourceid.saml20.domain.IdentityStoreProvisionerInstance;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.InboundProvisioningUserRepositoryType;
import org.sourceid.saml20.domain.LdapDataSource;
import org.sourceid.saml20.domain.mgmt.AttributeSourceFactory;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.scim.ScimUserProvisioning;

public class InboundProvisioningUserRepositoryState
extends UserRepositoryState {
    private static final long serialVersionUID = 8803676648320779517L;
    private InboundProvisioningUserRepositoryType userRepositoryType = InboundProvisioningUserRepositoryType.NONE;
    private transient StringPairPropertySelectionModel identityStoreProvisionerList;
    private transient IdentityStoreProvisionerInstance selectedIdentityStoreProvisioner;
    private String selectedIdentityStoreProvisionerId;

    public InboundProvisioningUserRepositoryState(Tasklet value, String name) {
        super(value, name);
        this.createIdentityStoreProvisionerModel();
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        switch (this.getUserRepositoryType()) {
            case IDENTITY_STORE: {
                if (this.selectedIdentityStoreProvisioner != null) break;
                delegate.setFormComponent(null);
                delegate.record(this.getMessage("Identity_store_provisioner_required"), ValidationConstraint.REQUIRED);
                break;
            }
            case ACTIVE_DIRECTORY: {
                if (this.selectedDataSource != null) break;
                delegate.record(this.getMessage("Data_store_required"), ValidationConstraint.REQUIRED);
                break;
            }
            default: {
                delegate.setFormComponent(null);
                delegate.record(this.getMessage("Identity_store_provisioner_required"), ValidationConstraint.REQUIRED);
            }
        }
        if (this.isGroupProvisioningEnabled() && !this.isGroupProvisioningSupportedInRepo()) {
            delegate.record(this.getMessage("Identity_store_provisioner_with_group_support_required"), ValidationConstraint.REQUIRED);
        }
    }

    @Override
    public boolean onStateExit() {
        if (!super.onStateExit()) {
            return false;
        }
        LdapDataSource ldapDataSource = (LdapDataSource)this.selectedDataSource;
        if (this.selectedDataSource != null && !ldapDataSource.getUseSSL() && !ldapDataSource.getUseStartTLS()) {
            this.recordErrorMsg(this.getMessage("Data_store_ssl_or_startTLS_required"));
            return false;
        }
        return true;
    }

    @Override
    public void onStateActivated() {
        this.refreshState();
    }

    @Override
    public void populate(Object dataFromDisk) {
        IdpConnection connection = (IdpConnection)dataFromDisk;
        ScimUserProvisioning scimUserProvisioning = connection.getInboundProvisioning();
        this.setUserRepositoryType(scimUserProvisioning.getUserRepositoryType());
        if (this.getUserRepositoryType() == InboundProvisioningUserRepositoryType.IDENTITY_STORE) {
            this.setSelectedIdentityStoreProvisionerId(scimUserProvisioning.getIdentityStoreProvisionerId());
            this.createIdentityStoreProvisionerModel();
        }
        super.populate(dataFromDisk);
    }

    @Override
    protected void populate() {
        this.createIdentityStoreProvisionerModel();
        super.populate();
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        if (this.getUserRepositoryType() == InboundProvisioningUserRepositoryType.IDENTITY_STORE) {
            summaryList.add(new SummaryInfo("Repository", this.getSelectedIdentityStoreProvisioner().getName(), this));
        } else {
            super.doSummary(summaryList);
        }
    }

    @Override
    public boolean save(Object dataToDisk) {
        IdpConnection connection = (IdpConnection)dataToDisk;
        ScimUserProvisioning scimUserProvisioning = connection.getInboundProvisioning();
        scimUserProvisioning.setUserRepositoryType(this.getUserRepositoryType());
        scimUserProvisioning.setIdentityStoreProvisionerId(this.selectedIdentityStoreProvisionerId);
        AttributeSource source = AttributeSourceFactory.getAttributeSource((DataSource)this.selectedDataSource, (String)this.getAttrSourceDesc());
        scimUserProvisioning.getWriteUsersAttributeMapping().addAttributeSource(source);
        scimUserProvisioning.getReadUsersAttributeMapping().addAttributeSource(source);
        scimUserProvisioning.getWriteGroupsAttributeMapping().addAttributeSource(source);
        scimUserProvisioning.getReadGroupsAttributeMapping().addAttributeSource(source);
        return true;
    }

    @Override
    public void refreshState() {
        this.setTaskletToEditToNull();
        this.selectedIdentityStoreProvisioner = InboundProvisioningUserRepositoryState.getIdentityStoreProvisionerById(this.selectedIdentityStoreProvisionerId);
        this.createIdentityStoreProvisionerModel();
        super.refreshState();
    }

    @Override
    public void onResumeDraft() {
        this.selectedIdentityStoreProvisioner = InboundProvisioningUserRepositoryState.getIdentityStoreProvisionerById(this.selectedIdentityStoreProvisionerId);
        this.createIdentityStoreProvisionerModel();
        super.onResumeDraft();
    }

    @Override
    public void reset() {
        this.userRepositoryType = InboundProvisioningUserRepositoryType.NONE;
        this.setSelectedIdentityStoreProvisioner(null);
        this.createIdentityStoreProvisionerModel();
        super.reset();
    }

    @Override
    public void formListener(IRequestCycle cycle) {
        switch (this.userRepositoryType) {
            case ACTIVE_DIRECTORY: {
                this.setSelectedIdentityStoreProvisioner(null);
                break;
            }
            case IDENTITY_STORE: {
                this.setSelectedDataSource(null);
                break;
            }
            case NONE: {
                this.setSelectedIdentityStoreProvisioner(null);
                this.setSelectedDataSource(null);
                break;
            }
        }
        this.getParent().reconfigureTransitions(this);
        super.formListener(cycle);
    }

    public InboundProvisioningUserRepositoryType getUserRepositoryType() {
        return this.userRepositoryType;
    }

    public void setUserRepositoryType(InboundProvisioningUserRepositoryType userRepositoryType) {
        this.userRepositoryType = userRepositoryType;
    }

    public StringPairPropertySelectionModel getIdentityStoreProvisionerList() {
        return this.identityStoreProvisionerList;
    }

    public void setIdentityStoreList(StringPairPropertySelectionModel identityStoreProvisionerList) {
        this.identityStoreProvisionerList = identityStoreProvisionerList;
    }

    public void setSelectedIdentityStoreProvisionerId(String selectedIdentityStoreProvisionerId) {
        this.selectedIdentityStoreProvisionerId = selectedIdentityStoreProvisionerId;
    }

    public List<String> getContractAttributes() {
        AttributeContract attributeContract;
        ArrayList<String> attributes = new ArrayList<String>();
        if (this.getSelectedIdentityStoreProvisioner() != null && (attributeContract = this.getSelectedIdentityStoreProvisioner().getAttributeContract()) != null) {
            attributes.addAll(attributeContract.getAllAttrNamesSorted());
        }
        return attributes;
    }

    public List<String> getGroupContractAttributes() {
        AttributeContract attributeContract;
        ArrayList<String> attributes = new ArrayList<String>();
        if (this.getSelectedIdentityStoreProvisioner() != null && (attributeContract = this.getSelectedIdentityStoreProvisioner().getGroupAttributeContract()) != null) {
            attributes.addAll(attributeContract.getAllAttrNamesSorted());
        }
        return attributes;
    }

    public void setSelectedIdentityStoreProvisioner(IdentityStoreProvisionerInstance selectedIdentityStoreProvisioner) {
        this.selectedIdentityStoreProvisioner = selectedIdentityStoreProvisioner;
        this.selectedIdentityStoreProvisionerId = selectedIdentityStoreProvisioner != null ? selectedIdentityStoreProvisioner.getId() : null;
    }

    public boolean isActiveDirectory() {
        return this.userRepositoryType == InboundProvisioningUserRepositoryType.ACTIVE_DIRECTORY;
    }

    public boolean isIdentityStore() {
        return this.userRepositoryType == InboundProvisioningUserRepositoryType.IDENTITY_STORE;
    }

    private static IdentityStoreProvisionerInstance getIdentityStoreProvisionerById(String id) {
        return (IdentityStoreProvisionerInstance)MgmtFactory.getIdentityStoreProvisionerManager().getInstance(id);
    }

    private void createIdentityStoreProvisionerModel() {
        if (this.getSelectedIdentityStoreProvisioner() == null && this.selectedIdentityStoreProvisionerId != null) {
            this.setSelectedIdentityStoreProvisioner(InboundProvisioningUserRepositoryState.getIdentityStoreProvisionerById(this.selectedIdentityStoreProvisionerId));
        }
        this.identityStoreProvisionerList = new StringPairPropertySelectionModel(true);
        Collection identityStoreProvisioners = MgmtFactory.getIdentityStoreProvisionerManager().getInstances();
        for (IdentityStoreProvisionerInstance identityStoreProvisioner : identityStoreProvisioners) {
            this.identityStoreProvisionerList.add(identityStoreProvisioner.getName(), identityStoreProvisioner);
        }
    }

    public IdentityStoreProvisionerInstance getSelectedIdentityStoreProvisioner() {
        return this.selectedIdentityStoreProvisioner;
    }

    private boolean isGroupProvisioningEnabled() {
        IdpConnectionConfigTasklet tasklet = this.findParent(IdpConnectionConfigTasklet.class);
        return tasklet != null && tasklet.isInboundProvisioningGroupsEnabled();
    }

    private boolean isGroupProvisioningSupportedInRepo() {
        if (this.isActiveDirectory()) {
            return true;
        }
        IdentityStoreProvisionerInstance provisioner = this.getSelectedIdentityStoreProvisioner();
        if (provisioner != null) {
            String className = provisioner.getDescriptor().getPluginClassName();
            try {
                Class<?> c = Class.forName(className);
                Object object = c.newInstance();
                if (object instanceof IdentityStoreProvisioner) {
                    return ((IdentityStoreProvisioner)object).isGroupProvisioningSupported();
                }
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException reflectiveOperationException) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    public ValidationDelegate getDelegate() {
        if (this.delegate == null) {
            this.setDelegate(this.getParent().getDelegate(this.getParent().getCycle()));
        }
        return this.delegate;
    }
}

