/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.admin.api.validator.KerberosRealmsSettingsValidator;
import com.pingidentity.common.util.KerberosConfigUtil;
import com.pingidentity.common.util.TimeUtil;
import com.pingidentity.fsm.IWizard;
import com.pingidentity.fsm.tasklet.TaskletState;
import java.io.Serializable;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.valid.IValidationDelegate;
import org.sourceid.saml20.domain.KerberosRealmsSettings;
import org.sourceid.saml20.domain.mgmt.KerberosRealmManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class KerberosRealmsSettingsState
extends TaskletState
implements Serializable {
    private Log log = LogFactory.getLog(this.getClass());
    private static final long serialVersionUID = 5L;
    private String forceTcp;
    private String kdcTimeout = this.convertMillisecToSec("3000");
    private String kdcRetries = "3";
    private String debugLogOutput;
    private String keySetRetentionPeriodMins = Integer.toString(610);

    public KerberosRealmsSettingsState(IWizard owner) {
        super(owner);
        this.setMenuName("Manage Domain/Realm Settings");
    }

    public KerberosRealmsSettingsState(IWizard owner, String cardName) {
        super(owner, cardName);
        this.setMenuName("Manage Domain/Realm Settings");
    }

    @Override
    public void populate(Object dataFromDisk) {
        if (dataFromDisk == null) {
            KerberosRealmManager kerberosRealmManager = MgmtFactory.getKerberosRealmManager();
            this.forceTcp = kerberosRealmManager.getforceTcp();
            this.kdcTimeout = this.convertMillisecToSec(kerberosRealmManager.getKdcTimout());
            this.kdcRetries = kerberosRealmManager.getKdcRetries() != null ? kerberosRealmManager.getKdcRetries() : "3";
            this.keySetRetentionPeriodMins = Integer.toString(kerberosRealmManager.getKeySetRetentionPeriodMins());
            this.debugLogOutput = kerberosRealmManager.getDebugLogOutput();
        }
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        KerberosRealmsSettingsValidator validator = new KerberosRealmsSettingsValidator.Builder().setKdcRetries(this.kdcRetries).setKdcTimeout(this.kdcTimeout).setKeySetRetentionPeriodMins(this.keySetRetentionPeriodMins).build();
        if (!validator.validate()) {
            this.recordErrors(validator.getErrors(), delegate);
        }
    }

    @Override
    public boolean save(Object dataToDisk) {
        KerberosRealmsSettings kerberosRealmsSettings = new KerberosRealmsSettings();
        kerberosRealmsSettings.setDebugLogOutput(this.debugLogOutput);
        kerberosRealmsSettings.setForceTcp(this.forceTcp);
        kerberosRealmsSettings.setKdcTimeout(this.convertSecToMillisec(this.kdcTimeout));
        kerberosRealmsSettings.setKdcRetries(this.kdcRetries);
        kerberosRealmsSettings.setKeySetRetentionPeriodMins(Integer.parseInt(this.keySetRetentionPeriodMins));
        KerberosRealmManager kerberosRealmManager = MgmtFactory.getKerberosRealmManager();
        kerberosRealmManager.setKerberosRealmsSettingsAndSave(kerberosRealmsSettings);
        return true;
    }

    public String convertSecToMillisec(String sec) {
        try {
            return TimeUtil.convertSecToMillisec((String)sec);
        }
        catch (NumberFormatException e) {
            this.log.error((Object)("Exception thrown converting seconds to millisec: " + e));
            this.log.error((Object)"Returning the default of 3000 millisec.");
            return "3000";
        }
    }

    public String convertMillisecToSec(String millisec) {
        try {
            if (StringUtils.isNotBlank((String)millisec)) {
                return TimeUtil.convertMillisecToSec((String)millisec);
            }
        }
        catch (NumberFormatException e) {
            this.log.error((Object)("Exception thrown converting millisec to seconds: " + e));
            this.log.error((Object)"Returning the default of 3 sec.");
        }
        return TimeUtil.convertMillisecToSec((String)"3000");
    }

    public boolean getForceTcp() {
        return Boolean.parseBoolean(this.forceTcp);
    }

    public void setForceTcp(boolean forceTcp) {
        this.forceTcp = String.valueOf(forceTcp);
    }

    public String getKdcTimeout() {
        return this.kdcTimeout;
    }

    public void setKdcTimeout(String kdcTimeoutInSeconds) {
        this.kdcTimeout = kdcTimeoutInSeconds.trim();
    }

    public String getKdcRetries() {
        if (StringUtils.isEmpty((String)this.kdcRetries)) {
            this.kdcRetries = "3";
        }
        return this.kdcRetries;
    }

    public void setKdcRetries(String kdcRetries) {
        this.kdcRetries = kdcRetries;
    }

    public boolean getDebugLogOutput() {
        return Boolean.parseBoolean(this.debugLogOutput);
    }

    public void setDebugLogOutput(boolean debugLogOutput) {
        this.debugLogOutput = String.valueOf(debugLogOutput);
    }

    public KerberosRealmsSettings getKerberosRealmsSettings() {
        KerberosRealmsSettings kerberosRealmsSettings = new KerberosRealmsSettings();
        kerberosRealmsSettings.setDebugLogOutput(this.debugLogOutput);
        kerberosRealmsSettings.setForceTcp(this.forceTcp);
        kerberosRealmsSettings.setKdcTimeout(this.convertSecToMillisec(this.kdcTimeout));
        kerberosRealmsSettings.setKdcRetries(this.kdcRetries);
        return kerberosRealmsSettings;
    }

    public boolean isAutoGenerateKrb5Conf() {
        return KerberosConfigUtil.isAutoGenerateKrb5ConfFile();
    }

    public String getKeySetRetentionPeriodMins() {
        return this.keySetRetentionPeriodMins;
    }

    public void setKeySetRetentionPeriodMins(String keySetRetentionPeriodMins) {
        this.keySetRetentionPeriodMins = keySetRetentionPeriodMins;
    }
}

