/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.admin.api.validator.LdapTagConfigValidator;
import com.pingidentity.common.util.ldap.LDAPUtil;
import com.pingidentity.common.util.ldap.PingLdapSSLSocketFactory;
import com.pingidentity.common.util.ssl.PingCustomSSLSocketFactoryUtil;
import com.pingidentity.component.common.FieldItem;
import com.pingidentity.component.common.SimpleFieldDescriptor;
import com.pingidentity.component.common.TableEditor;
import com.pingidentity.component.common.TableRow;
import com.pingidentity.crypto.PkCert;
import com.pingidentity.fsm.impl.Wizard;
import com.pingidentity.fsm.state.impl.AdvancedLdapOptionsState;
import com.pingidentity.fsm.state.impl.ManageDataSourcesState;
import com.pingidentity.fsm.state.impl.TagableDataStoreState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.data.Mode;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.fsm.tasklet.impl.AdvancedLdapOptionsTasklet;
import com.pingidentity.fsm.tasklet.impl.DataSourceTasklet;
import com.pingidentity.module.connection.ConnectionModuleSupport;
import com.pingidentity.pf.common.api.validator.error.ValidationError;
import com.pingidentity.sdk.secretmanager.SecretReferenceUtil;
import com.pingidentity.templates.mgmt.SaaSLdapTemplateFileManager;
import com.pingidentity.util.StringPairPropertySelectionModel;
import com.pingidentity.validator.LdapConfigValidator;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.net.ssl.SSLSocketFactory;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.sourceid.saml20.domain.DataSource;
import org.sourceid.saml20.domain.LdapDataSource;
import org.sourceid.saml20.domain.SecretType;
import org.sourceid.saml20.domain.datasource.info.LdapInfo;
import org.sourceid.saml20.domain.datasource.info.LdapTypeNotFoundException;
import org.sourceid.saml20.domain.datasource.tag.LdapInstanceIdentifier;
import org.sourceid.saml20.domain.datasource.tag.LdapTagConfig;
import org.sourceid.saml20.domain.mgmt.DataSourceManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.PkCertManager;
import org.sourceid.websso.profiles.ProcessRuntimeException;

public class LdapConfigState
extends TaskletState
implements TagableDataStoreState<LdapInstanceIdentifier>,
TableEditor.TableEditorListener {
    private static final long serialVersionUID = 20050515L;
    private String defaultHostName;
    private String userName;
    private String password;
    private String authMethod = "simple";
    private SecretType secretType = SecretType.INTERNALLY_MANAGED;
    private SecretType previousSecretTypeSelected;
    private String secretManagerPassword;
    private String id;
    private boolean bindAnon;
    private String connectionSecurity = "none";
    private boolean useDnsSrvRecord;
    private boolean useLdapReferral;
    private LdapDataSource ldapDS;
    private Tasklet advancedLdapOptionsTasklet;
    private boolean maskAttributeValues;
    private Map<String, String> ldapNameToTypeMap;
    private StringPairPropertySelectionModel ldapTypeList;
    private String selectedLdapType;
    private String selectedLdapTypeDesc;
    private String sourceName;
    private String connectionTestSuccessfulMessage = null;
    private List<TableRow> ldapTagTable = new ArrayList<TableRow>();
    private transient Object componentState;
    private StringPairPropertySelectionModel testConnectionList;
    private String testConnectionId;
    private PkCert clientTlsCert;
    private transient PkCertManager certManager;
    private static final String TAG_COL_NAME = "Tags";
    private static final String HOSTNAME_COL_NAME = "Hostname(s)";
    private final SimpleFieldDescriptor TAG_DESC = new SimpleFieldDescriptor.Builder().setType(SimpleFieldDescriptor.FieldType.TEXT).setName("Tags").setWidth(200).setDescriptorId("tags").create();
    private final SimpleFieldDescriptor HOSTNAME_DESC = new SimpleFieldDescriptor.Builder().setType(SimpleFieldDescriptor.FieldType.TEXT).setName("Hostname(s)").setWidth(200).setDescriptorId("hostname").setRequiredField(true).create();
    private final transient LdapConfigValidator validator = new LdapConfigValidator();

    public LdapConfigState(Tasklet value) {
        super(value);
        this.setMenuName("LDAP Configuration");
        this.createTestConnectionList();
        this.certManager = MgmtFactory.getSslAuthPkCertManager();
    }

    @Override
    public void populate(Object dataFromDisk) {
        this.ldapDS = (LdapDataSource)dataFromDisk;
        this.defaultHostName = this.ldapDS.getHost();
        this.authMethod = this.ldapDS.getAuthenticationMethod();
        this.bindAnon = this.ldapDS.getAnonymousBinding();
        this.userName = this.ldapDS.getPrincipal();
        if (SecretReferenceUtil.isSecretReference((String)this.ldapDS.getCredentials())) {
            this.secretType = SecretType.SECRET_MANAGER;
            this.secretManagerPassword = this.ldapDS.getCredentials();
        } else {
            this.secretType = SecretType.INTERNALLY_MANAGED;
            this.password = this.ldapDS.getCredentials();
        }
        this.connectionSecurity = this.ldapDS.getUseSSL() ? "ssl" : (this.ldapDS.getUseStartTLS() ? "startTls" : "none");
        this.useDnsSrvRecord = this.ldapDS.isUseDnsSrvRecords();
        this.useLdapReferral = this.ldapDS.isUseAdReferral();
        this.id = this.ldapDS.getId();
        this.maskAttributeValues = this.ldapDS.isMaskAttributeValues();
        this.sourceName = this.ldapDS.getDsName();
        this.selectedLdapType = this.ldapDS.getLdapType().name();
        if (StringUtils.isNotBlank((String)this.ldapDS.getClientTlsCertificate())) {
            this.clientTlsCert = this.certManager.getPkCert(this.ldapDS.getClientTlsCertificate());
        }
        this.populateTagInfo(this.ldapDS.getLdapTagConfigList());
        this.selectedLdapTypeDesc = LdapInfo.LdapType.SunDirectoryServer.getDescription().equals(this.ldapDS.getLdapTypeDesc()) ? "Oracle Directory Server" : this.ldapDS.getLdapTypeDesc();
        SaaSLdapTemplateFileManager templateMgr = SaaSLdapTemplateFileManager.getInstance();
        this.ldapNameToTypeMap = templateMgr.getSaaSLdapTemplateNameToTypeMap();
        this.createAndPopulateAdvancedLdapOptionsTasklet();
    }

    public void populateTagInfo(List<LdapTagConfig> tagConfigList) {
        boolean tagConfigTableHasDefault;
        if (tagConfigList == null) {
            return;
        }
        this.ldapTagTable = new ArrayList<TableRow>();
        if (StringUtils.isNotEmpty((String)this.defaultHostName) && !(tagConfigTableHasDefault = tagConfigList.parallelStream().anyMatch(dataSourceTagConfig -> dataSourceTagConfig.getIdentifier().getHostname().equals(this.defaultHostName)))) {
            this.ldapTagTable.add(this.makeRowFromEntry(this.defaultHostName, "", true));
        }
        for (LdapTagConfig tagConfig : tagConfigList) {
            this.ldapTagTable.add(this.makeRowFromEntry(tagConfig.getIdentifier().getHostname(), tagConfig.getTags(), tagConfig.isDefaultSource()));
        }
    }

    private TableRow makeRowFromEntry(String hostnames, String tags, boolean isDefault) {
        TableRow newRow = this.makeRowFromEntry(hostnames, tags);
        newRow.setDefault(isDefault);
        return newRow;
    }

    private TableRow makeRowFromEntry(String hostnames, String tags) {
        ArrayList<FieldItem> fields = new ArrayList<FieldItem>();
        fields.add(new FieldItem(this.HOSTNAME_DESC, hostnames));
        fields.add(new FieldItem(this.TAG_DESC, tags));
        TableRow newRow = new TableRow(fields);
        return newRow;
    }

    @Override
    public void onStateActivated() {
        if (!this.isShowSourceName() && this.getParent() != null && this.getParent() instanceof DataSourceTasklet) {
            this.sourceName = ((DataSourceTasklet)this.getParent()).getSourceName();
        }
        if (!this.isShowMaskLogValues() && this.getParent() != null && this.getParent() instanceof DataSourceTasklet) {
            this.maskAttributeValues = ((DataSourceTasklet)this.getParent()).isMaskAttributeValues();
        }
        this.initializeLdapTypes();
        this.createAndPopulateAdvancedLdapOptionsTasklet();
        this.createTestConnectionList();
    }

    @Override
    public void refreshState() {
        this.createTestConnectionList();
    }

    private void initializeLdapTypes() {
        StringPairPropertySelectionModel model = new StringPairPropertySelectionModel(false);
        this.ldapNameToTypeMap = SaaSLdapTemplateFileManager.getInstance().getSaaSLdapTemplateNameToTypeMap();
        for (Map.Entry<String, String> e : this.ldapNameToTypeMap.entrySet()) {
            model.add(e.getKey(), e.getKey());
        }
        model.sort();
        this.ldapTypeList = model;
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        LdapDataSource dataSource = this.getDataSource();
        List<ValidationError> errors = this.validator.validate(dataSource, false, false, SecretType.SECRET_MANAGER.equals((Object)this.secretType));
        List<LdapTagConfig> ldapTagTableConfigList = this.convertTagTableRow(this.ldapTagTable);
        LdapTagConfigValidator ldapTagConfigValidator = new LdapTagConfigValidator(ldapTagTableConfigList, this.useDnsSrvRecord, this.isUseSsl());
        if (!ldapTagConfigValidator.validate()) {
            errors.addAll(ldapTagConfigValidator.getErrors());
        }
        if (!errors.isEmpty()) {
            this.recordErrors(errors, delegate);
        } else {
            if (this.isShowSourceName() && StringUtils.isBlank((String)this.sourceName)) {
                delegate.setFormComponent(null);
                delegate.record(this.getMessage("Name_required"), ValidationConstraint.REQUIRED);
            }
            DataSourceTasklet dataSourceTasklet = this.getParent(DataSourceTasklet.class);
            if (this.isShowSourceName() && dataSourceTasklet.isDuplicate(this.sourceName, this.findParentState(ManageDataSourcesState.class), true)) {
                delegate.setFormComponent(null);
                delegate.record(this.getMessage("Instance_name_in_use"), ValidationConstraint.REQUIRED);
            }
        }
    }

    @Override
    public boolean onStateExit() {
        return true;
    }

    public boolean isInconsistentLdapType(Tasklet taskletToBeCompared) {
        DataSourceTasklet d;
        DataSourceTasklet dataSourceTasklet = d = taskletToBeCompared instanceof DataSourceTasklet ? (DataSourceTasklet)taskletToBeCompared : null;
        if (d != null && this.defaultHostName.equals(d.getDesc())) {
            return this.selectedLdapTypeDesc != null && !this.selectedLdapTypeDesc.equals(d.getLdapTypeDesc());
        }
        return false;
    }

    private void fillLdapDataSource(LdapDataSource ldap) {
        ldap.setId(this.id);
        ldap.setAnonymousBinding(StringUtils.equals((String)this.authMethod, (String)"none"));
        ldap.setAuthenticationMethod(this.authMethod);
        ldap.setPrincipal(this.userName);
        if (SecretType.SECRET_MANAGER.equals((Object)this.secretType)) {
            ldap.setCredentials(this.secretManagerPassword);
        } else {
            ldap.setCredentials(this.password);
        }
        if (this.clientTlsCert != null) {
            ldap.setClientTlsCertificate(this.clientTlsCert.getId());
        }
        if (this.isUseSsl()) {
            ldap.setUseSSL(true);
            ldap.setUseStartTLS(false);
        } else if (this.isUseStartTls()) {
            ldap.setUseStartTLS(true);
            ldap.setUseSSL(false);
        } else {
            ldap.setUseStartTLS(false);
            ldap.setUseSSL(false);
        }
        ldap.setMaskAttributeValues(this.maskAttributeValues);
        ldap.setDescription(this.sourceName);
        ldap.setDsName(this.sourceName);
        ldap.setLdapTypeDesc(this.selectedLdapTypeDesc);
        ldap.setLdapType(this.processLdapType(this.ldapNameToTypeMap.get(this.selectedLdapTypeDesc)));
        ldap.setUseDnsSrvRecords(this.useDnsSrvRecord);
        ldap.setUseAdReferral(this.isUseLdapReferral());
        ldap.setLdapTagConfigList(this.getDataStoreTaggingInfo());
        this.fillDefaultDataSource(ldap);
    }

    private void fillDefaultDataSource(LdapDataSource ldap) {
        ldap.setHost(null);
        this.defaultHostName = null;
        for (TableRow row : this.ldapTagTable) {
            if (!row.isDefault() || row.isMarkedForDelete()) continue;
            String tableDefaultHostname = this.getFieldValue(row, this.HOSTNAME_DESC);
            ldap.setHost(tableDefaultHostname);
            this.defaultHostName = tableDefaultHostname;
        }
    }

    public List<LdapTagConfig> getDataStoreTaggingInfo() {
        LinkedList<LdapTagConfig> tagConfigList = new LinkedList<LdapTagConfig>();
        for (TableRow row : this.ldapTagTable) {
            if (row.isMarkedForDelete()) continue;
            String hostnames = this.getFieldValue(row, this.HOSTNAME_DESC);
            String tags = this.getFieldValue(row, this.TAG_DESC);
            if (!StringUtils.isNotEmpty((String)hostnames)) continue;
            LdapInstanceIdentifier identifier = new LdapInstanceIdentifier(hostnames);
            tagConfigList.add(new LdapTagConfig(identifier, tags, row.isDefault()));
        }
        return tagConfigList;
    }

    private LdapInfo.LdapType processLdapType(String type) {
        try {
            return LdapInfo.LdapType.canonicalName((String)type);
        }
        catch (LdapTypeNotFoundException e) {
            return LdapInfo.LdapType.Undefined;
        }
    }

    @Override
    public boolean save(Object dataToDisk) {
        LdapDataSource tempLdap = (LdapDataSource)dataToDisk;
        this.fillLdapDataSource(tempLdap);
        if (this.advancedLdapOptionsTasklet != null) {
            this.advancedLdapOptionsTasklet.save(tempLdap);
        }
        this.ldapDS = tempLdap;
        return true;
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        summaryList.add(new SummaryInfo(this.getMessage("InstanceName"), this.sourceName, this));
        this.doTaggingSummary(summaryList);
        summaryList.add(new SummaryInfo(this.getMessage("Ldap_type"), this.selectedLdapTypeDesc, this));
        if (this.useDnsSrvRecord) {
            summaryList.add(new SummaryInfo(this.getMessage("Use_DNS_SRV_Records"), Boolean.toString(this.useDnsSrvRecord), this));
        }
        if (this.isUseLdapReferral()) {
            summaryList.add(new SummaryInfo(this.getMessage("Use_ldap_referral"), Boolean.toString(this.isUseLdapReferral()), this));
        }
        if (this.isUseSsl()) {
            summaryList.add(new SummaryInfo(this.getMessage("Connection_Security"), "LDAPS", this));
        } else if (this.isUseStartTls()) {
            summaryList.add(new SummaryInfo(this.getMessage("Connection_Security"), "StartTLS", this));
        } else {
            summaryList.add(new SummaryInfo(this.getMessage("Connection_Security"), "None", this));
        }
        switch (this.authMethod) {
            case "none": {
                summaryList.add(new SummaryInfo(this.getMessage("Authentication_method"), "None (Anonymous)", this));
                break;
            }
            case "simple": {
                summaryList.add(new SummaryInfo(this.getMessage("Authentication_method"), "Simple", this));
                summaryList.add(new SummaryInfo(this.getMessage("Username"), this.userName, this));
                if (!SecretType.SECRET_MANAGER.equals((Object)this.secretType)) break;
                summaryList.add(new SummaryInfo(this.getMessage("Password_reference"), this.secretManagerPassword, this));
                break;
            }
            case "clientTlsCert": {
                summaryList.add(new SummaryInfo(this.getMessage("Authentication_method"), "Client TLS Certificate", this));
                summaryList.add(new SummaryInfo(this.getMessage("Client_Tls_Certificate"), this.clientTlsCert.getDescriptionForDisplay(), this));
                break;
            }
            default: {
                summaryList.add(new SummaryInfo(this.getMessage("Authentication_method"), "None (Anonymous)", this));
            }
        }
        summaryList.add(new SummaryInfo(this.getMessage("Mask_attribute_values"), Boolean.toString(this.maskAttributeValues), this));
        Optional.of(this.advancedLdapOptionsTasklet).map(Wizard::getSourceState).filter(state -> state instanceof AdvancedLdapOptionsState).ifPresent(state -> ((AdvancedLdapOptionsState)state).doSummary(summaryList));
    }

    @Override
    public void doTaggingSummary(ArrayList<SummaryInfo> summaryList) {
        if (this.ldapTagTable == null || this.ldapTagTable.isEmpty()) {
            summaryList.add(new SummaryInfo(HOSTNAME_COL_NAME, "", this));
        } else {
            for (TableRow tagInfoRow : this.ldapTagTable) {
                if (tagInfoRow.isMarkedForDelete()) continue;
                StringBuilder rowValue = new StringBuilder();
                String rowHostname = this.getFieldValue(tagInfoRow, this.HOSTNAME_DESC);
                String tags = this.getFieldValue(tagInfoRow, this.TAG_DESC);
                rowValue.append("Hostname(s): " + rowHostname);
                if (StringUtils.isNotEmpty((String)tags)) {
                    rowValue.append(System.lineSeparator() + "Tags: " + tags);
                }
                if (StringUtils.equals((String)rowHostname, (String)this.defaultHostName)) {
                    rowValue.append(System.lineSeparator() + "Default");
                }
                summaryList.add(new SummaryInfo(HOSTNAME_COL_NAME, rowValue.toString(), this));
            }
        }
    }

    public boolean showDataTypeList() {
        return LdapInfo.LdapType.Undefined.toString().equals(this.selectedLdapTypeDesc) || !this.isInUse();
    }

    @Override
    public void loadTaskletToEdit() {
        if (this.advancedLdapOptionsTasklet == null) {
            this.createAndPopulateAdvancedLdapOptionsTasklet();
        }
        this.advancedLdapOptionsTasklet.setCurrentState(this.advancedLdapOptionsTasklet.getInitialState());
        this.loadTasklet(this.advancedLdapOptionsTasklet);
    }

    private void createAndPopulateAdvancedLdapOptionsTasklet() {
        if (this.advancedLdapOptionsTasklet == null) {
            String taskletName = "AdvancedLdapOptionsTasklet";
            String menuName = "Advanced LDAP Options";
            AdvancedLdapOptionsTasklet tasklet = this.createTaskletToLoad(AdvancedLdapOptionsTasklet.class, taskletName, menuName);
            tasklet.setMode(Mode.edit);
            tasklet.populate(null);
            this.advancedLdapOptionsTasklet = tasklet;
        }
        this.advancedLdapOptionsTasklet.populate(this.ldapDS);
    }

    private boolean isInUse() {
        DataSourceManager dsMgr = MgmtFactory.getDataSourceManager();
        ConnectionModuleSupport moduleSupport = ConnectionModuleSupport.getInstance();
        return dsMgr.isInUse((DataSource)this.getLdapDS()) || moduleSupport.isDataSourceInUse((DataSource)this.getLdapDS());
    }

    @Override
    public void formListener(IRequestCycle cycle) {
        switch (this.authMethod) {
            case "none": {
                this.secretType = null;
                this.clearUserNamePasswordFields();
                this.clientTlsCert = null;
                break;
            }
            case "simple": {
                this.clientTlsCert = null;
                if (this.secretType == null) {
                    this.secretType = SecretType.INTERNALLY_MANAGED;
                }
                if (SecretType.SECRET_MANAGER.equals((Object)this.secretType)) {
                    this.password = "";
                    break;
                }
                this.secretManagerPassword = "";
                break;
            }
            case "clientTlsCert": {
                this.secretType = null;
                this.clearUserNamePasswordFields();
                break;
            }
        }
    }

    private void clearUserNamePasswordFields() {
        this.userName = "";
        this.password = "";
        this.secretManagerPassword = "";
    }

    private LdapDataSource getDataSource() {
        LdapDataSource dataSource = new LdapDataSource();
        this.fillLdapDataSource(dataSource);
        return dataSource;
    }

    public String getDefaultHostName() {
        return this.defaultHostName;
    }

    public void setDefaultHostName(String defaultHostName) {
        this.defaultHostName = defaultHostName;
    }

    public String getAuthMethod() {
        return this.authMethod;
    }

    public void setAuthMethod(String authMethod) {
        this.authMethod = authMethod;
    }

    public PkCertManager getCertManager() {
        return this.certManager;
    }

    public void setCertManager(PkCertManager certManager) {
        this.certManager = certManager;
    }

    public PkCert getClientTlsCert() {
        return this.clientTlsCert;
    }

    public void setClientTlsCert(PkCert clientTlsCert) {
        this.clientTlsCert = clientTlsCert;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = this.previousSecretTypeSelected != null && !this.previousSecretTypeSelected.equals((Object)this.secretType) ? "" : password;
    }

    public SecretType getSecretType() {
        return this.secretType;
    }

    public void setSecretType(SecretType secretType) {
        this.previousSecretTypeSelected = this.secretType;
        this.secretType = secretType;
    }

    public String getSecretManagerPassword() {
        return this.secretManagerPassword;
    }

    public void setSecretManagerPassword(String secretManagerPassword) {
        this.secretManagerPassword = this.previousSecretTypeSelected != null && !this.previousSecretTypeSelected.equals((Object)this.secretType) ? "" : secretManagerPassword;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public boolean getBindAnon() {
        return this.bindAnon;
    }

    public void setBindAnon(boolean bindAnon) {
        this.bindAnon = bindAnon;
    }

    public String getConnectionSecurity() {
        return this.connectionSecurity;
    }

    public void setConnectionSecurity(String connectionSecurity) {
        this.connectionSecurity = connectionSecurity;
    }

    public LdapDataSource getLdapDS() {
        return this.ldapDS;
    }

    public void setLdapDS(LdapDataSource ldapDS) {
        this.ldapDS = ldapDS;
    }

    public String getId() {
        return this.id;
    }

    public boolean isMaskAttributeValues() {
        return this.maskAttributeValues;
    }

    public void setMaskAttributeValues(boolean maskAttributeValues) {
        this.maskAttributeValues = maskAttributeValues;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public void setSourceName(String sourceName) {
        this.sourceName = sourceName;
    }

    public StringPairPropertySelectionModel getLdapTypeList() {
        return this.ldapTypeList;
    }

    public String getSelectedLdapType() {
        return this.selectedLdapType;
    }

    public void setSelectedLdapType(String selectedLdapType) {
        this.selectedLdapType = selectedLdapType;
    }

    public String getSelectedLdapTypeDesc() {
        return this.selectedLdapTypeDesc;
    }

    public void setSelectedLdapTypeDesc(String selectedLdapTypeDesc) {
        this.selectedLdapTypeDesc = LdapInfo.LdapType.SunDirectoryServer.getDescription().equals(selectedLdapTypeDesc) ? "Oracle Directory Server" : selectedLdapTypeDesc;
    }

    public boolean isUseDnsSrvRecord() {
        return this.useDnsSrvRecord;
    }

    public void setUseDnsSrvRecord(boolean useDnsSrvRecord) {
        this.useDnsSrvRecord = useDnsSrvRecord;
    }

    public boolean isUseLdapReferral() {
        return this.showLdapReferral() && this.useLdapReferral;
    }

    public boolean showLdapReferral() {
        return this.selectedLdapTypeDesc == null || !this.selectedLdapTypeDesc.equals(LdapInfo.LdapType.PingDirectory.getDescription()) && !this.selectedLdapTypeDesc.equals(LdapInfo.LdapType.PingDS.getDescription());
    }

    public void setUseLdapReferral(boolean useLdapReferral) {
        this.useLdapReferral = useLdapReferral;
    }

    public boolean isShowSourceName() {
        return this.getParent().getMode() == Mode.edit;
    }

    public boolean isShowMaskLogValues() {
        return this.getParent().getMode() == Mode.edit;
    }

    public boolean isUseSecretManager() {
        return SecretType.SECRET_MANAGER.equals((Object)this.secretType);
    }

    private void createTestConnectionList() {
        this.testConnectionList = this.createTestConnectionList(this.ldapTagTable, this.HOSTNAME_DESC);
    }

    public boolean isDisableForAuditor() {
        return this.getCurrentUser().isAuditor();
    }

    public void testLdapConnection() {
        AdvancedLdapOptionsTasklet tasklet;
        LdapDataSource ldap = this.getDataSource();
        SSLSocketFactory sslSocketFactory = null;
        DataSourceManager dsMgr = MgmtFactory.getDataSourceManager();
        if (ldap.getUseSSL() || ldap.getUseStartTLS()) {
            tasklet = (AdvancedLdapOptionsTasklet)this.advancedLdapOptionsTasklet;
            LdapDataSource existingDs = (LdapDataSource)dsMgr.getDataSource(this.id);
            if (existingDs != null) {
                ldap.setVerifyHost(existingDs.isVerifyHost());
            }
            if (tasklet != null) {
                ldap.setVerifyHost(tasklet.isVerifyHost());
            }
            if ("clientTlsCert".equals(ldap.getAuthenticationMethod()) && StringUtils.isNotBlank((String)ldap.getClientTlsCertificate())) {
                try {
                    sslSocketFactory = PingCustomSSLSocketFactoryUtil.getSSLSocketFactoryWithSingleKey((String)ldap.getClientTlsCertificate());
                }
                catch (GeneralSecurityException e) {
                    throw new ProcessRuntimeException("Unexpected error while creating single-key SSLSocketFactory", (Throwable)e);
                }
            } else {
                sslSocketFactory = PingLdapSSLSocketFactory.getDefault();
            }
        }
        if (ldap.isUseDnsSrvRecords() && (tasklet = (AdvancedLdapOptionsTasklet)this.advancedLdapOptionsTasklet) != null) {
            ldap.setLdapDnsSrvPrefix(tasklet.getLdapDnsSrvPrefix());
            ldap.setLdapsDnsSrvPrefix(tasklet.getLdapsDnsSrvPrefix());
        }
        if ((tasklet = (AdvancedLdapOptionsTasklet)this.advancedLdapOptionsTasklet) != null) {
            try {
                ldap.setConnTimeoutMillis(Integer.parseInt(tasklet.getConnTimeoutMillis()));
                ldap.setReadTimeoutMillis(Integer.parseInt(tasklet.getReadTimeoutMillis()));
            }
            catch (NumberFormatException e) {
                this.log.warn((Object)"Error setting timeouts based on Advanced LDAP Options.  Read Timeout and Connection Timeout must be greater than or equal to -1.");
            }
        }
        List<ValidationError> errors = this.validator.validate(ldap, false, SecretType.SECRET_MANAGER.equals((Object)this.secretType));
        this.recordErrors(errors, (IValidationDelegate)this.delegate);
        ldap.setHost(this.testConnectionId);
        ldap.setLdapTagConfigList(new LinkedList());
        this.connectionTestSuccessfulMessage = null;
        if (errors.isEmpty()) {
            LdapInfo ldapInfo = ldap.getLdapInfoClone();
            if (ldapInfo != null) {
                LDAPUtil.doAdminAuditLogging((String)ldapInfo.getHost());
            }
            if (this.validator.testConnectionRecordErrors(ldap, sslSocketFactory, (IValidationDelegate)this.delegate)) {
                this.setConnectionTestSuccessfulMessage("Connectivity test was successful.");
            }
        }
    }

    public String getConnectionTestSuccessfulMessage() {
        return this.connectionTestSuccessfulMessage;
    }

    public void setConnectionTestSuccessfulMessage(String message) {
        this.connectionTestSuccessfulMessage = message;
    }

    @Override
    public List<SimpleFieldDescriptor> getTaggingColumnDescriptors() {
        ArrayList<SimpleFieldDescriptor> tableList = new ArrayList<SimpleFieldDescriptor>();
        tableList.add(this.HOSTNAME_DESC);
        tableList.add(this.TAG_DESC);
        return tableList;
    }

    @Override
    public List<TableRow> getTaggingTable() {
        return this.ldapTagTable;
    }

    @Override
    public void setTaggingTable(List<TableRow> tagTable) {
        this.ldapTagTable = tagTable;
    }

    @Override
    public Object getComponentState() {
        return this.componentState;
    }

    @Override
    public void setComponentState(Object componentState) {
        this.componentState = componentState;
    }

    public StringPairPropertySelectionModel getTestConnectionList() {
        return this.testConnectionList;
    }

    public void setTestConnectionList(StringPairPropertySelectionModel testConnectionList) {
        this.testConnectionList = testConnectionList;
    }

    public String getTestConnectionId() {
        return this.testConnectionId;
    }

    public void setTestConnectionId(String testConnectionId) {
        this.testConnectionId = testConnectionId;
    }

    @Override
    public void cancel(Object newData) {
        super.cancel(newData);
        this.setComponentState(null);
    }

    @Override
    public List<String> validate(TableRow row, TableRow originalRow, List<TableRow> list, TableEditor owner) {
        LinkedList<String> errorList = new LinkedList<String>();
        List<LdapTagConfig> ldapTagConfigList = this.convertTagTableRow(owner.getUnsavedRowList());
        LdapTagConfigValidator validator = new LdapTagConfigValidator(ldapTagConfigList, this.useDnsSrvRecord, this.isUseSsl());
        validator.setValidateDuplicateTags(false);
        validator.setValidateDuplicateDataStoreIdentifier(false);
        if (!validator.validate()) {
            errorList.addAll(this.convertErrorMessages(validator.getErrors()));
        }
        if (!list.isEmpty() && this.missingDefault(list, row)) {
            errorList.add("Must set one hostname as default");
        }
        return errorList;
    }

    @Override
    public void onUpdateItem(TableEditor owner, TableRow originalRow, TableRow updatedRow) {
        this.createTestConnectionList();
    }

    @Override
    public void onAddItem(TableEditor owner, TableRow newRow) {
        TableEditor.TableEditorListener.super.onAddItem(owner, newRow);
        this.createTestConnectionList();
    }

    @Override
    public void onChooseDefaultItem(TableEditor owner, TableRow rowToSetAsDefault) {
        TableEditor.TableEditorListener.super.onChooseDefaultItem(owner, rowToSetAsDefault);
        String defaultHostname = this.getFieldValue(rowToSetAsDefault, this.HOSTNAME_DESC);
        if (StringUtils.isNotEmpty((String)defaultHostname)) {
            this.defaultHostName = defaultHostname;
        }
    }

    @Override
    public void onDeleteItem(TableEditor owner, TableRow deletedRow) {
        TableEditor.TableEditorListener.super.onDeleteItem(owner, deletedRow);
        this.createTestConnectionList();
    }

    @Override
    public void onUndeleteItem(TableEditor owner, TableRow undeletedRow) {
        TableEditor.TableEditorListener.super.onUndeleteItem(owner, undeletedRow);
        this.createTestConnectionList();
    }

    public void setId(String id) {
        this.id = id;
    }

    private List<LdapTagConfig> convertTagTableRow(List<TableRow> tableRows) {
        ArrayList<LdapTagConfig> ldapTagConfigForSingleRow = new ArrayList<LdapTagConfig>();
        for (TableRow tableRow : tableRows) {
            if (tableRow.isMarkedForDelete()) continue;
            LdapInstanceIdentifier rowIdentifier = new LdapInstanceIdentifier(this.getFieldValue(tableRow, this.HOSTNAME_DESC));
            String rowTags = this.getFieldValue(tableRow, this.TAG_DESC);
            LdapTagConfig rowTagConfig = new LdapTagConfig(rowIdentifier, rowTags, tableRow.isDefault());
            ldapTagConfigForSingleRow.add(rowTagConfig);
        }
        return ldapTagConfigForSingleRow;
    }

    public boolean isClientTlsCertAuthenticationMethodAllowed() {
        return this.isUseSsl() || this.isUseStartTls();
    }

    private boolean isUseSsl() {
        return "ssl".equals(this.connectionSecurity);
    }

    private boolean isUseStartTls() {
        return "startTls".equals(this.connectionSecurity);
    }
}

