/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.util.StringPairPropertySelectionModel;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.sourceid.a2a.domain.Source2TargetMapping;
import org.sourceid.util.license.LicenseConnectionGroup;
import org.sourceid.util.license.LicenseManager;
import org.sourceid.util.license.LicenseObject;

public class LicenseGroupState
extends TaskletState {
    private static final long serialVersionUID = 20050515L;
    private String selectedLicenseConnectionGroup = "";
    private Source2TargetMapping s2tMapping;
    private Map<String, String> groupName2DisplayValue = new HashMap<String, String>();
    private Map<String, String> displayValue2GroupName = new HashMap<String, String>();
    private SimpleDateFormat dateFormatter = new SimpleDateFormat("MM/dd/yyyy");

    public LicenseGroupState(Tasklet parent) {
        super(parent);
        this.setMenuName("License Assignment");
    }

    @Override
    public void populate(Object dataFromDisk) {
        this.s2tMapping = (Source2TargetMapping)dataFromDisk;
        this.selectedLicenseConnectionGroup = this.s2tMapping.getLicenseConnectionGroupAssignment();
        this.getLicenseConnectionGroupList();
    }

    @Override
    public boolean save(Object dataToDisk) {
        Source2TargetMapping mapping = (Source2TargetMapping)dataToDisk;
        mapping.setLicenseConnectionGroupAssignment(this.selectedLicenseConnectionGroup);
        return true;
    }

    public String getSelectedLicenseConnectionGroup() {
        return this.groupName2DisplayValue.get(this.selectedLicenseConnectionGroup);
    }

    public void setSelectedLicenseConnectionGroup(String selectedLicenseConnectionGroup) {
        this.selectedLicenseConnectionGroup = this.displayValue2GroupName.get(selectedLicenseConnectionGroup);
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        if (this.getSelectedLicenseConnectionGroup() != null) {
            summaryList.add(new SummaryInfo("License Group", this.getSelectedLicenseConnectionGroup(), this));
        } else {
            summaryList.add(new SummaryInfo("License Group", "No License Group defined", this));
        }
    }

    public StringPairPropertySelectionModel getLicenseConnectionGroupList() {
        List availableGroups = LicenseManager.getAvailableLicenseGroups((LicenseObject)this.s2tMapping, (int)1);
        StringPairPropertySelectionModel model = new StringPairPropertySelectionModel(true);
        if (availableGroups != null && !availableGroups.isEmpty()) {
            Collections.sort(availableGroups);
            for (LicenseConnectionGroup grp : availableGroups) {
                String groupName = grp.getGroupName();
                String displayValue = this.makeDisplayValue(grp);
                this.groupName2DisplayValue.put(groupName, displayValue);
                this.displayValue2GroupName.put(displayValue, groupName);
                model.add(displayValue, displayValue);
            }
        }
        return model;
    }

    private String makeDisplayValue(LicenseConnectionGroup grp) {
        Object retV = "";
        if (grp != null) {
            retV = grp.getGroupName() + " (" + this.dateFormatter.format(grp.getEffectiveDate()) + "-" + this.dateFormatter.format(grp.getExpirationDate()) + ", " + grp.getConnectionLimit() + ")";
        }
        return retV;
    }
}

