/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.admin.api.validator.CertificateValidator;
import com.pingidentity.admin.api.validator.KeyAndCertificateLinkValidator;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.crypto.Cert;
import com.pingidentity.crypto.CertificateService;
import com.pingidentity.crypto.PkCert;
import com.pingidentity.fsm.helper.ImportMetadataSummaryHelper;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.data.CertItem;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import java.security.PrivateKey;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.request.IUploadFile;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.sourceid.saml20.domain.mgmt.PkCertManager;

public class LinkCertState
extends TaskletState {
    private static final long serialVersionUID = 20250509000000L;
    private String fileName;
    private long fileSize;
    private String privateKeyId;
    private transient IUploadFile certFile;
    private String errorMessage;
    private boolean keyErrorEncountered = false;
    private Cert cert;
    private PrivateKey privateKey;
    private CertItem certItem;
    private transient ValidationErrorFactory errorFactory;
    private transient CertificateService certificateService;
    private transient PkCertManager pkCertManager;

    public LinkCertState(Tasklet value) {
        super(value);
        this.setMenuName("Link Certificate");
    }

    public void setErrorFactory(ValidationErrorFactory errorFactory) {
        this.errorFactory = errorFactory;
    }

    public void setCertificateService(CertificateService certificateService) {
        this.certificateService = certificateService;
    }

    public void setPkCertManager(PkCertManager pkCertManager) {
        this.pkCertManager = pkCertManager;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public void setFileSize(long fileSize) {
        this.fileSize = fileSize;
    }

    public String getPrivateKeyId() {
        return this.privateKeyId;
    }

    public void setPrivateKeyId(String privateKeyId) {
        this.privateKeyId = privateKeyId;
    }

    public IUploadFile getCertFile() {
        return this.certFile;
    }

    public void setCertFile(IUploadFile certFile) {
        this.certFile = certFile;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public CertItem getCertItem() {
        return this.certItem;
    }

    public List<String> createCertItem() {
        if (this.cert == null || this.privateKey == null || StringUtils.isEmpty((CharSequence)this.privateKeyId)) {
            return List.of("Private key and certificate must be set");
        }
        PkCert pkCert = new PkCert(this.privateKeyId, this.cert.getX509Certificate(), this.privateKey);
        pkCert.setStoredOnHSM(Boolean.valueOf(true));
        this.certItem = new CertItem((Cert)pkCert);
        return List.of();
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        summaryList.add(new SummaryInfo(this.getMessage("Filename"), this.getFileName(), this));
        summaryList.add(new SummaryInfo(this.getMessage("File_size"), Long.toString(this.getFileSize()), this));
        summaryList.addAll(ImportMetadataSummaryHelper.getCertSummary(this.cert, this));
        super.doSummary(summaryList);
    }

    @Override
    public void formListener(IRequestCycle cycle) {
        Objects.requireNonNull(this.errorFactory, "errorFactory");
        Objects.requireNonNull(this.certificateService, "certificateService");
        Objects.requireNonNull(this.pkCertManager, "pkCertManager");
        if (this.certFile == null || this.certFile.getSize() == 0L) {
            return;
        }
        CertificateValidator certificateValidator = new CertificateValidator.CertificateValidatorBuilder(this.certFile.getStream(), null).setCertOnly(true).build();
        if (!certificateValidator.validate()) {
            this.recordErrors(certificateValidator.getErrors(), (IValidationDelegate)this.delegate);
            return;
        }
        this.fileName = this.certFile.getFileName();
        this.fileSize = this.certFile.getSize();
        this.cert = certificateValidator.getCert();
        KeyAndCertificateLinkValidator keyAndCertificateLinkValidator = new KeyAndCertificateLinkValidator(this.privateKeyId, certificateValidator.getCert(), this.errorFactory, this.certificateService, this.pkCertManager);
        if (keyAndCertificateLinkValidator.validate()) {
            this.privateKey = keyAndCertificateLinkValidator.getPrivateKey();
        } else {
            this.recordErrors(keyAndCertificateLinkValidator.getErrors(), (IValidationDelegate)this.delegate);
            this.keyErrorEncountered = true;
            this.fileName = null;
            this.fileSize = 0L;
            this.cert = null;
        }
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        if (!(this.keyErrorEncountered || this.certFile != null && this.fileSize != 0L)) {
            delegate.setFormComponent(null);
            delegate.record(this.getMessage("Valid_path_required"), ValidationConstraint.REQUIRED);
        }
        if (StringUtils.isEmpty((CharSequence)this.privateKeyId)) {
            delegate.setFormComponent(null);
            delegate.record(this.getMessage("Private_key_id_required"), ValidationConstraint.REQUIRED);
        }
        this.keyErrorEncountered = false;
    }
}

