/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.crypto.Cert;
import com.pingidentity.crypto.OCSPCheckerSupport;
import com.pingidentity.fsm.state.impl.CertificateState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.api.InUseCertsApi;
import com.pingidentity.fsm.tasklet.data.CertificateTypes;
import com.pingidentity.fsm.tasklet.impl.CertManagementTasklet;
import com.pingidentity.util.StringPairPropertySelectionModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.sourceid.common.ValidationUtil;
import org.sourceid.saml20.domain.ConnectionCerts;
import org.sourceid.saml20.domain.RevocationSettings;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.PkCertAndConnectionCertManager;
import org.sourceid.saml20.domain.mgmt.PkCertManager;

public class ManageCertificateRevocationState
extends CertificateState
implements CertificateTypes {
    private static final long serialVersionUID = 1L;
    private static final String ERROR_ACTION_FAIL = OCSPCheckerSupport.ACTION.FAIL.toString();
    private static final String ERROR_ACTION_CONTINUE = OCSPCheckerSupport.ACTION.CONTINUE.toString();
    private static final String ERROR_ACTION_FAILOVER = OCSPCheckerSupport.ACTION.FAILOVER.toString();
    private boolean ocspEnabled;
    private String ocspDefaultResponderURL;
    private boolean ocspRequestorAddNonce;
    private boolean ocspRequestorAddNonceFromPopulate;
    private String ocspThisUpdateGracePeriod;
    private String ocspNextUpdateGracePeriod;
    private String ocspResponderTimeout;
    private String ocspResponseCachingInterval;
    private String ocspActionOnCertUnknown;
    private String ocspActionOnResponderUnavailable;
    private String ocspActionOnResponderReturnsError;
    private boolean crlCheckingEnabled;
    private boolean crlTreatUnretrievableCrlsAsRevoked;
    private boolean crlTreatUnretrievableCrlsAsRevokedFromPopulate;
    private String crlResolutionFailureNextRetry;
    private String crlUpdateExpirationNextRetry;
    private boolean crlVerifyCrlSignature;
    private boolean crlVerifyCrlSignatureFromPopulate;
    private String proxyHost;
    private String proxyPort;

    public ManageCertificateRevocationState(Tasklet parent) {
        super(parent);
        this.certType = CertificateTypes.ValidTypes.ocspDsigVerificationCert;
        this.setMenuName("Manage Certificate Revocation");
    }

    @Override
    public void populate(Object dataFromDisk) {
        PkCertAndConnectionCertManager certManager;
        Set verificationCerts;
        RevocationSettings revocationSettings = MgmtFactory.getRevocationManager().getRevocationSettings();
        this.ocspEnabled = revocationSettings.isOcspEnabled();
        this.ocspDefaultResponderURL = revocationSettings.getOcspResponderUrl();
        this.ocspRequestorAddNonce = this.ocspRequestorAddNonceFromPopulate = revocationSettings.isOcspRequesterAddNonce();
        this.ocspThisUpdateGracePeriod = revocationSettings.getOcspThisUpdateGracePeriod();
        this.ocspNextUpdateGracePeriod = revocationSettings.getOcspNextUpdateGracePeriod();
        this.ocspResponderTimeout = revocationSettings.getOcspConnectionTimeoutSecs();
        this.ocspResponseCachingInterval = revocationSettings.getOcspResponseCachePeriod();
        this.ocspActionOnCertUnknown = revocationSettings.getOcspActionOnStatusUnknown();
        this.ocspActionOnResponderUnavailable = revocationSettings.getOcspActionOnResponderUnavailable();
        this.ocspActionOnResponderReturnsError = revocationSettings.getOcspActionOnUnsuccessfulResponse();
        this.crlCheckingEnabled = revocationSettings.isCrlEnabled();
        this.crlTreatUnretrievableCrlsAsRevoked = this.crlTreatUnretrievableCrlsAsRevokedFromPopulate = revocationSettings.isTreatNonRetrievableCrlAsRevoked();
        this.crlResolutionFailureNextRetry = revocationSettings.getNextRetryMinsWhenResolveFailed();
        this.crlUpdateExpirationNextRetry = revocationSettings.getNextRetryMinsWhenNextUpdateInPast();
        this.crlVerifyCrlSignature = this.crlVerifyCrlSignatureFromPopulate = revocationSettings.isVerifyCrlSignature();
        this.proxyHost = revocationSettings.getProxyHost();
        this.proxyPort = revocationSettings.getProxyPort();
        if ("0".equals(this.proxyPort)) {
            this.proxyPort = "";
        }
        if ((verificationCerts = (certManager = (PkCertAndConnectionCertManager)MgmtFactory.getDsigPkCertManager()).getCertsForFeature("Revocation Settings OCSP Responder Certs")) != null) {
            Cert selectedCert;
            String selectedCertAlias = revocationSettings.getOcspResponderCertAlias();
            try {
                selectedCert = certManager.getCert(selectedCertAlias);
            }
            catch (IllegalArgumentException e) {
                selectedCert = null;
            }
            this.setSelectedCert(selectedCert);
            HashSet verificationCertsSet = new HashSet(verificationCerts);
            ConnectionCerts connectionCertsObject = new ConnectionCerts();
            connectionCertsObject.setVerificationCerts((ArrayList)(selectedCert == null ? null : new ArrayList<Cert>(Collections.singletonList(selectedCert))), verificationCertsSet);
            this.setConnectionCerts(connectionCertsObject);
        }
    }

    @Override
    public boolean save(Object dataToDisk) {
        RevocationSettings revocationSettings = new RevocationSettings();
        revocationSettings.setOcspEnabled(this.ocspEnabled);
        if (this.ocspEnabled) {
            if (!StringUtils.isBlank((String)this.ocspDefaultResponderURL)) {
                revocationSettings.setOcspResponderUrl(this.ocspDefaultResponderURL);
            }
            revocationSettings.setOcspRequesterAddNonce(this.ocspRequestorAddNonce);
            revocationSettings.setOcspThisUpdateGracePeriod(this.ocspThisUpdateGracePeriod);
            revocationSettings.setOcspNextUpdateGracePeriod(this.ocspNextUpdateGracePeriod);
            revocationSettings.setOcspConnectionTimeoutSecs(this.ocspResponderTimeout);
            revocationSettings.setOcspResponseCachePeriod(this.ocspResponseCachingInterval);
            revocationSettings.setOcspActionOnStatusUnknown(this.ocspActionOnCertUnknown);
            revocationSettings.setOcspActionOnResponderUnavailable(this.ocspActionOnResponderUnavailable);
            revocationSettings.setOcspActionOnUnsuccessfulResponse(this.ocspActionOnResponderReturnsError);
            ConnectionCerts connectionCertsObject = this.getConnectionCerts();
            Set allVerificationCertsToSave = connectionCertsObject.getAllVerificationCerts();
            PkCertAndConnectionCertManager certManager = (PkCertAndConnectionCertManager)MgmtFactory.getDsigPkCertManager();
            certManager.saveCertsForFeature(allVerificationCertsToSave, "Revocation Settings OCSP Responder Certs");
            String selectedCertAlias = "";
            Cert selectedCert = this.getSelectedCert();
            if (selectedCert != null) {
                selectedCertAlias = selectedCert.getAlias();
            }
            revocationSettings.setOcspResponderCertAlias(selectedCertAlias);
        } else {
            revocationSettings.setOcspRequesterAddNonce(this.ocspRequestorAddNonceFromPopulate);
        }
        revocationSettings.setCrlEnabled(this.crlCheckingEnabled);
        if (this.crlCheckingEnabled) {
            revocationSettings.setTreatNonRetrievableCrlAsRevoked(this.crlTreatUnretrievableCrlsAsRevoked);
            revocationSettings.setNextRetryMinsWhenResolveFailed(this.crlResolutionFailureNextRetry);
            revocationSettings.setNextRetryMinsWhenNextUpdateInPast(this.crlUpdateExpirationNextRetry);
            revocationSettings.setVerifyCrlSignature(this.crlVerifyCrlSignature);
        } else {
            revocationSettings.setTreatNonRetrievableCrlAsRevoked(this.crlTreatUnretrievableCrlsAsRevokedFromPopulate);
            revocationSettings.setVerifyCrlSignature(this.crlVerifyCrlSignatureFromPopulate);
        }
        revocationSettings.setProxyHost(this.proxyHost);
        revocationSettings.setProxyPort(this.proxyPort);
        MgmtFactory.getRevocationManager().saveRevocationSettings(revocationSettings);
        return true;
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        boolean proxyPortDefined;
        if (this.ocspEnabled) {
            if (!StringUtils.isBlank((String)this.ocspDefaultResponderURL) && !ValidationUtil.isValidHttpOrHttpsUrl((String)this.ocspDefaultResponderURL)) {
                delegate.setFormComponent(null);
                delegate.record(this.getMessage("Default_ocsp_url_invalid"), ValidationConstraint.REQUIRED);
            }
            if (StringUtils.isBlank((String)this.ocspThisUpdateGracePeriod)) {
                delegate.setFormComponent(null);
                delegate.record(this.getMessage("This_update_grace_period_required"), ValidationConstraint.REQUIRED);
            } else if (!ValidationUtil.isValidInt((String)this.ocspThisUpdateGracePeriod, (int)1, (int)65535)) {
                delegate.setFormComponent(null);
                delegate.record(this.getMessage("This_update_grace_period_invalid"), ValidationConstraint.REQUIRED);
            }
            if (StringUtils.isBlank((String)this.ocspNextUpdateGracePeriod)) {
                delegate.setFormComponent(null);
                delegate.record(this.getMessage("Next_update_grace_period_required"), ValidationConstraint.REQUIRED);
            } else if (!ValidationUtil.isValidInt((String)this.ocspNextUpdateGracePeriod, (int)1, (int)65535)) {
                delegate.setFormComponent(null);
                delegate.record(this.getMessage("Next_update_grace_period_invalid"), ValidationConstraint.REQUIRED);
            }
            if (StringUtils.isBlank((String)this.ocspResponderTimeout)) {
                delegate.setFormComponent(null);
                delegate.record(this.getMessage("Responder_timeout_required"), ValidationConstraint.REQUIRED);
            } else if (!ValidationUtil.isValidInt((String)this.ocspResponderTimeout, (int)1, (int)65535)) {
                delegate.setFormComponent(null);
                delegate.record(this.getMessage("Responder_timeout_invalid"), ValidationConstraint.REQUIRED);
            }
            if (StringUtils.isBlank((String)this.ocspResponseCachingInterval)) {
                delegate.setFormComponent(null);
                delegate.record(this.getMessage("Response_cache_interval_required"), ValidationConstraint.REQUIRED);
            } else if (!ValidationUtil.isValidInt((String)this.ocspResponseCachingInterval, (int)0, (int)65535)) {
                delegate.setFormComponent(null);
                delegate.record(this.getMessage("Response_cache_interval_invalid"), ValidationConstraint.REQUIRED);
            }
            if ((ERROR_ACTION_FAILOVER.equals(this.ocspActionOnCertUnknown) || ERROR_ACTION_FAILOVER.equals(this.ocspActionOnResponderReturnsError) || ERROR_ACTION_FAILOVER.equals(this.ocspActionOnResponderUnavailable)) && !this.crlCheckingEnabled) {
                delegate.setFormComponent(null);
                delegate.record(this.getMessage("Failover_defined_no_crl"), ValidationConstraint.REQUIRED);
            }
            if (!ERROR_ACTION_FAILOVER.equals(this.ocspActionOnCertUnknown) && !ERROR_ACTION_FAILOVER.equals(this.ocspActionOnResponderReturnsError) && !ERROR_ACTION_FAILOVER.equals(this.ocspActionOnResponderUnavailable) && this.crlCheckingEnabled) {
                delegate.setFormComponent(null);
                delegate.record(this.getMessage("No_Failover_defined_but_crl_is"), ValidationConstraint.REQUIRED);
            }
        }
        if (this.crlCheckingEnabled) {
            if (StringUtils.isBlank((String)this.crlResolutionFailureNextRetry)) {
                delegate.setFormComponent(null);
                delegate.record(this.getMessage("Resolution_failure_required"), ValidationConstraint.REQUIRED);
            } else if (!ValidationUtil.isValidInt((String)this.crlResolutionFailureNextRetry, (int)1, (int)65535)) {
                delegate.setFormComponent(null);
                delegate.record(this.getMessage("Resolution_failure_invalid"), ValidationConstraint.REQUIRED);
            }
            if (StringUtils.isBlank((String)this.crlUpdateExpirationNextRetry)) {
                delegate.setFormComponent(null);
                delegate.record(this.getMessage("Update_expiration_required"), ValidationConstraint.REQUIRED);
            } else if (!ValidationUtil.isValidInt((String)this.crlUpdateExpirationNextRetry, (int)1, (int)65535)) {
                delegate.setFormComponent(null);
                delegate.record(this.getMessage("Update_expiration_invalid"), ValidationConstraint.REQUIRED);
            }
        }
        boolean proxyHostDefined = !StringUtils.isBlank((String)this.proxyHost);
        boolean bl = proxyPortDefined = !StringUtils.isBlank((String)this.proxyPort);
        if (proxyHostDefined || proxyPortDefined) {
            if (!proxyHostDefined || !proxyPortDefined) {
                delegate.setFormComponent(null);
                delegate.record(this.getMessage("Host_and_port_required"), ValidationConstraint.REQUIRED);
            } else {
                if (!ValidationUtil.isValidDomainName((String)this.proxyHost)) {
                    delegate.setFormComponent(null);
                    delegate.record(this.getMessage("Proxy_host_invalid"), ValidationConstraint.REQUIRED);
                }
                if (!ValidationUtil.isValidPort((String)this.proxyPort, (boolean)false)) {
                    delegate.setFormComponent(null);
                    delegate.record(this.getMessage("Proxy_port_invalid"), ValidationConstraint.REQUIRED);
                }
            }
        }
    }

    public StringPairPropertySelectionModel getErrorHandlingActions() {
        StringPairPropertySelectionModel model = new StringPairPropertySelectionModel();
        model.add("Treat as Revoked", ERROR_ACTION_FAIL);
        model.add("Treat as Valid", ERROR_ACTION_CONTINUE);
        model.add("Failover to CRL", ERROR_ACTION_FAILOVER);
        return model;
    }

    public PkCertManager getCertManager() {
        return MgmtFactory.getDsigPkCertManager();
    }

    public ConnectionCerts getConnectionCerts() {
        return this.findParent(InUseCertsApi.class).getDsigConnectionCerts();
    }

    public void setConnectionCerts(ConnectionCerts certs) {
        this.findParent(InUseCertsApi.class).setDsigConnectionCerts(certs);
    }

    @Override
    public void refreshState() {
        CertManagementTasklet tasklet = (CertManagementTasklet)this.getTaskletToEdit();
        this.setSelectedCert(tasklet.getSelectedCert());
        InUseCertsApi iuca = this.findParent(InUseCertsApi.class);
        iuca.setDsigConnectionCerts(tasklet.getDsigVerificationCerts());
    }

    public boolean isOcspEnabled() {
        return this.ocspEnabled;
    }

    public void setOcspEnabled(boolean ocspEnabled) {
        this.ocspEnabled = ocspEnabled;
    }

    public String getOcspDefaultResponderURL() {
        return this.ocspDefaultResponderURL;
    }

    public void setOcspDefaultResponderURL(String ocspDefaultResponderURL) {
        this.ocspDefaultResponderURL = ocspDefaultResponderURL;
    }

    public String getOcspThisUpdateGracePeriod() {
        return this.ocspThisUpdateGracePeriod;
    }

    public void setOcspThisUpdateGracePeriod(String ocspThisUpdateGracePeriod) {
        this.ocspThisUpdateGracePeriod = ocspThisUpdateGracePeriod;
    }

    public String getOcspNextUpdateGracePeriod() {
        return this.ocspNextUpdateGracePeriod;
    }

    public void setOcspNextUpdateGracePeriod(String ocspNextUpdateGracePeriod) {
        this.ocspNextUpdateGracePeriod = ocspNextUpdateGracePeriod;
    }

    public String getOcspResponderTimeout() {
        return this.ocspResponderTimeout;
    }

    public void setOcspResponderTimeout(String ocspResponderTimeout) {
        this.ocspResponderTimeout = ocspResponderTimeout;
    }

    public String getOcspResponseCachingInterval() {
        return this.ocspResponseCachingInterval;
    }

    public void setOcspResponseCachingInterval(String ocspResponseCachingInterval) {
        this.ocspResponseCachingInterval = ocspResponseCachingInterval;
    }

    public String getOcspActionOnCertUnknown() {
        return this.ocspActionOnCertUnknown;
    }

    public void setOcspActionOnCertUnknown(String ocspActionOnCertUnknown) {
        this.ocspActionOnCertUnknown = ocspActionOnCertUnknown;
    }

    public String getOcspActionOnResponderUnavailable() {
        return this.ocspActionOnResponderUnavailable;
    }

    public void setOcspActionOnResponderUnavailable(String ocspActionOnResponderUnavailable) {
        this.ocspActionOnResponderUnavailable = ocspActionOnResponderUnavailable;
    }

    public String getOcspActionOnResponderReturnsError() {
        return this.ocspActionOnResponderReturnsError;
    }

    public void setOcspActionOnResponderReturnsError(String ocspActionOnResponderReturnsError) {
        this.ocspActionOnResponderReturnsError = ocspActionOnResponderReturnsError;
    }

    public boolean isCrlCheckingEnabled() {
        return this.crlCheckingEnabled;
    }

    public void setCrlCheckingEnabled(boolean crlCheckingEnabled) {
        this.crlCheckingEnabled = crlCheckingEnabled;
    }

    public boolean isCrlTreatUnretrievableCrlsAsRevoked() {
        return this.crlTreatUnretrievableCrlsAsRevoked;
    }

    public void setCrlTreatUnretrievableCrlsAsRevoked(boolean crlTreatUnretrievableCrlsAsRevoked) {
        this.crlTreatUnretrievableCrlsAsRevoked = crlTreatUnretrievableCrlsAsRevoked;
    }

    public String getCrlResolutionFailureNextRetry() {
        return this.crlResolutionFailureNextRetry;
    }

    public void setCrlResolutionFailureNextRetry(String crlResolutionFailureNextRetry) {
        this.crlResolutionFailureNextRetry = crlResolutionFailureNextRetry;
    }

    public String getCrlUpdateExpirationNextRetry() {
        return this.crlUpdateExpirationNextRetry;
    }

    public void setCrlUpdateExpirationNextRetry(String crlUpdateExpirationNextRetry) {
        this.crlUpdateExpirationNextRetry = crlUpdateExpirationNextRetry;
    }

    public boolean isCrlVerifyCrlSignature() {
        return this.crlVerifyCrlSignature;
    }

    public void setCrlVerifyCrlSignature(boolean crlVerifyCrlSignature) {
        this.crlVerifyCrlSignature = crlVerifyCrlSignature;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public String getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(String proxyPort) {
        this.proxyPort = proxyPort;
    }

    public boolean isOcspRequestorAddNonce() {
        return this.ocspRequestorAddNonce;
    }

    public void setOcspRequestorAddNonce(boolean ocspRequestorAddNonce) {
        this.ocspRequestorAddNonce = ocspRequestorAddNonce;
    }

    @Override
    public LinkedHashSet<Cert> getActiveCerts() {
        if (this.getSelectedCert() == null) {
            return new LinkedHashSet<Cert>();
        }
        return new LinkedHashSet<Cert>(Collections.singleton(this.getSelectedCert()));
    }

    @Override
    public Set<Cert> getInactiveCerts() {
        InUseCertsApi iuca = this.findParent(InUseCertsApi.class);
        Set inactiveCerts = iuca.getDsigConnectionCerts().getAllVerificationCerts();
        inactiveCerts.remove(this.getSelectedCert());
        return inactiveCerts;
    }
}

