/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.fsm.state.impl.AutoSaveState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletListState;
import com.pingidentity.fsm.tasklet.data.Mode;
import com.pingidentity.fsm.tasklet.impl.DataSourceTasklet;
import com.pingidentity.validator.SummaryInfoPFValidationDelegate;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.sourceid.saml20.domain.CustomDataSource;
import org.sourceid.saml20.domain.JdbcDataSource;
import org.sourceid.saml20.domain.LdapDataSource;
import org.sourceid.saml20.domain.mgmt.DataSourceManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

@AutoSaveState
public class ManageDataSourcesState
extends TaskletListState {
    private static final long serialVersionUID = 20050515L;
    private final transient DataSourceManager dsMgr = MgmtFactory.getDataSourceManager();

    public ManageDataSourcesState(Tasklet value) {
        super(value);
        this.setMenuName("Manage Data Stores");
    }

    @Override
    public void populate(Object dataFromDisk) {
        DataSourceTasklet tasklet;
        this.deleteAllTasklets();
        for (JdbcDataSource jdbc : this.dsMgr.getJdbcDataSources()) {
            tasklet = this.createTasklet(DataSourceTasklet.class);
            tasklet.setMode(Mode.edit);
            tasklet.populate(jdbc);
            if (this.getParent().showFinishButtonIfAuditor()) {
                tasklet.setDisabled(true);
            }
            this.addTasklet(tasklet);
        }
        for (LdapDataSource ldap : this.dsMgr.getLdapDataSources()) {
            tasklet = this.createTasklet(DataSourceTasklet.class);
            tasklet.setMode(Mode.edit);
            tasklet.populate(ldap);
            if (this.getParent().showFinishButtonIfAuditor()) {
                tasklet.setDisabled(true);
            }
            this.addTasklet(tasklet);
        }
        for (CustomDataSource custom : this.dsMgr.getCustomDataSources()) {
            tasklet = this.createTasklet(DataSourceTasklet.class);
            tasklet.setMode(Mode.edit);
            tasklet.populate(custom);
            if (this.getParent().showFinishButtonIfAuditor()) {
                tasklet.setDisabled(true);
            }
            this.addTasklet(tasklet);
        }
    }

    @Override
    public void deleteTasklet(Integer taskletToDelete) {
        DataSourceTasklet tasklet = (DataSourceTasklet)this.getTasklet(taskletToDelete);
        tasklet.setItDeleted(true);
        DataSourceManager dsMgr = MgmtFactory.getDataSourceManager();
        switch (tasklet.getSelectedDataSourceType()) {
            case Database: {
                JdbcDataSource jdbcDataSource = new JdbcDataSource();
                tasklet.setMode(Mode.edit);
                tasklet.save(jdbcDataSource);
                dsMgr.deleteJdbcDataSource(jdbcDataSource);
                break;
            }
            case LDAP: 
            case LDAP_GATEWAY: {
                LdapDataSource ldapDataSource = new LdapDataSource();
                tasklet.setMode(Mode.edit);
                tasklet.save(ldapDataSource);
                dsMgr.deleteLdapDataSource(ldapDataSource);
                break;
            }
            case Other: {
                CustomDataSource tempSource = new CustomDataSource();
                tasklet.setMode(Mode.edit);
                tasklet.save(tempSource);
                dsMgr.deleteCustomDataSource(tempSource);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid data source type: " + tasklet.getSelectedDataSourceType());
            }
        }
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        for (Tasklet tasklet : this.getTasklets()) {
            if (tasklet.isItDeleted()) continue;
            SummaryInfoPFValidationDelegate tempDelegate = new SummaryInfoPFValidationDelegate();
            tasklet.appendErrors((IValidationDelegate)tempDelegate, null, fastFail);
            if (!tempDelegate.getHasErrors()) continue;
            delegate.setFormComponent(null);
            delegate.record(this.getMessage("Data_store_errors"), ValidationConstraint.REQUIRED);
            break;
        }
    }

    public boolean isDuplicate(String sourceName) {
        for (Tasklet t : this.getTasklets()) {
            DataSourceTasklet dst = (DataSourceTasklet)t;
            if (!dst.getDesc().equals(sourceName)) continue;
            return true;
        }
        return false;
    }

    public boolean isDuplicate(String sourceName, Tasklet taskletToBeCompared) {
        for (Tasklet t : this.getTasklets()) {
            DataSourceTasklet dst = (DataSourceTasklet)t;
            if (t.equals(taskletToBeCompared) || !dst.getDesc().equals(sourceName)) continue;
            return true;
        }
        return false;
    }
}

