/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.common.mgr.ExpressionManager;
import com.pingidentity.component.common.DataMap;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.fsm.tasklet.impl.ConnectionTasklet;
import com.pingidentity.fsm.tasklet.impl.MappingTasklet;
import com.pingidentity.util.SAML2MappingModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.form.IPropertySelectionModel;
import org.apache.tapestry.valid.IValidationDelegate;
import org.sourceid.saml20.domain.AttrMappingValue;
import org.sourceid.saml20.domain.AttributeMapping;
import org.sourceid.saml20.domain.AttributeSource;
import org.sourceid.saml20.domain.SourceType;

public abstract class MappingState
extends TaskletState {
    private static final long serialVersionUID = 1L;
    protected SAML2MappingModel model = new SAML2MappingModel(this.getCurrentUser());
    protected transient DataMap.Sources sources = new DataMap.Sources();
    protected AttributeMapping attributeMapping;

    public MappingState(Tasklet value, String name) {
        super(value, name);
        this.setMessageSimpleName("MappingState");
    }

    @Override
    public void cancel(Object newData) {
        if (!this.isViewOnly()) {
            super.cancel(newData);
        }
    }

    public boolean getIsOidc() {
        ConnectionTasklet connTasklet = this.findParent(ConnectionTasklet.class);
        if (connTasklet != null) {
            return connTasklet.isConnectionProtocolOIDC();
        }
        return false;
    }

    public DataMap.Sources getSources() {
        return this.sources;
    }

    public SAML2MappingModel getModel() {
        ExpressionManager expressionManager = ExpressionManager.getInstance();
        if (!expressionManager.isEvaluateExpressionsOn()) {
            this.model.setTestingExpression(false);
        }
        return this.model;
    }

    @Override
    public void onStateActivated() {
        if (this.sources == null) {
            this.sources = new DataMap.Sources();
        }
        this.sources.reset();
        this.sources.addNoMappingSource("No Mapping");
        ExpressionManager expressionManager = ExpressionManager.getInstance();
        if (expressionManager.isEvaluateExpressionsOn()) {
            this.sources.addExpressionSource("Expression");
        }
        this.sources.addTextSource("Text");
        MappingTasklet parent = this.findParent(MappingTasklet.class);
        if (parent.isUseOtherValuesWithOneMapping()) {
            Map<AttributeSource, IPropertySelectionModel> dataStoreModels = parent.getIPropertySelectionModelsForAttributeSources();
            for (Map.Entry<AttributeSource, IPropertySelectionModel> modelEntry : dataStoreModels.entrySet()) {
                String selectionLabel = modelEntry.getKey().getType() + " (" + modelEntry.getKey().getDescription() + ")";
                this.sources.addPropertySelectionSource(modelEntry.getKey().getType(), modelEntry.getKey().getId(), selectionLabel, modelEntry.getValue());
            }
        }
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        if (!this.isViewOnly()) {
            this.onStateActivated();
            this.model.validate(delegate, this.getTarget(), this.getSources(), this);
        }
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        if (this.model != null) {
            Collection<String> target;
            Map attrMap = this.model.getMapping().getAttributeMapping();
            if (attrMap.isEmpty()) {
                summaryList.add(new SummaryInfo(this.getMessage("Mappings"), "(None)", this));
            }
            if ((target = this.getTarget()) == null) {
                target = new ArrayList<String>();
            }
            for (String key : new TreeSet(attrMap.keySet())) {
                if (!target.contains(key)) continue;
                for (AttrMappingValue v : (List)attrMap.get(key)) {
                    if (v != null) {
                        summaryList.add(new SummaryInfo(key, (String)(SourceType.NO_MAPPING.equals((Object)v.getType()) ? "No Mapping" : this.getAttrValueForDisplay(v) + " (" + v.getTypeString() + ")"), this));
                        continue;
                    }
                    summaryList.add(new SummaryInfo(key, "Not defined", this));
                }
            }
        }
    }

    public String getAttrValueForDisplay(AttrMappingValue attrMappingValue) {
        return attrMappingValue.getValue();
    }

    public abstract Collection<String> getTarget();
}

