/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.admin.api.validator.MetadataSignatureValidator;
import com.pingidentity.admin.api.validator.MetadataValidator;
import com.pingidentity.crypto.Cert;
import com.pingidentity.fsm.IWizard;
import com.pingidentity.fsm.helper.ImportMetadataSummaryHelper;
import com.pingidentity.fsm.state.impl.ImportMetadataState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.api.ImportMetadataApi;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.fsm.tasklet.impl.MetadataUrlCertTasklet;
import com.pingidentity.fsm.tasklet.impl.MetadataUrlImportCertTasklet;
import com.pingidentity.pf.common.api.validator.error.ValidationError;
import java.io.InputStream;
import java.util.ArrayList;
import javax.xml.bind.ValidationException;
import org.apache.commons.lang.StringUtils;
import org.apache.xmlbeans.XmlObject;
import org.sourceid.common.dsig.XmlSignatureVerifier;
import org.sourceid.saml20.domain.mgmt.impl.MetadataUpdateTaskHelper;

public class MetadataUrlCertSummaryState
extends TaskletState
implements ImportMetadataApi {
    private static final long serialVersionUID = 1L;
    private static final String TITLE = "Certificate Summary";
    private boolean importButtonVisible = false;
    private boolean verified = false;
    private String verificationMessage = this.getMessage("Verification_successful");
    private String error = "";

    public MetadataUrlCertSummaryState(IWizard value) {
        super(value);
        this.setMenuName(TITLE);
        this.resetPageState();
    }

    @Override
    public String getNoteKey() {
        return this.getCert() == null && !this.isCertUpdatedFromMetadata() ? super.getNoteKey() + "_No_cert" : super.getNoteKey();
    }

    @Override
    public void populate(Object populateData) {
        this.resetPageState();
    }

    @Override
    public boolean save(Object dataToDisk) {
        this.resetPageState();
        return true;
    }

    @Override
    public void getSummary(ArrayList<SummaryInfo> summaryList) {
        if (this.getCert() != null) {
            summaryList.add(new SummaryInfo(TITLE, "", this, true));
            this.doSummary(summaryList);
        }
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        this.doCertSummary(summaryList);
    }

    public ArrayList<SummaryInfo> getCertSummary() {
        ArrayList<SummaryInfo> certSummaryList = new ArrayList<SummaryInfo>();
        MetadataUrlCertTasklet metadataUrlCert = this.getParent(MetadataUrlCertTasklet.class);
        if (this.getCert() != null && metadataUrlCert.isValidateSignature()) {
            this.doCertSummary(certSummaryList);
        }
        return certSummaryList;
    }

    private void doCertSummary(ArrayList<SummaryInfo> summaryList) {
        if (summaryList != null && this.getCert() != null) {
            MetadataUrlCertTasklet metadataUrlCert = this.getParent(MetadataUrlCertTasklet.class);
            if (metadataUrlCert.isCertUpdated() && metadataUrlCert.isValidateSignature()) {
                summaryList.add(new SummaryInfo("Trusted", String.valueOf(metadataUrlCert.isCertTrusted()), this));
            }
            summaryList.addAll(ImportMetadataSummaryHelper.getCertSummary(this.getCert(), this));
        }
    }

    public String getSummaryTitle() {
        return TITLE;
    }

    public boolean isImportButtonVisible() {
        return this.importButtonVisible;
    }

    @Override
    public XmlObject getMetadataXml() {
        return null;
    }

    @Override
    public ArrayList<SummaryInfo> getMetadataSummary() {
        ArrayList<SummaryInfo> summary = this.getCertSummary();
        return summary;
    }

    @Override
    public void importConnection() {
    }

    @Override
    public void refreshState() {
        MetadataUrlImportCertTasklet importTasklet;
        Cert importedCert;
        Tasklet taskletToEdit = this.getTaskletToEdit();
        if (taskletToEdit instanceof MetadataUrlImportCertTasklet && (importedCert = (importTasklet = (MetadataUrlImportCertTasklet)taskletToEdit).getImportedCert()) != null) {
            this.updateCert(importedCert, importTasklet.getMetadataSignatureValidator().getSigVerifier().isCertChainValid(), false);
            this.setError("");
            this.importButtonVisible = false;
        }
    }

    public boolean validate() {
        this.resetPageState();
        MetadataUrlCertTasklet tasklet = this.getParent(MetadataUrlCertTasklet.class);
        InputStream metadataStream = null;
        String url = tasklet.getUrl();
        try {
            metadataStream = MetadataUpdateTaskHelper.downloadMetadataFromUrl((String)url);
        }
        catch (ValidationException e) {
            this.setError(e.getMessage());
        }
        if (metadataStream != null) {
            MetadataValidator metadataValidator = new MetadataValidator(null, null, metadataStream, false, null, null, null);
            metadataValidator.setValidateAllConnection(false);
            metadataValidator.validate();
            if (metadataValidator.hasErrors()) {
                this.setError(((ValidationError)metadataValidator.getErrors().iterator().next()).getMessage().trim());
            } else if (tasklet.isValidateSignature()) {
                XmlSignatureVerifier signatureVerifier = metadataValidator.getSigVerifier();
                if (!(signatureVerifier.getEmbeddedX509Cert() == null || this.getCert() != null && signatureVerifier.getEmbeddedX509Cert().equals(this.getCert().getX509Certificate()))) {
                    this.updateCert(new Cert(null, signatureVerifier.getEmbeddedX509Cert()), signatureVerifier.isCertChainValid(), true);
                } else if (signatureVerifier.hasSignature()) {
                    MetadataSignatureValidator sigValidator = new MetadataSignatureValidator(metadataValidator.getMetadataXml(), true, this.getCert(), null, null);
                    if (!sigValidator.validate()) {
                        this.setError(((ValidationError)sigValidator.getErrors().iterator().next()).getMessage().trim() + " Import a valid certificate.");
                        this.importButtonVisible = true;
                    }
                } else if (this.getCert() != null) {
                    this.updateCert(null, false, true);
                }
            }
        }
        this.verified = true;
        return true;
    }

    public boolean isVerified() {
        return this.verified;
    }

    public String getError() {
        return this.error;
    }

    public void setError(String errorMessage) {
        this.error = errorMessage;
    }

    @Override
    public boolean onStateExit() {
        return !this.hasError();
    }

    public boolean hasError() {
        return StringUtils.isNotBlank((String)this.error);
    }

    public String getVerificationMessage() {
        return this.verificationMessage;
    }

    @Override
    public String getMetadataUrlId() {
        return null;
    }

    @Override
    public Integer getMetadataType() {
        return ImportMetadataState.NONE;
    }

    public Cert getCert() {
        MetadataUrlCertTasklet tasklet = this.findParent(MetadataUrlCertTasklet.class);
        if (tasklet == null) {
            return null;
        }
        return tasklet.getSigningCert();
    }

    public void updateCert(Cert cert, boolean trusted, boolean fromMetadata) {
        MetadataUrlCertTasklet tasklet = this.findParent(MetadataUrlCertTasklet.class);
        if (tasklet == null) {
            return;
        }
        tasklet.updateSigningCert(cert, trusted, fromMetadata);
    }

    public boolean isCertUpdatedFromMetadata() {
        MetadataUrlCertTasklet tasklet = this.findParent(MetadataUrlCertTasklet.class);
        if (tasklet == null) {
            return false;
        }
        return tasklet.isCertUpdatedFromMetadata();
    }

    public String getCertUpdatedMessage() {
        if (this.getCert() == null) {
            return "The metadata is unsigned. You should confirm with your partner that this is expected before proceeding.";
        }
        return "The certificate embedded in the metadata has been retrieved. You should confirm the certificate details before proceeding.";
    }

    public void resetPageState() {
        this.verified = false;
        this.setError("");
        this.importButtonVisible = false;
    }
}

