/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.fsm.IWizard;
import com.pingidentity.fsm.state.impl.AutoSaveState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletListState;
import com.pingidentity.fsm.tasklet.data.MetadataUrlCertItem;
import com.pingidentity.fsm.tasklet.data.Mode;
import com.pingidentity.fsm.tasklet.impl.MetadataUrlCertTasklet;
import java.io.Serializable;
import java.util.Comparator;
import org.apache.tapestry.IRequestCycle;
import org.sourceid.saml20.domain.MetadataUrlCertPair;
import org.sourceid.saml20.domain.mgmt.MetadataUrlManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.PkCertAndConnectionCertManager;

@AutoSaveState
public class MetadataUrlCertsState
extends TaskletListState {
    private static final long serialVersionUID = 1L;
    private final transient MetadataUrlManager metadataUrlManager = MgmtFactory.getMetadataUrlManager();
    private static final Comparator<Tasklet> COMPARE_BY_ID_DOWN = (Comparator & Serializable)(o1, o2) -> {
        MetadataUrlCertTasklet tasklet1 = (MetadataUrlCertTasklet)o1;
        MetadataUrlCertTasklet tasklet2 = (MetadataUrlCertTasklet)o2;
        if (tasklet1.getName() != null && tasklet2.getName() != null) {
            return tasklet1.getName().compareToIgnoreCase(tasklet2.getName());
        }
        return 0;
    };

    public MetadataUrlCertsState(IWizard owner) {
        super(owner);
        this.setMenuName("Manage Metadata URLs");
        this.buildTaskletList();
    }

    @Override
    public void populate(Object dataFromDisk) {
        this.buildTaskletList();
    }

    private void buildTaskletList() {
        this.deleteAllTasklets();
        for (MetadataUrlCertPair metadataUrlCertPair : this.metadataUrlManager.getMetadataUrlPairs()) {
            MetadataUrlCertTasklet urlCertTasklet = this.createTaskletToLoad(MetadataUrlCertTasklet.class);
            urlCertTasklet.setMode(Mode.edit);
            urlCertTasklet.populate(new MetadataUrlCertItem(metadataUrlCertPair));
            this.addTasklet(urlCertTasklet);
        }
        this.sort(COMPARE_BY_ID_DOWN);
    }

    public boolean isDuplicateUrl(String url, String id) {
        for (Tasklet t : this.getTasklets()) {
            String metadataUrlId;
            MetadataUrlCertTasklet metadataUrlTasklet = (MetadataUrlCertTasklet)t;
            if (!metadataUrlTasklet.getUrl().equalsIgnoreCase(url) || (metadataUrlId = metadataUrlTasklet.getMetadataUrlId()) != null && metadataUrlId.equals(id)) continue;
            return true;
        }
        return false;
    }

    public boolean isDuplicateMetadataName(String name, String id) {
        for (Tasklet t : this.getTasklets()) {
            String metadataId;
            MetadataUrlCertTasklet metadataTasklet = (MetadataUrlCertTasklet)t;
            if (!metadataTasklet.getName().equalsIgnoreCase(name) || (metadataId = metadataTasklet.getMetadataUrlId()) != null && metadataId.equals(id)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setTaskletToEdit(Tasklet taskletToEdit) {
        super.setTaskletToEdit(taskletToEdit);
        this.sort(COMPARE_BY_ID_DOWN);
    }

    @Override
    public void deleteTasklet(Integer taskletToDelete) {
        Tasklet tasklet = this.getTasklet(taskletToDelete);
        tasklet.setItDeleted(true);
        MetadataUrlCertTasklet metadataUrlCertTasklet = (MetadataUrlCertTasklet)tasklet;
        String metadataId = metadataUrlCertTasklet.getMetadataUrlId();
        if (this.metadataUrlManager.getMetadataUrlPair(metadataId) != null) {
            this.metadataUrlManager.deleteMetadataUrl(metadataId);
            ((PkCertAndConnectionCertManager)MgmtFactory.getDsigPkCertManager()).deleteCertsForFeature(metadataId);
        }
    }

    public void createNewTasklet() {
        MetadataUrlCertTasklet tasklet = this.createTaskletToLoad(MetadataUrlCertTasklet.class, "MetadataUrlCertTasklet", "Metadata URL");
        tasklet.setMode(Mode.create);
        tasklet.initialize();
        tasklet.setFinishLabel("Save");
        this.loadTasklet(tasklet);
    }

    public void edit(Integer indexToEdit, IRequestCycle cycle) {
        Tasklet tasklet = this.getTasklet(indexToEdit);
        tasklet.resetCurrentStateToSourceState();
        tasklet.setFinishLabel("Save");
        this.loadTasklet(tasklet);
        tasklet.gotoSummaryState(cycle);
    }
}

