/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.component.common.NameValuePair;
import com.pingidentity.fsm.IWizard;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.util.StringPairPropertySelectionModel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.sourceid.oauth20.domain.ClientSetting;
import org.sourceid.saml20.domain.ConfigurablePluginInstance;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class NotificationSendersState
extends TaskletState
implements Serializable {
    private static final long serialVersionUID = 2017082401L;
    private String selectedSender;
    private List<SenderItem> senders = new ArrayList<SenderItem>();

    public NotificationSendersState(IWizard owner) {
        super(owner);
        this.setMenuName("Notification Publishers");
    }

    public List<SenderItem> getSenders() {
        return this.senders;
    }

    public String getSelectedSender() {
        return this.selectedSender;
    }

    public void setSelectedSender(String selectedSender) {
        this.selectedSender = selectedSender;
    }

    public StringPairPropertySelectionModel getActiveSenderList() {
        StringPairPropertySelectionModel activePolicyList = new StringPairPropertySelectionModel(true);
        activePolicyList.addAll(MgmtFactory.getNotificationPublisherPluginManager().getInstances().stream().map(SenderItem::new).filter(instance -> !this.senders.contains(instance)).map(this.toSPair()).sorted(StringPairPropertySelectionModel.SPair.ID_COMPARATOR).collect(Collectors.toList()));
        return activePolicyList;
    }

    private Function<NameValuePair, StringPairPropertySelectionModel.SPair> toSPair() {
        return nameValuePair -> new StringPairPropertySelectionModel.SPair(nameValuePair.getValue(), nameValuePair.getName());
    }

    private SenderItem policyIdToNameValuePair(String policyId) {
        if (StringUtils.isBlank((String)policyId)) {
            return null;
        }
        return MgmtFactory.getNotificationPublisherPluginManager().getInstances().stream().filter(i -> i.getId().equals(policyId)).findFirst().map(SenderItem::new).orElse(null);
    }

    public void moveUp(int index) {
        if (index > 0) {
            SenderItem item = this.senders.get(index);
            this.senders.set(index, this.senders.get(index - 1));
            this.senders.set(index - 1, item);
        }
    }

    public void moveDown(int index) {
        if (index < this.senders.size() - 1) {
            SenderItem item = this.senders.get(index);
            this.senders.set(index, this.senders.get(index + 1));
            this.senders.set(index + 1, item);
        }
    }

    public void delete(int index) {
        if (index >= 0 || index < this.senders.size() - 1) {
            SenderItem item;
            item.setMarkedForDelete(!(item = this.senders.get(index)).isMarkedForDelete());
            this.senders.set(index, item);
        }
    }

    public void add() {
        Optional<SenderItem> selectedValue = MgmtFactory.getNotificationPublisherPluginManager().getInstances().stream().map(SenderItem::new).filter(nameValuePair -> nameValuePair.getName().equals(this.selectedSender)).findFirst();
        if (selectedValue.isPresent() && !this.senders.contains((Object)selectedValue.get())) {
            this.senders.add(selectedValue.get());
        } else {
            this.recordErrorMsg(this.getMessage("Common", "notification_sender_not_selected"));
        }
        this.selectedSender = null;
    }

    @Override
    public boolean populateAllStates(Object data) {
        if (data != null) {
            ClientSetting clientSetting = (ClientSetting)data;
            this.senders = clientSetting.getPolicyPlugins().stream().map(this::policyIdToNameValuePair).collect(Collectors.toList());
        }
        return true;
    }

    @Override
    public boolean save(Object dataToDisk) {
        if (dataToDisk != null) {
            // empty if block
        }
        return true;
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        List summaryInfos = this.senders.stream().map(nameValuePair -> new SummaryInfo(nameValuePair.getSenderType(), nameValuePair.getValue(), this)).collect(Collectors.toList());
        summaryList.addAll(summaryInfos);
    }

    public static class SenderItem
    extends NameValuePair {
        private String senderType;

        public SenderItem() {
        }

        public SenderItem(ConfigurablePluginInstance instance) {
            super(instance.getId(), instance.getName());
            this.senderType = instance.getDescriptor().getType();
        }

        public String getSenderType() {
            return this.senderType;
        }

        public void setSenderType(String senderType) {
            this.senderType = senderType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            SenderItem that = (SenderItem)((Object)o);
            return this.senderType != null ? this.senderType.equals(that.senderType) : that.senderType == null;
        }

        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + (this.senderType != null ? this.senderType.hashCode() : 0);
            return result;
        }
    }
}

