/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.c2ccontract.C2cContract;
import com.pingidentity.c2ccontract.mgmt.C2cContractManager;
import com.pingidentity.dependency.error.AffectedItemType;
import com.pingidentity.dependency.error.DependencyErrorHandler;
import com.pingidentity.dependency.error.DependencyErrorUIValidator;
import com.pingidentity.dependency.error.DependencyErrorUIValidatorImpl;
import com.pingidentity.fsm.Visit;
import com.pingidentity.fsm.state.impl.OAuthApc2TargetMappingsState;
import com.pingidentity.fsm.state.impl.OAuthSource2TargetMappingTasklet;
import com.pingidentity.fsm.tasklet.data.DependencyType;
import java.util.List;
import org.sourceid.oauth20.domain.ApcToUserKeyAttrMapping;
import org.sourceid.oauth20.domain.AuthzServerManager;
import org.sourceid.saml20.domain.AttributeContract;
import org.sourceid.saml20.domain.BasePluginInstance;
import org.sourceid.saml20.domain.ConfigurablePluginInstance;
import org.sourceid.saml20.domain.SourceContextType;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class OAuthApc2TargetMappingTasklet
extends OAuthSource2TargetMappingTasklet<ApcToUserKeyAttrMapping> {
    private static final long serialVersionUID = 1L;
    C2cContractManager c2cMgr = MgmtFactory.getC2cContractManager();
    AuthzServerManager authzServerManager = MgmtFactory.getAuthzServerManager();

    public OAuthApc2TargetMappingTasklet(Visit visit) {
        super("OAuthApc2TargetMappingTasklet", "Policy Contract Mapping", visit);
    }

    @Override
    public AttributeContract getMappingContract() {
        return this.authzServerManager.getKeyNameContract();
    }

    @Override
    public String getSourceType() {
        return "Authentication Policy Contract";
    }

    @Override
    protected List<SourceContextType> getContextMappingTypes() {
        return SourceContextType.getContextTypesForOAuthWebRedirectFlowMapping();
    }

    @Override
    public void saveSetSelectedId(String id, ApcToUserKeyAttrMapping mapping) {
        mapping.setApcId(id);
    }

    @Override
    public String loadGetSelectedId(ApcToUserKeyAttrMapping mapping) {
        return mapping.getApcId();
    }

    @Override
    public String getDescription() {
        return "'" + this.getSelectedPlugin().getName() + "' to Persistent Grant Contract";
    }

    @Override
    public ConfigurablePluginInstance getSelectedPlugin() {
        return this.getFakeInstance(this.c2cMgr.getContract(this.selectedId));
    }

    private ConfigurablePluginInstance getFakeInstance(C2cContract apc) {
        if (apc == null) {
            return null;
        }
        BasePluginInstance bpi = new BasePluginInstance();
        bpi.setId(apc.getId());
        bpi.setName(apc.getName());
        bpi.setImmutableAttributeContract(apc.getImmutableAttributeNames());
        bpi.setExtendedContractAttributes(apc.getMutableAttributeNames());
        return bpi;
    }

    @Override
    public String getMappingSourceForDisplay() {
        return null;
    }

    @Override
    public void finish() {
        OAuthApc2TargetMappingsState oAuthApc2TargetMappingsState = new OAuthApc2TargetMappingsState(this.getParentTasklet());
        ApcToUserKeyAttrMapping mappingToSave = oAuthApc2TargetMappingsState.newEmptyMapping(this.getSelectedId());
        if (this.save(mappingToSave)) {
            this.authzServerManager.saveApcToUserKeyMapping(mappingToSave, this.isNewMapping());
            DependencyErrorUIValidatorImpl dependencyErrorUIValidator = new DependencyErrorUIValidatorImpl(this);
            DependencyErrorHandler dependencyErrorHandler = new DependencyErrorHandler();
            dependencyErrorHandler.performDependencyValidation((DependencyErrorUIValidator)dependencyErrorUIValidator, (Object)mappingToSave, DependencyType.OAUTH_CLIENT_SETTINGS);
        }
        super.finish();
    }

    @Override
    public AffectedItemType getAffectedItemType() {
        return AffectedItemType.APC_TO_PERSISTENT_GRANT_MAPPING;
    }

    private boolean isNewMapping() {
        return this.authzServerManager.getApcToUserKeyMapping(this.selectedId) == null;
    }
}

