/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.c2ccontract.C2cContract;
import com.pingidentity.fsm.state.impl.OAuthIdpConnection2TargetMappingTasklet;
import com.pingidentity.fsm.tasklet.SingleTaskletState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.fsm.tasklet.impl.ConnectionTasklet;
import com.pingidentity.fsm.tasklet.impl.IdpBrowserSsoTasklet;
import com.pingidentity.fsm.tasklet.impl.IdpC2cContractMappingTasklet;
import com.pingidentity.util.StringPairPropertySelectionModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.sourceid.oauth20.domain.AccessTokenMapping;
import org.sourceid.oauth20.domain.AuthzServerManager;
import org.sourceid.oauth20.handlers.ContextUtil;
import org.sourceid.oauth20.handlers.OAuthSourceId;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class OAuthAttributeMappingState
extends SingleTaskletState {
    private static final long serialVersionUID = 20050515L;
    private MappingOption selectedOption = null;
    private String selectedApc;

    public OAuthAttributeMappingState(Tasklet value) {
        super(value);
        this.setMenuName("OAuth Attribute Mapping");
    }

    @Override
    public void getSummary(ArrayList<SummaryInfo> summaryList) {
        if (this.selectedOption == MappingOption.APC) {
            SummaryInfo info = new SummaryInfo(this.getMenuName(), "", this);
            info.setTaskletType(true);
            summaryList.add(info);
            String apcName = this.selectedApc;
            C2cContract contract = MgmtFactory.getC2cContractManager().getContract(this.selectedApc);
            if (contract != null) {
                apcName = contract.getName();
            }
            summaryList.add(new SummaryInfo("OAuth Authentication Policy Contract", apcName, this));
        } else {
            super.getSummary(summaryList);
        }
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        if (this.selectedOption == MappingOption.APC) {
            boolean appendApcError;
            boolean bl = appendApcError = this.selectedApc == null;
            if (this.selectedApc != null) {
                boolean bl2 = appendApcError = !this.getAvailableApcsMap().containsKey(this.selectedApc);
            }
            if (appendApcError) {
                delegate.setFormComponent(null);
                delegate.record(this.getMessage("select_apc"), ValidationConstraint.REQUIRED);
            }
        } else {
            Tasklet tasklet = this.getTaskletToEdit();
            if (tasklet == null) {
                delegate.setFormComponent(null);
                delegate.record(this.getMessage("Not_configured"), ValidationConstraint.REQUIRED);
            }
            super.appendErrors(delegate, component, fastFail);
        }
    }

    @Override
    public void onStateActivated() {
        this.createTaskletToEdit();
        if (this.selectedOption == null) {
            this.selectedOption = this.getAvailableApcsMap().size() > 0 ? MappingOption.APC : MappingOption.DIRECT;
        }
        if (!this.getIsApcEnabled()) {
            this.selectedOption = MappingOption.DIRECT;
        }
    }

    @Override
    public void populate(Object dataFromDisk) {
        IdpConnection idpConnection = (IdpConnection)dataFromDisk;
        if (idpConnection.hasOAuthApcId()) {
            this.selectedOption = MappingOption.APC;
            this.selectedApc = idpConnection.getOAuthApcId();
        } else {
            this.selectedOption = MappingOption.DIRECT;
            this.createTaskletToEdit();
            if (dataFromDisk != null) {
                this.getTaskletToEdit(this.getTaskletClass()).populate(dataFromDisk);
            }
        }
    }

    @Override
    public boolean save(Object dataToDisk) {
        if (this.selectedOption == MappingOption.APC) {
            ((IdpConnection)dataToDisk).setOAuthApcId(this.selectedApc);
            AuthzServerManager oauthSettingsManager = MgmtFactory.getAuthzServerManager();
            Collection currentMappings = oauthSettingsManager.getUserKeyToAccessTokenMappings();
            ArrayList newMappings = new ArrayList(currentMappings);
            ContextUtil util = new ContextUtil();
            OAuthSourceId id = new OAuthSourceId(OAuthSourceId.Type.IDP_CONNECTION, ((IdpConnection)dataToDisk).getId());
            String ctxId = util.buildQualifiedId("authz_req", id);
            boolean foundMapping = false;
            for (AccessTokenMapping mapping : currentMappings) {
                if (!ctxId.equals(mapping.getContextId())) continue;
                this.log.debug((Object)("Found an OAuth access token mapping for this connection (" + mapping.getContextId() + ")"));
                newMappings.remove(mapping);
                foundMapping = true;
            }
            boolean success = super.save(dataToDisk);
            if (success && foundMapping) {
                this.log.debug((Object)("Removing access token mappings for connection " + ((IdpConnection)dataToDisk).getId()));
                oauthSettingsManager.saveUserKeyToAccessTokenMappings(newMappings);
            }
            return success;
        }
        return super.save(dataToDisk);
    }

    private void createTaskletToEdit() {
        if (this.getTaskletToEdit(this.getTaskletClass()) == null) {
            this.setTasklet(this.createTasklet(this.getTaskletClass()));
        }
    }

    Class<? extends Tasklet> getTaskletClass() {
        return OAuthIdpConnection2TargetMappingTasklet.class;
    }

    public String getLabelText() {
        return "Configure OAuth Attribute Mapping";
    }

    public MappingOption getSelectedOption() {
        return this.selectedOption;
    }

    public void setSelectedOption(MappingOption selectedOption) {
        this.selectedOption = selectedOption;
    }

    private Map<String, String> getAvailableApcsMap() {
        HashMap<String, String> apcId2Name = new HashMap<String, String>();
        List<IdpC2cContractMappingTasklet> c2cMappings = this.getParent().findParent(IdpBrowserSsoTasklet.class).getC2cTasklets();
        if (c2cMappings != null) {
            for (IdpC2cContractMappingTasklet mappingTasklet : c2cMappings) {
                if (mappingTasklet.isItDeleted()) continue;
                apcId2Name.put(mappingTasklet.getContractId(), mappingTasklet.getDescription());
            }
        }
        return apcId2Name;
    }

    public StringPairPropertySelectionModel getAvailableApcs() {
        StringPairPropertySelectionModel model = new StringPairPropertySelectionModel(true);
        Map<String, String> apcId2Name = this.getAvailableApcsMap();
        for (Map.Entry<String, String> entry : apcId2Name.entrySet()) {
            model.add(entry.getValue(), entry.getKey());
        }
        model.sort();
        return model;
    }

    public String getSelectedApc() {
        return this.selectedApc;
    }

    public void setSelectedApc(String selectedApc) {
        this.selectedApc = selectedApc;
    }

    public boolean getIsApcEnabled() {
        ConnectionTasklet connTasklet = this.findParent(ConnectionTasklet.class);
        return connTasklet.isC2cEnabled();
    }

    public static enum MappingOption {
        APC,
        DIRECT;

    }
}

